<?php
//#############################################################################//
//# Front
//#
//# Author: Colotin Florin (E-mail: colotin_f@yahoo.com, Web: www.yourchoice.ro)
//# Date: 19.12.2011
//#############################################################################//

class etp extends ApplicationModel
{	
	private $patInfo;
	private $per_code;
	
	function __construct($action)
	{
		parent::__construct('etp_cs');
		
		if(isset($_GET['per_code']))
			$per_code = $_GET['per_code'];
		elseif(isset($_SESSION[SESS_IDX]['etp_pat_per_code']))
			$per_code = $_SESSION[SESS_IDX]['etp_pat_per_code'];
		
		if(!empty($per_code) && $pat_info = get_patient_info($per_code))
		{
			$this->per_code = $per_code;
			$this->patInfo = $pat_info;
			
			$_SESSION[SESS_IDX]['etp_pat_per_code'] = $this->per_code;			
		}
		else
			show_http_error_page(null, null, 'Invalid person code!!!');
		
		//Page actions
		switch($action)
	  	{
	  		case 'page_login':
				$this->pageLogin();
      		 	break;
      		 	
      		case 'page_consultation':
				$this->pageConsultation();
      		 	break;

      		case 'refus_update':
				$this->refusUpdate();
      		 	break;	
      		 	
      		case 'etape_pce':
      			if(!empty($_GET['pce_code']) && $_GET['pce_code']>=1 && $_GET['pce_code']<=5)
      			{
					$etapeMethod = 'etapePCE'.$_GET['pce_code'];
      				$this->$etapeMethod();
      			}
      		 	break;

      		case 'etape_pce1_initiale':      		
      			$this->etapePCE1_Initiale();      			
      		 	break;
      		 	
      		case 'etape_pce2_items':      		
      			$this->etapePCE2Items();      			
      		 	break;
      		case 'etape_pce2_facteurs_upd':
				$this->etapePCE2FacteursUpd();
      		 	break;
      		case 'etape_pce2_besoins':      		
      			$this->etapePCE2Besoins();      			
      		 	break;
      		case 'etape_pce2_objectifs':      		
      			$this->etapePCE2Objectifs();      			
      		 	break;
      		 	
      		case 'get_interventions':
				$this->getInterventions();
      		 	break;
      		 	
      		case 'item_eval_graph':
				$this->itemEvalGraph();
      		 	break;
      		 	
      		case 'cse_eval_trait':
				$this->evalTrait();
      		 	break;
      		
      		case 'etp_ps_radar_graph':
				$this->itemsPsRadarGraph();
      		 	break;

      		case 'report_synthese':
				$this->reportSynthese();
      		 	break;
      		 	
      		case 'report_intv_suivi_effectues':
				$this->reportIntvSuivi(true);
      		 	break;
      		case 'report_intv_suivi_non_effectues':
				$this->reportIntvSuivi(false);
      		 	break;
      		 	
      		case 'courrier':
      			$this->courrier();
      			break;
      		case 'search_courrier':
      			$this->searchCourrier();
      			break;
      		case 'courrier_correspondant':
      			$this->courrierCorrespondant();
      			break;
      		case 'courrier_compte_rendu':
      			$this->courrierCompteRendu();
      			break;
      		case 'courrier_imprimer':
      			$this->courrierImprimer();
      			break;
      			
      		case 'delete_cse':
      			$this->deleteCse();
      			break;
	  	}
	}
	
	/**
	 * Consultation home page
	 * @param
	 * @return null
	*/
	public function pageConsultation()
	{
		global $smarty;
		
        $smarty->assign('csl_date', dt_cdate()); 
        
        //assign (medecin) csl dates (from ran)       
    	$smarty->assign('cslStrDates', $this->getCslStrDates($this->per_code));
    	
    	//get & assign cse list
    	$cse_list = $this->getCseList($this->per_code);
        $cse_str_dates = '';
        $facteurs = array();
    	foreach($cse_list as $k=>$v)
        {
    		$t = strtotime($v['cse_date']);
			$d = (int) date('d', $t);
			$m = (int) date('m', $t);
			$y = (int) date('Y', $t);
			
			$cse_str_dates .= '\''.$d.'_'.$m.'_'.$y.'\',';   
			
			//get facteurs
			if($v['pce_code']==2)
			{
				if(!empty($v['data']['facteurs'][5]) && empty($facteurs['facilitant']))//facteurs facilitant (just from the last cse 2)
				{
					foreach($v['data']['facteurs'][5] as $k2=>$v2)
						$facteurs['facilitant'][$v2['ite_code']] = $v2['ite_libelle'];
				}
				if(!empty($v['data']['facteurs'][6]) && empty($facteurs['limitant']))//facteurs limitant(just from the last cse 2)
				{
					foreach($v['data']['facteurs'][6] as $k2=>$v2)
						$facteurs['limitant'][$v2['ite_code']] = $v2['ite_libelle'];
				}
			}
        }
               
        if($cse_str_dates != '')
    		$cse_str_dates = substr($cse_str_dates, 0, strlen($cse_str_dates)-1);    	    	
    		
    	//assign (evaluation) cse dates
    	$smarty->assign('cseStrDates', $cse_str_dates);
    	
    	//getInterventionsProgDates
    	$smarty->assign('itvStrDates', $this->getInterventionsProgDates($this->per_code));
    	
    	//assign cse list
    	$smarty->assign('cseList', $cse_list);
    	
    	//assign facteurs
    	$smarty->assign('facteurs', $facteurs);
        
        //assign patient info
		$smarty->assign('patInfo', $this->patInfo);
		
		$smarty->assign('pceList', dao_get_table_content('etp_profil_consultation', 'pce_code', 'pce_desc', 'pce_code', null, 1));
		$smarty->assign('mreList', dao_get_table_content('etp_motif_refus', 'mre_code', 'mre_libelle', 'mre_code', null, 1));
		
		//Display the template
		$smarty->display('etp/etp_consultation.tpl');
	}
	
	/**
	 * Get csl (medecin) dates (from ran)
	 * @param $per_code
	 * @return string with csl dates
	*/
	private function getCslStrDates($per_code)
	{    	
        $daoCsl = DB_DataObject::factory('consultation');
        $daoCsl->selectAdd();
        $daoCsl->selectAdd('DISTINCT csl_date');
    	$daoCsl->whereAdd('per_code_pat='.$per_code);
        $daoCsl->orderBy('csl_date DESC, csl_code DESC');
        $daoCsl->find();
        $csl_str_dates = '';
		while($daoCsl->fetch()) {
			$t = strtotime($daoCsl->csl_date);
			$d = (int) date('d', $t);
			$m = (int) date('m', $t);
			$y = (int) date('Y', $t);
			
			$csl_str_dates .= '\''.$d.'_'.$m.'_'.$y.'\',';
		}
		if($csl_str_dates != '')
    		$csl_str_dates=substr($csl_str_dates, 0, strlen($csl_str_dates)-1);		
		
		return $csl_str_dates;
	}
	
	/**
	 * Get Interventions Dates
	 * @param $per_code 
	 * @return string with interventions dates
	*/
	private function getInterventionsProgDates($per_code)
	{    	
        $daoCse = DB_DataObject::factory('etp_cs');
        $daoCse->pat_per_code = $per_code;
        
        $daoProg = DB_DataObject::factory('etp_cs_prog_interv');
        $daoProg->joinAdd($daoCse);
        
        $daoItv = DB_DataObject::factory('etp_intervention');        
        $daoItv->joinAdd($daoProg);
        $daoItv->selectAdd();
		$daoItv->selectAdd('DISTINCT itv_date');
		$daoItv->orderBy('itv_date DESC');				
        $daoItv->find();
        $itv_str_dates = '';
		while($daoItv->fetch()) {
			$t = strtotime($daoItv->itv_date);
			$d = (int) date('d', $t);
			$m = (int) date('m', $t);
			$y = (int) date('Y', $t);
			
			$itv_str_dates .= '\''.$d.'_'.$m.'_'.$y.'\',';
		}
		if($itv_str_dates != '')
    		$itv_str_dates=substr($itv_str_dates, 0, strlen($itv_str_dates)-1);
		
		return $itv_str_dates;
	}
	
	/**
	 * Get evaluation consultations
	 * @param $per_code
	 * @return array
	*/
	private function getCseList($per_code)
	{
    	$list = array();
		
		//prepare join tables
		$daoPceJoin = DB_DataObject::factory('etp_profil_consultation');    	
		$daoSpeJoin = DB_DataObject::factory('etp_specialite');
		$daoPerJoin = DB_DataObject::factory('personne');
		$daoIntJoin = DB_DataObject::factory('etp_intervenant');
		
		$daoIntJoin->joinAdd($daoPerJoin);
		$daoIntJoin->joinAdd($daoSpeJoin);
		
		$daoCseList = DB_DataObject::factory('etp_cs');
		$daoCseList->pat_per_code = $per_code;
		
		$daoCseList->joinAdd($daoPceJoin);
		$daoCseList->joinAdd($daoIntJoin);
		
		$daoCseList->orderBy('cse_date DESC, cse_code DESC');
		$daoCseList->find();
		while($daoCseList->fetch())
			$list[]=$daoCseList->toArray();
							
		$daoCseList->free();
		$daoIntJoin->free();
		$daoPerJoin->free();
		$daoSpeJoin->free();

		//get consultation text by profil consultation
		foreach($list as $k=>$cse)
		{
			$method = 'getPCE'.$cse['pce_code'].'Data';		
			$list[$k]['data'] = $this->$method($cse['cse_code']);						
		}
		
		return $list;
	}
	
	/**
	 * Ajax Refus update
	 * @param null
	 * @return null
	 */
	public function refusUpdate()
	{
		global $smarty;
		
		if(isset($_GET['refus']) && is_numeric($_GET['refus']))
		{			
			$daoPRE = DB_DataObject::factory('etp_patient_refus_etp');
			
			//delete
			$daoPRE->per_code = $this->per_code;
			$daoPRE->delete();
			
			if($_GET['refus']>0)
			{
				$mre_code = $_GET['refus'];
				
				//insert
				$daoPRE->per_code = $this->per_code;
				$daoPRE->mre_code = $mre_code;
				$daoPRE->pre_date = dt_cdate();
				$daoPRE->insert();
			}
			
			$daoPRE->free();
						
			$json_arr = array('done'=>1);
		}
		else
			$json_arr = array('done'=>0);
		
		json_output($json_arr);
	}
		
	/**
	 * Etape 1 : Recueil de donnees
	 * 
	 * @return unknown_type
	 */
	public function etapePCE1()
	{
		global $smarty;
		
		$pce_code = $_GET['pce_code']; // 1 is the value
		
		//check if for this patient exists cse_code (recueil de donnees) added
		$cse_info = dao_get_row_content('etp_cs', array('pce_code'=>$pce_code, 'pat_per_code'=>$this->per_code));		
		if($cse_info)
			$cse_code = $cse_info['cse_code'];
		
			
		if(!empty($_GET['ite_code_pere'])) //subitems for a parent item sent via GET 
		{
			$etp_ite_code_pere = $_GET['ite_code_pere'];
						
			//get sub-items
			$daoQuery = DB_DataObject::factory('etp_item_ss_item');
			if(!empty($cse_code))
			{
				$q='SELECT 
						ite.ite_code, ite.ite_libelle, rec.commentaire_item
					FROM 
						etp_item_ss_item AS isi
						INNER JOIN etp_item_etp AS ite ON ite.ite_code=isi.etp_ite_code_fils AND ite.tit_code=2
						LEFT JOIN etp_prof_cs_item_etp AS pci ON pci.ite_code=ite.ite_code AND pci.pce_code='.$pce_code.'
						LEFT JOIN etp_cs_recueil_item AS rec ON rec.ite_code=ite.ite_code AND rec.cse_code='.$cse_code.'
					WHERE 
						isi.etp_ite_code_pere='.$etp_ite_code_pere.'
					ORDER BY
						pci.pci_ordre
				';
			}
			else
			{
				$q='SELECT 
						ite.ite_code, ite.ite_libelle
					FROM 
						etp_item_ss_item AS isi
						INNER JOIN etp_item_etp AS ite ON ite.ite_code=isi.etp_ite_code_fils AND ite.tit_code=2
						LEFT JOIN etp_prof_cs_item_etp AS pci ON pci.ite_code=ite.ite_code AND pci.pce_code='.$pce_code.'						
					WHERE 
						isi.etp_ite_code_pere='.$etp_ite_code_pere.'
					ORDER BY
						pci.pci_ordre
				';
			}
			
			$daoQuery->query($q);			
			$isi_list = array();
			while($daoQuery->fetch())
				$isi_list[] = $daoQuery->toArray();
			
			$daoQuery->free();

			//post action
			if(!empty($_POST['act']) && $_SESSION[SESS_IDX][UL]['is_intervenant'])
			{
				if(empty($cse_code))
				{					
					//default cse date
					$cse_date = dt_cdate();
					if(!empty($_POST['cse_date'])) {//overwrite cse default date					
						$ddmmyyyy = explode('/', $_POST['cse_date']);					
				    	if(count($ddmmyyyy)==3 && checkdate($ddmmyyyy[1], $ddmmyyyy[0], $ddmmyyyy[2]))//(int $month , int $day , int $year)
				    		$cse_date = $ddmmyyyy[2].'-'.$ddmmyyyy[1].'-'.$ddmmyyyy[0];
					}
					
					//add a new consultation - etp_cs				
					$daoInsertCSE = DB_DataObject::factory('etp_cs');				
					$daoInsertCSE->pce_code = $pce_code;
					$daoInsertCSE->pat_per_code = $this->per_code;
					$daoInsertCSE->int_per_code = $_SESSION[SESS_IDX][UL]['per_code_uti'];
					$daoInsertCSE->cse_date = $cse_date;
					$daoInsertCSE->sequenceKey('cse_code', false);
					$cse_code = $daoInsertCSE->insert();
					$daoInsertCSE->free();
					
					$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
					if($error)
						exit('Error: '.$error->getMessage());
					else 
					{
						//insert in etp_cs_recueil_donnees
						$daoInsertCSE_RD = DB_DataObject::factory('etp_cs_recueil_donnees');
						$daoInsertCSE_RD->cse_code = $cse_code;
						$daoInsertCSE_RD->csr_connaissances_init = '';
						$daoInsertCSE_RD->sequenceKey(false, false);
						$daoInsertCSE_RD->insert();
						$daoInsertCSE_RD->free();
					}
				}
				
				if(!empty($cse_code))
				{					
					foreach($isi_list as $k=>$row)
					{
						if(isset($_POST['ite_'.$row['ite_code']]))
						{
							//delete old assignation
							$daoDelRD = DB_DataObject::factory('etp_cs_recueil_item');
					        $daoDelRD->whereAdd('cse_code='.$cse_code);
					        $daoDelRD->whereAdd('ite_code='.$row['ite_code']);
							$daoDelRD->delete(DB_DATAOBJECT_WHEREADD_ONLY);
							$daoDelRD->free();
							
							//insert new
							$daoInsertRD = DB_DataObject::factory('etp_cs_recueil_item');
							$daoInsertRD->cse_code = $cse_code;
							$daoInsertRD->ite_code = $row['ite_code'];
							$daoInsertRD->commentaire_item = $_POST['ite_'.$row['ite_code']];
							$daoInsertRD->insert();
							$daoInsertRD->free();
						}
					}
					
					redirect('index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&per_code='.$this->per_code.'&pce_code='.$pce_code.'&etp_ite_code_pere='.$etp_ite_code_pere);
				}
				else
					exit('Error invalid cse_code!!!');
			}
			
			//assign data
			$smarty->assign('libelle_pere', dao_get_field_content('etp_item_etp', 'ite_libelle', 'ite_code', $etp_ite_code_pere));			
			$smarty->assign('isiList', $isi_list);
				
		}//end !empty($_GET['ite_code_pere'])
		else //get etp items for pce = 1
		{
			//post action for csr_connaissances_init
			if(!empty($_POST['act']) && $_SESSION[SESS_IDX][UL]['is_intervenant'])
			{
				if(empty($cse_code))
				{					
					//default cse date
					$cse_date = dt_cdate();
					if(!empty($_POST['cse_date'])) {//overwrite cse default date
						$ddmmyyyy = explode('/', $_POST['cse_date']);			
				    	if(count($ddmmyyyy)==3 && checkdate($ddmmyyyy[1], $ddmmyyyy[0], $ddmmyyyy[2]))//(int $month , int $day , int $year)
				    		$cse_date = $ddmmyyyy[2].'-'.$ddmmyyyy[1].'-'.$ddmmyyyy[0];
					}
					
					//add a new consultation - etp_cs				
					$daoInsertCSE = DB_DataObject::factory('etp_cs');
					$daoInsertCSE->pce_code = $pce_code;
					$daoInsertCSE->pat_per_code = $this->per_code;
					$daoInsertCSE->int_per_code = $_SESSION[SESS_IDX][UL]['per_code_uti'];
					$daoInsertCSE->cse_date = $cse_date;
					$daoInsertCSE->sequenceKey('cse_code', false);
					$cse_code = $daoInsertCSE->insert();
					$daoInsertCSE->free();
					
					$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
					if($error)
						exit('Error: '.$error->getMessage());
					else
					{
						//insert new
						$daoInsertCSE_RD = DB_DataObject::factory('etp_cs_recueil_donnees');
						$daoInsertCSE_RD->cse_code = $cse_code;
						$daoInsertCSE_RD->csr_connaissances_init = $_POST['csr_connaissances_init'];
						$daoInsertCSE_RD->sequenceKey(false, false);
						$daoInsertCSE_RD->insert();
						$daoInsertCSE_RD->free();
					}
				}
				else
				{
					$daoAddUpdCSE_RD = DB_DataObject::factory('etp_cs_recueil_donnees');					
					//check if exists
					if(dao_check_row_exists('etp_cs_recueil_donnees', 'cse_code', $cse_code))
					{
						//update						
						$daoAddUpdCSE_RD->get($cse_code);
						$daoAddUpdCSE_RD->csr_connaissances_init = $_POST['csr_connaissances_init'];
						$daoAddUpdCSE_RD->update();
					}
					else 
					{
						//insert
						$daoAddUpdCSE_RD->cse_code = $cse_code;
						$daoAddUpdCSE_RD->csr_connaissances_init = $_POST['csr_connaissances_init'];
						$daoAddUpdCSE_RD->sequenceKey(false, false);
						$daoAddUpdCSE_RD->insert();
					}
					
					$daoAddUpdCSE_RD->free();
				}
				
				redirect('index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&per_code='.$this->per_code.'&pce_code='.$pce_code);
				
			}//end POST
			
			//assign data
			$data = $this->getPCE1Data((!empty($cse_code) ? $cse_code:null));
			$smarty->assign('pciList', $data['pci_list']);	
			
			if(!empty($cse_code))
				$cse_info['csr_connaissances_init'] = !empty($data['csr']['csr_connaissances_init']) ? $data['csr']['csr_connaissances_init'] : '';
			
		}//else !item pere
		
		//Assign cse info
		if($cse_info)
		{
			//$cse_info['csr_connaissances_init'] = dao_get_field_content('etp_cs_recueil_donnees', 'csr_connaissances_init', 'cse_code', $cse_code); 						
			$smarty->assign('cseInfo', $cse_info);
		}
		
		//Assign patient info
		$smarty->assign('patInfo', $this->patInfo);
		
		//Display the template
		$smarty->display('etp/etp_etape_pce_1.tpl');
	}
	
	/**
	 * Etape 1 : Recueil de donnees - Eval competence initiale - Objectif psycho-social
	 * 
	 * @return unknown_type
	 */
	public function etapePCE1_Initiale()
	{
		global $smarty;
		
		$pce_code=1;
		//DB_DataObject::debugLevel(1);
		
		//check if for this patient exists cse_code (recueil de donnees) added
		$cse_info = dao_get_row_content('etp_cs', array('pce_code'=>$pce_code, 'pat_per_code'=>$this->per_code));		
		if($cse_info) 
		{
			$cse_code = $cse_info['cse_code'];
								
			//post action for csr_connaissances_init
			if(!empty($_POST['act']) && $_SESSION[SESS_IDX][UL]['is_intervenant'])
			{			
				//DB_DataObject::debugLevel(1);
				
				//===>check if have something in etp_cs_recueil_donnees
				$daoCsr = DB_DataObject::factory('etp_cs_recueil_donnees');
				if(!$daoCsr->get($cse_code))
				{
					//insert
					$daoCsr->cse_code=$cse_code;
					$daoCsr->csr_connaissances_init='NULL';
					$daoCsr->trt_code=$_POST['trt_code'];
					$daoCsr->csr_comment_reprise=!empty($_POST['csr_comment_reprise']) ? $_POST['csr_comment_reprise'] : 'NULL';
					$daoCsr->csr_eval_trait=$_POST['csr_eval_trait']>=0 ? $_POST['csr_eval_trait'] : 'NULL';
					$daoCsr->csr_comment_eval_trait=!empty($_POST['csr_comment_eval_trait']) ? $_POST['csr_comment_eval_trait'] : 'NULL';
					$daoCsr->sequenceKey(false, false);
					$daoCsr->insert();
				}
				else {
					//update
					$daoCsr->trt_code=$_POST['trt_code'];
					$daoCsr->csr_comment_reprise=!empty($_POST['csr_comment_reprise']) ? $_POST['csr_comment_reprise'] : 'NULL';
					$daoCsr->csr_eval_trait=$_POST['csr_eval_trait']>=0 ? $_POST['csr_eval_trait'] : 'NULL';
					$daoCsr->csr_comment_eval_trait=!empty($_POST['csr_comment_eval_trait']) ? $_POST['csr_comment_eval_trait'] : 'NULL';
					$daoCsr->update();
				}
				$daoCsr->free();
				//<===				
				//exit;
				//===>get initiale competences items
				$daoIte = DB_DataObject::factory('etp_item_etp');				
				$daoIte->orderBy('ite_libelle');
				$daoIte->find();
				$ite_init_list = array();
				while($daoIte->fetch())
					$ite_init_list[] = $daoIte->toArray(); 
				$daoIte->free();			
				//<===
				
				//Delete existent EIC
				$daoDelEIC = DB_DataObject::factory('etp_eval_init_competence');
		        $daoDelEIC->whereAdd('cse_code='.$cse_code);		        
				$daoDelEIC->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelEIC->free();
				
				//Insert EIC
				foreach($ite_init_list as $k=>$row)
				{
					$eic_eval_init = (isset($_POST['eval_objectif_'.$row['ite_code']]) && $_POST['eval_objectif_'.$row['ite_code']]>=0) ? $_POST['eval_objectif_'.$row['ite_code']] : null;									
					
					//insert new
					$daoInsertEIC = DB_DataObject::factory('etp_eval_init_competence');
					$daoInsertEIC->cse_code = $cse_code;
					$daoInsertEIC->ite_code = $row['ite_code'];
					$daoInsertEIC->eic_eval_init_objectif = $eic_eval_init;
					$daoInsertEIC->insert();
					$daoInsertEIC->free();
				}
				
				redirect('index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&per_code='.$this->per_code);
				
			}//end POST['act']
			
			//get all info about consultation
			$cse_info['csr'] = dao_get_row_content('etp_cs_recueil_donnees', array('cse_code'=>$cse_code));				
			
			//===>get initiale competences items
			$daoIteQ = DB_DataObject::factory('etp_item_etp');
			/*
			$q = '
				SELECT 
					ite.ite_code, ite.ite_libelle, ite_pere.ite_code ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, eic.eic_eval_init_objectif, ite.tit_code, tit.tit_libelle
				FROM 
					etp_item_ss_item isi
					INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code LEFT JOIN etp_eval_init_competence eic ON eic.ite_code=ite.ite_code AND eic.cse_code='.$cse_code.'
					INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere=ite_pere.ite_code AND ite_pere.tit_code=3
					,etp_type_item tit 
				WHERE
					ite.tit_code=tit.tit_code
				ORDER BY
					tit.tit_libelle, ite_libelle_pere, ite.ite_libelle
			';
			*/
			
			$q = '
				SELECT 
					ite.ite_code, ite.ite_libelle, ite_pere.ite_code ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, eic.eic_eval_init_objectif, ite.tit_code, tit.tit_libelle
				FROM etp_item_ss_item isi
					INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils = ite.ite_code
					LEFT JOIN etp_eval_init_competence eic ON eic.ite_code = ite.ite_code	AND eic.cse_code =  '.$cse_code.'
					INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere = ite_pere.ite_code AND ite_pere.tit_code=3 
					
					LEFT JOIN etp_prof_cs_item_etp ordre_fils ON ite.ite_code = ordre_fils.ite_code AND ordre_fils.pce_code='.$pce_code.'
					LEFT JOIN etp_prof_cs_item_etp ordre_pere ON ite_pere.ite_code = ordre_pere.ite_code AND ordre_pere.pce_code='.$pce_code.'
					,
					etp_type_item tit
				WHERE 
					ite.tit_code = tit.tit_code AND 
					tit.tit_code=4
				ORDER BY tit.tit_libelle, ordre_pere.pci_ordre, ite_code_pere, ordre_fils.pci_ordre, ite.ite_code
			';/*tit.tit_libelle, ordre_pere.pci_ordre, ite_libelle_pere, ordre_fils.pci_ordre, ite.ite_libelle*/
			
			$daoIteQ->query($q);
			while($daoIteQ->fetch())
				$ite_init_list[] = $daoIteQ->toArray();
						
			$daoIteQ->free();
			//<===
			
			//Assign item psycho-social
			$smarty->assign('iteInitList', $ite_init_list);
			
			//Assign cse info
			$smarty->assign('cseInfo', $cse_info);
			
			//Assign patient info
			$smarty->assign('patInfo', $this->patInfo);
			
			//Assign type item competence
			$smarty->assign('trtList', dao_get_table_content('etp_type_reprise_travail', 'trt_code', 'trt_libelle', 'trt_code', null, 1));
			
			//check eval trait history exists for graph icon display
			$smarty->assign('evalTraitHistoryExists', $this->checkEvalTraitHistoryExists());
						
			//Display the template
			$smarty->display('etp/etp_etape_pce_1_initiale.tpl');
		}
		else
			exit('Il n\'y a pas de consultation Etape 1 - Recueil de donnes');
	}
	
	
	private function getPCE1Data($cse_code=null)
	{
		$pce_code = 1;//requeil donnees
		
		$daoITE_Join = DB_DataObject::factory('etp_item_etp');
		$daoITE_Join->tit_code = 1; //Recueil de donnes regroupes
		
		$daoPCI = DB_DataObject::factory('etp_prof_cs_item_etp');
		$daoPCI->pce_code = $pce_code;
		$daoPCI->joinAdd($daoITE_Join, 'INNER');
		$daoPCI->orderBy('pci_ordre');			
		$daoPCI->find();
		
		$data = array();
		$data['pci_list'] = array(); 
		//$data['csr_connaissances_init'] = ''; 
		
		$i=0;
		
		if(!empty($cse_code))
		{
			while($daoPCI->fetch())
			{
				$data['pci_list'][$i] = $daoPCI->toArray();
									
				$q='SELECT 
						ite.ite_code, ite.ite_libelle, rec.commentaire_item
					FROM 
						etp_item_ss_item AS isi
						INNER JOIN etp_item_etp AS ite ON ite.ite_code=isi.etp_ite_code_fils AND ite.tit_code=2
						LEFT JOIN etp_prof_cs_item_etp AS pci ON pci.ite_code=ite.ite_code AND pci.pce_code='.$pce_code.'
						LEFT JOIN etp_cs_recueil_item AS rec ON rec.ite_code=ite.ite_code AND rec.cse_code='.$cse_code.'																		
					WHERE 
						isi.etp_ite_code_pere='.$daoPCI->ite_code.'
					ORDER BY
						pci.pci_ordre
				';					
				$daoISI_Tmp = DB_DataObject::factory('etp_item_ss_item');
				$daoISI_Tmp->query($q);										
				while($daoISI_Tmp->fetch())
					$data['pci_list'][$i]['fils'][] = $daoISI_Tmp->toArray();
				
				$daoISI_Tmp->free();
				
				$i++;
			}
						
			//get etp_cs_recueil_donnees
			$daoCsr = DB_DataObject::factory('etp_cs_recueil_donnees');
			$daoCsr->get($cse_code);
			$daoTrt = DB_DataObject::factory('etp_type_reprise_travail');
			$daoCsr->joinAdd($daoTrt);
			$daoCsr->find(true);			
			$data['csr'] = $daoCsr->toArray();				
			$daoCsr->free();
			$daoTrt->free();					
			//$data['csr'] = dao_get_row_content('etp_cs_recueil_donnees', array('cse_code'=>$cse_code));			
			//get csr_connaissances_init
			//$data['csr_connaissances_init'] = dao_get_field_content('etp_cs_recueil_donnees', 'csr_connaissances_init', 'cse_code', $cse_code);
						
			//===>get initiale competences items
			$daoIteQ = DB_DataObject::factory('etp_item_etp');
			$q = '
				SELECT
					ite.ite_code, ite.ite_libelle, ite_pere.ite_code ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, eic.eic_eval_init_objectif, ite.tit_code, tit.tit_libelle
				FROM etp_item_ss_item isi
					INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils = ite.ite_code
					LEFT JOIN etp_eval_init_competence eic ON eic.ite_code = ite.ite_code	AND eic.cse_code =  '.$cse_code.'
					INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere = ite_pere.ite_code AND ite_pere.tit_code=3
		
					LEFT JOIN etp_prof_cs_item_etp ordre_fils ON ite.ite_code = ordre_fils.ite_code AND ordre_fils.pce_code='.$pce_code.'
					LEFT JOIN etp_prof_cs_item_etp ordre_pere ON ite_pere.ite_code = ordre_pere.ite_code AND ordre_pere.pce_code='.$pce_code.'
					,
					etp_type_item tit
				WHERE
					ite.tit_code = tit.tit_code AND
					tit.tit_code=4
				ORDER BY tit.tit_libelle, ordre_pere.pci_ordre, ite_code_pere, ordre_fils.pci_ordre, ite.ite_code
			';/*tit.tit_libelle, ordre_pere.pci_ordre, ite_libelle_pere, ordre_fils.pci_ordre, ite.ite_libelle*/	
			$daoIteQ->query($q);
			while($daoIteQ->fetch())
				$ite_init_list[] = $daoIteQ->toArray();			
			$daoIteQ->free();			
			$data['eval_init'] = $ite_init_list;
			//<===

			//check if exists and assign valid_radar_graph
			$this->itemsPsRadarGraph(0, 1);			
		}
		else
		{
			while($daoPCI->fetch())
			{
				$data['pci_list'][$i] = $daoPCI->toArray();					
				
				$daoITE_Tmp_Join = DB_DataObject::factory('etp_item_etp');
				
				$daoISI_Tmp = DB_DataObject::factory('etp_item_ss_item');
				$daoISI_Tmp->etp_ite_code_pere = $daoPCI->ite_code;							
				$daoISI_Tmp->joinAdd($daoITE_Tmp_Join, 'INNER', false, 'etp_ite_code_fils');
				
				$daoISI_Tmp->orderBy('ite_code');
				$daoISI_Tmp->find();
				while($daoISI_Tmp->fetch())
					$data['pci_list'][$i]['fils'][] = $daoISI_Tmp->toArray();
				
				$daoISI_Tmp->free();
				$daoITE_Tmp_Join->free();
				
				$i++;
			}
		}
		
		$daoPCI->free();
		$daoITE_Join->free();
		
		return $data;
	}
	
	public function etapePCE2()
	{
		global $smarty;
		
		$pce_code = $_GET['pce_code']; // 2 is the value
				
		if(!empty($_GET['cse_code']))
		{			
			$cse_info = dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pat_per_code'=>$this->per_code));		
			if($cse_info)
				$cse_code = $cse_info['cse_code'];
		}
		else {
			
			//Clone the last cse
			$daoCseSyntLast = DB_DataObject::factory('etp_cs');
			$daoCseSyntLast->pat_per_code=$this->per_code;
			$daoCseSyntLast->pce_code = $pce_code;
			$daoCseSyntLast->orderBy('cse_date DESC, cse_code DESC');
			$daoCseSyntLast->limit(0, 1);
			if($daoCseSyntLast->find(1))
			{
				//default cse date
				$cse_date = dt_cdate();
				if(!empty($_GET['cse_date'])) {//overwrite cse default date
					$ddmmyyyy = explode('/', $_GET['cse_date']);
					if(count($ddmmyyyy)==3 && checkdate($ddmmyyyy[1], $ddmmyyyy[0], $ddmmyyyy[2]))//(int $month , int $day , int $year)
						$cse_date = $ddmmyyyy[2].'-'.$ddmmyyyy[1].'-'.$ddmmyyyy[0];
				}				
				
				$redirect = 'index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&per_code='.$this->per_code.'&pce_code='.$pce_code;
				
				//add a new consultation - clone				
				$daoInsertCSE = DB_DataObject::factory('etp_cs');				
				$daoInsertCSE->pce_code = $daoCseSyntLast->pce_code;				
				$daoInsertCSE->int_per_code = $_SESSION[SESS_IDX][UL]['per_code_uti'];
				$daoInsertCSE->pat_per_code = $daoCseSyntLast->pat_per_code;
				$daoInsertCSE->cse_date = $cse_date;
				$daoInsertCSE->sequenceKey('cse_code', false);
				$cse_code = $daoInsertCSE->insert();
				$daoInsertCSE->free();
				if($cse_code>0)
				{
					$daoSynIte = DB_DataObject::factory('etp_cs_synthese');
					$q = '					
						INSERT INTO etp_cs_synthese 
							(cse_code, ite_code, css_objectif_negocie, css_commentaire) 
						SELECT 
							'.$cse_code.', ite_code, css_objectif_negocie, css_commentaire
						FROM 
							etp_cs_synthese
						WHERE
							cse_code='.$daoCseSyntLast->cse_code.'
					';
					$daoSynIte->query($q);
					
					$daoSynIte->free();
					
					$redirect .= '&cse_code='.$cse_code;
				}
				else
				{
					$redirect .= (!empty($_GET['cse_date']) ? '&cse_date='.$_GET['cse_date'] : '');
				}
				
				$daoInsertCSE->free();
				
				redirect($redirect);
			}
		}
		
		if(!empty($cse_code))
		{
			if(isset($_POST['act']) && $_POST['act']=='upd')
			{	
				//===>get assigend items list for tit code = 5 & 6 Facteurs
				$ite_code_list = array();	
				$daoIte = DB_DataObject::factory('etp_item_etp');
				$q = '
					SELECT 
						ite.ite_code
					FROM 
						etp_item_etp ite 
						INNER JOIN etp_cs_synthese css ON ite.ite_code=css.ite_code
					WHERE
						ite.tit_code!=4 AND 
						css.cse_code='.$cse_code.'
					ORDER BY
						ite.ite_libelle 
				';
				$daoIte->query($q);
				while($daoIte->fetch())
					$ite_code_list[] = $daoIte->ite_code;
				$daoIte->free();
				//<===
				
				//update facteurs commentaire 
				foreach($ite_code_list as $item_code)
				{
					if(isset($_POST['facteur-'.$item_code]))
					{
						$daoCss = DB_DataObject::factory('etp_cs_synthese');
						$daoCss->css_commentaire = $_POST['facteur-'.$item_code];
						$daoCss->whereAdd('cse_code='.$cse_code.' AND ite_code='.$item_code);
						$daoCss->update(DB_DATAOBJECT_WHEREADD_ONLY);
						$daoCss->free();
					}
				}
				
				//update cse commenaire-text (free text)
				$daoCseUpd = DB_DataObject::factory('etp_cs');
				if($daoCseUpd->get($cse_code)) {
					$daoCseUpd->cse_text = (trim($_POST['cse_text']) ? trim($_POST['cse_text']) : 'NULL');
					$daoCseUpd->update();
				}
				$cse_info['cse_text'] = trim($_POST['cse_text']);
				$daoCseUpd->free();
				
			}//end post upd
			elseif(!empty($_GET['del_ite']))
			{
				//delte item
				$daoCssDel = DB_DataObject::factory('etp_cs_synthese');
				$daoCssDel->whereAdd('cse_code='.$cse_code.' AND ite_code='.$_GET['del_ite']);
				$daoCssDel->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoCssDel->free();
			}
			
			
			$ite_list = array();
			
			//===>get assigend items list for tit code = 5 & 6 Facteurs
			$daoIte = DB_DataObject::factory('etp_item_etp');
			$q = '
				SELECT 
					ite.*, css.css_commentaire
				FROM 
					etp_item_etp ite 
					INNER JOIN etp_cs_synthese css ON ite.ite_code=css.ite_code
				WHERE
					ite.tit_code!=4 AND 
					css.cse_code='.$cse_code.'
				ORDER BY
					ite.ite_libelle 
			';
			$daoIte->query($q);
			while($daoIte->fetch())
				$ite_list[$daoIte->tit_code][] = $daoIte->toArray();
			$daoIte->free();
			//<===
			
			//Assign patient info
			$smarty->assign('iteList', $ite_list);
			
		}//if(!empty($cse_code))
		else
		{
			//get last CSE with pce_code=2 for autopopulate the facteurs
			/*			
			$daoCseSyntLast = DB_DataObject::factory('etp_cs');
			$daoCseSyntLast->pat_per_code=$this->per_code;
			$daoCseSyntLast->orderBy('cse_date DESC, cse_code DESC');
			$daoCseSyntLast->limit(0, 1);
			if($daoCseSyntLast->find(1))
			{
				$cse_synt_last = $daoCseSyntLast->toArray();				
				
				//===>get assigend items list for tit code = 5 & 6 Facteurs
				$ite_list = array();
				$daoIte = DB_DataObject::factory('etp_item_etp');
				$q = '
					SELECT 
						ite.*, css.css_commentaire
					FROM 
						etp_item_etp ite 
						INNER JOIN etp_cs_synthese css ON ite.ite_code=css.ite_code
					WHERE
						ite.tit_code!=4 AND 
						css.cse_code='.$cse_synt_last['cse_code'].'
					ORDER BY
						ite.ite_libelle 
				';
				$daoIte->query($q);
				while($daoIte->fetch())
					$ite_list[$daoIte->tit_code][] = $daoIte->toArray();
				$daoIte->free();				
				$smarty->assign('iteList', $ite_list);	
				//<===				
			}
			$daoCseSyntLast->free();
			*/
		}
		
		//Assign cse info
		if(!empty($cse_info))
		{
			$smarty->assign('cseInfo', $cse_info);
		}
		
		//Assign patient info
		$smarty->assign('patInfo', $this->patInfo);
		
		//Display the template
		$smarty->display('etp/etp_etape_pce_2.tpl');
	}
	
	public function etapePCE2Items()
	{
		global $smarty;
		
		$pce_code = 2; //Synthese
		
		if(!empty($_GET['cse_code']))
		{
			$cse_info = dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pat_per_code'=>$this->per_code));		
			if($cse_info) 
				$cse_code = $cse_info['cse_code'];
		}
		
		$ite_list = array();
		
		if(!empty($_GET['tit_code']))
		{
			$tit_code=$_GET['tit_code'];
			
			$daoIte = DB_DataObject::factory('etp_item_etp');
			
			$sql_from = $sql_where = '';
			if(!empty($cse_code))
			{
				$sql_from = 'LEFT JOIN etp_cs_synthese css ON ite.ite_code=css.ite_code AND css.cse_code='.$cse_code;
				$sql_where = ' AND css.ite_code IS NULL';
			}
			
			if($tit_code==4)//Objectif ducatif
			{
				$q = '
					SELECT 
						ite.*, isi.etp_ite_code_pere, ite_pere.ite_libelle ite_libelle_pere
					FROM 
						etp_item_ss_item isi
						INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code
						INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere=ite_pere.ite_code AND ite_pere.tit_code=3

						LEFT JOIN etp_prof_cs_item_etp ordre_fils ON ite.ite_code = ordre_fils.ite_code AND ordre_fils.pce_code='.$pce_code.'
						LEFT JOIN etp_prof_cs_item_etp ordre_pere ON ite_pere.ite_code = ordre_pere.ite_code AND ordre_pere.pce_code='.$pce_code.'
						
						'.$sql_from.'
					WHERE
						ite.tit_code='.$tit_code.$sql_where.'
					ORDER BY
						ordre_pere.pci_ordre, 
						ordre_fils.pci_ordre,
						ite_pere.ite_libelle,
						ite.ite_libelle 
				';
			}
			else // Facteur facilitant [5] or Facteur limitant [6]
			{
				$q = '
					SELECT 
						ite.*
					FROM 
						etp_item_etp ite 
						LEFT JOIN etp_prof_cs_item_etp pci ON ite.ite_code = pci.ite_code AND pci.pce_code='.$pce_code.'
						'.$sql_from.'
					WHERE
						ite.tit_code='.$tit_code.$sql_where.'
					ORDER BY
						pci.pci_ordre, ite.ite_libelle 
				';
				
			}
			
			$daoIte->query($q);
			while($daoIte->fetch())
				$ite_list[] = $daoIte->toArray();
			
			$daoIte->free();
			
			
			if(!empty($_POST))
			{
				$error = false;
				
				if(empty($cse_code))
				{
					//default cse date
					$cse_date = dt_cdate();
					if(!empty($_POST['cse_date'])) {//overwrite cse default date					
						$ddmmyyyy = explode('/', $_POST['cse_date']);					
				    	if(count($ddmmyyyy)==3 && checkdate($ddmmyyyy[1], $ddmmyyyy[0], $ddmmyyyy[2]))//(int $month , int $day , int $year)
				    		$cse_date = $ddmmyyyy[2].'-'.$ddmmyyyy[1].'-'.$ddmmyyyy[0];
					}
					
					//add a new consultation - etp_cs				
					$daoInsertCSE = DB_DataObject::factory('etp_cs');				
					$daoInsertCSE->pce_code = $pce_code;
					$daoInsertCSE->pat_per_code = $this->per_code;
					$daoInsertCSE->int_per_code = $_SESSION[SESS_IDX][UL]['per_code_uti'];
					$daoInsertCSE->cse_date = $cse_date;
					$daoInsertCSE->sequenceKey('cse_code', false);
					$cse_code = $daoInsertCSE->insert();
					$daoInsertCSE->free();
					
					$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
				}
				
				if(!$error)
				{
					foreach($ite_list as $k=>$item) 
					{
						if(isset($_POST['ite_'.$item['ite_code']]))
						{
							$daoInsertTmp = DB_DataObject::factory('etp_cs_synthese');
							$daoInsertTmp->cse_code = $cse_code;
							$daoInsertTmp->ite_code = $item['ite_code'];
							$daoInsertTmp->insert();
							$daoInsertTmp->free();
						}
					}
					
					$json_arr['cse_code'] = $cse_code;
					$json_arr['error'] = 0;
				}
				else {
					
					$json_arr['error'] = 1;
					$json_arr['message'] = 'Error: '.$error->getMessage();
				}
				
				//json output
				json_output($json_arr);			
				exit;
			}//end post
			
		}		
		
		//Assign patient info
		$smarty->assign('iteList', $ite_list);
		
		//Display the template
		$smarty->display('ajax/etp_synthese_items.tpl');
	}
	//Autosave canceled in favour of Valider button
	public function etapePCE2FacteursUpd()
	{		
		$json_arr['err'] = 0;
		if(!empty($_GET['cse_code']))
		{
			$cse_code = $_GET['cse_code'];
			
			if(isset($_POST['act']) && $_POST['act']=='upd')
			{
				$daoCss = DB_DataObject::factory('etp_cs_synthese');
				$daoCss->css_commentaire = $_POST['css_commentaire'];
				$daoCss->whereAdd('cse_code='.$cse_code.' AND ite_code='.$_POST['ite_code']);
				$daoCss->update(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoCss->free();
				$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
				if($error)
					$json_arr['err'] = 1;
			}
		}
		else
			$json_arr['err'] = 2;
		
		json_output($json_arr);
		exit;
	}
	public function etapePCE2Besoins()
	{
		$pce_code = 2;
		if(!empty($_GET['cse_code']))
		{
			$cse_code = $_GET['cse_code'];
			global $smarty;
			
			$rec_list = array();
			
			//===>get assigend items list for tit code = 4 Besoins - Objectifs					
			$daoIte = DB_DataObject::factory('etp_item_etp');
			$q = '
				SELECT 
					ite.*, isi.etp_ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, css.css_objectif_negocie
				FROM 
					etp_item_ss_item isi
					INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code
					INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere=ite_pere.ite_code AND ite_pere.tit_code=3							
					INNER JOIN etp_cs_synthese css ON ite.ite_code=css.ite_code
					
					LEFT JOIN etp_prof_cs_item_etp ordre_fils ON ite.ite_code = ordre_fils.ite_code AND ordre_fils.pce_code='.$pce_code.'
					LEFT JOIN etp_prof_cs_item_etp ordre_pere ON ite_pere.ite_code = ordre_pere.ite_code AND ordre_pere.pce_code='.$pce_code.'
					
				WHERE
					ite.tit_code=4 AND 
					css.cse_code='.$cse_code.'
				ORDER BY
					ordre_pere.pci_ordre, 
					ordre_fils.pci_ordre,
					ite_pere.ite_libelle,
					ite.ite_libelle 
			';// AND css.css_objectif_negocie IS NULL
			$daoIte->query($q);
			while($daoIte->fetch())
				$rec_list[] = $daoIte->toArray();
			$daoIte->free();
			//<===
	
			//Assign patient info
			$smarty->assign('recList', $rec_list);
			
			header('Content-type:text/html; charset=utf-8');

			//Display the template
			$smarty->display('ajax/etp_etape2_besoins.tpl');
		}
		else
			exit('Invalid cse_code !');
	}
	public function etapePCE2Objectifs()
	{
		global $smarty;
		
		$pce_code = 2;
		
		if(!empty($_GET['cse_code']))
		{
			$cse_code = $_GET['cse_code'];
			
			if(!empty($_GET['add']))
			{
				$ite_code = $_GET['add'];
				
				$daoCss = DB_DataObject::factory('etp_cs_synthese');
				$daoCss->css_objectif_negocie = 1;
				$daoCss->whereAdd('cse_code='.$cse_code.' AND ite_code='.$ite_code);
				$daoCss->update(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoCss->free();
			}
			elseif(!empty($_GET['del']))
			{
				$ite_code = $_GET['del'];
				
				$daoCss = DB_DataObject::factory('etp_cs_synthese');
				$daoCss->css_objectif_negocie = 'NULL';
				$daoCss->whereAdd('cse_code='.$cse_code.' AND ite_code='.$ite_code);
				$daoCss->update(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoCss->free();
			}
			
			$rec_list = array();
		
			//===>get assigend items list for tit code = 4 Objectif ducatif					
			$daoIte = DB_DataObject::factory('etp_item_etp');
			$q = '
				SELECT 
					ite.*, isi.etp_ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, css.css_objectif_negocie
				FROM 
					etp_item_ss_item isi
					INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code
					INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere=ite_pere.ite_code AND ite_pere.tit_code=3
					INNER JOIN etp_cs_synthese css ON ite.ite_code=css.ite_code
					
					LEFT JOIN etp_prof_cs_item_etp ordre_fils ON ite.ite_code = ordre_fils.ite_code AND ordre_fils.pce_code='.$pce_code.'
					LEFT JOIN etp_prof_cs_item_etp ordre_pere ON ite_pere.ite_code = ordre_pere.ite_code AND ordre_pere.pce_code='.$pce_code.'					
				WHERE
					ite.tit_code=4 AND 
					css.cse_code='.$cse_code.' AND 
					css.css_objectif_negocie=1
				ORDER BY
					ordre_pere.pci_ordre, 
					ordre_fils.pci_ordre,
					ite_pere.ite_libelle,
					ite.ite_libelle 
			';
			$daoIte->query($q);
			while($daoIte->fetch())
				$rec_list[] = $daoIte->toArray();
			$daoIte->free();
			//<===
	
			//Assign patient info
			$smarty->assign('recList', $rec_list);
			
			//Display the template
			$smarty->display('ajax/etp_etape2_objectifs.tpl');
		}
		else
			exit('Invalid cse_code !');
	}
	
	private function getPCE2Data($cse_code)
	{
		$pce_code = 2;
		
		$data = array();
		
		$data['cse_text'] = dao_get_field_content('etp_cs', 'cse_text', 'cse_code', $cse_code);
		
		//===>get assigend items list for tit code = 5 & 6 Facteurs			
		$daoIte = DB_DataObject::factory('etp_item_etp');
		$q = '
			SELECT 
				ite.*, css.css_commentaire
			FROM 
				etp_item_etp ite 
				INNER JOIN etp_cs_synthese css ON ite.ite_code=css.ite_code
				LEFT JOIN etp_prof_cs_item_etp pci ON ite.ite_code = pci.ite_code AND pci.pce_code='.$pce_code.'
			WHERE
				ite.tit_code!=4 AND 
				css.cse_code='.$cse_code.'
			ORDER BY
				pci.pci_ordre,
				ite.ite_libelle 
		';
		$daoIte->query($q);
		while($daoIte->fetch())
			$data['facteurs'][$daoIte->tit_code][] = $daoIte->toArray();
		$daoIte->free();
		//<===
		
		//===>get assigend items list for tit code = 4 Besoins - Objectifs
		$daoIte = DB_DataObject::factory('etp_item_etp');
		$q = '
			SELECT 
				ite.*, isi.etp_ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, css.css_objectif_negocie
			FROM 
				etp_item_ss_item isi
				INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code
				INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere=ite_pere.ite_code AND ite_pere.tit_code=3							
				INNER JOIN etp_cs_synthese css ON ite.ite_code=css.ite_code
				
				LEFT JOIN etp_prof_cs_item_etp ordre_fils ON ite.ite_code = ordre_fils.ite_code AND ordre_fils.pce_code='.$pce_code.'
				LEFT JOIN etp_prof_cs_item_etp ordre_pere ON ite_pere.ite_code = ordre_pere.ite_code AND ordre_pere.pce_code='.$pce_code.'
			WHERE
				ite.tit_code=4 AND 
				css.cse_code='.$cse_code.'
			ORDER BY
				ordre_pere.pci_ordre, 
				ordre_fils.pci_ordre,
				ite_pere.ite_libelle,
				ite.ite_libelle 
		';// AND css.css_objectif_negocie IS NULL
		$daoIte->query($q);
		while($daoIte->fetch())
			$data['besoins'][] = $daoIte->toArray();
		$daoIte->free();
		//<===
		
		//===>get assigend items list for tit code = 4 Objectif ducatif
		$daoIte = DB_DataObject::factory('etp_item_etp');
		$q = '
			SELECT 
				ite.*, isi.etp_ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, css.css_objectif_negocie
			FROM 
				etp_item_ss_item isi
				INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code
				INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere=ite_pere.ite_code AND ite_pere.tit_code=3							
				INNER JOIN etp_cs_synthese css ON ite.ite_code=css.ite_code
				
				LEFT JOIN etp_prof_cs_item_etp ordre_fils ON ite.ite_code = ordre_fils.ite_code AND ordre_fils.pce_code='.$pce_code.'
				LEFT JOIN etp_prof_cs_item_etp ordre_pere ON ite_pere.ite_code = ordre_pere.ite_code AND ordre_pere.pce_code='.$pce_code.'
			WHERE
				ite.tit_code=4 AND 
				css.cse_code='.$cse_code.' AND 
				css.css_objectif_negocie=1
			ORDER BY
				ordre_pere.pci_ordre, 
				ordre_fils.pci_ordre,
				ite_pere.ite_libelle,
				ite.ite_libelle 
		';
		$daoIte->query($q);
		while($daoIte->fetch())
			$data['objectifs'][] = $daoIte->toArray();
		$daoIte->free();
		//<===
		
		return $data;		
	}
	
	/**
	 * Etape 3 : Programme des interventions
	 * 
	 * @return null
	 */
	public function etapePCE3()
	{
		global $smarty;
		
		$this->objInitVar('etp/etp_etape_pce_3.tpl', 'etp_cs_prog_interv', 'etp_cs_prog_interv', 'itv_code');
		
		$pce_code = $_GET['pce_code']; // 3 is the value
		
		if(isset($_GET['cse_code']))
		{
			$cse_info = dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pce_code'=>$pce_code, 'pat_per_code'=>$this->per_code));			
			if($cse_info) {
				$cse_code = $cse_info['cse_code'];
				
				$smarty->assign('cseInfo', $cse_info);
			}
			else
				exit('Invalid cse code!!!');
		}
		
		//operations
		if(isset($_POST['act']) && $_POST['act']=='add' && !empty($_POST['ids']) && $_SESSION[SESS_IDX][UL]['is_intervenant'])//add programations
		{			
			$json_arr = array();
			$json_arr['done'] = 0;
			
			if(empty($cse_code))//add a new consultation
			{			
				//add a new consultation - etp_cs
				$cse_date = dt_cdate();
				if(!empty($_POST['cse_date'])) {//overwrite cse default date					
					$ddmmyyyy = explode('/', $_POST['cse_date']);					
			    	if(count($ddmmyyyy)==3 && checkdate($ddmmyyyy[1], $ddmmyyyy[0], $ddmmyyyy[2]))//(int $month , int $day , int $year)
			    		$cse_date = $ddmmyyyy[2].'-'.$ddmmyyyy[1].'-'.$ddmmyyyy[0];
				}
				
				$daoInsertCSE = DB_DataObject::factory('etp_cs');
				$daoInsertCSE->pce_code = $pce_code;
				$daoInsertCSE->pat_per_code = $this->per_code;
				$daoInsertCSE->int_per_code = $_SESSION[SESS_IDX][UL]['per_code_uti'];
				$daoInsertCSE->cse_date = $cse_date;
				$daoInsertCSE->sequenceKey('cse_code', false);
				$cse_code = $daoInsertCSE->insert();
				$daoInsertCSE->free();
				
				//prepare a json redirect variable to send cse_code via GET
				$json_arr['redirect'] = 'index.php?obj=etp&action=etape_pce&per_code='.$this->per_code.'&pce_code='.$pce_code.'&cse_code='.$cse_code;
			}
			else
				$json_arr['redirect'] = '';
			
			if(!empty($cse_code))//add programations
			{
				$tmp_arr = explode(',', $_POST['ids']);
				foreach($tmp_arr as $k=>$itv_code)
				{
					//add programations
					$daoInsertProg = DB_DataObject::factory('etp_cs_prog_interv');
					$daoInsertProg->cse_code = $cse_code;
					$daoInsertProg->itv_code = $itv_code;
					$daoInsertProg->sequenceKey(false, false);
					$daoInsertProg->insert();
					$daoInsertProg->free();
				}
				
				$json_arr['done'] = 1;
			}
			
			json_output($json_arr);
			exit;
		}
		elseif(isset($_GET['del_itv']) && $_GET['del_itv']>0)
		{
			$json_arr = array();
			$json_arr['succes'] = 0;
			
			if(!empty($cse_code))
			{
				//delete programations
				$daoDelProg = DB_DataObject::factory('etp_cs_prog_interv');
				$daoDelProg->cse_code = $cse_code;
				$daoDelProg->itv_code = $_GET['del_itv'];
				$daoDelProg->delete();
				$daoDelProg->free();
				
				$json_arr['succes'] = 1;
			}
			else {			
				;//exit('Invalid cse_code on delete operation of itv_code '.$_GET['del_itv']);
			}
			
			json_output($json_arr);
			exit;
		}
		
		
		//===>get person intervenant list for smarty assignation
		$int_list = array();
		$daoIntPer_join = DB_DataObject::factory('personne');
		$daoIntSpe_join = DB_DataObject::factory('etp_specialite');
		$daoInt = DB_DataObject::factory('etp_intervenant');
		$daoInt->joinAdd($daoIntPer_join, 'INNER');
		$daoInt->joinAdd($daoIntSpe_join, 'INNER');
		$daoInt->orderBy('per_nom, per_prenom');
		$daoInt->find();
		while($daoInt->fetch())
			$int_list[$daoInt->per_code] = $daoInt->toArray();

		$daoInt->free();
		$daoIntSpe_join->free();
		$daoIntPer_join->free();
		//<===
		
		//Assign vars		
		$smarty->assign('intList', $int_list);
		$smarty->assign('litList', dao_get_table_content('etp_lieu_intervention', 'lit_code', 'lit_libelle', 'lit_libelle', null, 1));		
		
		//Assign patient info
		$smarty->assign('patInfo', $this->patInfo);
		
		//Display the template
		$smarty->display('etp/etp_etape_pce_3.tpl');
	}
	/**
	 * Ajax Get Interventions
	 * 
	 * @param: $cse_code
	 * @return: null
	 */
	public function getInterventions($cse_code_as_param = null)
	{
		global $smarty;
		
		$list = array();
					
		if(isset($_POST['act']) && $_POST['act'] == 'search')
		{
			//get available interventions
			
			$tpl_name = 'etp_interventions_available.tpl';
			
			$sql_where = '';
			if(!empty($_POST['tyt_code']))
				$sql_where .= 'AND itv.tyt_code='.$_POST['tyt_code'].' ';
			if(!empty($_POST['lit_code']))
				$sql_where .= 'AND itv.lit_code='.$_POST['lit_code'].' ';
			if(!empty($_POST['per_code']))//intervenant
				$sql_where .= 'AND itv.per_code='.$_POST['per_code'].' ';
			if(!empty($_POST['itv_date1']))
				$sql_where .= 'AND itv.itv_date>=\''.date_fr_to_mysql($_POST['itv_date1']).' 00:00:00\' ';
			if(!empty($_POST['itv_date2']))
				$sql_where .= 'AND itv.itv_date<=\''.date_fr_to_mysql($_POST['itv_date2']).' 23:59:59\' ';	
				
			$daoList = DB_DataObject::factory('etp_intervention');
			$q='SELECT 
					itv.*, lit.lit_libelle, 
					per.per_nom, per.per_prenom, spe.spe_libelle,
					prog.cse_code, 
					COUNT(prog_count.itv_code) as nb_inscrits
				FROM 
					etp_intervention itv
						LEFT JOIN etp_cs_prog_interv prog ON prog.itv_code=itv.itv_code AND prog.cse_code IN (SELECT cs.cse_code FROM etp_cs cs WHERE cs.pat_per_code='.$this->per_code.')
						LEFT JOIN etp_cs_prog_interv prog_count ON prog_count.itv_code=itv.itv_code 
					,
					etp_lieu_intervention lit,
					etp_intervenant intv,
					personne per,
					etp_specialite spe
				WHERE 
					prog.itv_code IS NULL AND 
					itv.itv_date>=NOW()  - INTERVAL 1 MONTH AND 					
					itv.lit_code=lit.lit_code AND
					itv.per_code=intv.per_code AND 
					intv.per_code=per.per_code AND
					intv.spe_code=spe.spe_code '.$sql_where.'
				GROUP BY
					itv.itv_code
				HAVING
					(itv.itv_nb_places!=1 OR nb_inscrits!=1)
				ORDER BY
					itv.itv_date DESC, itv.itv_code DESC
			';
			/*LEFT JOIN etp_cs cs ON prog.cse_code=cs.cse_code AND cs.pat_per_code='.$this->per_code.'
			 * 
			 * cs.cse_code IS NULL AND 
			 */ 
			$daoList->query($q);
			while($daoList->fetch())
				$list[] = $daoList->toArray();
			
			$daoList->free();
		}
		else // list assignated interventions
		{
			$tpl_name = 'etp_interventions_assigned.tpl';
			
			if(!empty($_GET['cse_code']) || $cse_code_as_param>0)
			{
				//DB_DataObject::debugLevel(1);
				
				$cse_code = !empty($_GET['cse_code']) ? $_GET['cse_code']:$cse_code_as_param;
				
				//get programmated interventions for cse_code				
		        $daoItvLit_Join = DB_DataObject::factory('etp_lieu_intervention');
		        $daoItvInt_Join = DB_DataObject::factory('etp_intervenant');
		        
		        $daoIntPer_Join = DB_DataObject::factory('personne');
		        $daoIntSpe_Join = DB_DataObject::factory('etp_specialite');
		        
		        $daoItvInt_Join->joinAdd($daoIntPer_Join);
		        $daoItvInt_Join->joinAdd($daoIntSpe_Join);
		        
		        $daoItv = DB_DataObject::factory('etp_intervention');
		        $daoItv->joinAdd($daoItvLit_Join);
		        $daoItv->joinAdd($daoItvInt_Join);
		        
		        $daoCs_Join = DB_DataObject::factory('etp_cs');
		        $daoCs_Join->pat_per_code = $this->per_code;
		        
		        $daoList = DB_DataObject::factory('etp_cs_prog_interv');
		        //$daoList->cse_code = $cse_code;
		        
		        $daoList->joinAdd($daoCs_Join);
		        
		        $daoList->joinAdd($daoItv);
	        	$daoList->orderBy('etp_intervention.itv_date DESC, etp_intervention.itv_code DESC');
				$daoList->find();
				
				while($daoList->fetch())
					$list[] = $daoList->toArray();
				
				$daoList->free();
				$daoItv->free();
				$daoItvInt_Join->free();
				$daoIntPer_Join->free();
				$daoIntSpe_Join->free();
				$daoItvLit_Join->free();
				
				//used for display cle in home etp
				if(!empty($cse_code_as_param))
					return $list;
			}
			else
				exit('Invalid cse_code!!!');
		}
		
		$smarty->assign('recList', $list);
		
		//Display the template
		$smarty->display('ajax/'.$tpl_name);
	}
	
	private function getPCE3Data($cse_code)
	{
		$pce_code = 3;//requeil donnees
		return $this->getInterventions($cse_code);
	}
	
	/**
	 * Etape 4 : Suivi des interventions
	 * 
	 * @return null
	 */
	public function etapePCE4()
	{
		global $smarty;		
		
		$pce_code = $_GET['pce_code']; // 4 is the value
		
		if(isset($_GET['cse_code']))
		{
			$cse_info = dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pce_code'=>$pce_code, 'pat_per_code'=>$this->per_code));			
			if($cse_info) {
				$cse_code = $cse_info['cse_code'];
				
				$smarty->assign('cseInfo', $cse_info);
			}
			else
				exit('Invalid cse code!!!');
		}
		
		//===>get all interventions programated for the current patient
		$prog_itv_list = array();
		$daoList = DB_DataObject::factory('etp_intervention');		
		$q='SELECT 
				itv.*, lit.lit_libelle, 
				per.per_nom, per.per_prenom, spe.spe_libelle
			FROM 
				etp_intervention itv
					INNER JOIN etp_cs_prog_interv prog ON prog.itv_code=itv.itv_code 
						INNER JOIN etp_cs cs ON prog.cse_code=cs.cse_code AND cs.pat_per_code='.$this->per_code.'
				,				
				etp_lieu_intervention lit,
				etp_intervenant intv,
				personne per,
				etp_specialite spe
			WHERE 
				itv.lit_code=lit.lit_code AND
				itv.per_code=intv.per_code AND 
				intv.per_code=per.per_code AND
				intv.spe_code=spe.spe_code
			GROUP BY
				itv.itv_code
			ORDER BY
				itv.itv_date DESC, itv.itv_code DESC
		';
		$daoList->query($q);
		while($daoList->fetch())
			$prog_itv_list[] = $daoList->toArray();
		$daoList->free();
		//<===
		
		//opperations
		if(isset($_POST['act']) && $_POST['act']=='save' && $_SESSION[SESS_IDX][UL]['is_intervenant'])
		{
			if(empty($cse_code))//add a new consultation
			{
				//add a new consultation - etp_cs
				$cse_date = dt_cdate();
				if(!empty($_POST['cse_date'])) {//overwrite cse default date					
					$ddmmyyyy = explode('/', $_POST['cse_date']);					
			    	if(count($ddmmyyyy)==3 && checkdate($ddmmyyyy[1], $ddmmyyyy[0], $ddmmyyyy[2]))//(int $month , int $day , int $year)
			    		$cse_date = $ddmmyyyy[2].'-'.$ddmmyyyy[1].'-'.$ddmmyyyy[0];
				}
				
				$daoInsertCSE = DB_DataObject::factory('etp_cs');
				$daoInsertCSE->pce_code = $pce_code;
				$daoInsertCSE->pat_per_code = $this->per_code;
				$daoInsertCSE->int_per_code = $_SESSION[SESS_IDX][UL]['per_code_uti'];
				$daoInsertCSE->cse_date = $cse_date;
				$daoInsertCSE->sequenceKey('cse_code', false);
				$cse_code = $daoInsertCSE->insert();
				$daoInsertCSE->free();
				
				$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
				if($error)
					exit($error->getMessage());

				//insert cse suivi
				$daoInsertCsSuivi = DB_DataObject::factory('etp_cs_suivi');				
				$daoInsertCsSuivi->cse_code = $cse_code;
				$daoInsertCsSuivi->ecs_comment_suivi = $_POST['ecs_comment_suivi'];
				$daoInsertCsSuivi->ecs_comment_suivre = $_POST['ecs_comment_suivre'];
				$daoInsertCsSuivi->sequenceKey(false, false);
				$daoInsertCsSuivi->insert();
				$daoInsertCsSuivi->free();
			}
			else
			{
				//update cse
				$daoUpdCsSuivi = DB_DataObject::factory('etp_cs_suivi');
				$daoUpdCsSuivi->get($cse_code);
				$daoUpdCsSuivi->ecs_comment_suivi = $_POST['ecs_comment_suivi'];
				$daoUpdCsSuivi->ecs_comment_suivre = $_POST['ecs_comment_suivre'];
				$daoUpdCsSuivi->update();
				$daoUpdCsSuivi->free();
			}						
			
			//delete from etp_suivi_interv
			$daoDelCsi = DB_DataObject::factory('etp_suivi_interv');
			$daoDelCsi->whereAdd('cse_code='.$cse_code);
			$daoDelCsi->delete(DB_DATAOBJECT_WHEREADD_ONLY);
			$daoDelCsi->free();
			
			foreach($prog_itv_list as $i=>$prog_itv)
			{
				if(!empty($_POST['itv_code_'.$prog_itv['itv_code']]))
				{
					//insert in etp_suivi_interv					
					$daoInsertTmp = DB_DataObject::factory('etp_suivi_interv');
					$daoInsertTmp->cse_code = $cse_code;
					$daoInsertTmp->itv_code = $prog_itv['itv_code'];
					$daoInsertTmp->eti_code = !empty($_POST['eti_code_'.$prog_itv['itv_code']]) ? $_POST['eti_code_'.$prog_itv['itv_code']]:1;
					$daoInsertTmp->met_code = $_POST['met_code_'.$prog_itv['itv_code']];
					$daoInsertTmp->csi_comment_interv = $_POST['csi_comment_interv_'.$prog_itv['itv_code']];
					$daoInsertTmp->insert();
					$daoInsertTmp->free();				
				}
			}			
			
			redirect('index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&per_code='.$this->per_code.'&pce_code='.$pce_code.'&cse_code='.$cse_code);			
		}
		
		
		//===>get all suivi for all interventions programated for the current patient
		if(!empty($cse_code))//edit etp_cs
		{
			$form_act = dao_get_row_content('etp_cs_suivi', array('cse_code'=>$cse_code));
			$smarty->assign('form_act', $form_act);			
			
			foreach($prog_itv_list as $i=>$prog_itv)
			{
				//get suivi info							
				$daoSuivi = DB_DataObject::factory('etp_suivi_interv');
				$daoSuivi->itv_code = $prog_itv['itv_code'];
				
				//join with etp_cs_suivi
				$daoCsSuivi = DB_DataObject::factory('etp_cs_suivi');								
				//join etp_cs_suivi with etp_cs
				$daoCs = DB_DataObject::factory('etp_cs');
				$daoCs->cse_code = $cse_code;
				$daoCs->pce_code = $pce_code;
				$daoCs->pat_per_code = $this->per_code;				
				$daoCsSuivi->joinAdd($daoCs);
				
				$daoSuivi->joinAdd($daoCsSuivi);
				
				$daoSuivi->find(true);
				
				$prog_itv_list[$i]['suivi'] = $daoSuivi->toArray();
				
				$daoSuivi->free();
				$daoCs->free();
				$daoCsSuivi->free();								
			}
		}
		else//if(1==2)//tmp
		{
			foreach($prog_itv_list as $i=>$prog_itv)
			{				
				//check if there exists SUIVI_INTERV and get info from the last ETP_CS
				
				//get suivi info							
				$daoSuivi = DB_DataObject::factory('etp_suivi_interv');
				$daoSuivi->itv_code = $prog_itv['itv_code'];
				
				//join with etp_cs_suivi
				$daoCsSuivi = DB_DataObject::factory('etp_cs_suivi');								
				//join etp_cs_suivi with etp_cs
				$daoCs = DB_DataObject::factory('etp_cs');
				$daoCs->pce_code = $pce_code;
				$daoCs->pat_per_code = $this->per_code;				
				$daoCsSuivi->joinAdd($daoCs);
				
				$daoSuivi->joinAdd($daoCsSuivi);
				
				//get for last cse
				$daoSuivi->orderBy('etp_cs.cse_date DESC, etp_cs.cse_code DESC');
				$daoSuivi->limit(0, 1);
				
				$daoSuivi->find(true);
				$prog_itv_list[$i]['suivi'] = $daoSuivi->toArray();
				
				$daoSuivi->free();
				$daoCs->free();
				$daoCsSuivi->free();
			}
		}	
		//<===
		
		//assign list of interv prog
		$smarty->assign('progItvList', $prog_itv_list);
		
		//Assign patient info
		$smarty->assign('patInfo', $this->patInfo);
		
		//assign etp_motif_etat list
		$smarty->assign('metList', dao_get_table_content('etp_motif_etat', 'met_code', 'met_libelle', 'met_libelle', null, 1));
		
		//assign etp_motif_refus list
		//$smarty->assign('mreList', dao_get_table_content('etp_motif_refus', 'mre_code', 'mre_libelle', 'mre_libelle', null, 1));		
		
		//assign etp_etat_intervention list
		$smarty->assign('etiList', dao_get_table_content('etp_etat_intervention', 'eti_code', 'eti_libelle', 'eti_libelle', null, 1));
		
		//Display the template
		$smarty->display('etp/etp_etape_pce_4.tpl');
	}
	private function getPCE4Data($cse_code)
	{
		$pce_code = 4; 
		
		$data['cs_suivi'] = dao_get_row_content('etp_cs_suivi', array('cse_code'=>$cse_code));
		
		//===>get all interventions programated for the current patient
		$data['prog_itv_list'] = array();		
		$daoList = DB_DataObject::factory('etp_intervention');		
		$q='SELECT 
				itv.*, lit.lit_libelle, 
				per.per_nom, per.per_prenom, spe.spe_libelle
			FROM 
				etp_intervention itv
					INNER JOIN etp_cs_prog_interv prog ON prog.itv_code=itv.itv_code 
						INNER JOIN etp_cs cs ON prog.cse_code=cs.cse_code AND cs.pat_per_code='.$this->per_code.'
				,				
				etp_lieu_intervention lit,
				etp_intervenant intv,
				personne per,
				etp_specialite spe
			WHERE 				
				itv.lit_code=lit.lit_code AND
				itv.per_code=intv.per_code AND 
				intv.per_code=per.per_code AND
				intv.spe_code=spe.spe_code
			GROUP BY
				itv.itv_code
			ORDER BY
				itv.itv_date DESC, itv.itv_code DESC
		';
		$daoList->query($q);
		while($daoList->fetch())
			$data['prog_itv_list'][] = $daoList->toArray();
		$daoList->free();
		//<===
		
		//get all suivi for all interventions programated for the current patient
		foreach($data['prog_itv_list'] as $i=>$prog_itv)
		{
			//get suivi info							
			$daoSuivi = DB_DataObject::factory('etp_suivi_interv');
			$daoSuivi->itv_code = $prog_itv['itv_code'];
			
			//join with etp_cs_suivi
			$daoCsSuivi = DB_DataObject::factory('etp_cs_suivi');								
			//join etp_cs_suivi with etp_cs
			$daoCs = DB_DataObject::factory('etp_cs');
			$daoCs->cse_code = $cse_code;
			$daoCs->pce_code = $pce_code;
			$daoCs->pat_per_code = $this->per_code;				
			$daoCsSuivi->joinAdd($daoCs);
			
			$daoSuivi->joinAdd($daoCsSuivi);
			
			$daoSuivi->find(true);
			
			$data['prog_itv_list'][$i]['suivi'] = $daoSuivi->toArray();
			
			$daoSuivi->free();
			$daoCs->free();
			$daoCsSuivi->free();								
		}
		
		return $data;
	}
	
	
	public function etapePCE5()
	{
		global $smarty;
		
		$pce_code = $_GET['pce_code']; // 5 is the value
		
		if(isset($_GET['cse_code']))
		{
			$cse_info = dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pce_code'=>$pce_code, 'pat_per_code'=>$this->per_code));			
			if($cse_info) {
				$cse_code = $cse_info['cse_code'];
				
				//check if exists cs evaluation precedente
				$daoCsePre = DB_DataObject::factory('etp_cs');
				$daoCsePre->whereAdd('pce_code='.$pce_code.' AND pat_per_code='.$this->per_code.' AND cse_date<=\''.$cse_info['cse_date'].'\' AND cse_code<\''.$cse_info['cse_code'].'\'');//cse_code!='.$cse_code.' AND 
				$daoCsePre->orderBy('cse_date DESC, cse_code DESC');
				$daoCsePre->limit(0, 1);
				if($daoCsePre->find()>0)
				{
					$daoCsePre->fetch();
					$cse_info['cse_precedente'] = $daoCsePre->toArray();//echo $cse_info['cse_precedente']['cse_code'];
				}
			}
			else
				exit('Invalid cse code!!!');							
		}		
		elseif(!isset($_POST['act']))//new cse still not created - used to fill new consultation with data from the last, atention on $cse_info['new']
		{
			//check if exists cs evaluation precedente
			$daoCsePre = DB_DataObject::factory('etp_cs');
			$daoCsePre->whereAdd('pce_code='.$pce_code.' AND pat_per_code='.$this->per_code);
			$daoCsePre->orderBy('cse_date DESC, cse_code DESC');
			$daoCsePre->limit(0, 1);
			if($daoCsePre->find()>0)
			{
				$daoCsePre->fetch();				
				$cse_info['cse_precedente'] = $daoCsePre->toArray();//echo $cse_info['cse_precedente']['cse_code'];
				
				//$cse_info['new'] =1 ; $cse_code = $cse_info['cse_precedente']['cse_code'];//they require me to not clone eval prec. items 31.10.2013 
			}
		}
		
		
		//==>get item competence list
		$ite_comp_list = array();
		$sql_from = $sql_select = '';
		if(!empty($cse_code)) {
			//get consultation items condition
			$sql_from = 'LEFT JOIN etp_eval_competence eco ON ite.ite_code=eco.ite_code AND eco.cse_code='.$cse_code;
			$sql_select = ', eco.eco_eval_objectif';
			
			//get all info about consultation
			$cse_info['cs_evaluation'] = dao_get_row_content('etp_cs_evaluation', array('cse_code'=>$cse_code));
			
			$smarty->assign('cseInfo', $cse_info);
		}
		/*
		$q='SELECT 
				ite.*, tit.tit_libelle'.$sql_select.'
			FROM
				etp_item_etp ite '.$sql_from.',
				etp_type_item tit 
			WHERE 
				ite.tit_code=tit.tit_code AND tit.tit_code=4 
			ORDER BY 
				tit.tit_libelle, ite.ite_libelle
		';
		*/
		$q = '
			SELECT 
				ite.*, ite_pere.ite_code ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, tit.tit_libelle'.$sql_select.'
			FROM 
				etp_item_ss_item isi
					INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code '.$sql_from.'
					INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere=ite_pere.ite_code AND ite_pere.tit_code=3
					LEFT JOIN etp_prof_cs_item_etp ordre_fils ON ite.ite_code = ordre_fils.ite_code AND ordre_fils.pce_code='.$pce_code.'
					LEFT JOIN etp_prof_cs_item_etp ordre_pere ON ite_pere.ite_code = ordre_pere.ite_code AND ordre_pere.pce_code='.$pce_code.'
				, 
				etp_type_item tit
			WHERE 
				ite.tit_code = tit.tit_code AND 
				tit.tit_code = 4
			ORDER BY 
				tit.tit_libelle, ordre_pere.pci_ordre, ite_libelle_pere, ordre_fils.pci_ordre, ite.ite_libelle
		';
		
		$q = '
			SELECT
				ite.*, ite_pere.ite_code ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, tit.tit_libelle'.$sql_select.'
			FROM
				etp_item_ss_item isi
					INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code '.$sql_from.'
					INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere=ite_pere.ite_code AND ite_pere.tit_code=3					
				,
				etp_type_item tit
			WHERE
				ite.tit_code = tit.tit_code AND
				tit.tit_code = 4
			ORDER BY
				tit.tit_libelle, ite_pere.ite_code, ite.ite_code
		';//tit.tit_libelle, ordre_pere.pci_ordre, ite_libelle_pere, ordre_fils.pci_ordre, ite.ite_libelle
		
		$daoIte = DB_DataObject::factory('etp_item_etp');
		$daoIte->query($q);
		while($daoIte->fetch())
			$ite_comp_list[] = $daoIte->toArray();
		$daoIte->free();
		//<===
		
		//===>post add-upd operation
		if(isset($_POST['act']) && $_POST['act']=='save' && $_SESSION[SESS_IDX][UL]['is_intervenant'])
		{
			if(empty($cse_code))//add a new consultation
			{
				//add a new consultation - etp_cs
				$cse_date = dt_cdate();
				if(!empty($_POST['cse_date'])) {//overwrite cse default date					
					$ddmmyyyy = explode('/', $_POST['cse_date']);					
			    	if(count($ddmmyyyy)==3 && checkdate($ddmmyyyy[1], $ddmmyyyy[0], $ddmmyyyy[2]))//(int $month , int $day , int $year)
			    		$cse_date = $ddmmyyyy[2].'-'.$ddmmyyyy[1].'-'.$ddmmyyyy[0];
				}				
				
				//insert into etp_cs
				$daoInsertCSE = DB_DataObject::factory('etp_cs');
				$daoInsertCSE->pce_code = $pce_code;
				$daoInsertCSE->pat_per_code = $this->per_code;
				$daoInsertCSE->int_per_code = $_SESSION[SESS_IDX][UL]['per_code_uti'];
				$daoInsertCSE->cse_date = $cse_date;
				$daoInsertCSE->cse_text = (trim($_POST['cse_text']) ? trim($_POST['cse_text']) : 'NULL');
				$daoInsertCSE->sequenceKey('cse_code', false);
				$cse_code = $daoInsertCSE->insert();
				$daoInsertCSE->free();
				
				$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
				if($error)
					exit($error->getMessage());
				
				//insert cse evaluation
				$daoInsertCsEv = DB_DataObject::factory('etp_cs_evaluation');				
				$daoInsertCsEv->cse_code = $cse_code;
				$daoInsertCsEv->trt_code = $_POST['trt_code'];
				$daoInsertCsEv->cse_comment_reprise = !empty($_POST['cse_comment_reprise']) ? $_POST['cse_comment_reprise'] : 'NULL';
				$daoInsertCsEv->cse_eval_trait = (isset($_POST['cse_eval_trait']) && $_POST['cse_eval_trait']>=0) ? $_POST['cse_eval_trait'] : 'null';
				$daoInsertCsEv->cse_comment_eval_trait = !empty($_POST['cse_comment_eval_trait']) ? $_POST['cse_comment_eval_trait'] : 'NULL';
				$daoInsertCsEv->sequenceKey(false, false);
				$daoInsertCsEv->insert();
				$daoInsertCsEv->free();
			}
			else//update cse eval
			{
				//update cse text
				$daoUpdCSE = DB_DataObject::factory('etp_cs');
				$daoUpdCSE->get($cse_code);
				$daoUpdCSE->cse_text = (trim($_POST['cse_text']) ? trim($_POST['cse_text']) : 'NULL');
				$daoUpdCSE->update();
				$daoUpdCSE->free();
				
				//update cse
				$daoUpdCsEv = DB_DataObject::factory('etp_cs_evaluation');
				$daoUpdCsEv->get($cse_code);
				$daoUpdCsEv->trt_code = $_POST['trt_code'];
				$daoUpdCsEv->cse_comment_reprise = !empty($_POST['cse_comment_reprise']) ? $_POST['cse_comment_reprise'] : 'NULL';
				$daoUpdCsEv->cse_eval_trait = $_POST['cse_eval_trait']>=0 ? $_POST['cse_eval_trait'] : 'NULL';
				$daoUpdCsEv->cse_comment_eval_trait = !empty($_POST['cse_comment_eval_trait']) ? $_POST['cse_comment_eval_trait'] : 'NULL';
				$daoUpdCsEv->update();
				$daoUpdCsEv->free();
			}
			
			//delete from etp_eval_competence
			$daoDelEvc = DB_DataObject::factory('etp_eval_competence');
			$daoDelEvc->whereAdd('cse_code='.$cse_code);
			$daoDelEvc->delete(DB_DATAOBJECT_WHEREADD_ONLY);
			$daoDelEvc->free();
								
			foreach($ite_comp_list as $i=>$eco)
			{
				if(isset($_POST['eval_objectif_'.$eco['ite_code']]))
				{
					//echo '<hr>'.$eco['ite_code'].' : '.$_POST['eval_objectif_'.$eco['ite_code']];
					
					if(isset($_POST['eval_objectif_'.$eco['ite_code']]) && $_POST['eval_objectif_'.$eco['ite_code']]>=0)
						$val = $_POST['eval_objectif_'.$eco['ite_code']];
					else
						$val = 'NULL';
					
					//insert in etp_suivi_interv					
					$daoInsertTmp = DB_DataObject::factory('etp_eval_competence');					
					$daoInsertTmp->ite_code = $eco['ite_code'];
					$daoInsertTmp->cse_code = $cse_code;					
					$daoInsertTmp->eco_eval_objectif = $val;
					$daoInsertTmp->insert();
					$daoInsertTmp->free();					
				}
			}
			
			//exit('index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&per_code='.$this->per_code.'&pce_code='.$pce_code.'&cse_code='.$cse_code);
			redirect('index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&per_code='.$this->per_code.'&pce_code='.$pce_code.'&cse_code='.$cse_code);
		}
		//<===//end post

		$check_initiale = 0;
		if(!empty($cse_info['cse_precedente']))
		{
			foreach ($ite_comp_list as $i=>$row)
			{
				//echo '<hr> cse_code pre: '.$cse_info['cse_precedente']['cse_code'].', ite_code: '. $row['ite_code'].', eval_prece: ';							
				$ite_comp_list[$i]['eval_precedente'] = dao_get_field_content('etp_eval_competence', 'eco_eval_objectif', 'cse_code', $cse_info['cse_precedente']['cse_code'], 'ite_code', $row['ite_code']);				
				if(0==$check_initiale && !is_integer($ite_comp_list[$i]['eval_precedente'])) {
					$check_initiale = 1;
				}
			}
		}
		else
			$check_initiale = 1;
		if(1==$check_initiale)
		{
			//get cse-code from requeil de donnes pce_code=1
			$cse_info_pce_code_1 = dao_get_row_content('etp_cs', array('pce_code'=>1, 'pat_per_code'=>$this->per_code));
			if($cse_info_pce_code_1)
			{
				foreach ($ite_comp_list as $i=>$row)
				{
					if(empty($ite_comp_list[$i]['eval_precedente']) && $ite_comp_list[$i]['eval_precedente']!==0) {// || !is_integer($ite_comp_list[$i]['eval_precedente'])
						$ite_comp_list[$i]['eval_initiale'] = dao_get_field_content('etp_eval_init_competence', 'eic_eval_init_objectif', 'cse_code', $cse_info_pce_code_1['cse_code'], 'ite_code', $row['ite_code']);
					}
				}
			}
		}
		
		//Assign competence items
		$smarty->assign('iteCompList', $ite_comp_list);
		
		//Assign type item competence
		$smarty->assign('trtList', dao_get_table_content('etp_type_reprise_travail', 'trt_code', 'trt_libelle', 'trt_code', null, 1));
		
		//Assign patient info
		$smarty->assign('patInfo', $this->patInfo);
		
		//check eval trait history exists for graph icon display
		$smarty->assign('evalTraitHistoryExists', $this->checkEvalTraitHistoryExists());
		
		//check if exists and assign valid_radar_graph
		$this->itemsPsRadarGraph(0);						
		
		//Display the template
		$smarty->display('etp/etp_etape_pce_5.tpl');
	}
	private function getPCE5Data($cse_code)
	{
		$pce_code = 5 ; 
		
		$data = array();
		//$data['cs_evaluation'] = dao_get_row_content('etp_cs_evaluation', array('cse_code'=>$cse_code));
		
		$data['cse_text'] = dao_get_field_content('etp_cs', 'cse_text', 'cse_code', $cse_code);
		
		$daoCev = DB_DataObject::factory('etp_cs_evaluation');
		$daoCev->get($cse_code);		
		$daoTrt = DB_DataObject::factory('etp_type_reprise_travail');		
		$daoCev->joinAdd($daoTrt);
		$daoCev->find(true);
		
		$data['cs_evaluation'] = $daoCev->toArray();
		 
		$daoCev->free();
		$daoTrt->free();
		
		//==>get item competence list
		$data['ite_comp_list'] = array();	

		/*
		 $q='SELECT 
				ite.*, tit.tit_libelle, eco.eco_eval_objectif
			FROM
				etp_item_etp ite 
					LEFT JOIN etp_eval_competence eco ON ite.ite_code=eco.ite_code AND eco.cse_code='.$cse_code.'
					LEFT JOIN etp_prof_cs_item_etp AS pci ON pci.ite_code=ite.ite_code AND pci.pce_code=5
				, etp_type_item tit								
			WHERE
				ite.tit_code=tit.tit_code
			ORDER BY
				tit.tit_libelle, pci.pci_ordre, ite.ite_libelle
		';	
		*/
		
		$q = '
			SELECT
				ite.*, ite_pere.ite_code ite_code_pere, ite_pere.ite_libelle ite_libelle_pere, tit.tit_libelle, eco.eco_eval_objectif
			FROM
				etp_item_ss_item isi
					INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code 
					LEFT JOIN etp_eval_competence eco ON ite.ite_code=eco.ite_code AND eco.cse_code='.$cse_code.'
					INNER JOIN etp_item_etp ite_pere ON isi.etp_ite_code_pere=ite_pere.ite_code AND ite_pere.tit_code=3
					LEFT JOIN etp_prof_cs_item_etp ordre_fils ON ite.ite_code = ordre_fils.ite_code AND ordre_fils.pce_code='.$pce_code.'
					LEFT JOIN etp_prof_cs_item_etp ordre_pere ON ite_pere.ite_code = ordre_pere.ite_code AND ordre_pere.pce_code='.$pce_code.'
				,
				etp_type_item tit
			WHERE
				ite.tit_code = tit.tit_code AND
				tit.tit_code = 4
			ORDER BY
				tit.tit_libelle, ordre_pere.pci_ordre, ite_libelle_pere, ordre_fils.pci_ordre, ite.ite_code
		';/*tit.tit_libelle, ordre_pere.pci_ordre, ite_libelle_pere, ordre_fils.pci_ordre, ite.ite_libelle*/
		$daoIte = DB_DataObject::factory('etp_item_etp');
		$daoIte->query($q);
		while($daoIte->fetch())
			$data['ite_comp_list'][] = $daoIte->toArray();
		$daoIte->free();
		//<===
		
		//check valid radar...
		$this->itemsPsRadarGraph(0);
				
		return $data;
	}
	
	public function itemEvalGraph()
	{
		global $smarty;
		
		//Display the template
		$smarty->display('ajax/etp_item_eval_graph.tpl');
	}
	
	public function itemsPsRadarGraph($show_tpl=1, $just_eval_init=0)
	{
		global $smarty;
		
		$valid_radar_graph = 0;
		
		if($just_eval_init==1) {
			$daoCse1Init = DB_DataObject::factory('etp_cs');
			$daoCse1Init->pat_per_code = $this->per_code;
			$daoCse1Init->pce_code = 1;
			$daoEic_Join = DB_DataObject::factory('etp_eval_init_competence');
			$daoCse1Init->joinAdd($daoEic_Join, 'INNER', false, 'cse_code');
			$daoCse1Init->whereAdd('etp_eval_init_competence.eic_eval_init_objectif IS NOT NULL');
			if($daoCse1Init->find())
				$valid_radar_graph = 1;
			
			$daoEic_Join->free();
			$daoCse1Init->free();
		}
		else {		
			//DB_DataObject::debugLevel(1);
			$daoCse5 = DB_DataObject::factory('etp_cs');
			$daoCse5->pat_per_code = $this->per_code;
			$daoCse5->pce_code = 5;				
			$daoEco_Join = DB_DataObject::factory('etp_eval_competence');
			$daoCse5->joinAdd($daoEco_Join, 'INNER', false, 'cse_code');
			$daoCse5->whereAdd('etp_eval_competence.eco_eval_objectif IS NOT NULL');		
			if($daoCse5->find())
				$valid_radar_graph = 1;
			else
			{	//DB_DataObject::debugLevel(1);
				$daoCse1Init = DB_DataObject::factory('etp_cs');
				$daoCse1Init->pat_per_code = $this->per_code;
				$daoCse1Init->pce_code = 1;			
				$daoEic_Join = DB_DataObject::factory('etp_eval_init_competence');
				$daoCse1Init->joinAdd($daoEic_Join, 'INNER', false, 'cse_code');
				$daoCse1Init->whereAdd('etp_eval_init_competence.eic_eval_init_objectif IS NOT NULL');
				if($daoCse1Init->find())
					$valid_radar_graph = 1;
				
				$daoEic_Join->free();
				$daoCse1Init->free();
			}
			
			$daoEco_Join->free();
			$daoCse5->free();
		}
		
		$smarty->assign('valid_radar_graph', $valid_radar_graph);
		
		if($show_tpl) {
			//Display the template
			$smarty->display('ajax/etp_ps_radar_graph.tpl');
		}
	}
	
	public function reportSynthese()
	{
		global $smarty;
		if(!empty($_GET['per_code']))		
		{
			$cse_list = $this->getCseList($this->per_code);
			
			/*
			$cse_list = array();
			
			$daoSpe_Join = DB_DataObject::factory('etp_specialite');
			$daoPer_Join = DB_DataObject::factory('personne');
			
			$daoInt_Join = DB_DataObject::factory('etp_intervenant');			
			$daoInt_Join->joinAdd($daoSpe_Join);
			$daoInt_Join->joinAdd($daoPer_Join);
			
			$daoCse2 = DB_DataObject::factory('etp_cs');
			$daoCse2->pat_per_code = $this->per_code;
			$daoCse2->joinAdd($daoInt_Join, 'INNER', false, 'int_per_code');			
			$daoCse2->orderBy('cse_date, cse_code');
			$daoCse2->find();
			while($daoCse2->fetch())
				$cse_list[] = 	$daoCse2->toArray();
			
			$daoCse2->free();
			$daoInt_Join->free();
			$daoPer_Join->free();
			$daoSpe_Join->free();						
			
			//get data about each synthese consultation
			foreach($cse_list as $k=>$row)
			{
				$method = 'getPCE'.$row['pce_code'].'Data';
				$cse_list[$k]['data'] = $this->$method($row['cse_code']);
			}
			*/
			
			//check if exists and assign valid_radar_graph
			$this->itemsPsRadarGraph(0);
			
			//Assign data
			$smarty->assign('cseList', array_reverse($cse_list));
			
			//Assign patient info
			$smarty->assign('patInfo', $this->patInfo);
			
			//Display the template
			$smarty->display('etp/etp_report_synthese.tpl');
		}
		else
			exit('Invalid per code!!!');					
	}
	
	//???
	public function reportSynthese_only_pce_synthse()
	{
		global $smarty;
		if(!empty($_GET['per_code']))		
		{
			$cse_synthese_list = array();

			$daoSpe_Join = DB_DataObject::factory('etp_specialite');
			$daoPer_Join = DB_DataObject::factory('personne');
			
			$daoInt_Join = DB_DataObject::factory('etp_intervenant');			
			$daoInt_Join->joinAdd($daoSpe_Join);
			$daoInt_Join->joinAdd($daoPer_Join);
			
			$daoCse2 = DB_DataObject::factory('etp_cs');
			$daoCse2->pce_code = 2;
			$daoCse2->pat_per_code = $this->per_code;
			$daoCse2->joinAdd($daoInt_Join, 'INNER', false, 'int_per_code');			
			$daoCse2->orderBy('cse_date, cse_code');
			$daoCse2->find();
			while($daoCse2->fetch())
				$cse_synthese_list[] = 	$daoCse2->toArray();
			
			$daoCse2->free();
			$daoInt_Join->free();
			$daoPer_Join->free();
			$daoSpe_Join->free();						
			
			//get data about each synthese consultation
			foreach($cse_synthese_list as $k=>$row)
			{
				$cse_synthese_list[$k]['data'] = $this->getPCE2Data($row['cse_code']);
			}
			
			//Assign data
			$smarty->assign('cseSyntheseList', $cse_synthese_list);
			
			//Assign patient info
			$smarty->assign('patInfo', $this->patInfo);
			
			//Display the template
			$smarty->display('etp/etp_report_synthese.tpl');
		}
		else
			exit('Invalid per code!!!');					
	}
	
	public function reportIntvSuivi($effectue=true)
	{
		global $smarty;
		
		if($effectue)
			$eti_code=2;//Faite
		else
			$eti_code=3;//Non Faite
		
		$itv_suivi_list = array();
		$q = '
			SELECT
				csi.csi_comment_interv, cs.cse_code, cs.cse_date, itv.*, lit.lit_libelle,
				spe_int_itv.spe_libelle as int_itv_spe_libelle, per_int_itv.per_nom as int_itv_per_nom, per_int_itv.per_prenom as int_itv_per_prenom,
				
				spe_int_cs.spe_libelle as int_cs_spe_libelle, per_int_cs.per_nom as int_cs_per_nom, per_int_cs.per_prenom as int_cs_per_prenom
			FROM 
				etp_suivi_interv csi
				INNER JOIN etp_cs cs ON cs.cse_code=csi.cse_code AND cs.pce_code=4 AND cs.pat_per_code='.$this->per_code.'
				INNER JOIN etp_intervention itv ON itv.itv_code=csi.itv_code
				INNER JOIN etp_lieu_intervention lit ON lit.lit_code=itv.lit_code
				INNER JOIN etp_intervenant int_itv ON int_itv.per_code=itv.per_code
				INNER JOIN personne per_int_itv ON per_int_itv.per_code=int_itv.per_code
				INNER JOIN etp_specialite spe_int_itv ON spe_int_itv.spe_code=int_itv.spe_code
				
				INNER JOIN etp_intervenant int_cs ON int_cs.per_code=cs.int_per_code
				INNER JOIN personne per_int_cs ON per_int_cs.per_code=int_cs.per_code
				INNER JOIN etp_specialite spe_int_cs ON spe_int_cs.spe_code=int_cs.spe_code
			WHERE
				csi.eti_code='.$eti_code.'
			ORDER BY
				cs.cse_date, cs.cse_code, itv.itv_date, itv.itv_code
		';		
		$daoList = DB_DataObject::factory('etp_suivi_interv');		
		$daoList->query($q);
		while($daoList->fetch())
			$itv_suivi_list[] = $daoList->toArray();
		
		//Assign data
		$smarty->assign('itvSuiviList', $itv_suivi_list);
		
		//Assign eti code
		$smarty->assign('eti_code', $eti_code);
		



		//Assign patient info
		$smarty->assign('patInfo', $this->patInfo);
		
		//Display the template
		$smarty->display('etp/etp_report_intv_suivi.tpl');
	}
	
	public function courrier()
	{
		global $smarty;
		
		$this->objInitVar('ajax/etp_courier.tpl', 'etp_courier_'.$this->per_code);
		
		$invalid_cse_code = 1;
		if(isset($_GET['cse_code']) && ($cse_info = dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pat_per_code'=>$this->per_code))))
		{			
			$invalid_cse_code = 0;			
			
			$cse_code = $cse_info['cse_code'];
			
			$cse_info['pce_desc'] = dao_get_field_content('etp_profil_consultation', 'pce_desc', 'pce_code', $cse_info['pce_code']);
						
			//Assign Cse Info
			$smarty->assign('cseInfo', $cse_info);
			
			//Assign patient info
			$smarty->assign('patInfo', $this->patInfo);
			
			//assign specialite_medicale and etp_specilite
			$smarty->assign('spmList', dao_get_table_content('specialite_medicale', 'spm_code', 'spm_libelle', 'spm_libelle', null, 1));
			$smarty->assign('speList', dao_get_table_content('etp_specialite', 'spe_code', 'spe_libelle', 'spe_libelle', null, 1));
			
			if(!empty($_SESSION[SESS_IDX][$this->moduleName]))
				$smarty->assign('moduleSession', $_SESSION[SESS_IDX][$this->moduleName]);
			
			//Display the template
			$smarty->display('etp/etp_courrier.tpl');
		}
		else
			exit('Invalid cse code!!!');
	}
	
	public function searchCourrier()
	{
		global $smarty;
		
		$this->objInitVar('ajax/etp_courier.tpl', 'etp_courier_'.$this->per_code);
		
		if(empty($_GET['cse_code']))
			return ;
		else
			$cse_code = $_GET['cse_code'];
									
		if(isset($_POST['act']) && 'search'==$_POST['act'])//Action click search 
		{			
			$daoList = DB_DataObject::factory('v_personne');
			$sql_where = '';
					
			search($this->moduleName);
			$search_arr=isset($_SESSION[SESS_IDX][$this->moduleName]['search']) ? $_SESSION[SESS_IDX][$this->moduleName]['search'] : array();		
			if(count($search_arr)>0)
			{
				foreach($search_arr as $key=>$value)
				{
					switch($key) {
						case 'per_nom':
							$sql_where .= ' AND vp.per_nom LIKE \''.$daoList->escape($value).'%\'';
							break;
						case 'per_prenom':
							$sql_where .= ' AND vp.per_prenom LIKE \''.$daoList->escape($value).'%\'';
							break;
						case 'com_nom':
							$sql_where .= ' AND vp.com_nom LIKE \''.$daoList->escape($value).'%\'';
							break;
						case 'dep_nom':
							$sql_where .= ' AND vp.dep_nom LIKE \''.$daoList->escape($value).'%\'';
							break;
						case 'spe_code':														
							if(!empty($search_arr['spm_code']))
								$sql_where .= ' AND (cor.spe_code = '.$search_arr['spe_code'].' OR m.spm_code = '.$search_arr['spm_code']. ')';
							else
								$sql_where .= ' AND cor.spe_code = '.$value;							
							break;
						case 'spm_code':
							if(!empty($search_arr['spe_code']))
								;
							else
								$sql_where .= ' AND m.spm_code = '.$value;
							break;
							
						case 'spe_spm_code':
							if($value[0]=='c'){
								$tmp = explode('-', $value);
								$sql_where .= ' AND cor.spe_code = '.$tmp[1];								
							}
							elseif($value[0]=='m'){
								$tmp = explode('-', $value);
								$sql_where .= ' AND m.spm_code = '.$tmp[1];
							}
							break;
							
						case 'specialite':
							if($value[0]=='c'){
								$tmp = explode('-', $value);
								$sql_where .= ' AND cor.spe_code = '.$tmp[1];
							}
							elseif($value[0]=='m'){								
								$sql_where .= ' AND m.spm_code IS NOT NULL';
							}
							break;
					}
				}
			}
			
			//need added cse_code etp_courrier_edite
			
			/*
			//Use just corespondant
			$q = '
				SELECT
					vp.*, cor.spe_code
				FROM
					etp_correspondant cor
					INNER JOIN v_personne vp ON cor.per_code=vp.per_code
				
					LEFT JOIN etp_courrier_correspondant coc ON cor.per_code=coc.per_code
					LEFT JOIN etp_courrier_edite coe ON coc.coe_code=coe.coe_code AND coe.cse_code='.$cse_code.'
				WHERE
					coe.coe_code IS NULL
					'.$sql_where.'
				GROUP BY
					cor.per_code
				ORDER BY
					vp.per_nom, vp.per_prenom
			';//coc.per_code IS NULL 
			*/
			
			//DB_DataObject::debugLevel(1);			
			// GROUP_CONCAT(DISTINCT cor.spe_code SEPARATOR  ',') concat_spe, GROUP_CONCAT(DISTINCT m.spm_code SEPARATOR  ',') conact_spm
			$q = '
				SELECT
					vp.*, cor.spe_code, m.spm_code
				FROM
					v_personne vp															
					LEFT JOIN etp_correspondant cor ON cor.per_code=vp.per_code					
					LEFT JOIN medecin m ON m.per_code=vp.per_code
															
					LEFT JOIN etp_courrier_correspondant coc ON coc.per_code=vp.per_code 
					LEFT JOIN etp_courrier_edite coe ON coe.coe_code=coc.coe_code AND coe.cse_code='.$cse_code.'					
				WHERE
					coe.coe_code IS NULL AND (cor.per_code IS NOT NULL OR m.per_code IS NOT NULL)
					'.$sql_where.'
				GROUP BY
					vp.per_code
				ORDER BY
					vp.per_nom, vp.per_prenom
			';
			$daoList->query($q);			
			$list = array();
			while($daoList->fetch())
				$list[] = $daoList->toArray();			
			$daoList->free();
				
			$smarty->assign('recList', $list);
		}
		else {//get corespondats from the last cse
			
			$daoCseLast = DB_DataObject::factory('etp_cs');
			$daoCseLast->pat_per_code=$this->per_code;
			//$daoCseLast->pce_code = $pce_code;
			$daoCseLast->whereAdd('etp_cs.cse_code<'.$cse_code);
			$daoCseLast->orderBy('cse_date DESC, cse_code DESC');
			$daoCseLast->limit(0, 1);
			if($daoCseLast->find(1))
			{
				$cse_code_last = $daoCseLast->cse_code;
				
				/*
				//get corespondants from the last cse
				$daoCoc_List = DB_DataObject::factory('etp_courrier_correspondant');
					
				$daoCoe_Join = DB_DataObject::factory('etp_courrier_edite');
					
				$daoCoc_List->joinAdd($daoCoe_Join, 'INNER', false, 'coe_code');
				$daoCoc_List->whereAdd('etp_courrier_edite.cse_code='.$cse_code_last);
					
				$daoCor_Join = DB_DataObject::factory('etp_correspondant');
				$daoPer_Join = DB_DataObject::factory('v_personne');
				$daoCor_Join->joinAdd($daoPer_Join, 'INNER', 'v_personne', 'per_code');//because v_personne is a view
					
				$daoCoc_List->joinAdd($daoCor_Join, 'INNER', false, 'per_code');
					
				$daoCoc_List->orderBy('per_nom, per_prenom');
					
				$daoCoc_List->find();
				$list = array();
				while($daoCoc_List->fetch())
					$list[] = $daoCoc_List->toArray();
					
				$daoPer_Join->free();
				$daoCor_Join->free();
				$daoCoe_Join->free();
				$daoCoc_List->free();
				*/
				
				$daoList = DB_DataObject::factory('v_personne');
				$q = '
					SELECT
						vp.*, cor.spe_code, m.spm_code
					FROM
						v_personne vp
						LEFT JOIN etp_correspondant cor ON cor.per_code=vp.per_code
						LEFT JOIN medecin m ON m.per_code=vp.per_code
									
						LEFT JOIN etp_courrier_correspondant coc ON coc.per_code=vp.per_code
						LEFT JOIN etp_courrier_edite coe ON coe.coe_code=coc.coe_code AND coe.cse_code='.$cse_code.'
					WHERE						
						coe.cse_code='.$cse_code_last.' AND 
						(cor.per_code IS NOT NULL OR m.per_code IS NOT NULL)
						'.$sql_where.'
					GROUP BY
						vp.per_code
					ORDER BY
						vp.per_nom, vp.per_prenom
				';
				$daoList->query($q);					
				$list = array();
				while($daoList->fetch())
					$list[] = $daoList->toArray();
				$daoList->free();
				
				$smarty->assign('recList', $list);
			}
			$daoCseLast->free();
		}
		
		//assign specialite_medicale and etp_specilite
		$smarty->assign('spmList', dao_get_table_content('specialite_medicale', 'spm_code', 'spm_libelle', 'spm_libelle', null, 1));
		$smarty->assign('speList', dao_get_table_content('etp_specialite', 'spe_code', 'spe_libelle', 'spe_libelle', null, 1));
		
		$smarty->assign('moduleSession', $_SESSION[SESS_IDX][$this->moduleName]);
		
		//Display the template
		$smarty->display('ajax/etp_courier_search.tpl');
	}
	
	public function courrierCorrespondant()
	{
		global $smarty;
		
		if(!empty($_GET['cse_code'])) {
			
			$cse_code = $_GET['cse_code'];
			
			//opperations
			if(!empty($_POST['act']))
			{
				if($_POST['act'] == 'add' && !empty($_POST['per_code_courier']))
				{
					//DB_DataObject::debugLevel(1);
					//get coe code					
					$daoCoe = DB_DataObject::factory('etp_courrier_edite');
					$daoCoe->cse_code = $cse_code;
					if($daoCoe->find())
					{
						$daoCoe->fetch();
						$coe_code = $daoCoe->coe_code;
						$daoCoe->coe_date = dt_cdate();
						$daoCoe->update();
					}
					else
					{
						$daoCoe->coe_date = dt_cdate();
						
						$daoCoe->sequencyKey(false, false);
						$coe_code = $daoCoe->insert();
					}					
					//DB_DataObject::debugLevel(0);
					$daoCoe->free();
					
					if(!empty($coe_code))
					{
						//check if already exists
						$daoCoc = DB_DataObject::factory('etp_courrier_correspondant');
						$daoCoc->coe_code = $coe_code;
						$daoCoc->per_code = $_POST['per_code_courier'];
						if(!$daoCoc->find())
						{
							//insert into etp_courrier_correspondant					
							$daoCoc = DB_DataObject::factory('etp_courrier_correspondant');
							$daoCoc->coe_code = $coe_code;
							$daoCoc->per_code = $_POST['per_code_courier'];
							$daoCoc->stc_code =  1;
							$daoCoc->insert();
						}						
						$daoCoc->free();
					}
				}
				elseif($_POST['act']=='del' && !empty($_POST['per_code_courier']))
				{
					//get coe_code
					$daoCoe = DB_DataObject::factory('etp_courrier_edite');
					$daoCoe->cse_code = $cse_code;
					if($daoCoe->find())
					{
						$daoCoe->fetch();
						$coe_code = $daoCoe->coe_code;
						
						//delete from etp_courrier_correspondant
						$daoCoc = DB_DataObject::factory('etp_courrier_correspondant');
						$daoCoc->coe_code = $coe_code;
						$daoCoc->per_code = $_POST['per_code_courier'];
						$daoCoc->delete();
						$daoCoc->free();
												
						//delete parent
						$daoCoe->delete();
						$daoCoe->free();						
					}
					$daoCoe->free();
				}
				elseif($_POST['act']=='save')
				{
					/*get list of availabel courrier*/
					
					/*$q = '
						SELECT 
							coc.per_code, coc.stc_code, coe.coe_date
						FROM
							etp_courrier_correspondant coc							
							INNER JOIN etp_courrier_edite coe ON coe.coe_code=coc.coe_code							
						WHERE
							coe.cse_code='.$cse_code.'
					';*/
					
					$coc_list = array();
					
					$daoCoc_List = DB_DataObject::factory('etp_courrier_correspondant');
					$daoCoe_Join = DB_DataObject::factory('etp_courrier_edite');					
					$daoCoc_List->joinAdd($daoCoe_Join, 'INNER', false, 'coe_code');
					$daoCoc_List->whereAdd('etp_courrier_edite.cse_code='.$cse_code);
					
					if($daoCoc_List->find()) {
						while($daoCoc_List->fetch())
							$coc_list[] = $daoCoc_List->toArray();
					}
					$daoCoc_List->free();
					
					if(count($coc_list)>0)
					{
						foreach($coc_list as $k=>$coc)
						{
							if(!empty($_POST['stc_code_'.$coc['per_code']]))
							{
								//DB_DataObject::debugLevel(1);
								//update etp_courrier_correspondant
								$daoCoc_Upd = DB_DataObject::factory('etp_courrier_correspondant');
								$daoCoc_Upd->stc_code = $_POST['stc_code_'.$coc['per_code']];
								$daoCoc_Upd->coc_envoyer = !empty($_POST['envoyer_to_'.$coc['per_code']]) ? 1 : 0;  							
								$daoCoc_Upd->whereAdd('per_code='.$coc['per_code'].' AND coe_code='.$coc['coe_code']);
								$daoCoc_Upd->update(DB_DATAOBJECT_WHEREADD_ONLY);
								$daoCoc_Upd->free();								
							}
						}
					}					
				}
			}//end POST
			
			//===>if no courier edite (no crespondants), populate with corespondants from the last cse (previous coe code)
			//check if already exists coe
			$daoCoe = DB_DataObject::factory('etp_courrier_edite');
			$daoCoe->cse_code = $cse_code;
			if(!$daoCoe->find()) {				
				//get last coe code
				$daoCoe_prev = DB_DataObject::factory('etp_courrier_edite');				
				$daoCse_join = DB_DataObject::factory('etp_cs');
				$daoCse_join->pat_per_code = $this->per_code;				
				$daoCoe_prev->joinAdd($daoCse_join, 'INNER', false, 'cse_code');
				$daoCoe_prev->orderBy('coe_code DESC');
				if($daoCoe_prev->find(1)) {
					$coe_code_last = $daoCoe_prev->coe_code;
					
					//get corespondats fro the last coe_code
					$daoCoc_prev = DB_DataObject::factory('etp_courrier_correspondant');
					$daoCoc_prev->coe_code = $coe_code_last;
					if($daoCoc_prev->find()) {
												
						//insert new coe
						$daoCoe->coe_date = dt_cdate();							
						$daoCoe->sequencyKey(false, false);
						$coe_code_new = $daoCoe->insert();
						
						//while last corespondants for clone
						while($daoCoc_prev->fetch()) {
							
							//insert into etp_courrier_correspondant
							$daoCoc = DB_DataObject::factory('etp_courrier_correspondant');
							$daoCoc->coe_code = $coe_code_new;
							$daoCoc->per_code = $daoCoc_prev->per_code;
							$daoCoc->stc_code =  $daoCoc_prev->stc_code;
							$daoCoc->insert();
							$daoCoc->free();
							
						}
					}
					$daoCoc_prev->free();
					
				}
				$daoCoe_prev->free();
				$daoCse_join->free();								
			}
			$daoCoe->free();
			//<===
			
			/*
			//DB_DataObject::debugLevel(1);
			//get corespondant assigned
			$daoCoc_List = DB_DataObject::factory('etp_courrier_correspondant');
			
			$daoCoe_Join = DB_DataObject::factory('etp_courrier_edite');					
			
			$daoCoc_List->joinAdd($daoCoe_Join, 'INNER', false, 'coe_code');
			$daoCoc_List->whereAdd('etp_courrier_edite.cse_code='.$cse_code);
			
			$daoCor_Join = DB_DataObject::factory('etp_correspondant');
			$daoPer_Join = DB_DataObject::factory('v_personne');
			$daoCor_Join->joinAdd($daoPer_Join, 'INNER', 'v_personne', 'per_code');//because v_personne is a view
			
			$daoCoc_List->joinAdd($daoCor_Join, 'INNER', false, 'per_code');
			
			$daoCoc_List->orderBy('per_nom, per_prenom');
			
			$daoCoc_List->find();
			$list = array();
			while($daoCoc_List->fetch())
				$list[] = $daoCoc_List->toArray();
			
			$daoPer_Join->free();
			$daoCor_Join->free();
			$daoCoe_Join->free();
			$daoCoc_List->free();
			*/
			
			$daoList = DB_DataObject::factory('v_personne');
			$q = '
				SELECT
					vp.*, cor.spe_code, m.spm_code, etp_courrier_correspondant.*
				FROM
					v_personne vp
					LEFT JOIN etp_correspondant cor ON cor.per_code=vp.per_code
					LEFT JOIN medecin m ON m.per_code=vp.per_code
				
					LEFT JOIN etp_courrier_correspondant coc ON coc.per_code=vp.per_code
					LEFT JOIN etp_courrier_edite coe ON coe.coe_code=coc.coe_code AND coe.cse_code='.$cse_code.'
				WHERE
					coe.cse_code='.$cse_code.' AND
					(cor.per_code IS NOT NULL OR m.per_code IS NOT NULL)
					'.$sql_where.'
				GROUP BY
					vp.per_code
				ORDER BY
					vp.per_nom, vp.per_prenom
			';
			$q = '
				SELECT
					vp.*, coc.stc_code, coc.coc_envoyer, cor.spe_code, m.spm_code
				FROM
					etp_courrier_correspondant coc
					INNER JOIN etp_courrier_edite coe ON coe.coe_code=coc.coe_code
					INNER JOIN v_personne vp ON vp.per_code=coc.per_code
					
					LEFT JOIN etp_correspondant cor ON cor.per_code=vp.per_code
					LEFT JOIN medecin m ON m.per_code=vp.per_code
				WHERE
					coe.cse_code='.$cse_code.'
					'.$sql_where.'
				GROUP BY
					coc.per_code
				ORDER BY
					vp.per_nom, vp.per_prenom
			';
			$daoList->query($q);
			$list = array();
			while($daoList->fetch())
				$list[] = $daoList->toArray();
			$daoList->free();
			
			$smarty->assign('recList', $list);
			
			//assign specialite_medicale and etp_specilite
			$smarty->assign('spmList', dao_get_table_content('specialite_medicale', 'spm_code', 'spm_libelle', 'spm_libelle', null, 1));
			$smarty->assign('speList', dao_get_table_content('etp_specialite', 'spe_code', 'spe_libelle', 'spe_libelle', null, 1));
			$smarty->assign('stcList', dao_get_table_content('etp_signet_courrier', 'stc_code', 'stc_libelle_haut', 'stc_libelle_haut', null, 1));
			
			//Display the template
			$smarty->display('ajax/etp_courrier_correspondant.tpl');
		}				
	}
	
	public function courrierCompteRendu()
	{
		global $smarty;
		
		if(!empty($_GET['cse_code']) && ($cse_info = dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pat_per_code'=>$this->per_code))))
		{
			$cse_info['pce_desc'] = dao_get_field_content('etp_profil_consultation', 'pce_desc', 'pce_code', $cse_info['pce_code']);
			
			dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pat_per_code'=>$this->per_code));
			
			$etapeDataMethod = 'getPCE'.$cse_info['pce_code'].'Data';      		
			$cse_info['data'] = $this->$etapeDataMethod($cse_info['cse_code']);
			
			if($cse_info['pce_code']==5) {
				//check if exists and assign valid_radar_graph
				$this->itemsPsRadarGraph(0);
			}
			
			//Assign patient info
			$smarty->assign('cseInfo', $cse_info);
			
			//Assign patient info
			$smarty->assign('patInfo', $this->patInfo);
			
			//Display the template
			$smarty->display('ajax/etp_courrier_compte_rendu.tpl');
		}
		else
			exit('Invalid cse_code!!!');
	}
	
	public function courrierImprimer()
	{
		global $smarty;
		
		if(!empty($_GET['cse_code']) && ($cse_info = dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pat_per_code'=>$this->per_code))))
		{
			//get profil consultation name
			$cse_info['pce_desc'] = dao_get_field_content('etp_profil_consultation', 'pce_desc', 'pce_code', $cse_info['pce_code']);
			
			//get intervenant information
			$daoInt = DB_DataObject::factory('etp_intervenant');
			$daoInt->per_code = $cse_info['int_per_code'];
			$daoInt_join_VP = DB_DataObject::factory('v_personne');
			$daoInt_join_Spe = DB_DataObject::factory('etp_specialite');			
			$daoInt->joinAdd($daoInt_join_VP, 'INNER', false, 'per_code');
			$daoInt->joinAdd($daoInt_join_Spe, 'INNER');
			$daoInt->find(true);
			
			$cse_info['intervenant'] = $daoInt->toArray(); 
			
			//free
			$daoInt->free();
			$daoInt_join_VP->free();
			$daoInt_join_Spe->free();
			
			/*
			if($cse_info['pce_code']==5){
				//check if exists and assign valid_radar_graph
				$this->itemsPsRadarGraph(0);
			}
			*/
			
			//get consultation info
			$etapeDataMethod = 'getPCE'.$cse_info['pce_code'].'Data';      		
			$cse_info['data'] = $this->$etapeDataMethod($cse_info['cse_code']);
			
			//get courrrier list / DB_DataObject::debugLevel(1);
			$dao_coc = DB_DataObject::factory('etp_courrier_correspondant');
			$sql_where = '';

			if(!empty($_GET['envoyer_to']))
				$sql_where .= ' AND coc.per_code IN ('.trim($_GET['envoyer_to'], ',').')';		
			$q = '
				SELECT
					vp.*, stc.*
				FROM
					etp_courrier_correspondant coc
					INNER JOIN etp_signet_courrier stc ON stc.stc_code=coc.stc_code					
					INNER JOIN etp_courrier_edite coe ON coe.coe_code=coc.coe_code
					INNER JOIN v_personne vp ON vp.per_code=coc.per_code									
				WHERE
					coe.cse_code='.$cse_info['cse_code'].'					
					'.$sql_where.'
				GROUP BY
					coc.per_code
				ORDER BY
					vp.per_nom, vp.per_prenom
			';
			$dao_coc->query($q);
			$corespondantsList = array();
			while($dao_coc->fetch())
				$corespondantsList[] = $dao_coc->toArray();
			$dao_coc->free();
			
			//get consultation template html
			$smarty->assign('cseInfo', $cse_info);
			$html_cse = $smarty->fetch('pdf/etp_pdf_cse_etape_'.$cse_info['pce_code'].'.tpl');
			
			//==================================== PDF SET HEADER ====================================//
		
			header('Pragma: public'); // required // leave blank to avoid IE errors or header("Pragma: public");
			header('Expires: 0');
			header('Cache-Control: must-revalidate, post-check=0, pre-check='); //leave blank to avoid IE errors
			header('Cache-Control: private', false); // required for certain browsers 			
			//header('Content-type: application/pdf');
			
			error_reporting(0);

			require_once('tcpdf/config/lang/fra.php');
			require_once('tcpdf/tcpdf.php');
			
			//==================================== TCPDF INIT START ====================================//
						
			//create new PDF document (document units are set by default to millimeters)
			$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true); 
			
			// set document information
			$pdf->SetCreator(PDF_CREATOR);
			$pdf->SetAuthor(PDF_AUTHOR);
			$pdf->SetTitle('RAN ETP Edition courrier');
			$pdf->SetSubject('ETP Edition courrier');
			$pdf->SetKeywords('ETP,Edition courrier');
			
			$pdf->SetCellPadding(0);
			
			// set default header data
			$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, utf8_encode('Education Thrapeutique du Patient'), utf8_encode("Compte-rendu de consultation\n".$cse_info['pce_desc']));
			
			// set header and footer fonts
			$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
			$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
			
			// set default monospaced font
			$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
			
			//set margins
			$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
			
			$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
			$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
			
			//set auto page breaks
			$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
			
			//set image scale factor
			$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
			
			//set some language-dependent strings
			$pdf->setLanguageArray($l);
			
			// set default font subsetting mode
			$pdf->setFontSubsetting(true);
			
			// Set font
			$pdf->SetFont('helvetica', '', 10, '', true);//dejavusans
						
			foreach($corespondantsList as $keyC=>$itemC)
			{
				$pdf->setPrintHeader(true);
				
				// Add a page
				$pdf->AddPage();
				
				$pdf->setPrintHeader(false);
								
				$htmlc = '<div><strong>'.$itemC['civ_libelle_court'].' '.$itemC['per_nom'].' '.$itemC['per_prenom'].'</strong><br />'.nl2br($itemC['adr_voie']).'<br />'.$itemC['adr_cp'].' '.$itemC['adr_ville'].'</div>';
				//$htmlc = '<table border="0"><tr><td><strong>Docteur '.$itemC['civ_libelle_court'].' '.$itemC['per_nom'].' '.$itemC['per_prenom'].'</strong><br />'.nl2br($itemC['adr_voie']).'<br />'.$itemC['adr_cp'].'<br />'.$itemC['adr_ville'].'</td></tr></table>';							
				$pdf->writeHTMLCell(90, 0, 105, 45, utf8_encode($htmlc), 0, 2, 0, true);
											
				$htmlc = '<div style="text-align:right">Bordeaux le '.date('d/m/Y',strtotime($cse_info['cse_date'])).'</div>';				
				//$htmlc='<table border="0"><tr><td>Bordeaux le '.date('d/m/Y',strtotime($cse_info['cse_date'])).'</td></tr></table>';
				$pdf->writeHTMLCell(85, 0, 105, 80, utf8_encode($htmlc), 0, 1, 0, true);				

				
				$htmlc = '<br /><br /><div style="line-height:6px;">';
				$htmlc .= '<font size="+1">'.utf8_encode($itemC['stc_libelle_haut']).',</font><br />';
				$htmlc .= ''.utf8_encode(str_utf8_ucfirst($this->patInfo['per']['per_prenom']).' '.str_utf8_upper($this->patInfo['per']['per_nom'])).' '.utf8_encode('participe  notre programme ETP Transplantation').'.<br />';
				//$htmlc .= utf8_encode('Voici le compte rendu de l\'tape ') . '&quot;' . utf8_encode(str_utf8_ucfirst($cse_info['pce_desc'])) . '&quot;<br />';
				$htmlc .= utf8_encode('Voici le compte rendu de l\'tape ') . '&quot;' . utf8_encode($cse_info['pce_desc']) . '&quot;<br />';
				$htmlc .= '</div>';
				$pdf->writeHTML($htmlc, true, false, true, false, '');								
				
				//write cse content
				$pdf->writeHTML(utf8_encode($html_cse), true, false, true, false, '');
				
				//write intervenant
				$htmlc = '<br /><br /><div style="text-align:right">'.utf8_encode(str_replace("\n", '<br>', $itemC['stc_libelle_bas'])).'<br />'.utf8_encode(str_utf8_ucfirst($cse_info['intervenant']['per_prenom']).' '.str_utf8_upper($cse_info['intervenant']['per_nom'])).' ('.utf8_encode($cse_info['intervenant']['spe_libelle']).')</div>';
				$pdf->writeHTML($htmlc, true, false, true, false, '');
			}
						
			// Close and output PDF document			
			$pdf->Output();
		}
		else
			exit('Invalid cse_code!!!');
	}
	
	public function deleteCse()
	{
		if(!empty($_GET['cse_code']) && ($cse_info = dao_get_row_content('etp_cs', array('cse_code'=>$_GET['cse_code'], 'pat_per_code'=>$this->per_code))))
		{
			$cse_code = $cse_info['cse_code'];
			//DB_DataObject::debugLevel(1);
			if($cse_info['pce_code']==1)
			{
				//delete from etp_cs_recueil_item
				$daoDelTmp = DB_DataObject::factory('etp_cs_recueil_item');
				$daoDelTmp->whereAdd('cse_code='.$cse_code);
				$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelTmp->free();
				
				//delete from etp_eval_init_competence
				$daoDelTmp = DB_DataObject::factory('etp_eval_init_competence');
				$daoDelTmp->whereAdd('cse_code='.$cse_code);
				$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelTmp->free();
				
				//delte from etp_cs_recueil_donnees
				$daoDelTmp = DB_DataObject::factory('etp_cs_recueil_donnees');
				$daoDelTmp->whereAdd('cse_code='.$cse_code);
				$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelTmp->free();
			}
			elseif($cse_info['pce_code']==2)
			{
				//delete from etp_cs_synthese
				$daoDelTmp = DB_DataObject::factory('etp_cs_synthese');
				$daoDelTmp->whereAdd('cse_code='.$cse_code);
				$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelTmp->free();
			}
			elseif($cse_info['pce_code']==3)
			{
				//delete from etp_cs_prog_interv
				$daoDelTmp = DB_DataObject::factory('etp_cs_prog_interv');
				$daoDelTmp->whereAdd('cse_code='.$cse_code);
				$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelTmp->free();
			}
			elseif($cse_info['pce_code']==4)
			{
				//delete from etp_suivi_interv
				$daoDelTmp = DB_DataObject::factory('etp_suivi_interv');
				$daoDelTmp->whereAdd('cse_code='.$cse_code);
				$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelTmp->free();
				
				//delete from etp_cs_suivi
				$daoDelTmp = DB_DataObject::factory('etp_cs_suivi');
				$daoDelTmp->whereAdd('cse_code='.$cse_code);
				$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelTmp->free();
			}
			elseif($cse_info['pce_code']==5)
			{
				//delete from etp_eval_competence
				$daoDelTmp = DB_DataObject::factory('etp_eval_competence');
				$daoDelTmp->whereAdd('cse_code='.$cse_code);
				$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelTmp->free();
				
				//delete from etp_cs_evaluation
				$daoDelTmp = DB_DataObject::factory('etp_cs_evaluation');
				$daoDelTmp->whereAdd('cse_code='.$cse_code);
				$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
				$daoDelTmp->free();
			}
			
			//delte from etp_courrier_edite
			$daoDelTmp = DB_DataObject::factory('etp_courrier_correspondant');
			$daoDelTmp->whereAdd('etp_courrier_correspondant.coe_code IN (SELECT etp_courrier_edite.coe_code FROM etp_courrier_edite WHERE etp_courrier_edite.cse_code='.$cse_code.')');
			$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
			$daoDelTmp->free();
			/*
		 	DELETE FROM
				etp_courrier_edite,
				etp_courrier_correspondant
			USING
				etp_courrier_edite
				LEFT JOIN etp_courrier_correspondant ON etp_courrier_edite.coe_code=etp_courrier_correspondant.coe_code
			WHERE
				etp_courrier_edite.cse_code='.$cse_code
			*/			
			
			//delte from etp_courrier_edite
			$daoDelTmp = DB_DataObject::factory('etp_courrier_edite');
			$daoDelTmp->whereAdd('cse_code='.$cse_code);
			$daoDelTmp->delete(DB_DATAOBJECT_WHEREADD_ONLY);
			$daoDelTmp->free();
			
			//delete from etp_cs
			$daoDelCse = DB_DataObject::factory('etp_cs');
			$daoDelCse->get($cse_code);
			$daoDelCse->delete();
			$daoDelCse->free();
			
			//exit;			
		}
		//redirect to etp home
		redirect('index.php?obj='.$_GET['obj'].'&action=page_consultation&per_code='.$this->per_code);
	}
	
	public function evalTrait()
	{
		global $smarty;
	
		//Display the template
		$smarty->display('ajax/etp_eval_trait.tpl');
	}
	
	function checkEvalTraitHistoryExists()
	{
		//check and get initial cs_recueil_donnees.csr_eval_trait
		$q = '
			SELECT
				cs.cse_date, csr.csr_eval_trait
			FROM
				etp_cs_recueil_donnees csr,
				etp_cs cs
			WHERE
				csr.cse_code=cs.cse_code AND
				cs.pat_per_code='.$this->per_code.' AND
				csr.csr_eval_trait IS NOT NULL
		';
		$daoCsr = DB_DataObject::factory('etp_cs_recueil_donnees');
		$daoCsr->query($q);
		if($daoCsr->find()) {
			$daoCsr->free();
			
			return true;
		}		
		$daoCsr->free();
		
		//get from evaluation
		$q = '
			SELECT
				cs.cse_date, cse.cse_eval_trait
			FROM
				etp_cs_evaluation cse,
				etp_cs cs
			WHERE
				cse.cse_code=cs.cse_code AND
				cs.pat_per_code='.$this->per_code.'
			ORDER BY
				cs.cse_date, cs.cse_code
		';
		$daoCse = DB_DataObject::factory('etp_cs_evaluation');
		$daoCse->query($q);
		if($daoCse->find()) {
			$daoCse->free();
			
			return true;
			
		}
		$daoCse->free();
		
		return false;
	}
}
?>
