<?php
//#############################################################################//
//# Front
//#
//# Author: Colotin Florin (E-mail: colotin_f@yahoo.com, Web: www.yourchoice.ro)
//# Date: 05.01.2012
//#############################################################################//

class etp_intervenant extends ApplicationModel
{	
	function __construct($action)
	{		
		parent::__construct('etp_intervenant');
		
		//status: corespondant or not
		//$this->checkbox01Fields = array('int_status');
		
		$this->fkTables = array('etp_intervention', 'etp_cs');
		
		//Define form validation scheme
		$this->validationScheme = array('oblig'=>array('spe_code'));
		
		//Page actions
		switch($action)
	  	{
	  		case 'page':
				$this->page();
      		 	break;
	  	}
	}
	
	public function page()
	{
		global $smarty;
		
		$this->objInitVar('etp/etp_intervenant.tpl', 'etp_intervenantcc', 'etp_intervenant', 'per_code');
		
		//Prepare default form_act array
		$form_act=array();
		$form_act['act']='add';
		
		//Operations : Add/update | Del | Switch		
		if(!empty($_POST['act']) && ($_POST['act']=='add' || $_POST['act']=='upd'))
		{
			if(!empty($_POST['per_code_uti']))//is utilisateur
			{
				if($_SESSION[SESS_IDX][UL]['per_code_uti']==$_POST['per_code_uti'])
					$_SESSION[SESS_IDX][UL]['is_intervenant']=true;
				
				//Define form validation scheme
				$this->validationScheme = array('oblig'=>array('spe_code'));
				
				//Form validation
				$frmVld = new FormValidation($this->validationScheme, $this->tableName, $this->idName);			
				if(!$frmVld->errExists())
				{
					//prepare insert/update etp_intervenant table
		        	$daoAct = DB_DataObject::factory($this->tableName);			    	
			    	$daoAct->spe_code = $_POST['spe_code'];
			    	
			    	if($_POST['act'] == 'add')
			    	{
				    	$daoAct->per_code = $_POST['per_code_uti'];
			    		$daoAct->sequenceKey(false, false);
						$daoAct->insert();
						
						$id = $_POST['per_code_uti'];
			    	}
			    	elseif(!empty($_POST[$this->idName]))//update
			    	{
			    		$id = $_POST[$this->idName];
			    		
			    		$daoAct->get($id);
	            		$daoAct->update();
			    	}
			    	//free dao
			    	$daoAct->free();			    		    				    
			    	
			    	//check dao error
					$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
					if($error)
					{
						header('Content-type: text/xml');
						echo '<root><err>3</err><message>Query execution error!!!</message><query>' . $error->getMessage() . '</query></root>';
					}
			    	else
			    	{
				    	$message = 'Les donnes ont t correctement enregistr!';
				    	$redirect_url = ROOT_HOST.'index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&edit_id='.$id;//.'&done='.($_POST['act'] == 'add' ? 'add':'upd');
				    	
				    	header('Content-type: text/xml');
						echo '<root><err>0</err><message><![CDATA[' . utf8_encode($message) . ']]></message><redirect><![CDATA[' . $redirect_url . ']]></redirect></root>';
			    	}
			    	
			    	dao_error_tracker('INTERVENANT SAVE');
			    	exit;
				}
				else
					$frmVld->errOutput(1);
			}
			else//not utilisateur
			{
				//Define form validation scheme
				$this->validationScheme = array(
		    		'oblig'=>array('spe_code', 'civ_code', 'per_nom', 'per_prenom', 'adr_ville', 'adr_cp', 'adr_voie'/*, 'cer_code'*/),
					'length'=>array('per_nom'=>array('min'=>2, 'max'=>50), 'per_prenom'=>array('min'=>2, 'max'=>50))					
		    	);
		    	
		    	//Form validation
		    	$frmVld = new FormValidation($this->validationScheme, $this->tableName, $this->idName);			
				if(!$frmVld->errExists())
				{
					//prepare insert in the adresse table
			    	$daoAdrAct = DB_DataObject::factory('adresse_postale');
		        	$daoAdrAct->adr_voie = $_POST['adr_voie'];
		        	$daoAdrAct->adr_cp = $_POST['adr_cp'];
		        	$daoAdrAct->adr_ville = $_POST['adr_ville'];
		        	
			    	//prepare insert in the personne table
		        	$daoPerAct = DB_DataObject::factory('personne');	
			        $daoPerAct->cer_code = (!empty($_POST['cer_code']) ? $_POST['cer_code'] : null);			        			        
		        	$daoPerAct->civ_code = $_POST['civ_code'];
		        	$daoPerAct->per_nom = $_POST['per_nom'];
		        	$daoPerAct->per_prenom = $_POST['per_prenom'];
		        	
		        	//prepare insert in the etp_intervenant table
		        	$daoAct = DB_DataObject::factory($this->tableName);
			    	$daoAct->spe_code = $_POST['spe_code'];
			    	if($_POST['act'] == 'add')
			    	{
				    	//insert in persone table
						$id = $per_code = $daoPerAct->insert();					
			        	
						//first insert into adresse_postale
						$adr_code = $daoAdrAct->insert();
						
						//first insert into personne_adr_postale
						$daoPerAdrAdd = DB_DataObject::factory('personne_adr_postale');
						$daoPerAdrAdd->adr_code = $adr_code;
						$daoPerAdrAdd->per_code = $per_code;
						$daoPerAdrAdd->insert();
						$daoPerAdrAdd->free();
						
						//insert in utilisateur table						        
		        		$daoAct->per_code = $per_code;
		        		$daoAct->sequenceKey(false, false);
						$daoAct->insert();
			    	}
			    	elseif(!empty($_POST[$this->idName]))//update
			    	{			    		
			    		$id = $_POST[$this->idName];
			    		
			    		//update personne table
		        		$daoPerAct->get($id);
		        		$daoPerAct->wherePerAdd('per_code='.$id);
		            	$daoPerAct->update();
		            	
		            	//get data from personne_adr_postale
			            $daoPerAdrSel = DB_DataObject::factory('personne_adr_postale');
			            $daoPerAdrSel->whereAdd('per_code='.$id);
			            $daoPerAdrSel->orderBy('adr_code');
			            $daoPerAdrSel->limit(0,1);
			            $daoPerAdrSel->find();
						if($daoPerAdrSel->count())
						{
							$daoPerAdrSel->fetch();
							
							//update addrese voie	
							$daoAdrAct->whereAdd('adr_code='.$daoPerAdrSel->adr_code);
							$daoAdrAct->get($daoPerAdrSel->adr_code);
							$daoAdrAct->update();
						}
						else					
						{
							//insert into adresse_postale
							$adr_code = $daoAdrAct->insert();
							
							//second insert into personne_adr_postale
							$daoPerAdrAdd = DB_DataObject::factory('personne_adr_postale');
							$daoPerAdrAdd->adr_code = $adr_code;
							$daoPerAdrAdd->per_code = $id;
							$daoPerAdrAdd->insert();
							$daoPerAdrAdd->free();
						}
						$daoPerAdrSel->free();
						
						//update intervenant table
			            $daoAct->get($id);
			            $daoAct->wherePerAdd('per_code='.$id);
			            $daoAct->update();
			            
			    	}
			    	
			    	//dao free
			    	$daoAct->free();
			    	$daoPerAct->free();
			    	$daoAdrAct->free();
			    	
			    	//dao_error_tracker('INTERVENANT_PER');	
			    	
					//check dao error
					$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
					if($error)
					{
						header('Content-type: text/xml');
						echo '<root><err>3</err><message>Query execution error!!!</message><query>' . $error->getMessage() . '</query></root>';					
						exit;
					}
			    	else
			    	{
				    	if (isset($_POST['back_url']) and $_POST['back_url']!='')
			        		$redirect_url = string2var($_POST['back_url']);
			        	else
			        		$redirect_url = ROOT_HOST.'index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&edit_id='.$id.'&done='.($_POST['act'] == 'add' ? 'add':'upd');//#med_form
			        					        	
			    		$message = 'Les donnes ont t correctement enregistr!';
				    	//$redirect_url = ROOT_HOST.'index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&edit_id='.$id.'&done='.($_POST['act'] == 'add' ? 'add':'upd');
				    	
				    	header('Content-type: text/xml');
						echo '<root><err>0</err><message><![CDATA[' . utf8_encode($message) . ']]></message><redirect><![CDATA[' . $redirect_url . ']]></redirect></root>';
						exit;
			    	}
			    	
				}
				else
					$frmVld->errOutput(1);
			}				    	
		}		
		elseif(!empty($_GET['del_ids']))
		{			
			//delete one or more ids
			$str_ids_success = $this->delete($_GET['del_ids'], array());
			
			$list = array();			
			$id_arr = explode(',', $_GET['del_ids']);			
			foreach($id_arr as $k=>$v)			
				$list[$k][$this->idName] = $v;
			
			$this->checkDelBlockedList($list);
			
			
			$op_info['op'] = 'delete';
			$op_info['total'] = count($list);
			$op_info['success_num'] = 0;
			$op_info['success_str'] = '';
			$op_info['affected_num'] = '';
			$op_info['fail_num'] = 0;
			$op_info['fail_str'] = '';
			
			/*
			 * 
			 * need to ask if I will delete the persone or the persone will be deleted from RAN
			 * maybe better is to check if the intervenant is an utilisateur, if not then can be deleted from personne, else only from etp_intervenant
			 * 
			 *  
			foreach($list as $k=>$v)
			{
				if(!$v['del_blocked'])
				{
					$op_info['success_num']++;
					
					del_personne($v[$this->idName]);
				}
			}
			*/
			
			$_GET['done'] = 'delete';
			
			$smarty->assign('opInfo', $op_info);			
		}
		elseif(isset($_GET['switch_ids']) && isset($_GET['switch_value']))
		{
			//switch field value for one or more ids
			$this->switchField(array(0, 1));			
		}
		elseif(isset($_GET['edit_id']))
		{
			//prepare date for edit form
			$id = (int)$_GET['edit_id'];
			
			if($form_act = dao_get_row_content($this->tableName, array($this->idName=>$id)))
			{				
				//get person info
				$form_act['per'] = get_per_info($id);
				
				//this say if the intervenant is utilisateur
				$form_act['uti'] = dao_get_row_content('utilisateur', array('per_code_uti'=>$id));				
				
				$form_act['act'] = 'upd';
				/*
				echo $id.'#<pre style="text-align:left">';
				print_r($form_act);
				echo '</pre>'; exit;*/
			}
			else {        		
        		exit('Invalid id#'.$id);
        	}        	
		}
    			
		//===>get specialite intervenant list
		$daoSpeTsp_Join = DB_DataObject::factory('etp_type_specialite');
		$daoSpe = DB_DataObject::factory('etp_specialite');
		$daoSpe->joinAdd($daoSpeTsp_Join);
		$daoSpe->orderBy('spe_libelle');
		$daoSpe->find();
		$spe_list = array();
		while($daoSpe->fetch())
			$spe_list[$daoSpe->spe_code]=$daoSpe->toArray();
		$daoSpe->free();
		$daoSpeTsp_Join->free();
		//<===
		
		//===>get user that are not intervenant
		$daoUti = DB_DataObject::factory('utilisateur');
		
		$daoPerCiv_Join = DB_DataObject::factory('civilite');
		
		$daoUtiPer_Join = DB_DataObject::factory('personne');
		$daoUtiPer_Join->joinAdd($daoPerCiv_Join, 'inner');
		
		$daoPerInt_Join = DB_DataObject::factory('etp_intervenant');
		$daoUtiPer_Join->joinAdd($daoPerInt_Join, 'left');
				
		$daoUti->joinAdd($daoUtiPer_Join, 'inner');
		$daoUti->whereAdd('etp_intervenant.per_code IS NULL');
		$daoUti->groupBy('utilisateur.per_code_uti');
		$daoUti->orderBy('personne.per_nom, personne.per_prenom');
		
		$daoUti->find();
		$uti_non_int_list = array();		
		while($daoUti->fetch())	
			$uti_non_int_list[] = $daoUti->toArray();
		
		$daoUti->free();
		$daoUtiPer_Join->free();
		$daoPerInt_Join->free();
		$daoPerCiv_Join->free();
		//<===
		
		//Assign vars
		$smarty->assign('form_act', $form_act);
		$smarty->assign('speList', $spe_list);
		$smarty->assign('utiNonIntList', $uti_non_int_list);
		$smarty->assign('cerList', dao_get_table_content('centre_de_rattachement', 'cer_code', 'cer_nom', 'cer_nom', null, 1));
		$smarty->assign('civList', dao_get_table_content('civilite', 'civ_code', 'civ_libelle_long', 'civ_libelle_long', null, 1));		
		$smarty->assign('recList', $this->getList());
		
		$smarty->assign('moduleSession', $_SESSION[SESS_IDX][$this->moduleName]);
		
		//Display the template
		$smarty->display('etp/etp_intervenant.tpl');
	}
	
	private function getList()
	{
		$daoList = DB_DataObject::factory($this->tableName);
		
		//===>Set search criteria
		if(isset($_POST['act']) && 'search'==$_POST['act']) 
			search($this->moduleName);
		$search_arr=isset($_SESSION[SESS_IDX][$this->moduleName]['search']) ? $_SESSION[SESS_IDX][$this->moduleName]['search'] : array();		
		if(count($search_arr)>0)
		{
			foreach($search_arr as $key=>$value)
			{
				switch($key)
				{
					case 'cer_code':
						$daoList->whereAdd('cer_code='.$value);
						break;
					case 'civ_code':
						$daoList->whereAdd('civ_code='.$value);						
						break;
					case 'per_nom':
						$daoList->whereAdd('per_nom LIKE \''.$value.'%\'');
						break;
					case 'per_prenom':
						$daoList->whereAdd('per_prenom LIKE \''.$value.'%\'');
						break;
					
					case 'adr_ville':
						$daoList->whereAdd('adr_ville LIKE \''.$value.'%\'');
						break;
					case 'adr_cp':
						$daoList->whereAdd('adr_cp LIKE \''.$value.'%\'');
						break;
					
					case 'spe_code':
						$daoList->whereAdd($this->tableName.'.spe_code='.$value);
						break;
				}
			}
		}
		//<===
		
		//Sort & pagination
		$sql_sort = new_sort($this->moduleName, 'per_nom', 'ASC');
        $sql_limit = paging($this->moduleName); $sql_limit = trim(str_replace(' LIMIT ', '', $sql_limit));
        $sql_limit_arr = explode(',', $sql_limit);
        
        $daoVPer_Join = DB_DataObject::factory('v_personne');		
		$daoAdr_Join = DB_DataObject::factory('v_adresse');
		$daoSpe_Join = DB_DataObject::factory('etp_specialite');
        
        $daoList->joinAdd($daoVPer_Join, 'inner', false, 'per_code', 'per_code');
		$daoList->joinAdd($daoSpe_Join, 'inner');
        
		//total no rows
		$_SESSION[SESS_IDX][$this->moduleName]['paging']['no_rows_result'] = $daoList->count();
		
        $daoList->orderBy($sql_sort.', per_prenom');        
		$daoList->limit(trim($sql_limit_arr[0]), trim($sql_limit_arr[1]));		
		$daoList->find();
		
		$list = array(); $i=-1;
		while($daoList->fetch())
		{
			$i++;
			$list[$i] = $daoList->toArray();						
		}
		
		$daoList->free();
		$daoSpe_Join->free();
		$daoAdr_Join->free();
		$daoVPer_Join->free();
		
		//Check access to do delete operation 
		$this->checkDelBlockedList($list);
				
		return $list;
	}
}
?>
