<?php
//#############################################################################//
//# Front
//#
//# Author: Colotin Florin (E-mail: colotin_f@yahoo.com, Web: www.yourchoice.ro)
//# Date: 05.01.2012
//#############################################################################//

class etp_intervention extends ApplicationModel
{	
	function __construct($action)
	{		
		parent::__construct('etp_intervention');

		$this->fkTables = array('etp_cs_prog_interv', 'etp_suivi_interv');
		
		//Define form validation scheme
		$this->validationScheme = array(
    		'oblig'=>array('lit_code', 'per_code', 'itv_libelle', 'itv_date', 'itv_nb_places'),
			'length'=>array('itv_libelle'=>array('min'=>2, 'max'=>255)),
			'date'=>array('itv_date'),
			'integer'=>array('itv_nb_places'),
			'range'=>array('itv_nb_places'=>array('min'=>0, 'max'=>255)),
			'unsigned'=>array('itv_nb_places')
    	);
		
		//Page actions
		switch($action)
	  	{
	  		case 'page':
				$this->page();
      		 	break;
	  	}
	}
	
	public function page()
	{
		global $smarty;
		
		$this->objInitVar('etp/etp_intervention.tpl', 'etp_intervention', 'etp_intervention', 'itv_code');
		
		//Prepare default form_act array
		$form_act=array();
		$form_act['act']='add';
		
		//Operations : Add/update | Del | Switch		
		if(!empty($_POST['act']))
		{
			if(!empty($_POST['itv_date']))
				$_POST['itv_date'] = date_fr_to_mysql($_POST['itv_date']);
			
	    	$this->save();
		}		
		elseif(!empty($_GET['del_ids']))
		{			
			//delete one or more ids
			$str_ids_success = $this->delete($_GET['del_ids']);
		}
		elseif(isset($_GET['switch_ids']) && isset($_GET['switch_value']))
		{
			//switch field value for one or more ids
			$this->switchField(array(0, 1));			
		}
		elseif(isset($_GET['edit_id']))
		{
			//prepare date for edit form
			$id=(int)$_GET['edit_id'];
			
			$daoForm = DB_DataObject::factory($this->tableName);
			$daoForm->get($id);
			$daoForm->find();
			if($daoForm->fetch())
			{
				$form_act = $daoForm->toArray();
				$form_act['act'] = 'upd';
				
				$daoForm->free();
			}
        	else {
        		$daoForm->free();
        		exit('Invalid id#'.$id);
        	}
		}
    	
		//===>get person intervenant list
		$int_list = array();
		$daoIntPer_join = DB_DataObject::factory('personne');
		$daoIntSpe_join = DB_DataObject::factory('etp_specialite');
		$daoInt = DB_DataObject::factory('etp_intervenant');
		$daoInt->joinAdd($daoIntPer_join, 'INNER');
		$daoInt->joinAdd($daoIntSpe_join, 'INNER');
		$daoInt->orderBy('per_nom, per_prenom');
		$daoInt->find();
		while($daoInt->fetch())
			$int_list[$daoInt->per_code] = $daoInt->toArray();
		$daoInt->free();
		$daoIntSpe_join->free();
		$daoIntPer_join->free();
		//<===
		
		//Assign vars
		$smarty->assign('form_act', $form_act);
		$smarty->assign('intList', $int_list);
		$smarty->assign('litList', dao_get_table_content('etp_lieu_intervention', 'lit_code', 'lit_libelle', 'lit_libelle', null, 1));		
		$smarty->assign('recList', $this->getList());
		$smarty->assign('moduleSession', $_SESSION[SESS_IDX][$this->moduleName]);
		
		//Display the template
		$smarty->display('etp/etp_intervention.tpl');
	}
	
	private function getList()
	{
		$daoList = DB_DataObject::factory($this->tableName);
		
		//===>Set search criteria
		if(isset($_POST['act']) && 'search'==$_POST['act'])
			search($this->moduleName);
		$search_arr=isset($_SESSION[SESS_IDX][$this->moduleName]['search']) ? $_SESSION[SESS_IDX][$this->moduleName]['search'] : array();		
		if(count($search_arr)>0)
		{
			foreach($search_arr as $key=>$value)
			{	
				switch($key)
				{
					case 'lit_code':
						$daoList->whereAdd($this->tableName.'.lit_code='.$value);
						break;					
					case 'per_code':
						$daoList->whereAdd($this->tableName.'.per_code='.$value);
						break;
					case 'itv_libelle':
						$daoList->whereAdd('itv_libelle LIKE \''.$value.'%\'');
						break;
						
					case 'int_status':
						$daoList->whereAdd('etp_intervenant.int_status='.$value);
						break;
				}
			}
		}		
		//<===
		
		//Sort & pagination
		$sql_sort = new_sort($this->moduleName, 'itv_date', 'DESC');
        $sql_limit = paging($this->moduleName); $sql_limit = trim(str_replace(' LIMIT ', '', $sql_limit));
        $sql_limit_arr = explode(',', $sql_limit);
                
        $daoItvLit_Join = DB_DataObject::factory('etp_lieu_intervention');
        $daoItvInt_Join = DB_DataObject::factory('etp_intervenant');
        
        $daoIntPer_Join = DB_DataObject::factory('personne');        
        $daoIntSpe_Join = DB_DataObject::factory('etp_specialite');
        
        $daoItvInt_Join->joinAdd($daoIntPer_Join);
        $daoItvInt_Join->joinAdd($daoIntSpe_Join);
        
        $daoList->joinAdd($daoItvLit_Join);
        $daoList->joinAdd($daoItvInt_Join);
        
        $_SESSION[SESS_IDX][$this->moduleName]['paging']['no_rows_result'] = $daoList->count();
        
        $daoList->orderBy($sql_sort);        
		$daoList->limit(trim($sql_limit_arr[0]), trim($sql_limit_arr[1]));		
		$daoList->find();
		
		$list = array(); $i=-1;
		while($daoList->fetch())
		{
			$i++;
			$list[$i] = $daoList->toArray();						
		}
		
		$daoList->free();
		$daoItvInt_Join->free();
		$daoIntPer_Join->free();
		$daoIntSpe_Join->free();
		$daoItvLit_Join->free();
		
		//Check access to do delete operation 
		$this->checkDelBlockedList($list);
				
		return $list;
	}
}
?>