<?php
//#############################################################################//
//# Front
//#
//# Author: Colotin Florin (E-mail: colotin_f@yahoo.com, Web: www.yourchoice.ro)
//# Date: 12.01.2012
//#############################################################################//

class etp_lieu_intervention extends ApplicationModel
{	
	function __construct($action)
	{		
		parent::__construct('etp_lieu_intervention');

		$this->fkTables = array('etp_intervention');
		
		//Define form validation scheme
		$this->validationScheme = array(
    		'oblig'=>array('lit_libelle'),
			'length'=>array('lit_libelle'=>array('min'=>2, 'max'=>255)),
			'unique'=>array('lit_libelle')
    	);
		
		//Page actions
		switch($action)
	  	{
	  		case 'page':
				$this->page();
      		 	break;
	  	}
	}
	
	public function page()
	{
		global $smarty;
		
		$this->objInitVar('etp/etp_lieu_intervention.tpl', 'etp_lieu_intervention', 'etp_lieu_intervention', 'lit_code');
		
		//Prepare default form_act array
		$form_act=array();
		$form_act['act']='add';
		
		//Operations : Add/update | Del | Switch		
		if(!empty($_POST['act']))
		{
			$this->save();
		}		
		elseif(!empty($_GET['del_ids']))
		{			
			//delete one or more ids
			$str_ids_success = $this->delete($_GET['del_ids']);
		}		
		elseif(isset($_GET['edit_id']))
		{
			//prepare date for edit form
			$id=(int)$_GET['edit_id'];
			
			$daoForm = DB_DataObject::factory($this->tableName);
			$daoForm->get($id);
			$daoForm->find();
			if($daoForm->fetch())
			{
				$form_act = $daoForm->toArray();
				$form_act['act'] = 'upd';
				
				$daoForm->free();
			}
        	else {
        		$daoForm->free();
        		exit('Invalid id#'.$id);
        	}
		}
    	
		//Assign vars
		$smarty->assign('form_act', $form_act);		
		$smarty->assign('recList', $this->getList());
		$smarty->assign('moduleSession', $_SESSION[SESS_IDX][$this->moduleName]);
		
		//Display the template
		$smarty->display('etp/etp_lieu_intervention.tpl');
	}
	
	private function getList()
	{
		$daoList = DB_DataObject::factory($this->tableName);
		
		//===>Set search criteria
		if(isset($_POST['act']) && 'search'==$_POST['act'])
			search($this->moduleName);
		$search_arr=isset($_SESSION[SESS_IDX][$this->moduleName]['search']) ? $_SESSION[SESS_IDX][$this->moduleName]['search'] : array();		
		if(count($search_arr)>0)
		{
			foreach($search_arr as $key=>$value)
			{	
				switch($key)
				{
					case 'lit_libelle':
						$daoList->whereAdd('lit_libelle LIKE \''.$value.'%\'');
						break;
				}
			}
		}		
		//<===
		
		//Sort & pagination
		$sql_sort = new_sort($this->moduleName, 'lit_libelle', 'ASC');
        $sql_limit = paging($this->moduleName); $sql_limit = trim(str_replace(' LIMIT ', '', $sql_limit));
        $sql_limit_arr = explode(',', $sql_limit);
                
        $_SESSION[SESS_IDX][$this->moduleName]['paging']['no_rows_result'] = $daoList->count();
        
        $daoList->orderBy($sql_sort);
		$daoList->limit(trim($sql_limit_arr[0]), trim($sql_limit_arr[1]));		
		$daoList->find();
		
		$list = array(); $i=-1;
		while($daoList->fetch())
		{
			$i++;
			$list[$i] = $daoList->toArray();						
		}
		
		$daoList->free();
		
		//Check access to do delete operation 
		$this->checkDelBlockedList($list);
				
		return $list;
	}
}
?>