<?php
//#############################################################################//
//# etp specialite
//#
//# Author: Colotin Florin (E-mail: colotin_f@yahoo.com, Web: www.yourchoice.ro)
//# Date: 29.10.2013
//#############################################################################//

class etp_specialite extends ApplicationModel
{	
	function __construct($action)
	{		
		parent::__construct('etp_specialite');
		
		//status: corespondant or not
		//$this->checkbox01Fields = array('int_status');
		
		$this->fkTables = array('etp_correspondant', 'etp_intervenant');
		
		//Define form validation scheme
		$this->validationScheme = array('oblig'=>array('tsp_code', 'spe_libelle'), 'length'=>array('spe_libelle'=>array('min'=>2, 'max'=>50)));
		
		//Page actions
		switch($action)
	  	{
	  		case 'page':
				$this->page();
      		 	break;
	  	}
	}
	
	public function page()
	{
		global $smarty;
		
		$this->objInitVar('etp/etp_specialite.tpl', 'etp_specialite', 'etp_specialite', 'spe_code');
		
		//Prepare default form_act array
		$form_act = array();
		$form_act['act'] = 'add';
		
		//Operations : Add/update | Del | Switch
		if(!empty($_POST['act']) && ($_POST['act']=='add' || $_POST['act']=='upd'))
		{				
	    	//Form validation
	    	$frmVld = new FormValidation($this->validationScheme, $this->tableName, $this->idName);			
			if(!$frmVld->errExists())
			{	
				//DB_DataObject::debugLevel(1);			
	        	//prepare insert in the etp_specialite table
	        	$daoAct = DB_DataObject::factory($this->tableName);
		    	$daoAct->tsp_code = $_POST['tsp_code'];
		    	$daoAct->spe_libelle = $_POST['spe_libelle'];
		    	if($_POST['act'] == 'add') {;
			    	//insert in persone table
					$id = $daoAct->insert();//$daoAct->sequenceKey(false, false);
		    	}
		    	elseif(!empty($_POST[$this->idName]))//update
		    	{			    		
		    		$id = $_POST[$this->idName];
		    		
					//update correspondant table
		            $daoAct->get($id);
		            $daoAct->update();
		    	}
		    	
		    	//dao free
		    	$daoAct->free();
		    	
		    	//dao_error_tracker('etp_specialite');	
		    	
				//check dao error
				$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
				if($error){
					header('Content-type: text/xml');
					echo '<root><err>3</err><message>Query execution error!!!</message><query>' . $error->getMessage() . '</query></root>';
				}
		    	else{
		    		$message = 'Les donnes ont t correctement enregistr!';
		    		
		    		$redirect_url = ROOT_HOST.'index.php?obj='.$_GET['obj'].'&action='.$_GET['action'];//.'&edit_id='.$id.'&done='.($_POST['act'] == 'add' ? 'add':'upd');//#med_form		        			    		
		    		
			    	header('Content-type: text/xml');
					echo '<root><err>0</err><message><![CDATA[' . utf8_encode($message) . ']]></message><redirect><![CDATA[' . $redirect_url . ']]></redirect></root>';
		    	}
		    	dao_error_tracker('CORESPONDANT SAVE');
		    	exit;
			}
			else
				$frmVld->errOutput(1);			    	
		}
		elseif(!empty($_GET['del_ids']))
		{			
			//delete one or more ids
			$str_ids_success = $this->delete($_GET['del_ids']);
			
			$list = array();
			$id_arr = explode(',', $_GET['del_ids']);	
			foreach($id_arr as $k=>$v)			
				$list[$k][$this->idName] = $v;
			
			//$this->checkDelBlockedList($list);
						
			$op_info['op'] = 'delete';
			$op_info['total'] = count($list);
			$op_info['success_num'] = 0;
			$op_info['success_str'] = '';
			$op_info['affected_num'] = '';
			$op_info['fail_num'] = 0;
			$op_info['fail_str'] = '';
			
			
			$_GET['done'] = 'delete';
			
			$smarty->assign('opInfo', $op_info);
		}		
		elseif(isset($_GET['edit_id']))
		{
			//prepare date for edit form
			$id = (int)$_GET['edit_id'];
			
			if($form_act = dao_get_row_content($this->tableName, array($this->idName=>$id)))
			{
				$form_act['act'] = 'upd';
				/*
				echo $id.'#<pre style="text-align:left">';
				print_r($form_act);
				echo '</pre>'; exit;
				*/
			}
			else {        		
        		exit('Invalid id#'.$id);
        	}     	
		}    		
		
		//Assign vars
		$smarty->assign('form_act', $form_act);
		$smarty->assign('tspList', dao_get_table_content('etp_type_specialite', 'tsp_code', 'tsp_libelle', 'tsp_libelle', null, 1));
		$smarty->assign('recList', $this->getList());
		
		$smarty->assign('moduleSession', $_SESSION[SESS_IDX][$this->moduleName]);
		
		//Display the template
		$smarty->display('etp/etp_specialite.tpl');
	}
	
	private function getList()
	{
		$daoList = DB_DataObject::factory($this->tableName);
		
		//===>Set search criteria
		if(isset($_POST['act']) && 'search'==$_POST['act']) 
			search($this->moduleName);
		$search_arr=isset($_SESSION[SESS_IDX][$this->moduleName]['search']) ? $_SESSION[SESS_IDX][$this->moduleName]['search'] : array();		
		if(count($search_arr)>0)
		{
			foreach($search_arr as $key=>$value)
			{
				switch($key)
				{
					case 'tsp_code':
						$daoList->whereAdd('tsp_code='.$value);
						break;					
					case 'spe_libelle':
						$daoList->whereAdd('spe_libelle LIKE \''.$value.'%\'');
						break;					
				}
			}
		}
		//<===
		
		//Sort & pagination
		$sql_sort = new_sort($this->moduleName, 'spe_code', 'DESC');
        $sql_limit = paging($this->moduleName); $sql_limit = trim(str_replace(' LIMIT ', '', $sql_limit));
        $sql_limit_arr = explode(',', $sql_limit);
        		
		$daoTsp_Join = DB_DataObject::factory('etp_type_specialite');
		
        $daoList->joinAdd($daoTsp_Join, 'inner', false, 'tsp_code', 'tsp_code');
		//$daoList->joinAdd($daoTsp_Join, 'inner');
        
		//total no rows
		$_SESSION[SESS_IDX][$this->moduleName]['paging']['no_rows_result'] = $daoList->count();
		
        $daoList->orderBy($sql_sort);        
		$daoList->limit(trim($sql_limit_arr[0]), trim($sql_limit_arr[1]));		
		$daoList->find();
		
		$list = array(); $i=-1;
		while($daoList->fetch())
		{
			$i++;
			$list[$i] = $daoList->toArray();						
		}
		
		$daoList->free();
		$daoTsp_Join->free();
		
		//Check access to do delete operation 
		$this->checkDelBlockedList($list);
		
		return $list;
	}
}
?>