<?
class ApplicationModel
{	
	protected $tableName;
    protected $idName;
	protected $idValue;
	
	protected $sqlSelect;
    protected $sqlFrom;
    protected $sqlWhere;
    
    protected $sqlGroupBy;
	protected $sqlHaving;
	protected $sqlSort;
	
	protected $fkTables;
	protected $statusField;
    protected $validationScheme;
    protected $idTypeNumeric = true;
    protected $checkbox01Fields;
    
	protected $tplName;
    protected $moduleName;      
    
	function __construct($table_name, $status_field = '')
	{		
		$this->tableName = $table_name;
		$this->idName = $table_name.'_id';
		
		if ($status_field !== '') {			
			$this->statusField = $status_field;			
			$this->checkbox01Fields = array($this->statusField);
		}
		$this->tplName = $table_name.'.tpl';
		$this->moduleName = $table_name;				
	}
  	
	function objInitVar($tpl_name = '', $module_name = '', $table_name = '', $id_name = '', $status_field = '')
	{
		global $smarty;
		
		if ($tpl_name) $this->tplName = $tpl_name;
		if ($module_name) $this->moduleName = $module_name;		
		if ($table_name) $this->tableName = $table_name;
		if ($id_name) $this->idName = $id_name;
		if ($status_field) $this->statusField = $status_field;
		
		if (!isset($_SESSION[SESS_IDX][$this->moduleName]))
			$_SESSION[SESS_IDX][$this->moduleName] = array();

		//Assign variables
		$smarty->assign('tableName', $this->tableName);
		$smarty->assign('idName', $this->idName);
		$smarty->assign('statusField', $this->statusField);
	}
	
	function save($st_ret = false, $redirect_url = false)
	{
		if(isset($_POST['act']) && ('add'==$_POST['act'] || 'upd'==$_POST['act'])) 
		{		
			$frmVld = new FormValidation($this->validationScheme, $this->tableName, $this->idName);			
			if(!$frmVld->errExists())
			{							
				$daoAct = DB_DataObject::factory($this->tableName);
				if($_POST['act']=='add'){
					$op='add';
					$daoAct->sequenceKey($this->idName, false);
				}
				else{
					$op='upd';
					$id = $_POST[$this->idName];
					$daoAct->get($id);
					$daoAct->whereAdd($this->idName.'='.$id);
				}

				//get table fields
				$table_data = dao_get_table_fields($this->tableName, ROOT_DIR.'DAO/ini/ran.ini');
				foreach ($table_data['fields'] as $field) {
					if (isset($_POST[$field]) && $field != $this->idName) {
						if (trim($_POST[$field]) == '')
							$daoAct->$field = 'NULL';
						else
							$daoAct->$field = trim($_POST[$field]);
					}
				}

				//case for checkbox fields (unchecked case)
				if (is_array($this->checkbox01Fields))
					foreach ($this->checkbox01Fields as $cbf)
						if (!isset($_POST[$cbf]))
							$daoAct->$cbf = 0;
			
									
				if($_POST['act']=='add')//add new
				{					
					$id = $daoAct->insert();
				}
				else//update
				{
					
					$daoAct->update();
				}
				//free dao
				$daoAct->free();
				
				//check exists dao errors
				$error = &PEAR::getStaticProperty('DB_DataObject', 'lastError');
				if($error)
				{
					dao_error_tracker('APP MODEL SAVE');
					header('Content-type: text/xml');
					echo '<root><err>3</err><message>Query execution error!!!</message><query>' . $error->getMessage() . '</query></root>';					
					exit;
				}
				else {
					
					$message = 'Les donnes ont t correctement enregistr';
					
					if(!$redirect_url)
						$redirect_url = ROOT_HOST.'index.php?obj='.$_GET['obj'].'&action='.$_GET['action'];
					
					//$redirect_url .= '&done='.$op;
					//$redirect_url = ROOT_HOST.'index.php?obj='.$_GET['obj'].'&action='.$_GET['action'].'&'.$this->idName.'='.$id.'&done='.$op;	
						
					if ($st_ret)
						return array('id' => $id, 'message' => $message, 'redirect' => $redirect_url);
					else {
						header('Content-type: text/xml');
						echo '<root><err>0</err><message><![CDATA[' . utf8_encode($message) . ']]></message><redirect><![CDATA[' . $redirect_url . ']]></redirect></root>';
						exit;
					}
				}
				                
			}//end formValidate
			else
				$frmVld->errOutput(1);
		}
	}
	
	function delete($del_ids, $others_to_delete = null)
	{
		if ($del_ids!='')//comma separated
		{
			global $smarty;
			
			$op_info['op'] = 'delete';
			$op_info['total'] = 0;
			$op_info['success_num'] = 0;
			$op_info['success_str'] = '';
			$op_info['affected_num'] = '';
			$op_info['fail_num'] = 0;
			$op_info['fail_str'] = '';
			
			$ids_arr = array();
			if (method_exists($this, 'verifyDelAccess'))
			{
				$invalid_id_arr = array();
				
				$tmp_arr = explode(',', $del_ids);
				foreach ($tmp_arr as $id)
				{
					if ($this->verifyDelAccess($id))//is_numeric($id) && 
						$ids_arr[]=$id;
					else
						$invalid_id_arr[$id]=$id;
				}
				
				$op_info['fail_num'] += count($invalid_id_arr);
				$op_info['fail_str'] .= implode(',', $invalid_id_arr);				
			}
			else {
				$tmp_arr=explode(',', $del_ids);				
				foreach($tmp_arr as $id) $ids_arr[]=$id;// if(is_numeric($id))
			}			
			
			if (($op_info['total'] = count($ids_arr)) > 0)
			{
				if ($this->idTypeNumeric)				
					$ids_str=implode(',', $ids_arr);
				else {
					$ids_str = '';
					foreach ($ids_arr as $id)
						$ids_str .= '\'' . $id . '\',';
					if ($ids_str != '')
						$ids_str = substr($ids_str, 0, strlen($ids_str)-1);
				}
				
				//Check if exists FK dependencies
				if (count($this->fkTables) > 0)
				{
					$valid_id_arr = array();
					$invalid_id_arr = array();
					
					foreach ($this->fkTables as $fkTable) 
					{
						$daoTmp_Join = DB_DataObject::factory($this->tableName);
						$daoTmp = DB_DataObject::factory($fkTable);
						$daoTmp->joinAdd($daoTmp_Join, 'INNER', 'jt');
						$daoTmp->whereAdd('jt.'.$this->idName.' IN ('.$ids_str.')');
						$daoTmp->find();
						while($daoTmp->fetch())
						{
							$id_name = $this->idName;
							$invalid_id_arr[$daoTmp->$id_name] = $daoTmp->$id_name;
						}
						$daoTmp->free();
						$daoTmp_Join->free();						
					}
					
					$op_info['fail_num'] += count($invalid_id_arr);
					$op_info['fail_str'] .= implode(',', $invalid_id_arr);
					
					foreach ($ids_arr as $id)
						if (!isset($invalid_id_arr[$id]))
							$valid_id_arr[$id] = $id;
				}
				else
					$valid_id_arr = $ids_arr;
								
				if(count($valid_id_arr)>0)
				{
					if ($this->idTypeNumeric)				
						$valid_id_str = implode(',', $valid_id_arr);
					else {
						$valid_id_str = '';
						foreach ($valid_id_arr as $id)
							$valid_id_str .= '\'' . $id . '\',';
						if ($ids_str != '')
							$valid_id_str = substr($valid_id_str, 0, strlen($valid_id_str)-1);
					}										
					
					//delete from aother table dependencies
					if (is_array($others_to_delete)) {
						foreach ($others_to_delete as $t)
						{							
							$daoDel = DB_DataObject::factory($t);
							$daoDel->whereAdd($this->idName.' IN ('.$valid_id_str.')');
							$daoDel->delete(DB_DATAOBJECT_WHEREADD_ONLY);					
							$daoDel->free();
						}
					}
					elseif ($others_to_delete) { //a single table						
						$daoDel = DB_DataObject::factory($others_to_delete);
						$daoDel->whereAdd($this->idName.' IN ('.$valid_id_str.')');
						$daoDel->delete(DB_DATAOBJECT_WHEREADD_ONLY);					
						$daoDel->free();
					}
					
					//delete
					$daoDel = DB_DataObject::factory($this->tableName);
					$daoDel->whereAdd($this->idName.' IN ('.$valid_id_str.')');
					$op_info['affected_num'] = $daoDel->delete(DB_DATAOBJECT_WHEREADD_ONLY);
					$daoDel->free();
											
					$op_info['success_num'] = count($valid_id_arr);
					$op_info['success_str'] = $valid_id_str;
				}
			}
			else
				$op_info['err'] = 'Invalid ids sent!!!';
			
			$_GET['done'] = 'delete';
			$smarty->assign('opInfo', $op_info);
			
			return $op_info['success_str'];//$op_info['affected_num'];
		}
	}
	
	function switchField($accepted_values = array(0, 1))
	{
		if (isset($_GET['switch_ids']) && isset($_GET['switch_value']))
		{
			global $dbi, $smarty;
			
			$op_info['op'] = 'switch';
			$op_info['total'] = 0;
			$op_info['success_num'] = 0;
			$op_info['success_str'] = '';
			$op_info['affected_num'] = '';
			$op_info['fail_num'] = 0;
			$op_info['fail_str'] = '';
			
			$tmp_arr = explode(',', $_GET['switch_ids']);
			foreach ($tmp_arr as $id) 
				$ids_arr[] = $id;
			
			if (($op_info['total'] = count($ids_arr)) > 0)
			{
				$switch_field = !empty($_GET['switch_field']) ? $_GET['switch_field']:(!empty($this->statusField) ? $this->statusField : '');
				if ($switch_field)
				{
					if (in_array($_GET['switch_value'], $accepted_values))
					{
						if (method_exists($this, 'verifySwitchAccess'))
						{
							$valid_id_arr = $invalid_id_arr = array();
							
							foreach ($ids_arr as $id)
								if($this->verifySwitchAccess($id))
									$valid_id_arr[]=$id;
								else
									$invalid_id_arr[$id]=$id;
							
							$op_info['fail_num'] += count($invalid_id_arr);
							$op_info['fail_str'] .= implode(',', $invalid_id_arr);							
						}
						else
							$valid_id_arr=$ids_arr;
						
						if (count($valid_id_arr) > 0)
						{
							if ($this->idTypeNumeric)							
								$ids_str = implode(',', $valid_id_arr);
							else {
								$ids_str = '';
								foreach ($valid_id_arr as $id)
									$ids_str .= '\'' . $id . '\',';
								if ($ids_str != '')
									$ids_str = substr($ids_str, 0, strlen($ids_str)-1);
							}							
							
							$op_info['affected_num'] = $dbi->exec('UPDATE '.$this->tableName.' SET '.$switch_field.'='.$_GET['switch_value'].' WHERE '.$this->idName.' IN ('.$ids_str.')');						
							$op_info['success_num'] = count($valid_id_arr);
							$op_info['success_str'] = $ids_str;
						}
					}
					else
						$op_info['err'] = 'Invalid filed value!!!';
				}
				else
					$op_info['err'] = 'Invalid filed name!!!';
			}
			else
				$op_info['err'] = 'Invalid ids sent!!!';
			
			$_GET['done'] = 'switch';
			$smarty->assign('opInfo', $op_info);
		}
	}
	
	function checkDelBlockedList(&$rec_list)
	{
		//check dependences for access to delete item
		if(count($this->fkTables) > 0)
		{
			$ids_str='';			
			if ($this->idTypeNumeric) {
				foreach($rec_list as $k => $rec)
					$ids_str .= $rec[$this->idName] . ',';
			} else {
				foreach ($rec_list as $k => $rec)
					$ids_str .= '\'' . $rec[$this->idName] . '\',';
			}
			
			if ($ids_str!='')
			{
				global $dbi;
				$ids_str = substr($ids_str, 0, strlen($ids_str)-1);
				
				$invalid_id_arr = array();
				foreach ($this->fkTables as $fkTable) {
					
					$daoTmp_Join = DB_DataObject::factory($this->tableName);					
					$daoTmp = DB_DataObject::factory($fkTable);
					$daoTmp->joinAdd($daoTmp_Join, 'INNER', 'jt');
					$daoTmp->whereAdd('jt.'.$this->idName.' IN ('.$ids_str.')');
					$daoTmp->find();
					while($daoTmp->fetch())
					{
						$id_name = $this->idName;
						$invalid_id_arr[$daoTmp->$id_name] = $daoTmp->$id_name;
					}
					$daoTmp->free();					
				}
				
				foreach ($rec_list as $k => $rec) {
					if (isset($invalid_id_arr[$rec[$this->idName]]))
						$rec_list[$k]['del_blocked'] = true;
					else
						$rec_list[$k]['del_blocked'] = false;
				}
			}//end if ($ids_str!='')
			
		}//end if count($this->fkTables) > 0
	}
}
?>
