<?php
//#########################################################################//
//# Project particularized functions
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 29.03.2011
//#########################################################################//

/**
 * Init front section
 *
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function init_app()
{
	global $smarty, $dbi;
	
	define('SESS_IDX', SESS_IDX_FE);
	define('UL', 'UL');
	
	//Session front initialization
	if(!isset($_SESSION[SESS_IDX])) 
		$_SESSION[SESS_IDX]=array();
		
	//Assign user loged data
	if(isset($_SESSION[SESS_IDX][UL]['auth']) && $_SESSION[SESS_IDX][UL]['auth']==1)
	{
		if(!isset($_SESSION[SESS_IDX][UL]['is_intervenant']))
			$_SESSION[SESS_IDX][UL]['is_intervenant'] = dao_check_row_exists('etp_intervenant', 'per_code', $_SESSION[SESS_IDX][UL]['per_code_uti']);
		
		$smarty->assign('UL', $_SESSION[SESS_IDX][UL]);
	}
	
	if(!empty($_SESSION[SESS_IDX]['etp_pat_per_code']))
		$smarty->assign('etp_pat_per_code', $_SESSION[SESS_IDX]['etp_pat_per_code']);
		
	//Assign current time
	$smarty->assign('ctime', dt_ctime());
	
	//Assign date formay
	$smarty->assign('DF', '%d/%m/%Y');
}

/**
 * Get Patient Info
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function get_patient_info($per_code)
{
	if($info = dao_get_row_content('patient', array('per_code'=>$per_code)))
	{
		//get person info
		$info['per'] = get_per_info($per_code);
		
		//check if a refuse is set
		$info['refus'] = dao_get_row_content('etp_patient_refus_etp', array('per_code'=>$per_code));
		
		if(!$info['refus'])
		{
			//get last cse
			
			//prepare join tables
			$daoSpeJoin = DB_DataObject::factory('etp_specialite');
			$daoPerJoin = DB_DataObject::factory('personne');
			$daoIntJoin = DB_DataObject::factory('etp_intervenant');			
			
			$daoIntJoin->joinAdd($daoPerJoin);
			$daoIntJoin->joinAdd($daoSpeJoin);
			
			$daoLastCse = DB_DataObject::factory('etp_cs');
			$daoLastCse->pat_per_code = $per_code;
			
			$daoLastCse->joinAdd($daoIntJoin);
			
			$daoLastCse->orderBy('cse_date DESC, cse_code DESC');
			$daoLastCse->limit(0, 1);
			if($daoLastCse->find(true))
				$info['lastCse'] = $daoLastCse->toArray();//12071
			else
				$info['lastCse'] = false;
				
			$daoLastCse->free();
			$daoIntJoin->free();
			$daoPerJoin->free();
			$daoSpeJoin->free();
		}
		else
			$info['lastCse'] = false;
		
		//get greffes
		$info['last_greffe'] = get_greffe($per_code, true);
		
		$info['age'] = get_age($info['pat_dt_naiss']);
		$info['pat_dt_naiss'] = date('d/m/Y', strtotime($info['pat_dt_naiss']));
		
		/*
		$info['comm'][1] = dao_get_field_content('patient_comment', 'pat_com_txt', 'per_code_pat', $per_code, 'pat_com_type', 1);    	
		$info['comm'][2] = dao_get_field_content('patient_comment', 'pat_com_txt', 'per_code_pat', $per_code, 'pat_com_type', 2);
		$info['comm'][3] = dao_get_field_content('patient_comment', 'pat_com_txt', 'per_code_pat', $per_code, 'pat_com_type', 3);
		*/
		return $info;
	}	
	else
		return false;
}

/**
 * Get personne info
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function get_per_info($per_code)
{
	$per_info = array();
	
	$daoCerJoin = DB_DataObject::factory('centre_de_rattachement');
	
	$daoInfo = DB_DataObject::factory('personne');
	$daoInfo->joinAdd($daoCerJoin, 'left');
	$daoInfo->get($per_code);
	$daoInfo->find();
	$daoInfo->fetch();
	
	$per_info = $daoInfo->toArray();
	//DB_DataObject::debugLevel(5);
	//get data from personne_adr_postale
    $per_info['adresse'] = array();
    $daoPerAdrSel = DB_DataObject::factory('v_adresse');
	$daoPerAdrSel->whereAdd('per_code='.$per_code);
	$daoPerAdrSel->orderBy('adr_code');
	$daoPerAdrSel->find();
	while($daoPerAdrSel->fetch())
		$per_info['adresse'][] = $daoPerAdrSel->toArray();
	
	//get telephone
	$per_info['tel'] = array();	
	$daoPerTel = DB_DataObject::factory('personne_telephone');
	$daoTel=DB_DataObject::factory('telephone');
	$daoPerTel->joinAdd($daoTel, 'inner');
	$daoPerTel->per_code = $per_code;
	$daoPerTel->find();
	
	while($daoPerTel->fetch())
		$per_info['tel'][] = $daoPerTel->toArray();
	
	//free dao
	$daoInfo->free();
	$daoPerTel->free();
	$daoPerAdrSel->free();
	//DB_DataObject::debugLevel(0);
	return $per_info;
}

function get_age($naiss)  
{
	if (ereg("/",$naiss))
		list($jour, $mois, $annee) = split('[/.]', $naiss);
	else
  		list($annee, $mois, $jour) = split('[-.]', $naiss);
  
	$today['mois'] = date('n');
	$today['jour'] = date('j');
	$today['annee'] = date('Y');
	$annees = $today['annee'] - $annee;
	if ($today['mois'] <= $mois) 
	{
    	if ($mois == $today['mois']) 
    	{
      		if ($jour > $today['jour'])
        		$annees--;
    	}
	    else
			$annees--;
	}
  
	return $annees;
}

function get_greffe($per_code_pat, $last = false)
{
	$daoGreffe = DB_DataObject::factory('greffe');	
	$daoTgr = DB_DataObject::factory('type_greffe');	
	$daoGreffe->joinAdd($daoTgr);	
	$daoGreffe->per_code_pat = $per_code_pat;
	
	if ($last!=false)
	{
		if (strlen($last)==10)
			$daoGreffe->whereAdd('gre_date<=\''.date('Y-m-d',strtotime($last)).'\'');
		
		$daoGreffe->orderBy('gre_date DESC');
		
		$daoGreffe->limit(0,1);
		
		if ($daoGreffe->count()>0)
		{
			$daoGreffe->find(true);					
			$greffe = $daoGreffe->toArray();
			$daoGreffe->free();
			
			//si on recupere pas la derniere greffe on cherche la date de la suivante si elle existe
			if (strlen($last)==10)
			{
				$daoGreffe=DB_DataObject::factory('greffe');				
				$daoGreffe->per_code_pat = $per_code_pat;
				$daoGreffe->whereAdd('gre_date>\''.date('Y-m-d', strtotime($greffe['gre_date'])).'\'');				
				$daoGreffe->orderBy('gre_date');
				$daoGreffe->limit(0,1);
				
				if ($daoGreffe->find(true)==1)
					$greffe['gre_date_fin'] = $daoGreffe->gre_date;
			}
			
			return $greffe;
		}
		else
			return false;
	}
	else
	{
		$daoGreffe->find();
		
		$greffes = array();		
		while($daoGreffe->fetch())
			$greffes[] = $daoGreffe->toArray();
		
		return $greffes;
	}
}

function get_taille($pat_code)
{
	$daoCsl = DB_DataObject::factory('consultation');
	$daoCsl->per_code_pat = $pat_code;
	$daoCsl->whereAdd('csl_taille is not null');
	$daoCsl->orderBy('csl_date desc, csl_code desc');
	
	if ($daoCsl->find(true)>0)
		return $daoCsl->csl_taille;
	else
		return '';
}

/**
 * Delete personne
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function del_personne($per_code)
{
	//get data in personne_adr_postale
	$daoPerAdrSel = DB_DataObject::factory('personne_adr_postale');
    $daoPerAdrSel->whereAdd('per_code='.$per_code);
    $daoPerAdrSel->find();
	while($daoPerAdrSel->fetch())
	{		
		//delete data from adresse_postale
		$daoAdrDel = DB_DataObject::factory('adresse_postale');
		$daoAdrDel->get($daoPerAdrSel->adr_code);
		$daoAdrDel->delete();
		$daoAdrDel->free();
	}
	$daoPerAdrSel->free();
	
	//delete from personne_adr_postale
	$daoPerAdrDel = DB_DataObject::factory('personne_adr_postale');
	$daoPerAdrDel->whereAdd('per_code='.$per_code);
	$daoPerAdrDel->delete(DB_DATAOBJECT_WHEREADD_ONLY);
	$daoPerAdrDel->free();
	
	//delete from personne
	$daoDel = DB_DataObject::factory('personne');
	$daoDel->get($per_code);
	$daoDel->delete();
	$daoDel->free();
}

//used just for back_url
function var2string($var)
{
	return base64_encode(gzdeflate(serialize($var),9));
}
function string2var($string)
{
	return unserialize(gzinflate(base64_decode($string)));
}
?>