<?
/*############################################ DAO USEFUL FUNCTIONS ############################################*/

function dao_get_table_fields($table_name, $ini_file)
{
	$db_info = parse_ini_file($ini_file, true);

	$table_info = $db_info[strtolower($table_name)];

	$table_data= array('fields'=>array(), 'keys'=>array());
	
	foreach($table_info as $field=>$type)
		$table_data['fields'][] = $field;
	
	if (isset($db_info[strtolower($table_name).'__keys']))
	{
		$table_key_info = $db_info[strtolower($table_name).'__keys'];
		foreach($table_key_info as $key=>$type)
			$table_data['keys'][] = $key;
	}
	
	return $table_data;
}


/**
 * DAO Get Row Content
 *
 * @param: $table_name = table name | $filters_arr = array filed=>value 
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 19.11.2011 (dd.mm.YYYY)
*/
function dao_get_row_content($table_name, $filters_arr)
{    
	$daoRow = DB_DataObject::factory($table_name);
	
	foreach($filters_arr as $field=>$value)
		$daoRow->$field = $value;
	
	$daoRow->limit(0, 1);
	$daoRow->find();
		
	if($daoRow->count())
	{
		$daoRow->fetch();
		$ret = $daoRow->toArray();
	}
	else 
		$ret = false;
		
	$daoRow->free();
	
	return $ret;	
}

/**
 * DAO Check Row Exists
 *
 * @access: public
 * @return: bool
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 19.11.2011 (dd.mm.YYYY)
*/
function dao_check_row_exists($table_name, $field_name, $field_value, $field_name2=null, $field_value2=null)
{
	$daoCheck = DB_DataObject::factory($table_name);

	$daoCheck->$field_name = $field_value;
	if($field_name2)
		$daoCheck->$field_name2 = $field_value2;

	$daoCheck->limit(0, 1);
	$c=$daoCheck->count();
	$daoCheck->free();
	
	if($c)
		return true;
	else 
		return false;
}

/**
 * DAO get field content
 *
 * @param: $table = table name | $field_name = name of filed | $id_name = id name | $id_value = id value
 * @access: public
 * @return: field name
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 19.11.2011 (dd.mm.YYYY)
*/
function dao_get_field_content($table_name, $field_name, $id_name, $id_value, $id_name2=null, $id_value2=null)
{
	$daoInfo = DB_DataObject::factory($table_name);
	
	$daoInfo->$id_name = $id_value;
	if($id_name2)
		$daoInfo->$id_name2 = $id_value2;
	
	$daoInfo->orderBy($field_name);
	$daoInfo->limit(0, 1);
	$daoInfo->find();
	$daoInfo->fetch();
	
	$v=$daoInfo->$field_name;
	$daoInfo->free();
	
	return $v;	
}


/**
 * DAO Get Table Content
 *
 * @param: $table_name = table name | $id_name = id name | $field_name = name of filed | $order_by = name of filed for order | $filters = array field=>value | $out_type = output type
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 19.11.2011 (dd.mm.YYYY)
*/
function dao_get_table_content($table_name, $id_name=null, $field_name=null, $order_by=null, $filters=null, $out_type=0)
{
	$daoContent = DB_DataObject::factory($table_name);
	
	//set fields to select
	if($id_name && $field_name)
	{
		$daoContent->selectAdd();
		$daoContent->selectAdd($id_name.', '.$field_name);
	}
	
	//add where conditions
	if(is_array($filters))
		foreach($filters as $field=>$value)
			$daoContent->$field = $value;
	
	//set order by
	if(!$order_by && $field_name)
		$order_by = $field_name;
	if($order_by)
		$daoContent->orderBy($order_by);
	
	//find
	$daoContent->find();
	
	//set out
	$ret = array();
	if(1==$out_type && $id_name && $field_name)
	{
		while($daoContent->fetch())
		{
			$rec = $daoContent->toArray();
			
			$ret[$rec[$id_name]] = $rec[$field_name];
		}
	}
	else
	{
		while($daoContent->fetch())
			$ret[] = $daoContent->toArray();
	}
	
    $daoContent->free();
    
    return $ret;
}
?>
