<?php
 
//#########################################################################//
//# Dbi MDB2
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 26.11.201
//#########################################################################//    
    
require('MDB2.php');

class DbiMDB2 
{
	var $dbo = null;
	var $debug = false;
    var $res;
    var $res_idx;
    
	/**
	* Constructor
	* 
	* @return null
	*/
	public function __construct($dsn_arr)
	{
		$dsn = $dsn_arr['type'].'://'.$dsn_arr['user'].':'.$dsn_arr['pass'].'@'.$dsn_arr['host'].'/'.$dsn_arr['db'];
			
		$this->dbo = & MDB2::connect($dsn);
		$this->dbo->setCharset('utf8');
		$this->errHandler($this->dbo);
		$this->res = array();
        $this->res_idx = -1;
    }
    
    /**
	* Destructor: call disconnect and free results
	* 
	* @return null
	*/
	function __destruct() 
	{
	    $this->disconnect();
	}
	
	/**
	* Set Debug
	* 
	* @return null
	*/
	function setDebug($state) 
    {
		$this->debug = $state;
	}
	
	/**
	* Disconnect and free results
	* 
	* @return null
	*/
	function disconnect()
    {
    	//free results
        for($i=0; $i<count($this->res); $i++)
        {
        	//if($this->res[$i]->isResult())
        		$this->res[$i]->free();
        }
        
        //disconect
        $this->dbo->disconnect();
        
        unset($this->dbo, $this->res, $this->res_idx);
    }
    
    /**
	* Error handler
	* 
	* @return null
	*/
 	function errHandler($e)
    {
        if (PEAR::isError($e))
    	{
    		$err_msg="--------------------\n";
			$err_msg.="Uri: {$_SERVER['REQUEST_URI']}\n";
    		$err_msg.="Message: ".$e->getMessage()."\n";
			$err_msg.="UserInfo: \n".$e->getUserInfo()."\n";
			$this->write_log(DB_LOG_DIR.'sql_log_'.date('ymd').'_error.txt', $err_msg);
			
			if ($this->debug)
			{
				echo "<div style=\"text-align:left; color:#B70000;\">";
				echo "<u>Uri</u>: ".$_SERVER['REQUEST_URI']."<br />";
				echo "<u>Message</u>: ".$e->getMessage()."<br />";
	           	echo "<u>UserInfo</u>:<br />".$e->getUserInfo();
	           	echo "</div>";
			}
			else
				echo 'DataBase Error! Please report the error!';
			
			$this->disconnect();
			exit;
    	}
    }
    
    /**
	* Before sql
	* 
	* @return time start
	*/
    function sqlBefore($sql) 
    {
		if(1==DEBUG)
		{
			global $profiler;
			$profiler->enterSection($sql);
		}
		
		return $this->get_microtime();
    }
	
    /**
	* Before after
	* 
	* @return null
	*/
    function sqlAfter($sql, $time_start) 
    {
    	if(1==DEBUG)
		{
			global $profiler;
			$profiler->leaveSection($sql);
		}
    	
		$time_exec=$this->get_microtime()-$time_start;
        
		if(1==DB_LOG && $time_exec>DB_LOG_TIME)
			$this->write_log(DB_LOG_DIR.'sql_log_'.date('ymd').'.txt', "Query: {$sql} \nExecution Time: {$time_exec}\n\n");
    }
    
    /**
	* Sql Execute
	* 
	* @return: number of affected rows on success, a MDB2 error on failure
	*/
	function exec($sql, $err_handler=1)
    {
        //Before sql
    	$time_start=$this->sqlBefore($sql);
    	
    	//Sql
    	$ret = $this->dbo->exec($sql);
        if(1==$err_handler) $this->errHandler($ret);
        
        //After sql
        $this->sqlAfter($sql, $time_start);
        
        return $ret;
    }
    
    /**
	* Query: send a query to the database and return any results
	* 
	* @return: MDB2_Result handle on success, a MDB2 error on failure
	*/
	function query($sql)
    {
        //Before sql
    	$time_start=$this->sqlBefore($sql);
		
    	//Sql
    	$this->res_idx++;
        $this->res[$this->res_idx] =& $this->dbo->query($sql);
        $this->errHandler($this->res[$this->res_idx]);
        
      	//After sql
        $this->sqlAfter($sql, $time_start);
		
        return $this->res_idx;
    }
    
    /**
	* Fetch Row
	* 
	* @return: data array on success, a MDB2 error on failure
	*/
	function fetchRow($idx = false, $mode = false) 
    {
        $idx_ = $idx === false ? $this->res_idx : $idx;
        
        if (!isset($this->res[$idx_])) 
        	die('Invalid result set id!');
        
        $row =& $this->res[$idx_]->fetchRow($mode ? MDB2_FETCHMODE_ORDERED : MDB2_FETCHMODE_ASSOC);
        if (!$row)
        {
            $this->res[$idx_]->free();
        	unset($this->res[$idx_]);
            //if ($idx === false)
            $this->res_idx--;
        }
       	
        return $row;
    }
    
	/**
	* Fetch One: fetch single column from the next row from a result set
	* 
	* @return: data on success, a MDB2 error on failure
	*/
	function fetchOne($idx = false) 
    {
        $idx_ = $idx === false ? $this->res_idx : $idx;
        
        if (!isset($this->res[$idx_])) 
        	die('Invalid result set id!');
        
        $col =& $this->res[$idx_]->fetchOne();
        if (!$col)
        {
            $this->res[$idx_]->free();
        	unset($this->res[$idx_]);
            
            $this->res_idx--;
        }
       	
        return $col;
    }
    
    /**
	* Get number of rows
	* 
	* @return: return number of rows
	*/
	function numRows($sql) 
    {
    	//Before sql
    	$time_start=$this->sqlBefore($sql);
		
    	//Sql
        $res =& $this->dbo->query($sql);
        $this->errHandler($res);
        
        $num = $res->numRows();
        
      	//After sql
        $this->sqlAfter($sql, $time_start);
		
        return $num;    	
    }
    
	/**
	* QueryOne: execute the specified query, fetch the value from the first column of the first row of the result set and then frees the result set
	* 
	* @return: MDB2_OK or field value on success, a MDB2 error on failure
	*/
	function queryOne($sql)
    {
        //Before sql
    	$time_start=$this->sqlBefore($sql);
    	
    	//Sql
    	$col =& $this->dbo->queryOne($sql);
        $this->errHandler($col);
        
        //After sql
        $this->sqlAfter($sql, $time_start);
        
        return $col;
    }
    
    /**
	* QueryRow: execute the specified query, fetch the values from the first row of the result set into an array and then frees the result set
	* 
	* @return: MDB2_OK or data array on success, a MDB2 error on failure
	*/
	function queryRow($sql, $mode = false)
    {
        //Before sql
    	$time_start=$this->sqlBefore($sql);
    	
    	//Sql
    	$row =& $this->dbo->queryRow($sql, array(), $mode ? MDB2_FETCHMODE_ORDERED : MDB2_FETCHMODE_ASSOC);
        $this->errHandler($row);
        
        //After sql
        $this->sqlAfter($sql, $time_start);
        
        return $row;
    }
    
    /**
	* QueryAll: execute the specified query, fetch all the rows of the result set into a two dimensional array and then frees the result set
	* 
	* @return: MDB2_Result handle on success, a MDB2 error on failure
	*/
 	function queryAll($sql, $mode = false)
    {
    	 //Before sql
    	$time_start=$this->sqlBefore($sql);
    	
    	//Sql
    	$rows =& $this->dbo->queryAll($sql, array(), $mode ? MDB2_FETCHMODE_ORDERED : MDB2_FETCHMODE_ASSOC);
        $this->errHandler($rows);
        
        //After sql
        $this->sqlAfter($sql, $time_start);
        
        return $rows;
    }
    
	/**
	* QueryAllCol: execute the specified query, fetch the value from the first column of each row of the result set into an array and then frees the result set
	* 
	* @return: MDB2_OK or data array on success, a MDB2 error on failure
	*/
 	function queryAllCol($sql)
    {
    	 //Before sql
    	$time_start=$this->sqlBefore($sql);
    	
    	//Sql
    	$rows =& $this->dbo->queryCol($sql);
        $this->errHandler($rows);
        
        //After sql
        $this->sqlAfter($sql, $time_start);
        
        return $rows;
    }
    
    /**
	* Get NextId
	* 
	* @return: next id
	*/
	function nextId($obj)
    {    	
        if (!$obj || !is_string($obj)) return false;

        if (!$this->queryOne('show tables like \'seq\''))
            $this->exec('create table seq (seq_table varchar(50), seq_id int(11), primary key(seq_table))');
        
        $val1 = $this->queryOne('select '.$obj.'_id from '.$obj.' order by '.$obj.'_id desc limit 1');
        $val2 = $this->queryOne('select seq_id from seq where seq_table=\''.$obj.'\'');
        if (!$val2)
            $this->exec('insert into seq set seq_table=\''.$obj.'\', seq_id=0');
        
        $val = ($val1 > $val2 ? $val1 : $val2) + 1;
        $this->exec('update seq set seq_id=\''.$val.'\' where seq_table=\''.$obj.'\'');
        
        return $val;
    }
    
	/**
	* Prepare Sql
	* 
	* @return: statement or error
	* $sql = 'INSERT INTO people VALUES (?, ?, ?, ?)';
	* $sql = 'INSERT INTO people VALUES (:id, :first_name, :last_name, :bdate)';
	* $data = array($mdb2->nextId('people'), 'Matt', 'Cameron', '1962-11-28');
	*/
 	function prepare($sql)
    { 	   
    	$statement = $this->dbo->prepare($sql);
	    $this->errHandler($statement);
	   	return $statement;	   	    
    }
    
    /**
	* Execute prepared statement
	* 
	* @return: no rows affected or err
	*/
	function prepareExec(&$statement, $data_arr)
    {
    	$res = $statement->execute($data_arr);//return MDB2_Result or integer (affected rows) on success, a MDB2 error on failure
    	$this->errHandler($res);
    	
    	return $res;    	
    }
    
    /**
	* Execute statement query for fetch
	* 
	* @return: no rows affected or err
	*/
	function prepareQuery(&$statement, $data_arr)
    {
    	$this->res_idx++;
    	$this->res[$this->res_idx] = $statement->execute($data_arr);
        $this->errHandler($this->res[$this->res_idx]);
                
    	return $this->res_idx;
    }
    
    /**
	* Free statement
	* 
	* @return: no rows affected or err
	*/
	function prepareFree(&$statement)
    {
    	$statement->free();
    }
    
	/**
	* Escape value: quotes a string so it can be safely used in a query. It will quote the text so it can safely be used within a query
	* 
	* @return: quoted string
	*/
	function escVal($val, $trim=1, $strip_tags=0)
    {
    	if(1==$trim) $val=trim($val);
		if(1==$strip_tags) $val=strip_tags($val);
		
		return $this->dbo->escape($val);
    }
    
    
    
	function del($table, $id1, $val1, $id2='', $val2='')
	{
		$this->exec('DELETE FROM '.$table.' WHERE '.$id1.'=\''.$val1.'\''.($id2!=''?' AND '.$id2.'=\''.$val2.'\'':''));
	}
	function emptyTable($table)
	{
		$this->exec('DELETE FROM '.$table);		
	}
	function switchField($table, $field, $id, $val)
	{
		$this->exec('UPDATE '.$table.' SET '.$field.'=('.$field.'+1)%2 WHERE '.$id.'=\''.$val.'\'');
	}
	function fieldContent($table, $field, $id1, $val1, $id2='', $val2='')
	{		
		return $this->queryOne('SELECT '.$field.' FROM '.$table.' WHERE '.$id1.'=\''.$val1.'\''.($id2!=''?' AND '.$id2.'=\''.$val2.'\'':'').' ORDER BY '.$field.' LIMIT 0,1');
	}
	function rowContent($table, $filters_arr)
	{    
		$sql_where='';
		foreach($filters_arr as $field=>$value)
			$sql_where.=$field.'=\''.$value.'\' AND ';
		if(''!=$sql_where)
			$sql_where=' WHERE '.substr($sql_where, 0, strlen($sql_where)-5);
				
		if($row=$this->queryRow('SELECT * FROM '.$table.$sql_where.' ORDER BY '.$field.' LIMIT 0,1'))	
			return $row;
		else
			return false;		
	}
	function tableContent($table, $id_name, $field_name, $field_order='', $filters=false, $out_type=0)
	{
		$sq_select=$out_type==2 ? '*' : $id_name.', '.$field_name;
		
		$sql_where='';
		if(is_array($filters))
			foreach($filters as $field=>$value)
				$sql_where.=$field.'=\''.$value.'\' AND ';
		if(''!=$sql_where)
			$sql_where=' WHERE '.substr($sql_where, 0, strlen($sql_where)-5);
		
		$sql_order='';
		if(''==$field_order && $field_name!='')
			$field_order=$field_name;
		if($field_order!='')
		{
			if($field_order!=$field_name && $field_name!='')
				$sql_order=' ORDER BY '.$field_order.', '.$field_name;
			else
				$sql_order=' ORDER BY '.$field_order;
		}
		
		$q='SELECT '.$sq_select.' FROM '.$table.$sql_where.$sql_order;
		
		$ret=array();
		if($out_type==3 || $out_type==0)
		{
			$ridx=$this->query($q);
			if($out_type==3)
				while($rec=$this->fetchRow($ridx, true))
					$ret[$rec[0]]=$rec[1];
			else
				while($rec=$this->fetchRow($ridx, true))
				{
					$ret[0][]=$rec[0];
				    $ret[1][]=$rec[1];
				}
		}
		else//if($out_type==2 || $out_type==1)
			$ret=$this->queryAll($q);

		return $ret;		
	}
	function existsDuplicates($table, $uniques_arr, $id_name, $id_val='')
	{
		$sql_where="";
		if(is_array($uniques_arr))
			foreach($uniques_arr as $field=>$value)
				$sql_where.=$field.'=\''.$value.'\' AND ';
		
		$sql_where=' WHERE '.(''!=$id_val ? $sql_where.$id_name.'!='.$id_val : substr($sql_where, 0, strlen($sql_where)-5));
		
		if($this->queryOne('SELECT '.$id_name.' FROM '.$table.$sql_where.' LIMIT 0, 1'))
			return true;
		else
			return false;
	}
	function checkRowExists($table, $field_name, $field_value, $field_name2='', $field_value2='')
	{
		if($this->queryOne('SELECT '.$field_name.' FROM '.$table.' WHERE '.$field_name.'=\''.$field_value.'\''.($field_name2 ? ' AND '.$field_name2.'=\''.$field_value.'\'':'').' LIMIT 0, 1'))
			return true;
		else
			return false;
	}
		
	function write_log($log_file, $str)
	{
		$fp=fopen($log_file, "a");
		fputs($fp, "\n\r#".date('d-m-Y H:i:s')."\nUri: {$_SERVER['REQUEST_URI']}\nServer Name: {$_SERVER['SERVER_NAME']}\nRemote IP: {$_SERVER['REMOTE_ADDR']}\nHTTP Referer: ".(isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:"--")."\n".$str."\n");
		fclose($fp);
	}
	
	function get_microtime($time_delay=0)
	{
	   list($usec, $sec) = explode(' ', microtime());	   
	   return ((float)$usec + (float)$sec)+$time_delay;
	}
}
?>
