<?php 
//#########################################################################//
//# Utile for debuging
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 22.01.2004
//#########################################################################//

/**
 * Print a array formated
 *
 * @parameters: $array = array
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function debug_array($array)
{
    if(isset($array))
    {
    	if(is_array($array))
    	{
    		echo '<pre style="font-size:12px; text-align:left;">';
	    	print_r($array);
	    	echo '</pre>';
    	}
    	else
    		echo "<font color=red>The type of variable <strong>$array</strong> is not array!</font>";
    }
    else
    	echo "<font color=red>The variable <strong>$array</strong> is undefined!</font>";
}

function profiler_display()
{
	global $profiler;
	
	if(AJAX_REQUEST)
		$_SESSION[SESS_IDX]['profiler'][]=$profiler->getAllSectionsInformations();
	else
	{		
		echo '<h3 style="color:red; font-size:18px; margin:0 0 5px 0; padding:0; border-bottom:1px solid red;">Page Benchmark Profiler:</h3>';
		profiler_display_formated($profiler->getAllSectionsInformations());//echo "<br /><br /><center>"; $profiler->display(); echo "</center>";
		
		if(isset($_SESSION[SESS_IDX]['profiler']))
		{
			echo '<h3 style="color:red; font-size:18px; margin:0 0 5px 0; padding:0; border-bottom:1px solid red;">AJAX calls Benchmark Profiler:</h3>';
			foreach($_SESSION[SESS_IDX]['profiler'] as $k=>$v)
				profiler_display_formated($v, $k+1);
			
			unset($_SESSION[SESS_IDX]['profiler']);			
		}			
	}
}

/**
 * Profiler Display Formated
 *
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function profiler_display_formated($profiler, $pno='')
{
   $msg=($pno?"":"<link rel=\"stylesheet\" type=\"text/css\" href=\"".ROOT_HOST."css/profiler.css\" />").  
   "<div class=\"profiler\">
		<strong>Benchmark Profiler {$pno}</strong><br />
		<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"> 
			<tr align=\"center\">
				<th width=\"508\">Section Name</th>
				<th>Total Ex. Time</th>
				<th>Netto Ex. Time	</th>
				<th>#Calls</th>
				<th>%</th>
				<th>Calls</th>
				<th>Callers</th>
			</tr>
			";
   			$i=-1;
   			foreach($profiler as $k=>$v)
   			{
   				$k=htmlentities($k);
   				$i++;
   				$msg.="<tr align=\"center\" class=\"p-bg".($i%2)."\">";
   				$msg.="<td align=\"left\"><div id=\"bpcallers{$pno}{$i}\" style=\"width:auto; display:none; background:#009933; border:1px solid #000000; padding:5px; color:#FFFFFF; position:absolute;\"><pre style=\"font-size:11px;\">".print_r($v['callers'], true)."</pre><div style=\"text-align:right;\"><a class=\"link1\" onclick=\"$('#bpcallers{$pno}{$i}').toggle(); return false;\" href=\"#\" style=\"color:#FFFFFF;\">close</a></div></div><div id=\"bpcalls{$pno}{$i}\" style=\"width:auto; display:none; background:#66CCFF; border:1px solid #000000; color:#FFFFFF; padding:5px; position:absolute;\"><pre style=\"font-size:11px;\">".print_r($v['calls'], true)."</pre><div style=\"text-align:right;\"><a class=\"link1\" onclick=\"$('#bpcalls{$pno}{$i}').toggle(); return false;\" href=\"#\" style=\"color:#FFFFFF;\">close</a></div></div><div style=\"width:500px; height:60px; overflow-x:hidden; overflow-y:scroll; background-color:#FCF9FF; border:1px solid #CCCCCC; padding:2px;\">{$k}</div></td>";
				$msg.="<td>{$v['time']}</td>";
				$msg.="<td>{$v['netto_time']}</td>";
				$msg.="<td><a class=\"link1\" onclick=\"$('#bpcalls{$pno}{$i}').toggle(); return false;\" href=\"#\">array(".count($v['calls']).")</a></td>";
				$msg.="<td>{$v['percentage']}%</td>";
				$msg.="<td>{$v['num_calls']}</td>";
				$msg.="<td><a class=\"link1\" onclick=\"$('#bpcallers{$pno}{$i}').toggle(); return false;\" href=\"#\">array(".count($v['callers']).")</a></td>";
				$msg.="</tr>";
   			}
	$msg.="
		</table>
	</div>
	";
	
	echo $msg;
}


//#########################################################################//

/** 
* print debug information to the current debug window 
* 
* @access public 
* @param $name string variable name 
* @param $data unknown variable 
* @return null 
* @global 
*/ 
function debug_var($name, $data) 
{ 
	if (DEBUG==1)
	{
	    debug_open_window(); 
	    $captured = explode("\n",debug_capture_print_r($data)); 
	    print "<script language='JavaScript'>\n"; 
	    print "debugWindow.document.writeln('<b>$name</b>');\n"; 
	    print "debugWindow.document.writeln('<pre>');\n"; 
	    foreach($captured as $line) 
	    { 
	    	$line = str_replace("'","\'",$line);
	        print "debugWindow.document.writeln('".debug_colorize_string($line)."');\n"; 
	    } 
	    print "debugWindow.document.writeln('</pre>');\n"; 
	    print "self.focus();\n"; 
	    print "</script>\n";
	} 
} 


/** 
* print a message to the debug window 
* 
* @access public 
* @param $mesg string message to display 
* @return null 
* @global 
*/ 
function debug_msg($mesg) 
{ 
	if (DEBUG==1)
	{
	    debug_open_window(); 
	    print "<script language='JavaScript'>\n"; 
	    print "debugWindow.document.writeln('".trim(nl2br($mesg))."<br>');\n"; 
	    print "self.focus();\n"; 
	    print "</script>\n";
	}
} 

/** 
* open a debug window for display 
* 
* this function may be called multiple times 
* it will only print the code to open the 
* remote window the first time that it is called. 
* 
* @access private 
* @return null 
* @global 
*/ 
function debug_open_window() 
{ 
    static $window_opened = FALSE; 
    if(!$window_opened) 
    { 
        ?> 
        <script language="JavaScript"> 
        debugWindow = window.open("","debugWin","toolbar=no,scrollbars,width=600,height=400"); 
        debugWindow.document.writeln('<html>'); 
        debugWindow.document.writeln('<head>'); 
        debugWindow.document.writeln('<title>PHP Remote Debug Window</title>'); 
        debugWindow.document.writeln('</head>'); 
        debugWindow.document.writeln('<body><font face="verdana,arial">'); 
        debugWindow.document.writeln('<hr size=1 width="100%">'); 
        </script> 
        <? 
        $window_opened = TRUE; 
    } 
} 


/** 
* catch the contents of a print_r into a string 
* 
* @access private 
* @param $data unknown variable 
* @return string print_r results 
* @global 
*/ 
function debug_capture_print_r($data) 
{ 
    ob_start(); 
    print_r($data); 

    $result = ob_get_contents(); 

    ob_end_clean(); 

    return $result; 
} 


/** 
* colorize a string for pretty display 
* 
* @access private 
* @param $string string info to colorize 
* @return string HTML colorized 
* @global 
*/ 
function debug_colorize_string($string) 
{ 
    /* turn array indexes to red */ 
    $string = str_replace('[','[<font color="red">',$string); 
    $string = str_replace(']','</font>]',$string); 
    /* turn the word Array blue */ 
    $string = str_replace('Array','<font color="blue">Array</font>',$string); 
    /* turn arrows graygreen */ 
    $string = str_replace('=>','<font color="#556F55">=></font>',$string); 
    return $string; 
} 
?>