<?php

//#########################################################################//
//# Utile for file-folders system
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 01.12.2010
//#########################################################################//

/**
 * Get files from a folder 
 *
 * @param: $dir = folder name | $like = files match
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function ff_read_dir($dir, $match='')
{	
	$ret=array();
	
	$dh=opendir($dir);
	if($match!='')
	{
		while(false!==($file=readdir($dh)))
			if($file!='.' && $file!='..' && strstr($file, $match))
				$ret[]=$file;
	}
	else 
	{		
		while(false!==($file=readdir($dh)))
			if($file!='.' && $file!='..')
				$ret[]=$file;
	}
	closedir($dh);
	
	return $ret;	
}

/**
 * Write logs in a file
 *
 * @param: $logFile = log file | $str = log string
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function ff_write_log($log_file, $str)
{
	$fp=fopen($log_file, "a");
	fputs($fp, "\n\r#".date("d-m-Y H:i:s")."\nUri: {$_SERVER['REQUEST_URI']}\nServer Name: {$_SERVER['SERVER_NAME']}\nRemote IP: {$_SERVER['REMOTE_ADDR']}\nHTTP Referer: ".(isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:"--")."\n".$str."\n");
	fclose($fp);
}

/**
 * Write a file
 *
 * @param: $fileName = file | $str = string
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function ff_write_file($file_name, $str) 
{ 
	$fp = fopen($file_name, "w"); 
	if($fp) 
	{
		fwrite($fp, $str, strlen($str));
		fclose($fp);
	}
	else
	{
		echo "Invalid file : $file_name<br>\n";		
		return false;
	}
} 

/**
 * Read file content
 *
 * @param: $fileName = file 
 * @access: public
 * @return: file content
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function ff_read_file($file_name)
{
	if(is_file($file_name))
		return implode('', file($file_name));
	else
		echo "Invalid file : {$file_name}<br>\n";
	return false;
}

/**
 * Get File Content
 *
 * @param: $filePath = file path
 * @access: public
 * @return: file content
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function ff_get_file_content($file_path) 
{    
    if(is_file($file_path))//return addslashes(fread(fopen($file_path, "r"), filesize($file_path)));
		return file_get_contents($file_path);
	else
		echo "Invalid file : $file_path<br>\n";
	return false;
}

/**
 * Get file extension
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function ff_file_extension($file_name, $with_pt=0)
{
	return (1==$with_pt?'.':'').substr(strrchr($file_name, '.'), 1);	
}

/**
 * Remove a file
 *
 * @param: $fileName = file | $displayError = status dispaly error
 * @access: public
 * @return: file content
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function ff_remove_file($file_path, $display_error=0)
{
	if(is_file($file_path))
	{
		if(unlink($file_path))
			return true;
		elseif($display_error==1)
			echo "<br>The file {$filePath} cannot be removed!";
	}
	elseif($display_error==1)
		echo "<br>The file {$filePath} not exist!";
	
	return false;
}

/**
 * Remove a entry folder
 *
 * @param: $folder
 * @access: public
 * @return: file content
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function ff_remove_folder($folder_path)
{			
	$folder_path=trim($folder_path);
	if($folder_path!='')
	{
		$l=strlen($folder_path);
		if(substr($folder_path, $l-1, $l)!='/')
			$folder_path.='/';
		
		if(is_dir($folder_path))
		{
			$d=dir($folder_path);
			while(false!==($entry=$d->read()))
			{
				if ($entry!='.' && $entry!='..') 
				{
					if(is_dir($folder_path.$entry))
						ff_remove_folder($folder_path.$entry);
					else
						ff_remove_file($folder_path.$entry);					
				} 
			}
			$d->close();
			
			rmdir($folder_path); 
		}
	}
}

/**
 * Remove match file, recursive
 *
 * @param: $path = directory path, finished with / | $file_math = file match
 * @access: public
 * @return: file content
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function ff_remove_match_files($path, $file_math)
{
	$path=rtrim($path, '/').'/';
	if($dh=opendir($path))
	{
		while(false!==($file_or_dir=readdir($dh))) 
		{
			if ($file_or_dir!='.' && $file_or_dir!='..')
			{				
				if(is_dir($path.$file_or_dir))
					ff_remove_match_files($path.$file_or_dir.'/', $file_math);
				elseif(is_file($path.$file_or_dir) && strpos($file_or_dir, $file_math, 0)!==false)
					unlink($path.$file_or_dir);
			}
		}
	    closedir($dh);
	}
}

/**
 * Get mime type
 *
 * @param: $file
 * @access: public
 * @return: file content
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 20.12.2010 (dd.mm.YYYY)
*/
function ff_mime_type($file, $shortmime=0)
{
	$mime_type=false;
	if(is_file($file)) {
		if(function_exists('finfo_open')) {		
			$finfo=finfo_open(FILEINFO_MIME_TYPE);
			$mime_type=finfo_file($finfo, $file);
			finfo_close($finfo);
		}
		elseif(function_exists('mime_content_type')) {
	    	$mime_type=mime_content_type($file);
	  	}
	  	else {
	  		$extarr = array(
	  			'ez'=>'application/andrew-inset',
				'hqx'=>'application/mac-binhex40',
				'cpt'=>'application/mac-compactpro',
				'doc'=>'application/msword',
				'bin'=>'application/octet-stream',
				'dms'=>'application/octet-stream',
				'lha'=>'application/octet-stream',
				'lzh'=>'application/octet-stream',
				'exe'=>'application/octet-stream',
				'class'=>'application/octet-stream',
				'so'=>'application/octet-stream',
				'dll'=>'application/octet-stream',
				'oda'=>'application/oda',
				'pdf'=>'application/pdf',
				'ai'=>'application/postscript',
				'eps'=>'application/postscript',
				'ps'=>'application/postscript',
				'smi'=>'application/smil',
				'smil'=>'application/smil',
				'wbxml'=>'application/vnd.wap.wbxml',
				'wmlc'=>'application/vnd.wap.wmlc',
				'wmlsc'=>'application/vnd.wap.wmlscriptc',
				'bcpio'=>'application/x-bcpio',
				'vcd'=>'application/x-cdlink',
				'pgn'=>'application/x-chess-pgn',
				'cpio'=>'application/x-cpio',
				'csh'=>'application/x-csh',
				'dcr'=>'application/x-director',
				'dir'=>'application/x-director',
				'dxr'=>'application/x-director',
				'dvi'=>'application/x-dvi',
				'spl'=>'application/x-futuresplash',
				'gtar'=>'application/x-gtar',
				'hdf'=>'application/x-hdf',
				'js'=>'application/x-javascript',
				'skp'=>'application/x-koan',
				'skd'=>'application/x-koan',
				'skt'=>'application/x-koan',
				'skm'=>'application/x-koan',
				'latex'=>'application/x-latex',
				'nc'=>'application/x-netcdf',
				'cdf'=>'application/x-netcdf',
				'sh'=>'application/x-sh',
				'shar'=>'application/x-shar',
				'swf'=>'application/x-shockwave-flash',
				'sit'=>'application/x-stuffit',
				'sv4cpio'=>'application/x-sv4cpio',
				'sv4crc'=>'application/x-sv4crc',
				'tar'=>'application/x-tar',
	  			'gz'=>'application/x-gtar',
	  			'tgz'=>'application/x-gtar',
				'tcl'=>'application/x-tcl',
				'tex'=>'application/x-tex',
				'texinfo'=>'application/x-texinfo',
				'texi'=>'application/x-texinfo',
				't'=>'application/x-troff',
				'tr'=>'application/x-troff',
				'roff'=>'application/x-troff',
				'man'=>'application/x-troff-man',
				'me'=>'application/x-troff-me',
				'ms'=>'application/x-troff-ms',
				'ustar'=>'application/x-ustar',
				'src'=>'application/x-wais-source',
				'xhtml'=>'application/xhtml+xml',
				'xht'=>'application/xhtml+xml',
				'zip'=>'application/zip',
				'au'=>'audio/basic',
				'snd'=>'audio/basic',
				'mid'=>'audio/midi',
				'midi'=>'audio/midi',
				'kar'=>'audio/midi',
				'mpga'=>'audio/mpeg',
				'mp2'=>'audio/mpeg',
				'mp3'=>'audio/mpeg',
				'aif'=>'audio/x-aiff',
				'aiff'=>'audio/x-aiff',
				'aifc'=>'audio/x-aiff',
				'm3u'=>'audio/x-mpegurl',
				'ram'=>'audio/x-pn-realaudio',
				'rm'=>'audio/x-pn-realaudio',
				'rpm'=>'audio/x-pn-realaudio-plugin',
				'ra'=>'audio/x-realaudio',
				'wav'=>'audio/x-wav',
				'pdb'=>'chemical/x-pdb',
				'xyz'=>'chemical/x-xyz',
				'bmp'=>'image/bmp',
				'gif'=>'image/gif',
				'ief'=>'image/ief',
				'jpeg'=>'image/jpeg',
				'jpg'=>'image/jpeg',
				'jpe'=>'image/jpeg',
				'png'=>'image/png',
				'tiff'=>'image/tiff',
				'tif'=>'image/tif',
				'djvu'=>'image/vnd.djvu',
				'djv'=>'image/vnd.djvu',
				'wbmp'=>'image/vnd.wap.wbmp',
				'ras'=>'image/x-cmu-raster',
				'pnm'=>'image/x-portable-anymap',
				'pbm'=>'image/x-portable-bitmap',
				'pgm'=>'image/x-portable-graymap',
				'ppm'=>'image/x-portable-pixmap',
				'rgb'=>'image/x-rgb',
				'xbm'=>'image/x-xbitmap',
				'xpm'=>'image/x-xpixmap',
				'xwd'=>'image/x-windowdump',
				'igs'=>'model/iges',
				'iges'=>'model/iges',
				'msh'=>'model/mesh',
				'mesh'=>'model/mesh',
				'silo'=>'model/mesh',
				'wrl'=>'model/vrml',
				'vrml'=>'model/vrml',
				'css'=>'text/css',
				'html'=>'text/html',
				'htm'=>'text/html',
				'asc'=>'text/plain',
				'txt'=>'text/plain',
				'rtx'=>'text/richtext',
				'rtf'=>'text/rtf',
				'sgml'=>'text/sgml',
				'sgm'=>'text/sgml',
				'tsv'=>'text/tab-seperated-values',
				'wml'=>'text/vnd.wap.wml',
				'wmls'=>'text/vnd.wap.wmlscript',
				'etx'=>'text/x-setext',
				'xml'=>'text/xml',
				'xsl'=>'text/xml',
				'mpeg'=>'video/mpeg',
				'mpg'=>'video/mpeg',
				'mpe'=>'video/mpeg',
				'qt'=>'video/quicktime',
				'mov'=>'video/quicktime',
				'mxu'=>'video/vnd.mpegurl',
				'avi'=>'video/x-msvideo',
				'movie'=>'video/x-sgi-movie',
				'ice'=>'x-conference-xcooltalk',
				'mng'=>'video/x-mng',
	  			'kdc'=>'image/x-kdc'
	  		);
	  		$ext=ff_file_extension($file);
	  		if(isset($extarr[$ext]))
	  			$mime_type=$extarr[$ext];
	  		else {//tar.gz ext
				reset($extarr);
				while(list($ext,$mt)=each($extarr))
					if(eregi("[.]".$ext."$",$file))
					{
						$mime_type=$mt;
						break;
					}
	  		}
	  	}
	}
	else {
		curl_setopt_array(($c = @curl_init((!preg_match("/[a-z]+:\/{2}(?:www\.)?/i",$f) ? sprintf("%s://%s/%s", "http" , $_SERVER['HTTP_HOST'],$f) :  $f))), array(CURLOPT_RETURNTRANSFER => 1, CURLOPT_HEADER => 1));
    	$mime_type=(preg_match("/Type:\s*(?<mime_type>[^\n]+)/i", @curl_exec($c), $m) && curl_getinfo($c, CURLINFO_HTTP_CODE) != 404)  ? ($m["mime_type"]) : 0;
	}
	
	if(1==$shortmime && $mime_type)
		return substr($mime_type, 0, strpos($mime_type, '/'));
	else
		return $mime_type;
}

function serverpath2abspath($server_path)
{
	//check if server_path can be accessed as absolute path
	if(strpos($server_path, PUBLIC_DIR)!==false)
	{		
		$str=str_replace(PUBLIC_DIR, '', $server_path);
		
		if(''!=$str)
			return ROOT_HOST.str_replace('\\', '/', $str);
		else
			return ROOT_HOST;
	}
	else
		return false;
    	
   	
}
?>