<?
/*
$validationScheme=array(
    	'oblig'=>array('title', 'priority'),
		'unique'=>array('title[&&]sample2_id'),
    	'length'=>array('title'=>array('min'=>10, 'max'=>1000)),
    	'integer'=>array('priority'),
    	'float'=>false,
    	'email'=>false,
    	'date'=>array('date'),
    	'fileupl'=>array('smaple1_file'=>array('type'=>'image', 'ext'=>'jpg', 'sizelimit'=>1024*1024))				
    );
*/
class FormValidation 
{	
	private $tableName;
	private $idName;
	
	private $msg;
	private $c=0;
	
	public $errArr=array();	
	
	function __construct($validation_scheme=false, $table_name=false, $id_name=false, $rewrite_err_messages=false)
	{		
		$this->tableName = $table_name;
		$this->idName = $id_name;
		if($table_name && !$id_name)
			$this->idName = $table_name.'_id';
		
		//error messages
		$this->buildArrErrMessages($rewrite_err_messages);
		
		if(!$validation_scheme)
			return ;
		
	    foreach ($validation_scheme as $state=>$val)
	    {
	    	switch($state)
	    	{
	    		case 'oblig':
    				if(is_array($val))
    				{
    					foreach($val as $k=>$field)
    					{
    						if(isset($_POST[$field]) && trim($_POST[$field])=='')
	    						$this->errAdd($field, $this->msg[$state], 0);
    						elseif(!isset($_POST[$field]))
    							$this->errAdd($field, $this->msg['invalid'], 0);
    					}
    				}
    				break;
    				
    			case 'oblig_any':
    				if(is_array($val))
    				{
    					foreach($val as $k=>$field)
    					{
    						if(isset($_POST[$field]) && $_POST[$field]=='')
    							$this->errAdd($field, $this->msg[$state], 0);
    						elseif(!isset($_POST[$field]))
    							$this->errAdd($field, $this->msg['invalid'], 0);
    					}
    				}
    				break;
    			
    			case 'unique':
    				if(is_array($val))
    				{    					
    					foreach($val as $unique)
						{
							$daoCheck = DB_DataObject::factory($this->tableName);
							
							$is_group=0;
							$unique_group=explode('[&&]', $unique);
							
							$sql_where_tmp='';
							if(2==count($unique_group))
							{
								$is_group=1;
								foreach($unique_group as $k=>$f)
									if(isset($_POST[$f]) && trim($_POST[$f])!='')
										$sql_where_tmp.='TRIM('.$f.')=\''.$daoCheck->escape($_POST[$f]).'\' AND ';
									else
										break;
								if(''!=$sql_where_tmp)
									$sql_where_tmp='('.substr($sql_where_tmp, 0, strlen($sql_where_tmp)-5).')';
							}
							elseif(isset($_POST[$unique]) && trim($_POST[$unique])!='')
								$sql_where_tmp='TRIM('.$unique.')=\''.$daoCheck->escape($_POST[$unique]).'\'';
							
							if(''!=$sql_where_tmp)
							{
								if(!empty($_POST[$this->idName]) && $_POST['act']!='add')
									$sql_where=$this->idName.'!=\''.$_POST[$this->idName].'\' AND ';
								else
									$sql_where='';
																
								$daoCheck->whereAdd($sql_where.$sql_where_tmp);
								$daoCheck->limit(0, 1);
								$c=$daoCheck->count();
								if($c>0)
									$this->errAdd($unique, $this->msg[$state], $is_group);
							}
							
							$daoCheck->free();
						}
    				}
    				break;
    			
    			case 'email':
    				if(is_array($val))
    				{
    					foreach($val as $k=>$field)
    					{
    						if(!empty($_POST[$field]) && !str_check_email($_POST[$field]))
    							$this->errAdd($field, $this->msg[$state], 0);
    					}
    				}
    				break;
    				
    			case 'date':
    				if(is_array($val))
    				{
    					foreach($val as $k=>$field)
    					{
    						if(!empty($_POST[$field]))
    						{
    							$yyyymmdd=explode('-', $_POST[$field]);
    							if(count($yyyymmdd)==3 && checkdate($yyyymmdd[1], $yyyymmdd[2], $yyyymmdd[0]))//(int $month , int $day , int $year)
    								;
    							else
	    							$this->errAdd($field, $this->msg[$state], 0);
    						}
    					}
    				}
    				break;
    				
	    		case 'length':
	    			if(is_array($val))
    				{
    					foreach($val as $field=>$v)
    					{
    						if(isset($_POST[$field]))
    						{
    							$err_tmp=0;					
    							if(isset($v['min']) && strlen(trim($_POST[$field]))<$v['min'])
    								$err_tmp=1;    								    							
    							if(0==$err_tmp && isset($v['max']) && strlen(trim($_POST[$field]))>$v['max'])
    								$err_tmp=1;
    							
    							if(1==$err_tmp)
    							{    								
    								if(isset($v['min']) && isset($v['max']))
    									$this->msg_tmp=str_replace('[max]', $v['max'], str_replace('[min]', $v['min'], $this->msg[$state]['minmax'])).' ('.strlen(trim($_POST[$field])).')';
    								elseif(isset($v['min']))
    									$this->msg_tmp=str_replace('[min]', $v['min'], $this->msg[$state]['min']);
    								else
    									$this->msg_tmp=str_replace('[max]', $v['max'], $this->msg[$state]['max']);
    								    								
    								$this->errAdd($field, $this->msg_tmp, 0);
    							}
    						}
    					}
    				}
	    			break;
	    			
	    		case 'integer':
	    			if(is_array($val))
    				{
    					foreach($val as $v=>$field)
    					{
    						if(!empty($_POST[$field]) && !(is_numeric($_POST[$field]) && ($_POST[$field]==(int)$_POST[$field])))    						
    							$this->errAdd($field, $this->msg[$state], 0);
    					}
    				}
	    			break;
	    		
	    		case 'numeric':
	    			if(is_array($val))
    				{    					    				
    					foreach($val as $v=>$field)
    					{
    						if(!empty($_POST[$field]) && !is_numeric($_POST[$field]))
    							$this->errAdd($field, $this->msg[$state], 0);
    					}
    				}
	    			break;
	    		
	    		case 'unsigned':
	    			if(is_array($val))
    				{
    					foreach($val as $v=>$field)
    					{
    						if(isset($_POST[$field]) && is_numeric($_POST[$field]) && $_POST[$field]<0)
    							$this->errAdd($field, $this->msg[$state], 0);
    					}
    				}
	    			break;
	    		
	    		case 'range':
	    			if(is_array($val))
    				{
    					foreach($val as $field=>$v)
    					{
    						if(isset($_POST[$field]) && is_numeric($_POST[$field]))
    						{
    							$err_tmp=0;
    							if(isset($v['min']) && $_POST[$field]<$v['min'])
    								$err_tmp=1;
    							if(0==$err_tmp && isset($v['max']) && $_POST[$field]>$v['max'])
    								$err_tmp=1;
    							
    							if(1==$err_tmp)
    							{
    								if(isset($v['min']) && isset($v['max']))
    									$this->msg_tmp=str_replace('[max]', $v['max'], str_replace('[min]', $v['min'], $this->msg[$state]['minmax']));
    								elseif(isset($v['min']))
    									$this->msg_tmp=str_replace('[min]', $v['min'], $this->msg[$state]['min']);
    								else
    									$this->msg_tmp=str_replace('[max]', $v['max'], $this->msg[$state]['max']);
    								    								    								
    								$this->errAdd($field, $this->msg_tmp, 0);
    							}
    						}
    					}
    				}
	    			break;
	    			

	    		case 'username':
	    			if(is_array($val))
    				{
    					foreach($val as $field=>$v)
    					{
    						if(isset($_POST[$field]))
    						{
    							if(isset($v['min']) && isset($v['max'])) {	
    								$min=$v['min'];
    								$max=$v['max'];		
    							} else {
    								$min=4;
    								$max=30;	
    							}
    							
    							if(strlen(trim($_POST[$field]))<$min || strlen(trim($_POST[$field]))>$max)
    								$this->errAdd($field, str_replace('[max]', $max, str_replace('[min]', $min, $this->msg[$state]['length'])), 0);
    							
    							if(!empty($v['pattern']))
    								$pattern=$v['pattern'].'{'.$min.','.$max.'}$/';
    							else							
    								$pattern='/^[A-Za-z0-9_-]{'.$min.','.$max.'}$/';
    							
    							if(!preg_match($pattern, $_POST[$field]))
    								$this->errAdd($field, $this->msg[$state]['chars'], 0);
    						}
    					}
    				}
	    			break;
	    			
	    		case 'password':
	    			if(is_array($val))
    				{
    					foreach($val as $field=>$v)
    					{
    						if(isset($_POST[$field]))
    						{
    							if(isset($v['min']) && isset($v['max'])) {	
    								$min=$v['min']; $max=$v['max'];    								
    							} else {
    								$min=4; $max=30;
    							}
    							
    							if(strlen(trim($_POST[$field]))<$min || strlen(trim($_POST[$field]))>$max)
    								$this->errAdd($field, str_replace('[max]', $max, str_replace('[min]', $min, $this->msg[$state]['length'])), 0);
    							
    							if(!empty($v['pattern']))
    								$pattern=$v['pattern'].'{'.$min.','.$max.'}$/';
    							else
    								$pattern='/^[A-Za-z0-9!@#$%^&*()+=._-]{'.$min.','.$max.'}$/';
    							
    							if(!preg_match($pattern, $_POST[$field]))
    								$this->errAdd($field, $this->msg[$state]['chars'], 0);
    							
    							if(!empty($v['confirm']) && isset($_POST[$v['confirm']]) && $_POST[$v['confirm']]!=$_POST[$field])
    								$this->errAdd($field, $this->msg[$state]['confirm'], 0);
    						}
    					}
    				}
	    			break;
    			
	    		//##############################################	
	    			
	    		case 'fileupl':
	    			if(is_array($val))
    				{
    					foreach($val as $field=>$v)
    					{
    						if(isset($_FILES[$field]['tmp_name']))
    						{
    							$err_upl=0;
    							if(is_uploaded_file($_FILES[$field]['tmp_name']))
    							{
    								//check file type: image
    								$ftype=explode('/', $_FILES[$field]['type']);
    								if(isset($v['type']) && $v['type']!=$ftype[0])
    								{
    									$err_upl=1;
		    							$this->errAdd($field, str_replace('[type]', $v['type'], str_replace('[ftype]', $ftype[0], $this->msg[$state]['type'])), 0);
    								}
    								
    								//check file ext: jpg, jpeg
    								$fext=strtolower(ff_file_extension($_FILES[$field]['name']));
    								if(isset($v['ext']) && (!$fext || strpos($v['ext'], $fext)===false))
    								{
    									$err_upl=1;
		    							$this->errAdd($field, str_replace('[ext]', $v['ext'], str_replace('[fext]', $fext, $this->msg[$state]['ext'])), 0);
    								}
    								
    								//check size limit
    								$fsize=$_FILES[$field]['size'];
    								if(isset($v['sizelimit']) && $_FILES[$field]['size']>$v['sizelimit'])
    								{
    									$err_upl=1;
    									
    									$fsize=round($fsize/1048576, 2);//Mega
    									$sizelimit=round($v['sizelimit']/1048576, 2);//Mega
    									
		    							$this->errAdd($field, str_replace('[sizelimit]', $sizelimit, str_replace('[fsize]', $fsize, $this->msg[$state]['sizelimit'])), 0);
    								}
    							}
    							elseif(isset($_FILES[$field]['error']) && $_FILES[$field]['error']!=4)//Value: 4 - No file was uploaded
    							{
    								$err_upl=1;    								
	    							$this->errAdd($field, $this->msg[$state]['error'].' - '.$_FILES[$field]['err'], 0);
    							}
    							else
    								$err_upl=1;
    							
    							if(isset($v['oblig']) && $v['oblig'] && 1==$err_upl)
	    							$this->errAdd($field, $this->msg[$state]['oblig'], 0);
    						}
    					}
    				}
	    			break;
	    	}
	    }	    	       	  
	}
	
	public function errAdd($field, $msg, $group=0)
	{
		$this->errArr[$this->c]['field']=$field;
		$this->errArr[$this->c]['msg']=$msg;
		$this->errArr[$this->c]['group']=$group;
		
		$this->c++;
	}
	
	public function errExists()
	{
		if($this->c==0)
	    	return false;
	    else
	    	return true;
	}
	
	public function errOutput($ordered=0)
	{
		if($ordered==1)
		{
			$tmp_arr=array();
			foreach($this->errArr as $k=>$v)
			{
				if(!isset($tmp_arr[$v['field']]))
					$tmp_arr[$v['field']]=array();
				
				$tmp_arr[$v['field']]['msg'][]=$v['msg'];
				$tmp_arr[$v['field']]['group']=$v['group'];
			}
			
			$err_xml='';
			foreach($tmp_arr as $field=>$v)
			{
				foreach($v['msg'] as $msg)
					$err_xml.='<item><field><![CDATA['.$field.']]></field><msg><![CDATA['.utf8_encode($msg).']]></msg><group>'.$v['group'].'</group></item>';				
			}
		}
		else
		{
			$err_xml='';
			foreach($this->errArr as $k=>$v)
				$err_xml.='<item><field><![CDATA['.$v['field'].']]></field><msg><![CDATA['.utf8_encode($v['msg']).']]></msg><group>'.$v['group'].'</group></item>';
		}
		
		header('Content-type: text/xml');
		echo '<root><err>1</err><err_fields>'.$err_xml.'</err_fields></root>';
		exit;
	}
	
	public function getErrArray()
	{
		return $this->errArr;
	}
	
	private function buildArrErrMessages($rewrite_err_messages)
	{		
		//error messages form_err_oblig
		$this->msg['oblig']='est obligatoire';
		$this->msg['oblig_any']='est obligatoire';
		$this->msg['unique']='tat resepcta pas unique';
		
		$this->msg['email']='est invalide';
		
		$this->msg['date']='format non valide ou date invalide';
		
		$this->msg['length']['minmax']='doit avoir une longueur comprise entre [min] et [max] caractres';
		$this->msg['length']['min']='doit avoir une longueur minimale [min] caractres';
		$this->msg['length']['max']='devraient avoir une longueur maximale [max] caractres';
		
		$this->msg['integer']='doivent tre entiers numriques';
		$this->msg['numeric']='doit tre numrique';
		
		$this->msg['range']['minmax']='doivent tre dans l\'intervalle [min] - [max]';
		$this->msg['range']['min']='doit tre infrieure  [min]';
		$this->msg['range']['max']='doit tre suprieur  [max]';
		
		$this->msg['unsigned']='devrait avoir un valeur positif';
		
		$this->msg['username']['length']='devrait se situer entre [min] et [max] caractres';
		$this->msg['username']['chars']='invalides, ne sont accepts que des caractres alphanumriques et _ ou -';
		
		$this->msg['password']['length']='devrait se situer entre [min] et [max] caractres';
		$this->msg['password']['chars']='autoris seulement des caractres alphanumriques et le jeu: !@#$%^&*()+=._-';
		$this->msg['password']['confirm']='passe pas confirm crespunde';
		$this->msg['password']['old']='ne correspond pas';
		
		$this->msg['fileupl']['err']='eraore serveur a rencontr un upload - Err:';
		$this->msg['fileupl']['type']='est de type [ftype], ne sont accepts que le type de fichier [type]';
		$this->msg['fileupl']['ext']='a une des extensions [fext], ne sont accepts que [ext]';
		$this->msg['fileupl']['sizelimit']='a la taille [fsize] fichiers M sont acceptes jusqu\'au [sizelimit] M';
		$this->msg['fileupl']['oblig']='fichier requis';
				
		$this->msg['invalid']='est invalide!!!';
		
		$this->msg['db']='db error!!!';
		
		if($rewrite_err_messages)
			$this->rewriteErrMessages();
	}
	
	private function rewriteErrMessages()
	{
		foreach($this->msg as $state=>$v)
		{
			if(is_array($v))
			{
				foreach($v as $k=>$state_idx)
				{
					$trans_idx='form_vld_'.$state.'_'.$state_idx;
					if(isset($_SESSION[SESS_IDX]['trans'][$trans_idx]))
						$this->msg[$state][$state_idx]=$_SESSION[SESS_IDX]['trans'][$trans_idx];
				}
			}
			else
			{
				$trans_idx='form_vld_'.$state;
				if(isset($_SESSION[SESS_IDX]['trans'][$trans_idx]))
					$this->msg[$state]=$_SESSION[SESS_IDX]['trans'][$trans_idx];
			}
		}		
	}
	
	public function getErrMessage($state, $state_idx=false)
	{
		if($state_idx)
		{
			$trans_idx='form_vld_'.$state.'_'.$state_idx;
			if(isset($_SESSION[SESS_IDX]['trans'][$trans_idx]))
				return $_SESSION[SESS_IDX]['trans'][$trans_idx];
			else
				return $this->msg[$state][$state_idx];
		}
		else
		{
			$trans_idx='form_vld_'.$state;
			if(isset($_SESSION[SESS_IDX]['trans'][$trans_idx]))
				return $_SESSION[SESS_IDX]['trans'][$trans_idx];
			else
				return $this->msg[$state];
		}
	}
	
	
}

?>