<?php

//#########################################################################//
//# Utile listing, search and pagination
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 22.01.2004
//#########################################################################//

/**
 * Pagination 
 *
 * @parameters: $moduleName = name of module for session register | $action = url action case | $no_rows = no rows per page
 * @access: public
 * @return: query limit string
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function paging($module_name, $no_rows=0)
{
    $_pg_no = 'pg_no';
	$_no_rows_displayed = 'no_rows_displayed';
	$_action = 'action';
	
	if(0 == $no_rows)
		if(defined('NO_ROWS_DISPLAYED'))
			$no_rows = NO_ROWS_DISPLAYED;
		else 
			$no_rows = 20;
	
	if(!isset($_SESSION[SESS_IDX][$module_name]['paging']))
    	$_SESSION[SESS_IDX][$module_name]['paging'] = array();
    
	$myc = $_SESSION[SESS_IDX][$module_name]['paging'];
		
	if(isset($_REQUEST[$_pg_no]) && is_numeric($_REQUEST[$_pg_no]) && $_REQUEST[$_pg_no]>0)
		$myc[$_pg_no]=$_REQUEST[$_pg_no];
	elseif(!isset($myc[$_pg_no]))
        $myc[$_pg_no]=1;
    
    if(isset($_POST[$_no_rows_displayed]))
    {
        if(is_numeric($_POST[$_no_rows_displayed]) && $_POST[$_no_rows_displayed]>0)
    		$myc[$_no_rows_displayed]=$_POST[$_no_rows_displayed];
    	else 
    		$myc[$_no_rows_displayed]=$no_rows;
    	
    	$myc[$_pg_no]=1;
    }
    elseif(!isset($myc[$_no_rows_displayed]))
        $myc[$_no_rows_displayed]=$no_rows;
    
    $_SESSION[SESS_IDX][$module_name]['paging']=$myc;
    
    $pg_no=$myc[$_pg_no];
    $no_rows_displayed=$myc[$_no_rows_displayed];
    
    return ' LIMIT '.($pg_no-1)*$no_rows_displayed.', '.$no_rows_displayed;
}

/**
 * Store in session search variables
 *
 * @parameters: $module_name = name of module for session register
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function search($module_name, $method='post')
{	
	if(isset($_SESSION[SESS_IDX][$module_name]['search']))
		unset($_SESSION[SESS_IDX][$module_name]['search']);
		
	if(isset($_SESSION[SESS_IDX][$module_name]['paging']))
		unset($_SESSION[SESS_IDX][$module_name]['paging']);
	
    $_SESSION[SESS_IDX][$module_name]['search'] = array();
	
    $myc=array();
	
    if('post'==$method)
    {
    	if(isset($_REQUEST['pg_no'])) $_REQUEST['pg_no']=1;
    	
    	$arr=$_POST;
    }
    else
    	$arr=$_GET;
    
	foreach($arr as $key=>$value)
	{
		if(!is_array($value) && trim($value)!='')
			$myc[$key]=$value;
		elseif(is_array($value))
			$myc[$key]=$value;
	}
	
    $_SESSION[SESS_IDX][$module_name]['search']=$myc;
}

/**
 * Query sort function
 *
 * @parameters: $module_name = name of module for session register | $fiedSort = name field sorted | $senswSort = ASC or DESC
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 01.12.2010 (dd.mm.YYYY)
*/
function new_sort($module_name, $field_sort='', $sense_sort='ASC')
{
    $_field_sort = 'field_sort';
    $_sense_sort = 'sense_sort';
	
	if(!isset($_SESSION[SESS_IDX][$module_name]['sort']))
        $_SESSION[SESS_IDX][$module_name]['sort']=array();
	
    $myc=$_SESSION[SESS_IDX][$module_name]['sort'];
    
    if(isset($_REQUEST[$_field_sort]) && ''!=$_REQUEST[$_field_sort])
    {
		if(isset($myc[$_field_sort]) && $myc[$_field_sort]==$_REQUEST[$_field_sort])
		{
			if($myc[$_sense_sort]=='ASC')
				$myc[$_sense_sort]='DESC';
			elseif($field_sort==$_REQUEST[$_field_sort] && $myc[$_sense_sort]=='DESC')
				$myc[$_sense_sort]='ASC';
			else
				unset($myc);
		}
		else
		{
			$myc[$_field_sort]=$_REQUEST[$_field_sort];
			$myc[$_sense_sort]='ASC';
		}
		
		if(isset($_REQUEST[$_sense_sort]) && ($_REQUEST[$_sense_sort]=='ASC' || $_REQUEST[$_sense_sort]=='DESC'))
    	{
    		$myc[$_sense_sort]=$_REQUEST[$_sense_sort];
    	}
    }
    
    $tmp='';
    if(''!=$field_sort && !isset($myc[$_field_sort]))
    {
    	$myc[$_field_sort]=$field_sort;
    	$myc[$_sense_sort]=$sense_sort;
    }
    elseif(''!=$field_sort && isset($myc[$_field_sort]))
    {
    	if($myc[$_field_sort]!=$field_sort)
    		$tmp = ', '.$field_sort.' '.$sense_sort.' ';
    }
    
    $_SESSION[SESS_IDX][$module_name]['sort']=$myc;    
    
    $field_sort = isset($myc[$_field_sort]) ? $myc[$_field_sort] : '';
    $sense_sort = isset($myc[$_sense_sort]) ? $myc[$_sense_sort] : '';
    
    if(''!=$field_sort && ''!=$sense_sort)
        return ' '.$field_sort.' '.$sense_sort.$tmp;
    else
        return '';
}
?>