<?php

//#########################################################################//
//# Utile for string processing
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 22.01.2004
//#########################################################################//

/**
 * Str rewrite escape - for friendly url
 *
 * @param: $str, $glue
 * @return:  str rewrite esc
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 15.12.2010
*/
function str_rewrite_escape($str, $glue='-') {
	$str = preg_replace('/[^\w\d]+|_+/u', ' ', str_replace_diacritics(str_remove_accents($str))); //$str = preg_replace('/[^\w\d]+|_+/', ' ', str_replace_diacritics($str)); 
	$str = preg_replace('/\s+/', $glue, trim($str));
  	
    return strtolower($str); 
}

/**
 * Str replace diacritics
 *
 * @param: $str, $glue
 * @return:  str rewrite esc
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 15.12.2010
*/
function str_replace_diacritics($str) { 
     $str = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $str);      
     $str = preg_replace('/["~^]+/', '', $str); //$string = preg_replace('/[\'"~^`]+/', '', $string); // poate e bine sa sterg \' ca sa pot avea expresii de genu Murphy's love laws:
     
     return $str; 
}

/**
 * Str tag filter
 *
 * @param: $str, $glue
 * @return:  str rewrite esc
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 15.12.2010
*/
function str_to_keywords($str, $replace_diacritics=1)
{
	if(1==$replace_diacritics)
		$str=str_remove_accents($str);
	
	$str=preg_replace('/[^-,\w\d% ]+/', '', $str);
	
	$keywords='';
	$arr=explode(',', $str);
	foreach($arr as $kw)
	{
		$kw=trim($kw);
		if(strlen($kw)>1)
			$keywords.=$kw.', ';
	}
	if($keywords)
		return strtolower(rtrim($keywords, ', '));
}

/**
 * Escaping for HTML attributes.
 *
 *
 * @param string $str
 * @return string
 */
function str_to_html($str) {
	return htmlentities($str, ENT_QUOTES, 'ISO-8859-1');//UTF-8
}

/**
 * Convert string to be used in a metatag atribute
 *
 * @access: public
 * @return: string
*/
function str_to_metatag($str, $comma=0)
{	
	$str=strip_tags($str);
	
	$str=trim(preg_replace('/[\r\n\t\s\"<>]+/', ' ', $str));
	
	if($comma==1)
		$str=preg_replace('/\s*([,])\s*/', '$1 ', $str);
	
	return $str;
}

function str_to_tag_atribute($str, $comma=0)
{
	$str=strip_tags($str);
	
	$str=trim(preg_replace('/[\r\n\t\s\"<>]+/', ' ', $str));
	
	if($comma==1)
		$str=preg_replace('/\s*([,])\s*/', '$1 ', $str);
	
	return $str;
}

/**
 * Convert string for JS use
 * 
 * @param string $str
 * @return string
 */
function str_to_js($str) {
	return preg_replace('/(\r\n|\r|\n)/', ' ', addslashes($str));
}

/**
 * Check email address
 *
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function str_check_email($email)
{
	// First, we check that there's one @ symbol, and that the lengths are right
	if(!ereg("^[^@]{1,64}@[^@]{1,255}$", $email))
	{
		// Email invalid because wrong number of characters in one section, or wrong number of @ symbols.
		return false;
	}
	// Split it into sections to make life easier
	$email_array = explode("@", $email);
	$local_array = explode(".", $email_array[0]);
	for($i = 0; $i < sizeof($local_array); $i++) 
	{
		if(!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) 
		{
			return false;
		}
	}
	  
	if(!ereg("^\[?[0-9\.]+\]?$", $email_array[1]))// Check if domain is IP. If not, it should be valid domain name
	{
		$domain_array = explode(".", $email_array[1]);
		if(sizeof($domain_array) < 2) 
		{
			return false; // Not enough parts to domain
		}
		for($i = 0; $i < sizeof($domain_array); $i++) 
		{
			if(!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) 
			{
				return false;
			}
		}
	}
	
	return true;
}

function str_utf8_lower($str)
{
	if (function_exists('mb_strtoupper') && function_exists('mb_substr') && !empty($str)) 
	{
		$e='utf-8';
		
		return mb_strtolower($str, $e);
	}
	else
		return utf8_encode(strtolower(utf8_decode($str)));
}

function str_utf8_ucfirst($str, $e='utf-8')
{
	if(empty($str))
		return $str;
	
	if (function_exists('mb_strtoupper') && function_exists('mb_substr')) {
		$str = mb_strtoupper(mb_substr($str, 0, 1, $e), $e) . mb_substr($str, 1, null, $e);
		/*
		$str = mb_strtolower($str, $e);
        $upper = mb_strtoupper($str, $e);
        preg_match('#(.)#us', $upper, $matches);
        $str = $matches[1] . mb_substr($str, 1, mb_strlen($str, $e), $e);
        */
	} 
    else {
    	$str = ucfirst($str);//$str=utf8_encode(ucfirst(utf8_decode($str)));
    }
    
    return ($str);
}

function str_utf8_upper($str)
{
	if(empty($str))
		return $str;

	if(function_exists('mb_strtoupper')) {
		$e='utf-8';
		return mb_strtoupper($str, $e);
	}
	else
		return utf8_encode(strtoupper(utf8_decode($str)));
}

function str_truncate($string, $length = 80, $etc = '...', $break_words = false, $middle = false) {
    if ($length == 0)
        return '';

    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
        if (mb_strlen($string, SMARTY_RESOURCE_CHAR_SET) > $length) {
            $length -= min($length, mb_strlen($etc, SMARTY_RESOURCE_CHAR_SET));
            if (!$break_words && !$middle) {
                $string = preg_replace('/\s+?(\S+)?$/u', '', mb_substr($string, 0, $length + 1, SMARTY_RESOURCE_CHAR_SET));
            } 
            if (!$middle) {
                return mb_substr($string, 0, $length, SMARTY_RESOURCE_CHAR_SET) . $etc;
            }
            return mb_substr($string, 0, $length / 2, SMARTY_RESOURCE_CHAR_SET) . $etc . mb_substr($string, - $length / 2, $length, SMARTY_RESOURCE_CHAR_SET);
        }
        return $string;
    }
    
    // no MBString fallback
    if (isset($string[$length])) {
        $length -= min($length, strlen($etc));
        if (!$break_words && !$middle) {
            $string = preg_replace('/\s+?(\S+)?$/', '', substr($string, 0, $length + 1));
        } 
        if (!$middle) {
            return substr($string, 0, $length) . $etc;
        }
        return substr($string, 0, $length / 2) . $etc . substr($string, - $length / 2);
    }
    return $string;
}

function str_strip($str)
{
    return preg_replace('!\s+!u', ' ', $str);
}

function str_strip_tags($str, $php_function=false)
{   
    if (!$php_function)
        return preg_replace('!<[^>]*?>!', ' ', $str);
    else
        return strip_tags($str);
}






/**
 * Checks to see if a string is utf8 encoded.
 *
 * NOTE: This function checks for 5-Byte sequences, UTF8
 *       has Bytes Sequences with a maximum length of 4.
 *
 * @author bmorel at ssi dot fr (modified)
 * @since 1.2.1
 *
 * @param string $str The string to be checked
 * @return bool True if $str fits a UTF-8 model, false otherwise.
 */
function str_seems_utf8($str) {
	$length = strlen($str);
	for ($i=0; $i < $length; $i++) {
		$c = ord($str[$i]);
		if ($c < 0x80) $n = 0; # 0bbbbbbb
		elseif (($c & 0xE0) == 0xC0) $n=1; # 110bbbbb
		elseif (($c & 0xF0) == 0xE0) $n=2; # 1110bbbb
		elseif (($c & 0xF8) == 0xF0) $n=3; # 11110bbb
		elseif (($c & 0xFC) == 0xF8) $n=4; # 111110bb
		elseif (($c & 0xFE) == 0xFC) $n=5; # 1111110b
		else return false; # Does not match any model
		for ($j=0; $j<$n; $j++) { # n bytes matching 10bbbbbb follow ?
			if ((++$i == $length) || ((ord($str[$i]) & 0xC0) != 0x80))
				return false;
		}
	}
	return true;
}

/**
 * Converts all accent characters to ASCII characters.
 *
 * If there are no accent characters, then the string given is just returned.
 *
 * @since 1.2.1
 *
 * @param string $string Text that might have accent characters
 * @return string Filtered string with replaced "nice" characters.
 */
function str_remove_accents($string) {
	if ( !preg_match('/[\x80-\xff]/', $string) )
		return $string;

	if (str_seems_utf8($string)) {
		$chars = array(
		// Decompositions for Latin-1 Supplement
		chr(195).chr(128) => 'A', chr(195).chr(129) => 'A',
		chr(195).chr(130) => 'A', chr(195).chr(131) => 'A',
		chr(195).chr(132) => 'A', chr(195).chr(133) => 'A',
		chr(195).chr(135) => 'C', chr(195).chr(136) => 'E',
		chr(195).chr(137) => 'E', chr(195).chr(138) => 'E',
		chr(195).chr(139) => 'E', chr(195).chr(140) => 'I',
		chr(195).chr(141) => 'I', chr(195).chr(142) => 'I',
		chr(195).chr(143) => 'I', chr(195).chr(145) => 'N',
		chr(195).chr(146) => 'O', chr(195).chr(147) => 'O',
		chr(195).chr(148) => 'O', chr(195).chr(149) => 'O',
		chr(195).chr(150) => 'O', chr(195).chr(153) => 'U',
		chr(195).chr(154) => 'U', chr(195).chr(155) => 'U',
		chr(195).chr(156) => 'U', chr(195).chr(157) => 'Y',
		chr(195).chr(159) => 's', chr(195).chr(160) => 'a',
		chr(195).chr(161) => 'a', chr(195).chr(162) => 'a',
		chr(195).chr(163) => 'a', chr(195).chr(164) => 'a',
		chr(195).chr(165) => 'a', chr(195).chr(167) => 'c',
		chr(195).chr(168) => 'e', chr(195).chr(169) => 'e',
		chr(195).chr(170) => 'e', chr(195).chr(171) => 'e',
		chr(195).chr(172) => 'i', chr(195).chr(173) => 'i',
		chr(195).chr(174) => 'i', chr(195).chr(175) => 'i',
		chr(195).chr(177) => 'n', chr(195).chr(178) => 'o',
		chr(195).chr(179) => 'o', chr(195).chr(180) => 'o',
		chr(195).chr(181) => 'o', chr(195).chr(182) => 'o',
		chr(195).chr(182) => 'o', chr(195).chr(185) => 'u',
		chr(195).chr(186) => 'u', chr(195).chr(187) => 'u',
		chr(195).chr(188) => 'u', chr(195).chr(189) => 'y',
		chr(195).chr(191) => 'y',
		// Decompositions for Latin Extended-A
		chr(196).chr(128) => 'A', chr(196).chr(129) => 'a',
		chr(196).chr(130) => 'A', chr(196).chr(131) => 'a',
		chr(196).chr(132) => 'A', chr(196).chr(133) => 'a',
		chr(196).chr(134) => 'C', chr(196).chr(135) => 'c',
		chr(196).chr(136) => 'C', chr(196).chr(137) => 'c',
		chr(196).chr(138) => 'C', chr(196).chr(139) => 'c',
		chr(196).chr(140) => 'C', chr(196).chr(141) => 'c',
		chr(196).chr(142) => 'D', chr(196).chr(143) => 'd',
		chr(196).chr(144) => 'D', chr(196).chr(145) => 'd',
		chr(196).chr(146) => 'E', chr(196).chr(147) => 'e',
		chr(196).chr(148) => 'E', chr(196).chr(149) => 'e',
		chr(196).chr(150) => 'E', chr(196).chr(151) => 'e',
		chr(196).chr(152) => 'E', chr(196).chr(153) => 'e',
		chr(196).chr(154) => 'E', chr(196).chr(155) => 'e',
		chr(196).chr(156) => 'G', chr(196).chr(157) => 'g',
		chr(196).chr(158) => 'G', chr(196).chr(159) => 'g',
		chr(196).chr(160) => 'G', chr(196).chr(161) => 'g',
		chr(196).chr(162) => 'G', chr(196).chr(163) => 'g',
		chr(196).chr(164) => 'H', chr(196).chr(165) => 'h',
		chr(196).chr(166) => 'H', chr(196).chr(167) => 'h',
		chr(196).chr(168) => 'I', chr(196).chr(169) => 'i',
		chr(196).chr(170) => 'I', chr(196).chr(171) => 'i',
		chr(196).chr(172) => 'I', chr(196).chr(173) => 'i',
		chr(196).chr(174) => 'I', chr(196).chr(175) => 'i',
		chr(196).chr(176) => 'I', chr(196).chr(177) => 'i',
		chr(196).chr(178) => 'IJ',chr(196).chr(179) => 'ij',
		chr(196).chr(180) => 'J', chr(196).chr(181) => 'j',
		chr(196).chr(182) => 'K', chr(196).chr(183) => 'k',
		chr(196).chr(184) => 'k', chr(196).chr(185) => 'L',
		chr(196).chr(186) => 'l', chr(196).chr(187) => 'L',
		chr(196).chr(188) => 'l', chr(196).chr(189) => 'L',
		chr(196).chr(190) => 'l', chr(196).chr(191) => 'L',
		chr(197).chr(128) => 'l', chr(197).chr(129) => 'L',
		chr(197).chr(130) => 'l', chr(197).chr(131) => 'N',
		chr(197).chr(132) => 'n', chr(197).chr(133) => 'N',
		chr(197).chr(134) => 'n', chr(197).chr(135) => 'N',
		chr(197).chr(136) => 'n', chr(197).chr(137) => 'N',
		chr(197).chr(138) => 'n', chr(197).chr(139) => 'N',
		chr(197).chr(140) => 'O', chr(197).chr(141) => 'o',
		chr(197).chr(142) => 'O', chr(197).chr(143) => 'o',
		chr(197).chr(144) => 'O', chr(197).chr(145) => 'o',
		chr(197).chr(146) => 'OE',chr(197).chr(147) => 'oe',
		chr(197).chr(148) => 'R',chr(197).chr(149) => 'r',
		chr(197).chr(150) => 'R',chr(197).chr(151) => 'r',
		chr(197).chr(152) => 'R',chr(197).chr(153) => 'r',
		chr(197).chr(154) => 'S',chr(197).chr(155) => 's',
		chr(197).chr(156) => 'S',chr(197).chr(157) => 's',
		chr(197).chr(158) => 'S',chr(197).chr(159) => 's',
		chr(197).chr(160) => 'S', chr(197).chr(161) => 's',
		chr(197).chr(162) => 'T', chr(197).chr(163) => 't',
		chr(197).chr(164) => 'T', chr(197).chr(165) => 't',
		chr(197).chr(166) => 'T', chr(197).chr(167) => 't',
		chr(197).chr(168) => 'U', chr(197).chr(169) => 'u',
		chr(197).chr(170) => 'U', chr(197).chr(171) => 'u',
		chr(197).chr(172) => 'U', chr(197).chr(173) => 'u',
		chr(197).chr(174) => 'U', chr(197).chr(175) => 'u',
		chr(197).chr(176) => 'U', chr(197).chr(177) => 'u',
		chr(197).chr(178) => 'U', chr(197).chr(179) => 'u',
		chr(197).chr(180) => 'W', chr(197).chr(181) => 'w',
		chr(197).chr(182) => 'Y', chr(197).chr(183) => 'y',
		chr(197).chr(184) => 'Y', chr(197).chr(185) => 'Z',
		chr(197).chr(186) => 'z', chr(197).chr(187) => 'Z',
		chr(197).chr(188) => 'z', chr(197).chr(189) => 'Z',
		chr(197).chr(190) => 'z', chr(197).chr(191) => 's',
		// Euro Sign
		chr(226).chr(130).chr(172) => 'E',
		// GBP (Pound) Sign
		chr(194).chr(163) => '');

		$string = strtr($string, $chars);
	} else {
		// Assume ISO-8859-1 if not UTF-8
		$chars['in'] = chr(128).chr(131).chr(138).chr(142).chr(154).chr(158)
			.chr(159).chr(162).chr(165).chr(181).chr(192).chr(193).chr(194)
			.chr(195).chr(196).chr(197).chr(199).chr(200).chr(201).chr(202)
			.chr(203).chr(204).chr(205).chr(206).chr(207).chr(209).chr(210)
			.chr(211).chr(212).chr(213).chr(214).chr(216).chr(217).chr(218)
			.chr(219).chr(220).chr(221).chr(224).chr(225).chr(226).chr(227)
			.chr(228).chr(229).chr(231).chr(232).chr(233).chr(234).chr(235)
			.chr(236).chr(237).chr(238).chr(239).chr(241).chr(242).chr(243)
			.chr(244).chr(245).chr(246).chr(248).chr(249).chr(250).chr(251)
			.chr(252).chr(253).chr(255);

		$chars['out'] = "EfSZszYcYuAAAAAACEEEEIIIINOOOOOOUUUUYaaaaaaceeeeiiiinoooooouuuuyy";

		$string = strtr($string, $chars['in'], $chars['out']);
		$double_chars['in'] = array(chr(140), chr(156), chr(198), chr(208), chr(222), chr(223), chr(230), chr(240), chr(254));
		$double_chars['out'] = array('OE', 'oe', 'AE', 'DH', 'TH', 'ss', 'ae', 'dh', 'th');
		$string = str_replace($double_chars['in'], $double_chars['out'], $string);
	}

	return $string;
}


/**
 * Escaping for HTML attributes.
 *
 * @since 2.8.0
 *
 * @param string $text
 * @return string
 */
function esc_attr( $str ) {
	return htmlentities($str, ENT_QUOTES, 'UTF-8');
}

function htmlentities2($myHTML) {
	$translation_table = get_html_translation_table( HTML_ENTITIES, ENT_QUOTES );
	$translation_table[chr(38)] = '&';
	return preg_replace( "/&(?![A-Za-z]{0,4}\w{2,3};|#[0-9]{2,3};)/", "&amp;", strtr($myHTML, $translation_table) );
}


/**
 * Escape single quotes, htmlspecialchar " < > &, and fix line endings.  ?????????????????????????
 *
 * Escapes text strings for echoing in JS, both inline (for example in onclick="...")
 * and inside <script> tag. Note that the strings have to be in single quotes.
 * The filter 'js_escape' is also applied here.
 *
 * @since 2.8.0
 *
 * @param string $text The text to be escaped.
 * @return string Escaped text.
 */
function esc_js( $text ) {
	$safe_text = wp_check_invalid_utf8( $text );
	$safe_text = _wp_specialchars( $safe_text, ENT_COMPAT );
	$safe_text = preg_replace( '/&#(x)?0*(?(1)27|39);?/i', "'", stripslashes( $safe_text ) );
	$safe_text = str_replace( "\r", '', $safe_text );
	$safe_text = str_replace( "\n", '\\n', addslashes( $safe_text ) );
	return apply_filters( 'js_escape', $safe_text, $text );
}

/**
 * Escape a HTML tag name. ?????????????????????????
 *
 * @since 2.5.0
 *
 * @param string $tag_name
 * @return string
 */
function tag_escape($tag_name) {
	$safe_tag = strtolower( preg_replace('/[^a-zA-Z_:]/', '', $tag_name) );
	return apply_filters('tag_escape', $safe_tag, $tag_name);
}

/**
 * Encode the Unicode values to be used in the URI.  ?????????????????????????
 *
 * @since 1.5.0
 *
 * @param string $utf8_string
 * @param int $length Max length of the string
 * @return string String with Unicode encoded for URI.
 */
function utf8_uri_encode( $utf8_string, $length = 0 ) {
	$unicode = '';
	$values = array();
	$num_octets = 1;
	$unicode_length = 0;

	$string_length = strlen( $utf8_string );
	for ($i = 0; $i < $string_length; $i++ ) {

		$value = ord( $utf8_string[ $i ] );

		if ( $value < 128 ) {
			if ( $length && ( $unicode_length >= $length ) )
				break;
			$unicode .= chr($value);
			$unicode_length++;
		} else {
			if ( count( $values ) == 0 ) $num_octets = ( $value < 224 ) ? 2 : 3;

			$values[] = $value;

			if ( $length && ( $unicode_length + ($num_octets * 3) ) > $length )
				break;
			if ( count( $values ) == $num_octets ) {
				if ($num_octets == 3) {
					$unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]) . '%' . dechex($values[2]);
					$unicode_length += 9;
				} else {
					$unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]);
					$unicode_length += 6;
				}

				$values = array();
				$num_octets = 1;
			}
		}
	}

	return $unicode;
}

/**
 * Determines the difference between two timestamps.
 *
 * The difference is returned in a human readable format such as "1 hour",
 * "5 mins", "2 days".
 *
 * @since 1.5.0
 *
 * @param int $from Unix timestamp from which the difference begins.
 * @param int $to Optional. Unix timestamp to end the time difference. Default becomes time() if not set.
 * @return string Human readable time difference.
 */
function human_time_diff( $from, $to = '' ) {
	if ( empty($to) )
		$to = time();
	$diff = (int) abs($to - $from);
	if ($diff <= 3600) {
		$mins = round($diff / 60);
		if ($mins <= 1) {
			$mins = 1;
		}
		$since = sprintf(_n('%s min', '%s mins', $mins), $mins);
	} else if (($diff <= 86400) && ($diff > 3600)) {
		$hours = round($diff / 3600);
		if ($hours <= 1) {
			$hours = 1;
		}
		$since = sprintf(_n('%s hour', '%s hours', $hours), $hours);
	} elseif ($diff >= 86400) {
		$days = round($diff / 86400);
		if ($days <= 1) {
			$days = 1;
		}
		$since = sprintf(_n('%s day', '%s days', $days), $days);
	}
	return $since;
}
























/**
 * String fomated
 *
 * @param: $str = string | $noChars = no. of chars | $sufix = sufix terminator
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function _strFormated($str, $noChars, $sufix='...')
{
	if(strlen($str) <= $noChars) 
		 return $str;
	else 
		return substr($str, 0, $noChars).$sufix;
}

/**
 * Get Tabulation
 *
 * @param: $no = no. of tabs \t
 * @access: public
 * @return: tab string
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function _strGetTabulation($no)
{
	$ret = "";
	for($i=0;$i<$no;$i++)
		$ret.="\t";
	return $ret;
}

/**
 * Generate random string
 *
 * @param: $noChar = string lenght | $strFrom = base of string generated
 * @access: public
 * @return: string generated
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function _strGetRandomStr($noChars, $strFrom='')
{
	if(''==$strFrom)
		$strFrom = "qwertyuiop123asdfghjkl456zxcvbnm7890";
	
    $len = strlen($strFrom);
    
    $vectStrGenerated = array();
    
    $i = 0;    
    while($i<$noChars)
    {
        $pos = rand(0, $len-1);
        $vectStrGenerated[$i] = $strFrom[$pos];
        $i++;
    }
    
    $strGenerated = implode('', $vectStrGenerated);
    
    return $strGenerated;
}

/**
 * Number formating
 *
 * @param: $no = number | $p = precision
 * @access: public
 * @return: number formated
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function _strNoFormated($no, $decimals=0, $dec_point=',', $thousands_sep='.')
{
	return number_format($no, $decimals, $dec_point, $thousands_sep);
}

function _strReplaceDiacritics($string) { 
     $string = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $string); 
     //$string = preg_replace('/[\'"~^`]+/', '', $string); // poate e bine sa sterg \' ca sa pot avea expresii de genu Murphy's love laws:
     $string = preg_replace('/["~^`]+/', '', $string);
     
     return $string; 
}



/**
 * Cenzurare/Bann Text
 *
 * @param: $str
 * @access: public
 * @return: number formated
 * @author: CFlorin (colotin_f@yahoo.com) preluata de la marius
*/
function _strTextBann($text_content, $wrong_words=array(), $replace_with="*") 
{
	$wrong_words = array("pula", "pulei", "pulica", "pulicica", "pulan", "dick", "penis", "pizda", "lindic", "gaoaza", "gaoz", "pussy", "coaie", "coaiele", "cur", "fut", "fute", "futut", "futai", "fututa", "fuck", "fucking", "xxx", "sex", "oral", "curva", "muie", "muist", "prono", "porn");	
	
	foreach($wrong_words as $word) 
	{
		$repl=$word[0];
		
		for($i=0;$i<strlen($word)-2;$i++)
			$repl.=$replace_with;
		
		$repl.=$word[strlen($word)-1];
			
		$text_content = eregi_replace("([ .\!\:,]){$word}([ .\!\:,])", "\\1{$repl}\\2", $text_content);		
	}
	
	return $text_content;
}

/**
 * Get Short url
 *
 * @param: $url
 * @access: public
 * @return: number formated
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function _strGetShortUrl($url)
{
	if(substr($url, 0, 7)=='http://')
    	$url=substr($url, 7);
    elseif(substr($url, 0, 8)=='https://')
   		$url=substr($url, 8);
   		
   	if(substr($url, 0, 4)=='www.')
    	$url=substr($url, 4);
    
    $tmp=explode("/", $url);
	
    return strtolower(str_replace('\\', '', $tmp[0]));
}

/**
 * Prepare Tag Atribute
 *
 * @param: $url
 * @access: public
 * @return: number formated
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function _strPrepareTagAtribute($str, $comma=0)
{
	$str=strip_tags($str);
	
	if($comma==1)
		$str=preg_replace('/ *([,]+) */', '$1 ', $str);
	
	$str=trim(preg_replace('/[\r\n\t\s\"<>]+/', ' ', $str));
	
	return $str;
}


/**
 * Replace special caracters
 * 
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function _strConvertToNoDiacritics($str, $sqlEscValue=0, $stripTags=0)
{
	//Aa - A
	$str = str_replace('Ă', 'a', $str);
	//aa
	$str = str_replace('?', 'a', $str);
	//ai - a 
	$str = str_replace('â', 'a', $str);	
	//Ai - a 
	$str = str_replace('Â', 'a', $str);
	
	// - O
	$str = str_replace('Ö', 'o', $str);
	//o: - o
	$str = str_replace('ö', 'o', $str);
	
	//Ii
	$str = str_replace('Î', 'i', $str);
	//ii
	$str = str_replace('î', 'i', $str);
	
	//Si - S
	$str = str_replace('Ş', 'S', $str);
	//si - s
	$str = str_replace('ş', 's', $str);
	//S` - S
	$str = str_replace('Š', 'S', $str);
	
	//Ti - T
	$str = str_replace('Ţ', 'T', $str);
	//ti - t
	$str = str_replace('ţ', 't', $str);
	
	//==============================================//
	
	// - a
	$str = str_replace("", 'a', $str);
	// - a 
	$str = str_replace('', 'a', $str);
	// - A
	$str = str_replace('', 'A', $str);
	// - A
	$str = str_replace('', 'A', $str);
	
	// - i
	$str = str_replace('', 'i', $str);
	// - i
	$str = str_replace('', 'I', $str);
		
	// - s
	$str = str_replace('', 's', $str);
	// - S
	$str = str_replace('', 'S', $str);
	
	// - t
	$str = str_replace('', 't', $str);
	// - T
	$str = str_replace('', 'T', $str);
	
	// - -
	$str = str_replace('', '-', $str);
	
	//==============================================//

	//&#258; :  - A
	$str = str_replace('&#258;', 'A', $str);
	//&#259; :  - a
	$str = str_replace('&#259;', 'a', $str);		
	//&#227; : ? - a
	$str = str_replace('&#227;', 'a', $str);
	//&atilde; : ? - a
	$str = str_replace('&atilde;', 'a', $str);
	
	//&#354; :  - T
	$str = str_replace('&#354;', 'T', $str);
	//&#355; :  - t
	$str = str_replace('&#355;', 't', $str);	
	//&#539; : ? - T
	$str = str_replace('&#539;', 't', $str);
	//&#254; : ? - t
	$str = str_replace('&#254;', 't', $str);
	
	//&#350; :  - S
	$str = str_replace('&#350;', 'S', $str);
	//&#351; :  - s
	$str = str_replace('&#351;', 's', $str);
	//&#537; : ? - s
	$str = str_replace('&#537;', 's', $str);	
	
	//&#8209; :  - -
	$str = str_replace('&#8209;', '-', $str);
	//&#8211; : - - -
	$str = str_replace('&#8211;', '-', $str);
	
	//&#8220; :  - "
	$str = str_replace('&#8220;', '"', $str);	
	//&#8221; :  - "
	$str = str_replace('&#8221;', '"', $str);
	//&#8222; :  - "
	$str = str_replace('&#8222;', '"', $str);
	
	//==============================================//
		
	if($sqlEscValue==1)
		return _sqlEscValue($str, 1, $stripTags);
	else
	{
		if($stripTags==1)
			return trim(strip_tags($str));
		else 
			return trim($str);
	}
}

/**
 * Correct the text signs: [?!.:,]
 * 
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function _strCorrentTextSigns($str, $noDiacritics=0, $sqlEscValue=0, $stripTags=0, $trim=0)
{	
	if($noDiacritics==1)
		$str=_strConvertToNoDiacritics($str, $sqlEscValue, $stripTags);
	else 
	{
		if($sqlEscValue==1)
			$str=_sqlEscValue($str, $trim, $stripTags);
		else
		{
			if($stripTags==1)
				$str=strip_tags($str);
			if($trim==1) 
				$str=trim($str);
		}
	}
	
	if(stripos($str, "\"")===false)	
		$str=preg_replace('/ *([\?\!:,]+) */', '$1 ', $str);
	else 
		$str=preg_replace('/ *([:,]+) */', '$1 ', $str);
	
	$str=str_ireplace("http: //", "http://", $str);
	/*
	$str=str_ireplace("www. ", "www.", $str);
	$str=str_ireplace(". ro", ".ro", $str);
	$str=str_ireplace(". com", ".com", $str);
	$str=str_ireplace(". eu", ".eu", $str);
	$str=str_ireplace(". fr", ".fr", $str);
	$str=str_ireplace(". net", ".net", $str);
	$str=str_ireplace(". info", ".info", $str);
	$str=str_ireplace(". me", ".me", $str);
	$str=str_ireplace(". md", ".md", $str);
	*/
	
	if($trim==1) $str=trim($str);
	
	return $str;
}


function _strStrip($text, $replace=' ')
{
    return preg_replace('!\s+!', $replace, $text);
}
?>