<?php

//#########################################################################//
//# Utile for date & time
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 22.01.2004
//#########################################################################//

/**
 * Get microtime in miliseconds
 *
 * @param: void
 * @access: public
 * @return: numeric miliseconds
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.10.2010 (dd.mm.YYYY)
*/
function dt_microtime($time_delay=0)
{
   list($usec, $sec) = explode(' ', microtime());
   
   return ((float)$usec + (float)$sec)+$time_delay;
}

/**
 * Get system time
 *
 * @param: void
 * @access: public
 * @return: numeric time
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.10.2010 (dd.mm.YYYY)
*/
function dt_ctime($time_delay=0)
{
	return time()+$time_delay;
}

/**
 * Get current date formated
 *
 * @param: $format = date format
 * @access: public
 * @return: date
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function dt_cdate($format='Y-m-d', $time_delay=0)
{   
	return date($format, dt_ctime($time_delay));
}

/**
 * Get week days
 *
 * @param: null
 * @access: public
 * @return: day/days
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function dt_days($d=-1, $lang_iso='')
{
	if($d==0)//0-Sunday
		$d=7;
	
	if(''==$lang_iso)
		$lang_iso=isset($_SESSION[SESS_IDX]['lang_iso']) ? $_SESSION[SESS_IDX]['lang_iso']:'ro';
	
	$ret=array();
	
	$ret['ro'][1]='Luni';
	$ret['ro'][2]='Marti';
	$ret['ro'][3]='Miercuri';
	$ret['ro'][4]='Joi';
	$ret['ro'][5]='Vineri';
	$ret['ro'][6]='Sambata';
	$ret['ro'][7]='Duminica';
	
	$ret['en'][1]='Monday';
	$ret['en'][2]='Tuesday';
	$ret['en'][3]='Wednesday';
	$ret['en'][4]='Thursday';
	$ret['en'][5]='Friday';
	$ret['en'][6]='Saturday';
	$ret['en'][7]='Sunday';
	
	if($d>0)
		return $ret[$lang_iso][$d];
	else
		return $ret[$lang_iso];
}

/**
 * Get year months
 *
 * @param: null
 * @access: public
 * @return: time
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function dt_months($m=-1, $lang_iso='')
{
	if(''==$lang_iso)
		$lang_iso=isset($_SESSION[SESS_IDX]['lang_iso']) ? $_SESSION[SESS_IDX]['lang_iso']:'ro';
	
	$ret=array();
	
	$ret['ro'][1]='Ianuarie';
	$ret['ro'][2]='Februarie';
	$ret['ro'][3]='Martie';
	$ret['ro'][4]='Aprilie';
	$ret['ro'][5]='Mai';
	$ret['ro'][6]='Iunie';
	$ret['ro'][7]='Iulie';
	$ret['ro'][8]='August';
	$ret['ro'][9]='Septembrie';
	$ret['ro'][10]='Octombrie';
	$ret['ro'][11]='Noiembrie';
	$ret['ro'][12]='Decembrie';
	
	$ret['en'][1]='January';
	$ret['en'][2]='February';
	$ret['en'][3]='March';
	$ret['en'][4]='April';
	$ret['en'][5]='May';
	$ret['en'][6]='June';
	$ret['en'][7]='July';
	$ret['en'][8]='August';
	$ret['en'][9]='September';
	$ret['en'][10]='October';
	$ret['en'][11]='November';
	$ret['en'][12]='December';
	
	if($m>0)
		return $ret[$lang_iso][$m];
	else
		return $ret[$lang_iso];
}

/**
 * Get H,I,S from unix time
 *
 * @param: $time = unix time | $zeroFill = zero fill
 * @access: public
 * @return: array()
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 12.12.2010 (dd.mm.YYYY)
*/
function dt_time_his($time, $zero_fill='')
{
	$vect_time=array();
	$vect_time['h'] = (int)($time/3600);
	$vect_time['i'] = (int)(($time - ($vect_time['h']*3600))/60);
	$vect_time['s'] = ($time - ($vect_time['h']*3600) - ($vect_time['i']*60));
	
	if(''!=$zero_fill)
	{
		if($vect_time['h']<9) $vect_time['h']=$zero_fill.$vect_time['h'];
		if($vect_time['i']<9) $vect_time['i']=$zero_fill.$vect_time['i'];
		if($vect_time['s']<9) $vect_time['s']=$zero_fill.$vect_time['s'];	
	}
	
	return $vect_time;
}

/**
 * Get D (no days), H (no hours), I (no minutes) from unix time
 *
 * @param: $time = unix time | $zeroFill = zero fill
 * @access: public
 * @return: array()
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 12.12.2010 (dd.mm.YYYY)
*/
function dt_time_dhi($sec, $format='%d d, %hh, %mm')
{
	if(is_numeric($sec) && $sec>0)
	{
		$d = (int)($sec/86400);
		$h = (int)(($sec-($d*86400))/3600);
		$m = (int)(($sec-($d*86400)-($h*3600))/60);
		
		$ret = str_replace("%d", $d, $format);
		$ret = str_replace("%h", $h, $ret);
		$ret = str_replace("%m", $m, $ret);
	
		return $ret;
	}
	else 
		return false;
}



//############## de eliminat

/**
 * Get date formated - depreceated
 *
 * @param: $format = date format
 * @access: public
 * @return: date
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function dt_date_format($date, $format='d.m.y')
{
	if($date!='' && $date!='0000-00-00' && $date!='0000-00-00 00:00:00')
		return date($format, strtotime($date));
	else
		return false;
}

/**
 * Get unic time for each day of the week
 *
 * @param: $year, $week
 * @access: public
 * @return: array();
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function dt_time_for_each_day_of_week($year, $week)
{
	$ret=array();				
	
	$startUT = _dtGetUTimeOfWeekFirstDay($year, $week);
	
	for($i=1;$i<=7;$i++)
	{
		$ret[$i]=$startUT+(($i-1)*(24*3600))-3600;
		//$ret[$i]=$startUT+(($i)*(24*3600))-3600;
	}
			
	return $ret;
}

/**
 * Get date of week first day (weeks starting on Monday)
 *
 * @param: $year, $week
 * @access: public
 * @return: time
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function dt_time_of_week_first_day($year, $week)
{		
	$startTime = strtotime("{$year}-01-01");
	
	$firstMondayTime = strtotime("first monday", $startTime);
	
	return $firstMondayTime+((3600*24*7)*($week-1));
}

/**
 * Minutes format
 *
 * @param: $year, $week
 * @access: public
 * @return: time
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function dt_minutes_format($minutes, $format='%hh %mm', $zerofill='&nbsp;')
{
	if(is_numeric($minutes))
	{
		$sign='';
		if($minutes<0)
		{
			$minutes=$minutes*(-1);
			$sign='-';
		}
		
		$h = (int)($minutes/60);
		$m = (int)($minutes-($h*60));
		
		if($zerofill!='')
		{
			$h = $h<=9 ? $zerofill.$h:$h;
			$m = $m<=9 ? $zerofill.$m:$m;
		}
		
		return $sign.str_replace('%m', $m, str_replace('%h', $h, $format));
	}
	else
		return '';
}

/**
 * Format old date, Beta, working only for yyyy format
 *
 * D - a textual representation of a day, three letters Mon through Sun 
 * F - a full textual representation of a month, such as January or March January through December 
 * M - a short textual representation of a month, three letters Jan through Dec
 * @param: $date, $format
 * @return: date formated;
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function dt_old_date_format($date_yyyy_mm_dd, $format='d M Y')
{
	$tmp1 = explode('-', $date_yyyy_mm_dd);
	$tmp2=date('Y').'-'.$tmp1[1].'-'.$tmp1[2];
	
	$ret = date($format, strtotime($tmp2));
	
	$ret=str_replace(date('Y'), $tmp1[0], $ret);
	
	return $ret;
}

function date_mysql_to_fr($date_mysql)
{
	$tab_date=explode("-",$date_mysql);
	$date_fr=date ("d/m/Y", mktime(0,0,0,$tab_date[1],$tab_date[2],$tab_date[0]));
	return ($date_fr);
}

function date_fr_to_mysql($date_fr)
{
	$tab_date=explode("/",$date_fr);
	$date_fr=date ("Y-m-d", mktime(0,0,0,$tab_date[1],$tab_date[0],$tab_date[2]));
	return ($date_fr);
}
?>