<?php
//#########################################################################//
//# Upload file class
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 30.03.2005
//#########################################################################//

include_once(LIB_DIR.'image/image.class.php');

if(!defined("UPL_SIZE_LIMIT")) define("UPL_SIZE_LIMIT",  0);
if(!defined("UPL_IMG_W_LIMIT")) define("UPL_IMG_W_LIMIT", 0);
if(!defined("UPL_IMG_H_LIMIT")) define("UPL_IMG_H_LIMIT", 0);

class upload
{	
	public $fileElem = null;
	public $uplPath = null;
	public $uplFile = null;
	
	public $fileSize = 0;
	public $fileType = null;
	public $fileExt = null;
	
	public $fileTypeAccepted = ''; //file type condition 
	public $fileExtAccepted = ''; //file extension condition 
	
	public $sizeLimit = 0;  //0 - indiferent, '' - default
	public $imgWLimit = 0;  //0 - indiferent, '' - default
	public $imgHLimit = 0;  //0 - indiferent, '' - default
	
	public $errCode = 0;
	
	function __construct($file_elem, $upl_path, $upl_file='')
	{
    	 $this->fileElem = $file_elem;
    	 $this->uplPath = $upl_path;
    	 $this->uplFile = $upl_file;
	}
	
	/**
	 * Process file uploaded
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function process($param_arr=null)
	{
		//uploaded condition
		if(is_uploaded_file($_FILES[$this->fileElem]['tmp_name']))
		{
			//if path directory not found, create it
			if(!file_exists($this->uplPath))
				mkdir($this->uplPath);
			
			$this->fileExt=$this->getFileExt($_FILES[$this->fileElem]['name']);
				
			if($this->uplFile) 
			{
				if(!$this->getFileExt($this->uplFile))
					if($this->fileExt)
						$this->uplFile.='.'.$this->fileExt;
			}
			else
				$this->uplFile=strtolower($_FILES[$this->fileElem]['name']);
			
			$this->fileSize = $_FILES[$this->fileElem]['size'];
			
			//uploaded size condition > 0
			if($this->fileSize>0)
			{
				//uploaded particular size condition
				if($this->fileSize<=$this->sizeLimit || $this->sizeLimit===0)
				{
					$this->fileType = $this->getFileType();
					
					//check particular file type condition
					if($this->checkTypeAccepted($this->fileType) && $this->checkExtAccepted($this->fileExt))
					{
						switch($this->fileType[0])
						{
							case 'image':
								$this->processImage($param_arr);
								break;
							default:
								$this->moveUploadFile();
						}
					}
					else 
						$this->errCode = 4;
				}//exceded size limit
				else 
					$this->errCode = 3;
			}//file with size 0
			else 
				$this->errCode = 2;
		}//end is_uploaded_file
		else
			$this->errCode = 1;
		
		if(!$this->errCode)
			return true;
		else
			return false;
	}
	
	/**
	 * Move uploaded file
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function moveUploadFile()
	{
		if(!move_uploaded_file($_FILES[$this->fileElem]['tmp_name'], $this->uplPath.$this->uplFile))
			$this->errCode = 5;
	}
	
	/**
	 * Set a limit size for a file
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 30.03.2005 (dd.mm.YYYY)
	*/
	function setSizeLimit($value=0)
	{
		$this->sizeLimit = $value;
	}
	
	/**
	 * Get file extension
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function getFileExt($file_name)
	{
		return strtolower(substr(strrchr($file_name, '.'), 1));
	}
	
	/**
	 * Get name of file dst
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 30.03.2005 (dd.mm.YYYY)
	*/
	function getFileDst()
	{
		return $this->uplFile;
	}
	
	/**
	 * Get file size
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function getFileSize()
	{
		return $this->fileSize;
	}
	
	/**
	 * Get file Type
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function getFileType()
	{
		return explode("/", $_FILES[$this->fileElem]['type']);	
	}
	
	/**
	 * Set type of file accepted
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function setFileTypeAccepted($value='')
	{
		$this->fileTypeAccepted=$value;
	}
	
	/**
	 * Set extensions of file accepted (comma separated)
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function setFileExtAccepted($value='')
	{
		$this->fileExtAccepted=$value;
	}
	
	/**
	 * Check type of file uploaded
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function checkTypeAccepted($type_arr)
	{
		if($this->fileTypeAccepted=='' || $this->fileTypeAccepted==$type_arr[0])
			return true;
		else 
			return false;
	}
	
	/**
	 * Check extension of file uploaded
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function checkExtAccepted($ext)
	{
		if($this->fileExtAccepted=='' || strpos($this->fileExtAccepted, $ext)!==false)
			return true;
		else 
			return false;
	}
	
	/**
	 * Set W & H limit for images
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function imgWHLimit($img_wlimit=0, $img_hlimit=0)
	{
		if($img_wlimit==='')
			$img_wlimit = UPL_IMG_W_LIMIT;
		if($img_hlimit==='')
			$img_hlimit = UPL_IMG_H_LIMIT;
		
		$this->imgWLimit = $img_wlimit;
		$this->imgHLimit = $img_hlimit;
	}
	
	/**
	 * Process Image
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function processImage($param_arr)
	{
		if(count($param_arr)>0 && $param_arr[0]!='' && $param_arr[1]!='')
		{
			//new image($file_src, $file_dst='', $action='', $tow=0, $toh=0, $fill='')			
			if(!(new image($_FILES[$this->fileElem]['tmp_name'], $this->uplPath.$this->uplFile, $param_arr[0], $param_arr[1], isset($param_arr[2])?$param_arr[2]:0, isset($param_arr[3])?$param_arr[3]:0)))
				$this->errCode=6;
		}
		else
		{
			$img_info=getimagesize($_FILES[$this->fileElem]['tmp_name']);
			$w=$img_info[0];
			$h=$img_info[1];
						
			if(($w<=$this->imgWLimit && $h<=$this->imgHLimit) || ($this->imgWLimit===0 && $this->imgHLimit===0))
				$this->moveUploadFile();
			else
	  			if(!(new image($_FILES[$this->fileElem]['tmp_name'], $this->uplPath.$this->uplFile, 'thumbnail', $this->imgWLimit, $this->imgHLimit)))
	  				$this->errCode=6;
		}
	}
	
	/**
	 * Error messages
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.12.2010 (dd.mm.YYYY)
	*/
	function errorMsg($code='')
	{
		if(''==$code)
			$code=$this->errCode;
		
		if($code==1)
			return 'Error! File not uploaded!';
		elseif($code==2) 
			return 'Size of file is zerro!';
		elseif($code==3) 
			return 'Size limit exced!';
		elseif($code==4) 
			return 'Invalid file type or file extension ('.$this->fileType[0].' | '.$this->fileExt.')';
		elseif($code==5) 
			return 'Move upload file error!';
		elseif($code==6)
			return 'Error processing image!';
		else 
			return false;
	}
	
}
/*
$obj = new upload('file1', 'upload', 'file1.jpg');
$obj->setSizeLimit(1000);
$obj->setFileTypeAccepted('image');
$obj->imgWHLimit(200, 300);

$obj->process('thumbnail', 300, 400);
$obj->process('scale', 400);
$obj->process('scalew', 400);
$obj->process('scaleh', 400);
$obj->process('crop', 300, 400);
*/
?>