<?php

//#########################################################################//
//# Useful
//# 
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 01.12.2010
//#########################################################################//

/**
 * Get IP
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function get_ip($cookie=0) 
{	
	$ip = "0.0.0.0";
	if (getenv("HTTP_CLIENT_IP")) $ip = getenv("HTTP_CLIENT_IP"); 
	elseif(getenv("HTTP_X_FORWARDED_FOR")) $ip = getenv("HTTP_X_FORWARDED_FOR"); 
	elseif(getenv("REMOTE_ADDR")) $ip = getenv("REMOTE_ADDR"); 
	else $ip = "0.0.0.0"; 
	
	$ip=trim($ip);
	
	if(1==$cookie)
	{
		if(isset($_COOKIE[VAR_COOKIE_IP]) && $_COOKIE[VAR_COOKIE_IP]!='')
			$ip=$_COOKIE[VAR_COOKIE_IP];
		else
			setcookie(VAR_COOKIE_IP, $ip, time()+3600*4*1);//s*h*d
	}
	
	return $ip;
}

/**
 * Redirect
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function redirect($url)
{	
	dao_error_tracker('REDIRECT');
	
	header('Request-URI: '.$url);
	header('Content-Location: '.$url); 
	header('Location: '.$url);		
	
	exit;
}

/**
 * Show Http error page
 * 
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function show_http_error_page($err_no=404, $err_name='Not Found', $err_message='')
{
	global $smarty;
	
	header("HTTP/1.0 {$err_no} {$err_name}");
	
	$smarty->assign('errNo', 404);
	$smarty->assign('errName', $err_name);
	$smarty->assign('errMessage', $err_message);
	
	$smarty->display('useful/httperror.tpl');
	
	exit;
}

/**
 * Check email address
 *
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function check_email_address($email) 
{
	// First, we check that there's one @ symbol, and that the lengths are right
	if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email))		
		return false; // Email invalid because wrong number of characters in one section, or wrong number of @ symbols.
	
	// Split it into sections to make life easier
	$email_array = explode('@', $email);
	$local_array = explode('.', $email_array[0]);
	for ($i = 0; $i < sizeof($local_array); $i++) 
	{
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) 
			return false;
	}
	  
	if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1]))// Check if domain is IP. If not, it should be valid domain name
	{
		$domain_array = explode(".", $email_array[1]);
		if (sizeof($domain_array) < 2) 
			return false; // Not enough parts to domain
		for ($i = 0; $i < sizeof($domain_array); $i++) 
		{
			if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) 
				return false;
		}
	}
	
	return true;
}

function json_output($arr)
{
	header('Cache-Control: no-cache, must-revalidate');
	header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header('Content-type: application/json');
	echo json_encode($arr);
}

function bot_detect()
{
	if(!isset($_SERVER['HTTP_USER_AGENT']))
		return true;
	
	$user_agent=strtolower($_SERVER['HTTP_USER_AGENT']);		
	
	//array of bot strings to check for
	$bot_list = array(
			'google',    	    'bot',				'teoma',				'webbug',		    'appie',
            'yahoo',	  	    'spider',			'alexa',				'infoseek',			'fast',
            'archiver',   	    'curl',				'froogle',				'webfindbot',		'webbug',
            'python',     	    'nambu',			'gigabot',				'girafabot',		'spade',
            'twitt',   		    'perl',				'inktomi',				'crawler',			'zyborg',
            'sphere',    	    'pear',				'looksmart',			'www.galaxy.com',	'rabaz',
            'java',    		    'wordpress',		'url_spider_sql',		'googlebot',		'baiduspider',
            'radian',     	    'crawl',			'firefly',				'scooter',			'crawler',
            'yandex',           'eventbox',			'nationaldirectory',	'slurp',			'technoratisnoop',
            'monitor',          'mechanize',		'technoseek',			'msnbot',
            'facebookexternal', 'spider',			'webbug',				'rankivabot'
	);
	
	foreach($bot_list as $bot)
		if(strpos($user_agent, $bot)!==false)
			return true;
	
	return false;		
}

function ip2country($ip=false)
{
	global $dbi;
	
	if(!$ip)
		$ip=get_ip();
	
	$ipnum = sprintf('%u', ip2long($ip));

	return $dbi->queryOne('SELECT country_iso FROM ip2country WHERE '.$ipnum.' BETWEEN ipnum_begin AND ipnum_end LIMIT 1');	
}

function dao_error_tracker($marker='')
{	
	$daoError = PEAR::getStaticProperty('DB_DataObject', 'lastError');
	if($daoError!=null)
	{
		$err_msg = "";
		if($marker)
			$err_msg .= ucwords($marker).":";
			
		$err_msg .= "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n";
		
				
		$err_msg .= "Uri: {$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}\n";
	    $err_msg .= "Message: ".$daoError->getMessage()."\n";
		$err_msg .= "UserInfo: \n\n".$daoError->getUserInfo()."\n";
		//$err_msg .= print_r($daoError, true)."\n\n";
		
		$err_msg .= "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n";
		
		$file_path = DB_LOG_DIR.date('ymd').'_dao_error.log';
								
		ff_write_log($file_path, $err_msg);
	}
}
?>