-- phpMyAdmin SQL Dump
-- version 3.3.5
-- http://www.phpmyadmin.net
--
-- Serveur: localhost
-- Généré le : Ven 14 Mars 2014 à 13:54
-- Version du serveur: 5.0.44
-- Version de PHP: 5.2.5-pl1-gentoo

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Base de données: `ran`
--

-- --------------------------------------------------------

--
-- Structure de la table `etp_correspondant`
--

DROP TABLE IF EXISTS `etp_correspondant`;
CREATE TABLE IF NOT EXISTS `etp_correspondant` (
  `per_code` int(11) NOT NULL,
  `spe_code` smallint(6) NOT NULL,
  PRIMARY KEY  (`per_code`),
  KEY `fk_etp_correspondant_specialite` (`spe_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_correspondant`
--

INSERT INTO `etp_correspondant` (`per_code`, `spe_code`) VALUES
(12123, 1),
(12146, 1),
(12165, 1),
(12093, 2),
(12107, 2),
(12142, 3),
(1, 4),
(12119, 4),
(12104, 7),
(12152, 7),
(12171, 7),
(12075, 8),
(12099, 8),
(12150, 8),
(12159, 8),
(12157, 9),
(12162, 9);

-- --------------------------------------------------------

--
-- Structure de la table `etp_courrier_correspondant`
--

DROP TABLE IF EXISTS `etp_courrier_correspondant`;
CREATE TABLE IF NOT EXISTS `etp_courrier_correspondant` (
  `per_code` int(11) NOT NULL,
  `coe_code` int(6) NOT NULL,
  `stc_code` int(2) NOT NULL,
  `coc_envoyer` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`per_code`,`coe_code`),
  KEY `fk_etp_courrier_correspondant_courrier` (`coe_code`),
  KEY `fk_etp_courrier_correspondant_signet` (`stc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_courrier_correspondant`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_courrier_edite`
--

DROP TABLE IF EXISTS `etp_courrier_edite`;
CREATE TABLE IF NOT EXISTS `etp_courrier_edite` (
  `coe_code` int(6) NOT NULL,
  `cse_code` bigint(20) NOT NULL,
  `coe_date` date NOT NULL,
  PRIMARY KEY  (`coe_code`),
  KEY `fk_etp_courrier_edite_etp_cs` (`cse_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_courrier_edite`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_courrier_edite_seq`
--

DROP TABLE IF EXISTS `etp_courrier_edite_seq`;
CREATE TABLE IF NOT EXISTS `etp_courrier_edite_seq` (
  `id` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `etp_courrier_edite_seq`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_cs`
--

DROP TABLE IF EXISTS `etp_cs`;
CREATE TABLE IF NOT EXISTS `etp_cs` (
  `cse_code` bigint(20) NOT NULL,
  `pce_code` smallint(6) NOT NULL,
  `int_per_code` int(11) NOT NULL,
  `pat_per_code` int(11) NOT NULL,
  `cse_date` date NOT NULL,
  `cse_text` text,
  PRIMARY KEY  (`cse_code`),
  KEY `fk_consultation_patient` (`pat_per_code`),
  KEY `fk_consult_intervenant` (`int_per_code`),
  KEY `fk_cs_profil_cs` (`pce_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_cs`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_cs_evaluation`
--

DROP TABLE IF EXISTS `etp_cs_evaluation`;
CREATE TABLE IF NOT EXISTS `etp_cs_evaluation` (
  `cse_code` bigint(20) NOT NULL,
  `trt_code` smallint(6) NOT NULL,
  `cse_comment_reprise` text,
  `cse_eval_trait` smallint(6) default NULL,
  `cse_comment_eval_trait` text,
  PRIMARY KEY  (`cse_code`),
  KEY `fk_cs_etp_reprise_travail` (`trt_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_cs_evaluation`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_cs_prog_interv`
--

DROP TABLE IF EXISTS `etp_cs_prog_interv`;
CREATE TABLE IF NOT EXISTS `etp_cs_prog_interv` (
  `cse_code` bigint(20) NOT NULL,
  `itv_code` int(6) NOT NULL,
  PRIMARY KEY  (`cse_code`,`itv_code`),
  KEY `fk_programme_intervention` (`itv_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_cs_prog_interv`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_cs_recueil_donnees`
--

DROP TABLE IF EXISTS `etp_cs_recueil_donnees`;
CREATE TABLE IF NOT EXISTS `etp_cs_recueil_donnees` (
  `cse_code` bigint(20) NOT NULL,
  `csr_connaissances_init` text,
  `trt_code` smallint(6) default NULL,
  `csr_comment_reprise` text,
  `csr_eval_trait` smallint(6) default NULL,
  `csr_comment_eval_trait` text,
  PRIMARY KEY  (`cse_code`),
  KEY `trt_code` (`trt_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_cs_recueil_donnees`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_cs_recueil_item`
--

DROP TABLE IF EXISTS `etp_cs_recueil_item`;
CREATE TABLE IF NOT EXISTS `etp_cs_recueil_item` (
  `ite_code` int(4) NOT NULL,
  `cse_code` bigint(20) NOT NULL,
  `commentaire_item` text,
  PRIMARY KEY  (`ite_code`,`cse_code`),
  KEY `fk_etp_cs_recueil_item_cs_recueil` (`cse_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_cs_recueil_item`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_cs_seq`
--

DROP TABLE IF EXISTS `etp_cs_seq`;
CREATE TABLE IF NOT EXISTS `etp_cs_seq` (
  `id` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `etp_cs_seq`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_cs_suivi`
--

DROP TABLE IF EXISTS `etp_cs_suivi`;
CREATE TABLE IF NOT EXISTS `etp_cs_suivi` (
  `cse_code` bigint(20) NOT NULL,
  `ecs_comment_suivi` text,
  `ecs_comment_suivre` text,
  PRIMARY KEY  (`cse_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_cs_suivi`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_cs_synthese`
--

DROP TABLE IF EXISTS `etp_cs_synthese`;
CREATE TABLE IF NOT EXISTS `etp_cs_synthese` (
  `cse_code` bigint(20) NOT NULL,
  `ite_code` int(4) NOT NULL,
  `css_objectif_negocie` tinyint(1) default NULL,
  `css_commentaire` text,
  PRIMARY KEY  (`cse_code`,`ite_code`),
  KEY `fk_objectif_negocie_item` (`ite_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_cs_synthese`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_etat_intervention`
--

DROP TABLE IF EXISTS `etp_etat_intervention`;
CREATE TABLE IF NOT EXISTS `etp_etat_intervention` (
  `eti_code` int(1) NOT NULL,
  `eti_libelle` varchar(50) NOT NULL,
  PRIMARY KEY  (`eti_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_etat_intervention`
--

INSERT INTO `etp_etat_intervention` (`eti_code`, `eti_libelle`) VALUES
(1, 'A faire'),
(2, 'Faite'),
(3, 'Non faite');

-- --------------------------------------------------------

--
-- Structure de la table `etp_eval_competence`
--

DROP TABLE IF EXISTS `etp_eval_competence`;
CREATE TABLE IF NOT EXISTS `etp_eval_competence` (
  `ite_code` int(4) NOT NULL,
  `cse_code` bigint(20) NOT NULL,
  `eco_eval_objectif` smallint(6) default NULL,
  PRIMARY KEY  (`ite_code`,`cse_code`),
  KEY `fk_objectif_cs_etp` (`cse_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_eval_competence`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_eval_init_competence`
--

DROP TABLE IF EXISTS `etp_eval_init_competence`;
CREATE TABLE IF NOT EXISTS `etp_eval_init_competence` (
  `ite_code` int(4) NOT NULL,
  `cse_code` bigint(20) NOT NULL,
  `eic_eval_init_objectif` smallint(6) default NULL,
  PRIMARY KEY  (`ite_code`,`cse_code`),
  KEY `fk_etp_eval_init_competence_recueil_donnees` (`cse_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_eval_init_competence`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_intervenant`
--

DROP TABLE IF EXISTS `etp_intervenant`;
CREATE TABLE IF NOT EXISTS `etp_intervenant` (
  `per_code` int(11) NOT NULL,
  `spe_code` smallint(6) NOT NULL,
  PRIMARY KEY  (`per_code`),
  KEY `fk_intervenant_specialite` (`spe_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_intervenant`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_intervention`
--

DROP TABLE IF EXISTS `etp_intervention`;
CREATE TABLE IF NOT EXISTS `etp_intervention` (
  `itv_code` int(6) NOT NULL,
  `lit_code` int(3) NOT NULL,
  `per_code` int(11) NOT NULL,
  `itv_libelle` text NOT NULL,
  `itv_date` datetime NOT NULL,
  `itv_nb_places` smallint(6) NOT NULL,
  PRIMARY KEY  (`itv_code`),
  KEY `fk_intervention_intervenant` (`per_code`),
  KEY `fk_intervention_lieu` (`lit_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_intervention`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_intervention_seq`
--

DROP TABLE IF EXISTS `etp_intervention_seq`;
CREATE TABLE IF NOT EXISTS `etp_intervention_seq` (
  `id` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `etp_intervention_seq`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_item_etp`
--

DROP TABLE IF EXISTS `etp_item_etp`;
CREATE TABLE IF NOT EXISTS `etp_item_etp` (
  `ite_code` int(4) NOT NULL,
  `tit_code` int(1) default NULL,
  `ite_libelle` text NOT NULL,
  `ite_secur` tinyint(1) default NULL,
  PRIMARY KEY  (`ite_code`),
  KEY `fk_item_type_item` (`tit_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_item_etp`
--

INSERT INTO `etp_item_etp` (`ite_code`, `tit_code`, `ite_libelle`, `ite_secur`) VALUES
(1, 1, 'Que sait le patient ?', 0),
(2, 1, 'Comment vit-il sa maladie ?', 0),
(3, 1, 'Quels sont ses projets ?', 0),
(4, 1, 'Comment vit-il au quotidien ?', 0),
(5, 2, 'De sa maladie', 0),
(6, 2, 'De son traitement', 0),
(7, 2, 'De la diététique', 0),
(8, 2, 'Du suivi, de la surveillance', 0),
(9, 2, 'Que ne sait-il pas ?', 0),
(10, 2, 'Représentation de la maladie / dialyse / transplantation', 0),
(11, 2, 'Ressenti psychologique', 0),
(12, 2, 'Comportement de santé', 0),
(13, 2, 'Court terme', 0),
(14, 2, 'Moyen terme', 0),
(15, 2, 'Long terme', 0),
(16, 2, 'Vie sociale et professionnelle', 0),
(17, 2, 'Ressources financières', 0),
(18, 2, 'Vie affective et sexuelle', 0),
(19, 2, 'Attitude de l''entourage', 0),
(20, 3, 'Compétences d''adaptation psycho-sociale', 0),
(21, 3, 'Compétences d''auto-soins en centres de néphrologie dialyse d''Aquitaine pré transplantation', 0),
(22, 3, 'Compétences d''auto-soins au CHU de Bordeaux, pré transplantation', 0),
(23, 3, 'Compétences d''auto-soins au CHU de Bordeaux : post transplantation', 0),
(24, 4, 'Exprimer son vécu, ses préoccupations sur sa maladie et la transplantation', 0),
(25, 4, 'Solliciter de l''aide auprès de son entourage, des soignants', 0),
(26, 4, 'Informer, éduquer son entourage', 0),
(27, 4, 'Identifier et utiliser les circuits d''aide sociaux, administratifs', 0),
(28, 4, 'Rechercher et analyser des informations utiles', 0),
(29, 4, 'Mettre en oeuvre des conduites d''ajustement pour gérer son stress, son anxiété', 0),
(30, 4, 'Formuler des projets', 0),
(31, 4, 'Identifier les possibilités de revenus après greffe (travail, aides sociales)', 0),
(32, 4, 'Expliquer ce qu''est l''IRC et l''IRC terminale', 0),
(33, 4, 'Expliquer les conséquences de l''IRC sur la santé et la vie quotidienne', 0),
(34, 4, 'Expliquer la nécessité d''un traitement de suppléance', 0),
(35, 4, 'Expliquer les principes de base de la transplantation', 0),
(36, 4, 'Expliquer les répercussions de la transplantation sur sa vie quotidienne', 0),
(37, 4, 'Identifier des stratégies d''adaptation de sa vie quotidienne après la transplantation', 0),
(38, 4, 'Identifier les personnes ressources', 0),
(39, 4, 'Expliquer l''appel greffe, la technique chirurgicale,  le devenir de l''abord veineux', 0),
(40, 4, 'Expliquer le phénomène de compatibilité et faire le lien avec la durée d''attente', 0),
(41, 4, 'Expliquer les effets des traitements post-transplantation', 0),
(42, 4, 'Expliquer les principales complications possibles de la transplantation et les mesures préventives', 0),
(43, 4, 'Définir les avantages et inconvénients de la greffe avec donneur vivant et donneur décédé', 0),
(44, 4, 'Aborder le don de donneur vivant en famille', 0),
(45, 4, 'Repérer les changements possibles dans son corps (manifestations cliniques)', 0),
(46, 4, 'Identifier les signes d''alerte des complications', 1),
(47, 4, 'Expliquer les moyens d''auto-surveillance et de prévention', 1),
(48, 4, 'Expliquer les conduites à tenir face à différents signes d''alerte', 1),
(49, 4, 'Lire son ordonnance', 0),
(50, 4, 'Identifier les doses et horaires de prise de traitement', 1),
(51, 4, 'Expliquer les indications, interactions et précautions d''emploi des immunosuppresseurs', 1),
(52, 4, 'Gérer son stock de médicaments', 0),
(53, 4, 'Adapter son activité physique en post-transplantation', 0),
(54, 4, 'Adapter son alimentation et hydratation après la transplantation', 0),
(55, 4, 'Identifier les procédures et précautions à prendre pour préparer, organiser un voyage', 0),
(56, 4, 'Expliquer les procédures et précautions à prendre pour mener un projet de grossesse', 0),
(57, 5, 'Amis', 0),
(58, 5, 'Compréhension', 0),
(59, 5, 'Famille', 0),
(60, 5, 'Handicaps', 0),
(61, 5, 'Loisirs', 0),
(62, 5, 'Projets', 0),
(63, 5, 'Ressources psychologiques', 0),
(64, 5, 'Ressources financières', 0),
(65, 5, 'Travail', 0),
(66, 5, 'Représentations', 0),
(67, 5, 'Autre', 0),
(68, 6, 'Amis', 0),
(69, 6, 'Compréhension', 0),
(70, 6, 'Famille', 0),
(71, 6, 'Handicaps', 0),
(72, 6, 'Loisirs', 0),
(73, 6, 'Projets', 0),
(74, 6, 'Ressources psychologiques', 0),
(75, 6, 'Ressources financières', 0),
(76, 6, 'Travail', 0),
(77, 6, 'Représentations', 0),
(78, 6, 'Autre', 0);

-- --------------------------------------------------------

--
-- Structure de la table `etp_item_ss_item`
--

DROP TABLE IF EXISTS `etp_item_ss_item`;
CREATE TABLE IF NOT EXISTS `etp_item_ss_item` (
  `etp_ite_code_pere` int(4) NOT NULL,
  `etp_ite_code_fils` int(4) NOT NULL,
  PRIMARY KEY  (`etp_ite_code_pere`,`etp_ite_code_fils`),
  KEY `fk_item_item_fils` (`etp_ite_code_fils`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_item_ss_item`
--

INSERT INTO `etp_item_ss_item` (`etp_ite_code_pere`, `etp_ite_code_fils`) VALUES
(1, 5),
(1, 6),
(1, 7),
(1, 8),
(1, 9),
(2, 10),
(2, 11),
(2, 12),
(3, 13),
(3, 14),
(3, 15),
(4, 16),
(4, 17),
(4, 18),
(4, 19),
(20, 24),
(20, 25),
(20, 26),
(20, 27),
(20, 28),
(20, 29),
(20, 30),
(20, 31),
(21, 32),
(21, 33),
(21, 34),
(21, 35),
(21, 36),
(21, 37),
(21, 38),
(22, 39),
(22, 40),
(22, 41),
(22, 42),
(22, 43),
(22, 44),
(23, 45),
(23, 46),
(23, 47),
(23, 48),
(23, 49),
(23, 50),
(23, 51),
(23, 52),
(23, 53),
(23, 54),
(23, 55),
(23, 56),
(23, 57);

-- --------------------------------------------------------

--
-- Structure de la table `etp_lieu_intervention`
--

DROP TABLE IF EXISTS `etp_lieu_intervention`;
CREATE TABLE IF NOT EXISTS `etp_lieu_intervention` (
  `lit_code` int(3) NOT NULL,
  `lit_libelle` varchar(256) NOT NULL,
  PRIMARY KEY  (`lit_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_lieu_intervention`
--

INSERT INTO `etp_lieu_intervention` (`lit_code`, `lit_libelle`) VALUES
(1, 'CHU'),
(2, 'Clinique Delay'),
(3, 'AURAD'),
(5, 'autre'),
(6, 'POLYCLINIQUE BORDEAUX RIVE DROITE'),
(7, 'CTMR'),
(8, 'CH COTE BASQUE');

-- --------------------------------------------------------

--
-- Structure de la table `etp_lieu_intervention_seq`
--

DROP TABLE IF EXISTS `etp_lieu_intervention_seq`;
CREATE TABLE IF NOT EXISTS `etp_lieu_intervention_seq` (
  `id` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;

--
-- Contenu de la table `etp_lieu_intervention_seq`
--

INSERT INTO `etp_lieu_intervention_seq` (`id`) VALUES
(9);

-- --------------------------------------------------------

--
-- Structure de la table `etp_motif_etat`
--

DROP TABLE IF EXISTS `etp_motif_etat`;
CREATE TABLE IF NOT EXISTS `etp_motif_etat` (
  `met_code` int(1) NOT NULL,
  `met_libelle` varchar(50) NOT NULL,
  PRIMARY KEY  (`met_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_motif_etat`
--

INSERT INTO `etp_motif_etat` (`met_code`, `met_libelle`) VALUES
(1, 'annulation intervention'),
(2, 'refus patient'),
(3, 'autre');

-- --------------------------------------------------------

--
-- Structure de la table `etp_motif_refus`
--

DROP TABLE IF EXISTS `etp_motif_refus`;
CREATE TABLE IF NOT EXISTS `etp_motif_refus` (
  `mre_code` int(2) NOT NULL,
  `mre_libelle` varchar(50) NOT NULL,
  PRIMARY KEY  (`mre_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_motif_refus`
--

INSERT INTO `etp_motif_refus` (`mre_code`, `mre_libelle`) VALUES
(1, 'Pas d''intérêt'),
(2, 'Pas disponible'),
(3, 'Problèmes financiers'),
(4, 'Incapacité physique'),
(5, 'Langue'),
(6, 'Autre');

-- --------------------------------------------------------

--
-- Structure de la table `etp_patient_refus_etp`
--

DROP TABLE IF EXISTS `etp_patient_refus_etp`;
CREATE TABLE IF NOT EXISTS `etp_patient_refus_etp` (
  `per_code` int(11) NOT NULL,
  `mre_code` int(2) NOT NULL,
  `pre_date` date NOT NULL,
  PRIMARY KEY  (`per_code`,`mre_code`),
  KEY `fk_etp_patient_refus_refus` (`mre_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_patient_refus_etp`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_profil_consultation`
--

DROP TABLE IF EXISTS `etp_profil_consultation`;
CREATE TABLE IF NOT EXISTS `etp_profil_consultation` (
  `pce_code` smallint(6) NOT NULL,
  `pce_desc` varchar(50) NOT NULL,
  PRIMARY KEY  (`pce_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_profil_consultation`
--

INSERT INTO `etp_profil_consultation` (`pce_code`, `pce_desc`) VALUES
(1, 'Recueil de données'),
(2, 'Synthèse du diagnostic éducatif'),
(3, 'Programmation des interventions'),
(4, 'Suivi des interventions'),
(5, 'Evaluation du patient');

-- --------------------------------------------------------

--
-- Structure de la table `etp_prof_cs_item_etp`
--

DROP TABLE IF EXISTS `etp_prof_cs_item_etp`;
CREATE TABLE IF NOT EXISTS `etp_prof_cs_item_etp` (
  `ite_code` int(4) NOT NULL,
  `pce_code` smallint(6) NOT NULL,
  `pci_ordre` int(2) default NULL,
  PRIMARY KEY  (`ite_code`,`pce_code`),
  KEY `fk_etp_prof_cs_prof_cs` (`pce_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_prof_cs_item_etp`
--

INSERT INTO `etp_prof_cs_item_etp` (`ite_code`, `pce_code`, `pci_ordre`) VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 1),
(6, 1, 2),
(7, 1, 3),
(8, 1, 4),
(9, 1, 5),
(10, 1, 1),
(11, 1, 2),
(12, 1, 3),
(13, 1, 1),
(14, 1, 2),
(15, 1, 3),
(16, 1, 1),
(17, 1, 2),
(18, 1, 3),
(19, 1, 4),
(20, 2, 1),
(21, 2, 2),
(22, 2, 3),
(23, 2, 4),
(24, 2, 1),
(25, 2, 2),
(26, 2, 3),
(27, 2, 4),
(28, 2, 5),
(29, 2, 6),
(30, 2, 7),
(31, 2, 8),
(32, 2, 1),
(33, 2, 2),
(34, 2, 3),
(35, 2, 4),
(36, 2, 5),
(37, 2, 6),
(38, 2, 7),
(39, 2, 1),
(40, 2, 2),
(41, 2, 3),
(42, 2, 4),
(43, 2, 5),
(44, 2, 6),
(45, 2, 1),
(46, 2, 2),
(47, 2, 3),
(48, 2, 4),
(49, 2, 5),
(50, 2, 6),
(51, 2, 7),
(52, 2, 8),
(53, 2, 9),
(54, 2, 10),
(55, 2, 11),
(56, 2, 12),
(57, 2, 1),
(58, 2, 2),
(59, 2, 3),
(60, 2, 4),
(61, 2, 5),
(62, 2, 6),
(63, 2, 7),
(64, 2, 8),
(65, 2, 9),
(66, 2, 10),
(67, 2, 11),
(68, 2, 1),
(69, 2, 2),
(70, 2, 3),
(71, 2, 4),
(72, 2, 5),
(73, 2, 6),
(74, 2, 7),
(75, 2, 8),
(76, 2, 9),
(77, 2, 10),
(78, 2, 11),
(79, 2, 2),
(80, 2, 3),
(81, 2, 4),
(82, 2, 5),
(83, 2, 6);

-- --------------------------------------------------------

--
-- Structure de la table `etp_signet_courrier`
--

DROP TABLE IF EXISTS `etp_signet_courrier`;
CREATE TABLE IF NOT EXISTS `etp_signet_courrier` (
  `stc_code` int(2) NOT NULL,
  `stc_libelle_haut` varchar(50) NOT NULL,
  `stc_libelle_bas` varchar(200) NOT NULL,
  PRIMARY KEY  (`stc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_signet_courrier`
--

INSERT INTO `etp_signet_courrier` (`stc_code`, `stc_libelle_haut`, `stc_libelle_bas`) VALUES
(1, 'Cher ami', 'N''hésitez pas à nous joindre si besoin\n\n\nAmicalement'),
(2, 'Cher confrère', 'Bien confraternellement'),
(4, 'Chere amie', 'Amitiés'),
(5, 'madame', 'bien à vous'),
(7, 'chere confrere', 'cordialement'),
(9, 'Monsieur', 'Bien à vous'),
(10, 'Imbécile', 'Tu comprends rien à rien!'),
(11, 'Mademoiselle', 'bien cordialement');

-- --------------------------------------------------------

--
-- Structure de la table `etp_signet_courrier_seq`
--

DROP TABLE IF EXISTS `etp_signet_courrier_seq`;
CREATE TABLE IF NOT EXISTS `etp_signet_courrier_seq` (
  `id` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;

--
-- Contenu de la table `etp_signet_courrier_seq`
--

INSERT INTO `etp_signet_courrier_seq` (`id`) VALUES
(11);

-- --------------------------------------------------------

--
-- Structure de la table `etp_specialite`
--

DROP TABLE IF EXISTS `etp_specialite`;
CREATE TABLE IF NOT EXISTS `etp_specialite` (
  `spe_code` smallint(6) NOT NULL,
  `tsp_code` int(2) NOT NULL,
  `spe_libelle` varchar(50) character set latin1 collate latin1_general_cs NOT NULL,
  PRIMARY KEY  (`spe_code`),
  KEY `fk_spe_type_spe` (`tsp_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_specialite`
--

INSERT INTO `etp_specialite` (`spe_code`, `tsp_code`, `spe_libelle`) VALUES
(1, 1, 'Diététicien'),
(2, 1, 'Kinésithérapeute'),
(3, 1, 'Psychologue'),
(4, 2, 'Assistante sociale'),
(5, 1, 'Ergothérapeute'),
(6, 1, 'Psychomotricien'),
(7, 1, 'Orthophoniste'),
(8, 2, 'Educateur spécialisé'),
(9, 1, 'IDE'),
(10, 2, 'Sophrologue');

-- --------------------------------------------------------

--
-- Structure de la table `etp_specialite_seq`
--

DROP TABLE IF EXISTS `etp_specialite_seq`;
CREATE TABLE IF NOT EXISTS `etp_specialite_seq` (
  `id` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Contenu de la table `etp_specialite_seq`
--

INSERT INTO `etp_specialite_seq` (`id`) VALUES
(10);

-- --------------------------------------------------------

--
-- Structure de la table `etp_suivi_interv`
--

DROP TABLE IF EXISTS `etp_suivi_interv`;
CREATE TABLE IF NOT EXISTS `etp_suivi_interv` (
  `cse_code` bigint(20) NOT NULL,
  `itv_code` int(6) NOT NULL,
  `eti_code` int(1) NOT NULL,
  `met_code` int(1) NOT NULL default '0',
  `csi_comment_interv` text,
  PRIMARY KEY  (`cse_code`,`itv_code`,`eti_code`,`met_code`),
  KEY `fk_suivi_interv_etat_interv` (`eti_code`),
  KEY `fk_suivi_interv_interv` (`itv_code`),
  KEY `fk_suivi_interv_motif_etat` (`met_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_suivi_interv`
--


-- --------------------------------------------------------

--
-- Structure de la table `etp_type_item`
--

DROP TABLE IF EXISTS `etp_type_item`;
CREATE TABLE IF NOT EXISTS `etp_type_item` (
  `tit_code` int(1) NOT NULL,
  `tit_libelle` varchar(50) NOT NULL,
  PRIMARY KEY  (`tit_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_type_item`
--

INSERT INTO `etp_type_item` (`tit_code`, `tit_libelle`) VALUES
(1, 'Recueil de données regroupées'),
(2, 'Recueil de données détaillées'),
(3, 'Compétence'),
(4, 'Objectif éducatif'),
(5, 'Facteur facilitant'),
(6, 'Facteur limitant');

-- --------------------------------------------------------

--
-- Structure de la table `etp_type_reprise_travail`
--

DROP TABLE IF EXISTS `etp_type_reprise_travail`;
CREATE TABLE IF NOT EXISTS `etp_type_reprise_travail` (
  `trt_code` smallint(6) NOT NULL,
  `trt_libelle` char(50) NOT NULL,
  PRIMARY KEY  (`trt_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_type_reprise_travail`
--

INSERT INTO `etp_type_reprise_travail` (`trt_code`, `trt_libelle`) VALUES
(1, 'Mi-temps'),
(2, 'Temps plein'),
(3, 'Sans activité');

-- --------------------------------------------------------

--
-- Structure de la table `etp_type_specialite`
--

DROP TABLE IF EXISTS `etp_type_specialite`;
CREATE TABLE IF NOT EXISTS `etp_type_specialite` (
  `tsp_code` int(2) NOT NULL,
  `tsp_libelle` varchar(50) NOT NULL,
  PRIMARY KEY  (`tsp_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Contenu de la table `etp_type_specialite`
--

INSERT INTO `etp_type_specialite` (`tsp_code`, `tsp_libelle`) VALUES
(1, 'Paramédicale'),
(2, 'Autre');

--
-- Contraintes pour les tables exportées
--

--
-- Contraintes pour la table `etp_correspondant`
--
ALTER TABLE `etp_correspondant`
  ADD CONSTRAINT `fk_etp_correspondant_personne` FOREIGN KEY (`per_code`) REFERENCES `personne` (`per_code`),
  ADD CONSTRAINT `fk_etp_correspondant_specialite` FOREIGN KEY (`spe_code`) REFERENCES `etp_specialite` (`spe_code`);

--
-- Contraintes pour la table `etp_courrier_correspondant`
--
ALTER TABLE `etp_courrier_correspondant`
  ADD CONSTRAINT `fk_etp_courrier_correspondant_correspondant` FOREIGN KEY (`per_code`) REFERENCES `personne` (`per_code`),
  ADD CONSTRAINT `fk_etp_courrier_correspondant_courrier` FOREIGN KEY (`coe_code`) REFERENCES `etp_courrier_edite` (`coe_code`),
  ADD CONSTRAINT `fk_etp_courrier_correspondant_signet` FOREIGN KEY (`stc_code`) REFERENCES `etp_signet_courrier` (`stc_code`);

--
-- Contraintes pour la table `etp_courrier_edite`
--
ALTER TABLE `etp_courrier_edite`
  ADD CONSTRAINT `fk_etp_courrier_edite_etp_cs` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs` (`cse_code`);

--
-- Contraintes pour la table `etp_cs`
--
ALTER TABLE `etp_cs`
  ADD CONSTRAINT `fk_consultation_patient` FOREIGN KEY (`pat_per_code`) REFERENCES `patient` (`per_code`),
  ADD CONSTRAINT `fk_consult_intervenant` FOREIGN KEY (`int_per_code`) REFERENCES `etp_intervenant` (`per_code`),
  ADD CONSTRAINT `fk_cs_profil_cs` FOREIGN KEY (`pce_code`) REFERENCES `etp_profil_consultation` (`pce_code`);

--
-- Contraintes pour la table `etp_cs_evaluation`
--
ALTER TABLE `etp_cs_evaluation`
  ADD CONSTRAINT `fk_cs_etp_reprise_travail` FOREIGN KEY (`trt_code`) REFERENCES `etp_type_reprise_travail` (`trt_code`),
  ADD CONSTRAINT `fk_cs_evaluation_cs_suivi` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs` (`cse_code`);

--
-- Contraintes pour la table `etp_cs_prog_interv`
--
ALTER TABLE `etp_cs_prog_interv`
  ADD CONSTRAINT `fk_programme_cs` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs` (`cse_code`),
  ADD CONSTRAINT `fk_programme_intervention` FOREIGN KEY (`itv_code`) REFERENCES `etp_intervention` (`itv_code`);

--
-- Contraintes pour la table `etp_cs_recueil_donnees`
--
ALTER TABLE `etp_cs_recueil_donnees`
  ADD CONSTRAINT `etp_cs_recueil_donnees_fk` FOREIGN KEY (`trt_code`) REFERENCES `etp_type_reprise_travail` (`trt_code`),
  ADD CONSTRAINT `fk_cs_etp_cs_recueil` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs` (`cse_code`);

--
-- Contraintes pour la table `etp_cs_recueil_item`
--
ALTER TABLE `etp_cs_recueil_item`
  ADD CONSTRAINT `fk_etp_cs_recueil_item_cs_recueil` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs_recueil_donnees` (`cse_code`),
  ADD CONSTRAINT `fk_etp_cs_recueil_item_item` FOREIGN KEY (`ite_code`) REFERENCES `etp_item_etp` (`ite_code`);

--
-- Contraintes pour la table `etp_cs_suivi`
--
ALTER TABLE `etp_cs_suivi`
  ADD CONSTRAINT `fk_cs_etp_cs_suivi` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs` (`cse_code`);

--
-- Contraintes pour la table `etp_cs_synthese`
--
ALTER TABLE `etp_cs_synthese`
  ADD CONSTRAINT `fk_objectif_negocie_item` FOREIGN KEY (`ite_code`) REFERENCES `etp_item_etp` (`ite_code`),
  ADD CONSTRAINT `fk_ojectif_negocie_cs` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs` (`cse_code`);

--
-- Contraintes pour la table `etp_eval_competence`
--
ALTER TABLE `etp_eval_competence`
  ADD CONSTRAINT `fk_objectif_cs_etp` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs_evaluation` (`cse_code`),
  ADD CONSTRAINT `fk_objectif_item_etp` FOREIGN KEY (`ite_code`) REFERENCES `etp_item_etp` (`ite_code`);

--
-- Contraintes pour la table `etp_eval_init_competence`
--
ALTER TABLE `etp_eval_init_competence`
  ADD CONSTRAINT `fk_etp_eval_init_competence_item_etp` FOREIGN KEY (`ite_code`) REFERENCES `etp_item_etp` (`ite_code`),
  ADD CONSTRAINT `fk_etp_eval_init_competence_recueil_donnees` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs_recueil_donnees` (`cse_code`);

--
-- Contraintes pour la table `etp_intervenant`
--
ALTER TABLE `etp_intervenant`
  ADD CONSTRAINT `fk_intervenant_personne` FOREIGN KEY (`per_code`) REFERENCES `personne` (`per_code`),
  ADD CONSTRAINT `fk_intervenant_specialite` FOREIGN KEY (`spe_code`) REFERENCES `etp_specialite` (`spe_code`);

--
-- Contraintes pour la table `etp_intervention`
--
ALTER TABLE `etp_intervention`
  ADD CONSTRAINT `fk_intervention_intervenant` FOREIGN KEY (`per_code`) REFERENCES `etp_intervenant` (`per_code`),
  ADD CONSTRAINT `fk_intervention_lieu` FOREIGN KEY (`lit_code`) REFERENCES `etp_lieu_intervention` (`lit_code`);

--
-- Contraintes pour la table `etp_item_etp`
--
ALTER TABLE `etp_item_etp`
  ADD CONSTRAINT `fk_item_type_item` FOREIGN KEY (`tit_code`) REFERENCES `etp_type_item` (`tit_code`);

--
-- Contraintes pour la table `etp_item_ss_item`
--
ALTER TABLE `etp_item_ss_item`
  ADD CONSTRAINT `fk_item_item_fils` FOREIGN KEY (`etp_ite_code_fils`) REFERENCES `etp_item_etp` (`ite_code`),
  ADD CONSTRAINT `fk_item_item_pere` FOREIGN KEY (`etp_ite_code_pere`) REFERENCES `etp_item_etp` (`ite_code`);

--
-- Contraintes pour la table `etp_patient_refus_etp`
--
ALTER TABLE `etp_patient_refus_etp`
  ADD CONSTRAINT `fk_etp_patient_refus_patient` FOREIGN KEY (`per_code`) REFERENCES `patient` (`per_code`),
  ADD CONSTRAINT `fk_etp_patient_refus_refus` FOREIGN KEY (`mre_code`) REFERENCES `etp_motif_refus` (`mre_code`);

--
-- Contraintes pour la table `etp_prof_cs_item_etp`
--
ALTER TABLE `etp_prof_cs_item_etp`
  ADD CONSTRAINT `fk_etp_prof_cs_item_etp` FOREIGN KEY (`ite_code`) REFERENCES `etp_item_etp` (`ite_code`),
  ADD CONSTRAINT `fk_etp_prof_cs_prof_cs` FOREIGN KEY (`pce_code`) REFERENCES `etp_profil_consultation` (`pce_code`);

--
-- Contraintes pour la table `etp_specialite`
--
ALTER TABLE `etp_specialite`
  ADD CONSTRAINT `fk_spe_type_spe` FOREIGN KEY (`tsp_code`) REFERENCES `etp_type_specialite` (`tsp_code`);

--
-- Contraintes pour la table `etp_suivi_interv`
--
ALTER TABLE `etp_suivi_interv`
  ADD CONSTRAINT `fk_suivi_interv_cs_suivi` FOREIGN KEY (`cse_code`) REFERENCES `etp_cs_suivi` (`cse_code`),
  ADD CONSTRAINT `fk_suivi_interv_etat_interv` FOREIGN KEY (`eti_code`) REFERENCES `etp_etat_intervention` (`eti_code`),
  ADD CONSTRAINT `fk_suivi_interv_interv` FOREIGN KEY (`itv_code`) REFERENCES `etp_intervention` (`itv_code`),
  ADD CONSTRAINT `fk_suivi_interv_motif_etat` FOREIGN KEY (`met_code`) REFERENCES `etp_motif_etat` (`met_code`);
