{strip}
	{*http://www.modemhelp.net/errNos/errNos.shtml*}

	{assign var=errNo value=$errNo|default:'xxx'}
	{assign var=errName value='HTTP Error'}
	{assign var=errDescr value='HTTP Error - Unknow Error!'}
	
	{if $errNo=='400'}		
		{assign var=errName value='Bad Request'}
		{assign var=errDescr value='Sorry your request could not be processed! The request was denied due to a syntax error in the request!'}
	{elseif $errNo=='401'}		
		{assign var=errName value='Unauthorized'}
		{assign var=errDescr value='The request requires user authentication! Your IP address or the username/password you entered were not correct. Your request was denied as you have no permission to access the data!'}
	{elseif $errNo=='403'}
		{assign var=errName value='Forbidden'}
		{assign var=errDescr value='The server understood the request, but is refusing to fulfill it! or Your IP address or the username/password you entered were not correct. Your request was denied as you have no permission to access the data!'}
	{elseif $errNo=='404'}
		{assign var=errName value='Not Found'}
		{assign var=errDescr value='The document that has been requested either no longer exists, or has never existed on the server!'}
	{elseif $errNo=='500'}
		{assign var=errName value='Internal Server Error'}
		{assign var=errDescr value='The server encountered an unexpected condition which prevented it from fulfilling the request. This is most often caused by a scripting problem, a failed database access attempt, or other similar reasons!'}
	{/if}
	
	{assign var=titleTag value=$errNo|cat:' '|cat:$errName}
	{assign var=descriptionMTag value='HTTP Error - '|cat:$errNo|cat:' '|cat:$errName|cat:'. '|cat:$errDescr}
	{assign var=keywordsMTag value=$errNo|cat:' error,http errors'}
	
{/strip}{include file='inc/top.tpl' robots='noindex,follow' revisitafter=365}	
	<div class="box-content">
		<h1>{$errMessage}</h1>
		<br />
		<h2>HTTP Error {$errNo} {$errName}</h2>
		<p class="fsize14">{$errDescr}</p>
	</div>
{include file='inc/bottom.tpl'}