<?php // content="text/plain; charset=utf-8"
include '../../init/config.php';

require_once (LIB_DIR.'jpgraph/jpgraph.php');
require_once (LIB_DIR.'jpgraph/jpgraph_radar.php');

// Create the basic radar graph
$graph = new RadarGraph(750,400);
$graph->img->SetAntiAliasing();

// Set background color and shadow
$graph->SetColor("#74F100");
$graph->SetShadow();

// Position the graph
$graph->SetCenter(0.4,0.55);

// Setup the axis formatting 	
$graph->axis->SetFont(FF_FONT1,FS_BOLD);

// Setup the grid lines
$graph->grid->SetLineStyle("solid");
$graph->grid->SetColor("#999");
$graph->grid->Show();
$graph->HideTickMarks();
		
// Setup graph titles
$graph->title->Set("Evaluation des items psycho-sociaux du 26/05/2011");
$graph->title->SetFont(FF_FONT1,FS_BOLD);

//$graph->SetTitles($gDateLocale->GetShortMonth());
$graph->SetTitles(array('Communication','Vie Sexuelle','Vie affective','Vie professionnele', 'Vie sociale', 'Image de soi', 'Gestion des emotions', 'Projets', 'Comportements de sante'));

// Create the first radar plot		
$plot = new RadarPlot(array(70,80,60,90,71,81,47, 80, 90));
$plot->SetLegend("Evaluation Initiale");
$plot->SetColor("#008000","lightred");
$plot->SetFill(true);
$plot->SetLineWeight(2);

// Create the second radar plot
$plot2 = new RadarPlot(array(70,40,30,80,31,51,14, 20, 30));
$plot2->SetLegend("Evaluation actuelle");
$plot2->SetLineWeight(2);
$plot2->SetColor("blue","lightblue");//#FF0000
$plot2->SetFill(true);

// Add the plots to the graph
$graph->Add($plot);
$graph->Add($plot2);

// And output the graph
$graph->Stroke();

?>
