<?php
include '../init/config.php';
include_once (LIB_DIR.'jpgraph/jpgraph.php');
include_once (LIB_DIR.'jpgraph/jpgraph_line.php');

//[+]DAO Config
include_once('DB/DataObject.php');
include_once('DB/DataObject/Cast.php');
$config = parse_ini_file(ROOT_DIR . 'DAO/dao.ini', TRUE);
foreach ($config as $class=>$values)
{
	$options = &PEAR::getStaticProperty($class, 'options');
	$options = $values;
}
$_DB_DATAOBJECT_FORMBUILDER['CONFIG'] = $config['DB_DataObject'];

DB_DataObject::debugLevel(0);
require_once(LIB_DIR.'db/dao.lib.php');
//[-]

if(isset($_GET['action']))
	$action = $_GET['action'];	
else 
	$action = '';

switch($action)
{
	case 'item_eval_graph' :
		item_eval_graph();
		break;
	case 'items_ps_radar_graph' :
		items_ps_radar_graph();
		break;
	case 'eval_trait' :
		eval_trait();
		break;
	
	
	default :
				
}

/**
 * Item evaluation Graph
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function item_eval_graph()
{	
	$show_value = 1;//isset($_GET['show_value']) ? 1 : 0;
	
	if(isset($_GET['per_code']) && isset($_GET['ite_code']))
	{
		$pat_per_code = (int) $_GET['per_code'];
		$ite_code = (int) $_GET['ite_code'];

		$datax = $datay = array();
		//$datay[] = 0;
		
		//check if exists eval initiale comp		
		$q = '
			SELECT
				cs.cse_date, eic.eic_eval_init_objectif
			FROM
				etp_eval_init_competence eic,
				etp_cs cs
			WHERE
				eic.cse_code=cs.cse_code AND
				cs.pat_per_code='.$pat_per_code.' AND 
				eic.ite_code='.$ite_code.' AND 
				eic.eic_eval_init_objectif IS NOT NULL			
		';
		$daoEic = DB_DataObject::factory('etp_eval_init_competence');
		$daoEic->query($q);
		while($daoEic->fetch())
		{
			$datax[] = date('d-m-Y', strtotime($daoEic->cse_date));
			$datay[] = (int) $daoEic->eic_eval_init_objectif;
		}
		$daoEic->free();
				
		//eval_etp_competence		
		$q = '
			SELECT
				cs.cse_date, eco.eco_eval_objectif
			FROM
				etp_eval_competence eco,
				etp_cs cs
			WHERE
				eco.cse_code=cs.cse_code AND
				cs.pat_per_code='.$pat_per_code.' AND  
				eco.ite_code='.$ite_code.'	 AND 
				eco.eco_eval_objectif IS NOT NULL			
			ORDER BY
				cs.cse_date, cs.cse_code
		';
		$daoEco = DB_DataObject::factory('etp_eval_competence');
		$daoEco->query($q);
		while($daoEco->fetch())
		{
			$datax[] = date('d-m-Y', strtotime($daoEco->cse_date));
			$datay[] = (int) $daoEco->eco_eval_objectif;
		}
		$daoEco->free();

		/*
		//$datay[] = 0;		
		echo '<pre>';
		print_r($datax);
		echo '<hr>';
		print_r($datay);
		echo '</pre>';
		exit;
		*/
		
		// Setup graph
		$graph = new Graph(700, 500, 'auto');
		$graph->img->SetMargin(50, 20, 20, 65);
		$graph->SetMarginColor('white');
		$graph->SetFrame(false, 'darkblue', 2); 
		$graph->SetScale('textlin', 0, 10);
		
		//$graph->SetShadow();
		
		//Setup title
		//$graph->title->Set('Expliquer les complications et le resques de rcidives possibles de la greffe');//
		//$graph->subtitle->Set('Item');
		
		//Use built in font
		$graph->title->SetFont(FF_ARIAL, FS_NORMAL, 12);
		
		//Slightly adjust the legend from it's default position
		$graph->legend->Pos(0.01, 0.963, 'right', 'center');
		$graph->legend->SetFont(FF_ARIAL, FS_BOLD);
		
		//Setup X-scale
		$graph->xaxis->SetTickLabels($datax);
		$graph->xaxis->SetFont(FF_ARIAL, FS_NORMAL, 8);
		$graph->xaxis->SetLabelAngle(45);
		//$graph->xaxis->title->Set('Date');
		
		//Setup Y-scale
		//$graph->yaxis->SetTickLabels(array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10));
		//$graph->yaxis->SetTickSize(1, 0);
		
		$graph->yaxis->SetFont(FF_ARIAL, FS_NORMAL, 8);
		//$graph->yaxis->title->SetFont(FF_ARIAL, FS_NORMAL, 8);
		//$graph->yaxis->title->Set('Evaluation: Min - 0 , Max - 10');
				
		//Create evaluation line
		$p1 = new LinePlot($datay);
		$p1->mark->SetType(MARK_FILLEDCIRCLE);
		$p1->mark->SetFillColor('red');
		$p1->mark->SetWidth(4);
		$p1->SetColor('blue');
		$p1->SetCenter();		
		//$p1->SetLegend('sdsd');	
		$p1->value->Show();		
		$graph->Add($p1);
				
			
		// Output line
		$graph->Stroke();
	}
	else
		exit('Invalid Get data!');
}

/**
 * Items psycho-social evaluation Radar Graph
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function items_ps_radar_graph()
{	
	if(isset($_GET['per_code']))
	{
		require_once (LIB_DIR.'jpgraph/jpgraph_radar.php');
		
		$pat_per_code = (int) $_GET['per_code'];
		
		$pat_info = dao_get_row_content('personne', array('per_code'=>$pat_per_code));
		
		$ITE_PS = 20;//Objectifs psycho-social
		
		$item_psycho_social_list = array();
		
		//Objectifs psycho-social (si.etp_ite_code_pere=20)
		$q = '
			SELECT 
				ite.ite_code, ite.ite_libelle
			FROM 
				etp_item_ss_item isi INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code
			WHERE
				isi.etp_ite_code_pere='.$ITE_PS.'
			ORDER BY				
				ite.ite_libelle 
		';
		$daoIsi = DB_DataObject::factory('etp_item_ss_item');
		$daoIsi->query($q);
		while($daoIsi->fetch())
			$item_psycho_social_list[$daoIsi->ite_code] = $daoIsi->ite_libelle;
		$daoIsi->free();		
		
		//get initial items psycho-social values	
		$ite_initial_list = array();
		$q='SELECT
				ite.ite_code, eic.eic_eval_init_objectif
			FROM
				etp_item_ss_item isi INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code							
				INNER JOIN etp_eval_init_competence eic ON ite.ite_code=eic.ite_code
				INNER JOIN etp_cs cs ON eic.cse_code=cs.cse_code	
			WHERE
				isi.etp_ite_code_pere='.$ITE_PS.' AND 
				cs.pat_per_code='.$pat_per_code.' AND cs.pce_code=1
			ORDER BY
				ite.ite_libelle
		';
		$daoIte = DB_DataObject::factory('etp_item_etp');
		$daoIte->query($q);
		while($daoIte->fetch())
			$ite_initial_list[$daoIte->ite_code] = $daoIte->eic_eval_init_objectif;
		$daoIte->free();
		
		if(empty($_GET['just_eval_init']))
		{
			//get last cs with pce_code=5
			$daoCse = DB_DataObject::factory('etp_cs');
			$daoCse->pat_per_code = $pat_per_code;
			$daoCse->pce_code = 5;
			$daoCse->orderBy('cse_date DESC, cse_code DESC');
			if($daoCse->find())
			{
				$daoCse->fetch();
				
				$cse_code_last = $daoCse->cse_code;			
				$cse_date_last = $daoCse->cse_date; 
				
				//get actual items psycho-social value
				$q='SELECT
						ite.ite_code, eco.eco_eval_objectif
					FROM
						etp_item_ss_item isi INNER JOIN etp_item_etp ite ON isi.etp_ite_code_fils=ite.ite_code							
						INNER JOIN etp_eval_competence eco ON ite.ite_code=eco.ite_code	
					WHERE
						isi.etp_ite_code_pere='.$ITE_PS.' AND 
						eco.cse_code='.$cse_code_last.'
					ORDER BY
						ite.ite_libelle
				';
				$daoEco = DB_DataObject::factory('etp_eval_competence');
				$daoEco->query($q);
				while($daoEco->fetch())
					$ite_actual_list[$daoEco->ite_code] = $daoEco->eco_eval_objectif;					
				$daoEco->free();
				
				$title_graph = 'Evaluation des items psycho-sociaux du '.date('d/m/Y', strtotime($cse_date_last));// #'.$cse_code_last.', date
			}
			else
				$title_graph = 'Evaluation des items psycho-sociaux du '.date('d/m/Y');
			
			$daoCse->free();
		}
		else {
			$title_graph = 'Evaluation initiale des items psycho-sociaux';
		}
		
		$title_graph .= ', '.$pat_info['per_prenom'].' '.strtoupper($pat_info['per_nom']);
		
		
		
		//build radar graph arrays
		$radar_titles = $radar_initial = $radar_actual = array();
		foreach($item_psycho_social_list as $ite_code=>$ite_libelle)
		{				
			$radar_titles[] =  wordwrap($ite_libelle, 40, "\n");//substr($ite_libelle, 0, 38).'...';
			$radar_initial[] = isset($ite_initial_list[$ite_code]) ? $ite_initial_list[$ite_code] : false;
			$radar_actual[] = isset($ite_actual_list[$ite_code]) ? $ite_actual_list[$ite_code] : false;
		}
		
		if(isset($_GET['debug']))
		{
			echo "<hr>LIST:";
			print_r($item_psycho_social_list);
			echo "<hr>INIT:";
			print_r($ite_initial_list); 
			echo "<hr>ACTUAL:";
			print_r($ite_actual_list); 
			echo "<hr>RI:";
			print_r($radar_initial); 
			echo "<hr>RA:";
			print_r($radar_actual);
			
			exit;
		}
		
		// Create the basic radar graph
		$graph = new RadarGraph(850, 540);
		$graph->SetScale('lin', 0, 10);
		$graph->img->SetAntiAliasing();
		//$graph->SetPlotSize(0.5);
		// Set background color and shadow
		$graph->SetColor('white');//#74F100
		$graph->SetShadow();
		
		// Position the graph
		$graph->SetCenter(0.48, 0.5);
		
		// Setup the axis formatting		
		$graph->axis->title->SetFont(FF_ARIAL, FS_NORMAL, 7);//$graph->axis->SetFont(FF_FONT1, FS_BOLD);
		//$graph->axis->title->SetMargin(5);
				
		
		
		// Setup the grid lines
		$graph->grid->SetLineStyle('solid');//solid dashed
		$graph->grid->SetColor('#999');
		$graph->grid->Show();
		$graph->HideTickMarks();
				
		// Setup graph titles
		$graph->title->Set($title_graph);
		$graph->title->SetFont(FF_FONT1, FS_BOLD);
		
		//$graph->SetTitles($gDateLocale->GetShortMonth());
		//$graph->SetTitles(array('Communication','Vie Sexuelle','Vie affective','Vie professionnele', 'Vie sociale', 'Image de soi', 'Gestion des emotions', 'Projets', 'Comportements de sante'));
		$graph->SetTitles($radar_titles);
		
		// Create the first radar plot		
		$plot1 = new RadarPlot($radar_initial);
		$plot1->SetLegend('Evaluation Initiale');		
		//$plot1->SetColor('red', 'lightred');
		$plot1->SetFillColor('red@0.9');
		////$plot1->SetFill('red@0.9');
		$plot1->SetLineWeight(2);
		$plot1->mark->SetType(MARK_IMG_SBALL, 'red');
		
				
		// Create the second radar plot
		$plot2 = new RadarPlot($radar_actual);
		$plot2->SetLegend('Evaluation actuelle');
		$plot2->SetLineWeight(2);
		$plot2->SetColor('blue', 'lightblue');//#FF0000
		$plot2->SetFillColor('blue@0.9');
		//$plot2->SetFill('blue@0.9');
		$plot2->mark->SetType(MARK_IMG_SBALL, 'bluegreen');
		/*
		$plot->SetColor('red@0.2');
		$plot->SetLineWeight(1);
		$plot->SetFillColor('red@0.7');
		*/
		
		$graph->legend->SetAbsPos(25,20,'right','top');
		
		
		// Add the plots to the graph
		$graph->Add($plot1);
		$graph->Add($plot2);
		
		// And output the graph
		$graph->Stroke();
	}
	else
		exit('Invalid Get data!');
}

function eval_trait()
{
	$show_value = 1;//isset($_GET['show_value']) ? 1 : 0;

	if(isset($_GET['per_code']))
	{
		$pat_per_code = (int) $_GET['per_code'];
		$datax = $datay = array();
		
		
		//check and get initial cs_recueil_donnees.csr_eval_trait
		$q = '
			SELECT
				cs.cse_date, csr.csr_eval_trait
			FROM
				etp_cs_recueil_donnees csr,
				etp_cs cs
			WHERE
				csr.cse_code=cs.cse_code AND
				cs.pat_per_code='.$pat_per_code.' AND
				csr.csr_eval_trait IS NOT NULL
		';
		$daoCsr = DB_DataObject::factory('etp_cs_recueil_donnees');
		$daoCsr->query($q);
		while($daoCsr->fetch())
		{
			$datax[] = date('d-m-Y', strtotime($daoCsr->cse_date));
			$datay[] = (int) $daoCsr->csr_eval_trait;
		}
		$daoCsr->free();
		
		//get from evaluation
		$q = '
			SELECT
				cs.cse_date, cse.cse_eval_trait
			FROM
				etp_cs_evaluation cse,
				etp_cs cs
			WHERE
				cse.cse_code=cs.cse_code AND
				cs.pat_per_code='.$pat_per_code.'
			ORDER BY
				cs.cse_date, cs.cse_code
		';
		$daoCse = DB_DataObject::factory('etp_cs_evaluation');
		$daoCse->query($q);
		while($daoCse->fetch())
		{
			$datax[] = date('d-m-Y', strtotime($daoCse->cse_date));
			$datay[] = (int) $daoCse->cse_eval_trait;
		}
		$daoCse->free();

		/*
		//$datay[] = 0;
		echo '<pre>';
		print_r($datax);
		echo '<hr>';
		print_r($datay);
		echo '</pre>';
		exit;
		*/

		// Setup graph
		$graph = new Graph(700, 500, 'auto');
		$graph->img->SetMargin(50, 20, 20, 65);
		$graph->SetMarginColor('white');
		$graph->SetFrame(false, 'darkblue', 2);
		$graph->SetScale('textlin', 0, 10);

		//$graph->SetShadow();

		//Setup title
		//$graph->title->Set('Expliquer les complications et le resques de rcidives possibles de la greffe');//
		//$graph->subtitle->Set('Item');

		//Use built in font
		$graph->title->SetFont(FF_ARIAL, FS_NORMAL, 12);

		//Slightly adjust the legend from it's default position
		$graph->legend->Pos(0.01, 0.963, 'right', 'center');
		$graph->legend->SetFont(FF_ARIAL, FS_BOLD);

		//Setup X-scale
		$graph->xaxis->SetTickLabels($datax);
		$graph->xaxis->SetFont(FF_ARIAL, FS_NORMAL, 8);
		$graph->xaxis->SetLabelAngle(45);
		//$graph->xaxis->title->Set('Date');

		//Setup Y-scale
		//$graph->yaxis->SetTickLabels(array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10));
		//$graph->yaxis->SetTickSize(1, 0);

		$graph->yaxis->SetFont(FF_ARIAL, FS_NORMAL, 8);
		//$graph->yaxis->title->SetFont(FF_ARIAL, FS_NORMAL, 8);
		//$graph->yaxis->title->Set('Evaluation: Min - 0 , Max - 10');

		//Create evaluation line
		$p1 = new LinePlot($datay);
		$p1->mark->SetType(MARK_FILLEDCIRCLE);
		$p1->mark->SetFillColor('red');
		$p1->mark->SetWidth(4);
		$p1->SetColor('blue');
		$p1->SetCenter();
		//$p1->SetLegend('sdsd');
		$p1->value->Show();
		$graph->Add($p1);

			
		// Output line
		$graph->Stroke();
	}
	else
		exit('Invalid Get data!');
}

?>