<?php
//#########################################################################//
//# Adresse Postale - all operation in some page
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 29.01.08
//#########################################################################//

class parametres_biologiques
{
	var $tplName 		  = "parametres_biologiques";
    var $moduleName 	  = "parametres_biologiques";
    var $pagingAction 	  = "page";

    var $tableName 		  = "parametres_biologiques";
    var $idName 		  = "pbi_code";
	var $flagName 		  = "";
	var $priorityName	  = "";
	
	var $tableFields	  = array("tpb_code", "pbi_libelle", "pbi_unite_mes", "pbi_val_defaut");
	
	/**
	 * Constructor
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function parametres_biologiques($action="")
	{
		switch($action)
	  	{
	  		case "page":	  			
				$this->page();
      		 	break;
      		 	
      		case "add_upd":
				$this->add_upd();
      		 	break;
	  	}
	}
		
	/**
	 * Page (list/add/upd form)
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function page()
	{
		global $smarty;
		
		objInitVar($this, "admin/parametres_biologiques.tpl", "parametres_biologiques", "page", "", "", "");
		
		//delete multiple items
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
		{
			$this->deleteMItems();
			
			redirect("admin.php?obj={$_GET['obj']}&action={$_GET['action']}");	
		}
		
		$form_act = array();
		
        if(isset($_GET['act']) && 'upd'==$_GET['act'] && isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
        {
			$id = $_GET[$this->idName];
        	$form_act = _sqlGetRowContent($this->tableName, $this->idName, $id);
        	$form_act['act'] = 'upd';
        }
		else
		{
			if(isset($_POST['act']) && $_POST['act']=='add')
				$form_act=$_POST;
			$form_act['act'] = 'add';
		}
		
		$smarty->assign("form_act", htmlArrayFilter($form_act));
		$smarty->assign("recList", $this->getList());
		$smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);
		$smarty->assign("tpbList", _sqlGetTableContent("type_parametre_biologique", "tpb_code", "tpb_libelle", "tpb_libelle", 0));		
		
		$smarty->display($this->tplName);
	}		
	
	/**
	 * Add/Update operation
	 *
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function add_upd()
    {    	
    	global $dbi;
    	
    	if(isset($_POST['act']) && ($_POST['act']=="add" || $_POST['act']=="upd"))
        {
	        if(!_sqlCheckDuplicates($this, "page", $this->tableName, array("pbi_libelle[&&]tpb_code"=>"{$_POST['pbi_libelle']}[&&]{$_POST['tpb_code']}"), $this->idName, $_POST[$this->idName]))
	    	{
	        	$q_tmp = objPrepareTableFields($this);
	        	
	        	if($_POST['act']=="add") //add
		        {
		        	$id = $dbi->nextId($this->tableName, $this->idName);
		        	$q="INSERT INTO
		                    $this->tableName
		                SET
			                $this->idName='$id',	
			                $q_tmp
		            ";
		            $dbi->execute($q);
		        }
		        elseif(isset($_POST[$this->idName]) && $_POST[$this->idName]!="") //update
		        {
		            $id = _sqlEscValue($_POST[$this->idName]);
		            
		            $q="UPDATE
		                    $this->tableName
		                SET
		                  	$q_tmp
		                WHERE
		                    $this->idName = '$id'
		            ";
		            $dbi->execute($q);
		        }
		        
		        if(isset($id))
				{
					if(isset($_POST['backToEditForm']))
						//redirect to update from
						redirect("admin.php?obj={$_GET["obj"]}&action=page&{$this->idName}={$id}&act=upd");
					else 
						//redirect to update from
						redirect("admin.php?obj={$_GET["obj"]}&action=page");
				}
				else
					echo "Error!";
	    	}
        }
        else 
        	redirect("admin.php?obj=index&action=page_invalid");
    }
	
    /**
	 * Get Items List
	 *
	 * @parameters: $withPaging (1 for paging)
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function getList()
	{
		global $dbi;
		
		//===> for search, paging and sort
		if(isset($_POST["act"]) && $_POST["act"] == "search") search($this->moduleName);
		
		$sqlSort = newSort($this->moduleName, "{$this->tableName}.pbi_libelle", 'ASC');
        $sqlLimit = paging($this->moduleName, $this->pagingAction);
		
		$myC = $_SESSION[SESS_IDX][$this->moduleName];
		$vectSearch = (isset($myC["search"]) ? $myC["search"] : array());
		$sqlWhere="";
		if(count($vectSearch) > 0)
		{
			foreach($vectSearch as $key=>$value)
			{				
				switch($key)
				{
					case "tpb_code":
						$sqlWhere .= "AND {$this->tableName}.tpb_code = '{$value}' ";
						break;
					case "vad_code":
						$sqlWhere .= "AND {$this->tableName}.vad_code = '{$value}' ";
						break;					
					case "pbi_libelle":
						$sqlWhere .= "AND {$this->tableName}.pbi_libelle LIKE '%{$value}%' ";
						break;
					case "pbi_unite_mes":
						$sqlWhere .= "AND {$this->tableName}.pbi_unite_mes LIKE '%{$value}%' ";
						break;
					case "pbi_val_defaut":
						$sqlWhere .= "AND {$this->tableName}.pbi_val_defaut LIKE '%{$value}%' ";
						break;
				}
			}
		}
		//<===
		
		$q="				
			SELECT 
				{$this->tableName}.{$this->idName}
			FROM 
				{$this->tableName}, type_parametre_biologique
			WHERE 
				{$this->tableName}.tpb_code=type_parametre_biologique.tpb_code
				{$sqlWhere}
		";
		$_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"]=$dbi->noRows($q);
		
		$q="
			SELECT 				
				{$this->tableName}.*, type_parametre_biologique.tpb_libelle
			FROM 
				{$this->tableName}, type_parametre_biologique
			WHERE 
				{$this->tableName}.tpb_code=type_parametre_biologique.tpb_code
				{$sqlWhere}
			ORDER BY 
				type_parametre_biologique.tpb_libelle, {$sqlSort}
			{$sqlLimit}
		";
		$res_idx=$dbi->query($q); $list = array(); $i=-1;
		while($rec=$dbi->getRow($res_idx))
		{
			$i++;
			$list[$i]=$rec;
			$list[$i]["del_op"] = $this->verifyDel($rec[$this->idName]);
		}
		
		return $list;
	}
	
	/**
	 * Verify item for remove operation
	 *
	 * @parameters: $id = item id
	 * @access: public
	 * @return: bool
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function verifyDel($id)
	{
		//if(_sqlCheckFieldExist("", $this->idName, $id))
			//return false;
		
		return true;
	}
	
    /**
	 * Delete multiple items
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function deleteMItems()
	{
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
        {
            if(isset($_POST["ids"]) && is_array($_POST["ids"]))
            {
				foreach($_POST["ids"] as $k=>$v)
                {
					$this->deleteItem($v);
                }
			}
        }	
	}
	
	/**
	 * Delete item
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function deleteItem($id)
	{		
		if($this->verifyDel($id))
		{
			//delete item			
			_sqlDel($this->tableName, $this->idName, $id);
		}
	}
}
?>