<?php
//#########################################################################//
//# Sample 2 - use upload file, form add/edit in a separated page 
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 14.01.08
//#########################################################################//

class sample2
{
	var $tplName 		  = "";
    var $moduleName 	  = "sample2";
    var $pagingAction 	  = "page_list";
    
    var $tableName 		  = "sample2";
    var $idName 		  = "sample2_id";
	var $flagName 		  = "sample2_active";
	var $priorityName	  = "sample2_priority";
	
	var $tableFields	  = array("sample1_id", "sample2_name", "sample2_priority", "sample2_active");
	
	var $arrFileFields 	  = array(
								"sample2_file1"=>array("name"=>"Image Upl 1", "type"=>"image", "processArgs"=>array("scale", 500)),
								"sample2_file2"=>array("name"=>"Image Upl 2", "type"=>"image2")
							);
	
	var $uploadDir        = SAMPLE2_UPLOAD_DIR;
	
	/**
	 * Constructor
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function sample2($action="")
	{
		switch($action)
	  	{
	  		case "page_act":
				$this->page_act();
      		 	break;
      		
      		case "add_upd":
				$this->add_upd();
      		 	break;
      		
      		case "page_list":
				$this->page_list();
      		 	break;
			
      		case "switch":
      			if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='' && isset($_GET['fieldName']) && $_GET['fieldName']!='')
      				_sqlFieldSwitch($this->tableName, $_GET['fieldName'], $this->idName, $_GET[$this->idName]);
      		 	redirect("admin.php?obj={$_GET['obj']}&action=page_list");
				break;
	  	}
	}
	
	/**
	 * Page act (add/edit form)
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function page_act()
	{
		global $smarty;
		
		objInitVar($this, "admin/{$this->tableName}_act.tpl", "page_act", "", "", "", "");
				
		$form_act = array();
        if(isset($_GET['act']) && 'upd'==$_GET['act'] && isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
        {
			$id = $_GET[$this->idName];
			$form_act = _sqlGetRowContent($this->tableName, $this->idName, $id);
        	$form_act['act'] = 'upd';
        }
		else
		{
			if(isset($_POST))
				$form_act=$_POST;			
			$form_act['act'] = 'add';
		}
		
		//assign variables					
		$smarty->assign("form_act", htmlArrayFilter($form_act));
		$smarty->assign("sample1List", _sqlGetTableContent("sample1", "sample1_id", "sample1_name", "sample1_priority", 0));
		
		//dispaly smarty template
		$smarty->display($this->tplName);		
	}
	
	/**
	 * Add/Update operation
	 * 
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function add_upd()
    {    	
    	global $dbi;
    	
    	if(isset($_POST['act']) && ($_POST['act']=="add" || $_POST['act']=="upd"))
        {
	    	if(!_sqlCheckDuplicates($this, "page_act", $this->tableName, array("sample2_name"=>$_POST['sample2_name']), $this->idName, $_POST[$this->idName]))
	    	{
		    	$q_tmp = objPrepareTableFields($this);
		    	
		        if($_POST['act']=="add")
		        {
		        	$q="INSERT INTO 
		                    $this->tableName
		                SET 
		                    $q_tmp
		            ";
		            $dbi->execute($q);
		            $id=$dbi->lastInsertId();
		        }
		        elseif(isset($_POST[$this->idName]) && $_POST[$this->idName]!="") //update
		        {
		            $id=$_POST[$this->idName];
		            
		            $q="UPDATE
		                    $this->tableName
		                SET
		                  	$q_tmp
		                WHERE
		                    $this->idName = $id
		            ";
		            $dbi->execute($q);
		        }
		        if(isset($id))
				{
					//===> file upload
					if(isset($this->arrFileFields) && is_array($this->arrFileFields) && count($this->arrFileFields)>0)
					{
						fileUplProcessing($this->tableName, $this->idName, $id, $this->uploadDir, $this->arrFileFields);
					}
					//<===
					
					//exit;
					if(isset($_POST['backToEditForm']))
						//redirect to update from
						redirect("admin.php?obj={$_GET["obj"]}&action=page_act&{$this->idName}={$id}&act=upd");
					else 
						//redirect to update from
						redirect("admin.php?obj={$_GET["obj"]}&action=page_list");
				}
				else
					echo "Error!";
	    	}
        }
        else 
        	redirect("admin.php?obj=index&action=page_invalid");
    }
    
    /**
	 * Page list/edit
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function page_list()
	{
		global $smarty;
		
		objInitVar($this, "admin/{$this->tableName}_list.tpl", "sample2_list", "page_list", "", "", "");
		
		//delete multiple items
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
			$this->deleteMItems();
			
		$smarty->assign("recList", $this->getList());
		$smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);
		$smarty->assign("sample1List", _sqlGetTableContent("sample1", "sample1_id", "sample1_name", "sample1_priority", 0));
		
		$smarty->display($this->tplName);
	}
	
	/**
	 * Get Items List
	 *
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function getList()
	{
		global $dbi;
		
		if(isset($_POST["act"]) && $_POST["act"] == "search") search($this->moduleName);
		
		$sqlSort = newSort($this->moduleName, "{$this->tableName}.{$this->priorityName}", 'ASC');
        $sqlLimit = paging($this->moduleName, $this->pagingAction);
		
		$myC = $_SESSION[SESS_IDX][$this->moduleName];		
		$vectSearch = (isset($myC["search"]) ? $myC["search"] : array());
		$sqlWhere="";
		if(count($vectSearch) > 0)
		{
			foreach($vectSearch as $key=>$value)
			{
				switch($key)
				{
					case "sample1_id":
						$sqlWhere .= "AND {$this->tableName}.sample1_id = '$value' ";
						break;
					case "sample2_name":
						$sqlWhere .= "AND {$this->tableName}.sample2_name LIKE '%$value%' ";
						break;
					case "sample2_active":
						$sqlWhere .= "AND {$this->tableName}.{$this->flagName} = '$value' ";
						break;
				}
			}
		}
		
		$q="				
			SELECT 
				{$this->tableName}.{$this->idName}
			FROM 
				{$this->tableName}, sample1
			WHERE 
				{$this->tableName}.sample1_id=sample1.sample1_id 
				{$sqlWhere}
		";
		$_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"]=$dbi->noRows($q);
		
		$q="
			SELECT 				
				{$this->tableName}.*, sample1.sample1_name
			FROM 
				{$this->tableName}, sample1
			WHERE 			
				{$this->tableName}.sample1_id=sample1.sample1_id 
				{$sqlWhere}
			ORDER BY 
				sample1.sample1_priority, sample1.sample1_id, 
				{$sqlSort}
			{$sqlLimit}
		";
		$res_idx=$dbi->query($q); $list = array(); $i=-1;
		while($rec=$dbi->getRow($res_idx))
		{
			$i++;
			$list[$i]=$rec;
			$list[$i]["del_op"] = $this->verifyDel($rec[$this->idName]);
		}
		
		return $list;
	}
		
	/**
	 * Verify item for delete operation
	 *
	 * @access: public
	 * @return: bool
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function verifyDel($id)
	{
		return true;
	}
	
	/**
	 * Delete multiple items
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function deleteMItems()
	{
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
        {
            if(isset($_POST["ids"]))
            {    				
				foreach($_POST["ids"] as $k=>$v)
                {
                	$this->deleteItem($v);
                }
			}
        }	
	}
	
	/**
	 * Delete item
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function deleteItem($id)
	{		
		if($this->verifyDel($id))
		{
			//remove files
			fileRemProcessing($this->tableName, $this->idName, $id, $this->uploadDir, $this->arrFileFields);
		    
			//delete item
			_sqlDel($this->tableName, $this->idName, $id);
		}
	}
}
?>