<?php
//#########################################################################//
//# Sample 3 - multilanguage / all operation in some page
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 14.01.08
//#########################################################################//

class sample3
{
	var $tplName 		  = "sample3";
    var $moduleName 	  = "sample3";
    var $pagingAction 	  = "page";

    var $tableName 		  = "sample3";
    var $idName 		  = "sample3_id";
	var $flagName 		  = "sample3_active";
	var $priorityName	  = "sample3_priority";
	
	var $tableFields	  = array("sample3_priority", "sample3_active");
	
	/**
	 * Constructor
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function sample3($action="")
	{
		switch($action)
	  	{
	  		case "page":	  			
				$this->page();
      		 	break;
      		 	
      		case "add_upd":
				$this->add_upd();
      		 	break;
      		 	
      		case "switch":
      			if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='' && isset($_GET['fieldName']) && $_GET['fieldName']!='')
					_sqlFieldSwitch($this->tableName, $_GET['fieldName'], $this->idName, $_GET[$this->idName]);
      		 	redirect("admin.php?obj={$_GET['obj']}&action=page");
				break;
	  	}
	}
		
	/**
	 * Page (list/add/upd form)
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function page()
	{
		global $smarty, $dbi, $L;
		
		objInitVar($this, "admin/{$this->tableName}.tpl", "sample3", "page", "", "", "");
		
		//delete multiple items
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
		{
			$this->deleteMItems();
			
			redirect("admin.php?obj={$_GET['obj']}&action={$_GET['action']}");	
		}
		
		$form_act = array();
		
        if(isset($_GET['act']) && 'upd'==$_GET['act'] && isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
        {
			$id = $_GET[$this->idName];
        	$form_act = _sqlGetRowContent($this->tableName, $this->idName, $id);
        	
        	//===>get lang content
			$q="
            	SELECT
            		{$L['id']}, 
            		{$this->tableName}{$L['table']}_name,
            		{$this->tableName}{$L['table']}_descr
                FROM
                    {$this->tableName}{$L['table']}
                WHERE
                    {$this->tableName}{$L['table']}.{$this->idName} = '{$id}'
            ";
            $dbi->query($q);
            while($rec=$dbi->getRow())
            {
                $form_act["{$this->tableName}{$L['table']}_name"][$rec[0]] = $rec[1];
                $form_act["{$this->tableName}{$L['table']}_descr"][$rec[0]] = $rec[2];
            }
            //<===
        	
        	$form_act['act'] = 'upd';
        }
		else
		{
			if(isset($_POST['act']) && $_POST['act']=='add')
				$form_act=$_POST;
			$form_act['act'] = 'add';
		}
		
		$smarty->assign("form_act", htmlArrayFilter($form_act));
		$smarty->assign("recList", $this->getList());
		$smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);
		
		$smarty->assign("langList", getLangList());
		
		$smarty->display($this->tplName);
	}		
	
	/**
	 * Add/Update operation
	 *
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function add_upd()
    {    	
    	global $L, $dbi;
    	
    	if(isset($_POST['act']) && ($_POST['act']=="add" || $_POST['act']=="upd"))
        {
	        if(true)
	    	{
	        	$q_tmp = objPrepareTableFields($this);
	        	
	        	if($_POST['act']=="add") //add
		        {
		        	$q="INSERT INTO
		                    $this->tableName
		                SET
		                	$q_tmp
		            ";
		            $dbi->execute($q);
		            $id=$dbi->lastInsertId();
		        }
		        elseif(isset($_POST[$this->idName]) && $_POST[$this->idName]!="") //update
		        {
		            $id = _sqlEscValue($_POST[$this->idName]);
		            
		            $q="UPDATE
		                    $this->tableName
		                SET
		                  	$q_tmp
		                WHERE
		                    $this->idName = '$id'
		            ";
		            $dbi->execute($q);
		        }
		        if(isset($id))
				{
					//===> delete lang fields
					_sqlDel($this->tableName.$L['table'], $this->idName, $id);            
					//<===
					
					//===> add fields per lang
					$qTmp="";
					for($i=0; $i<$_POST['no_langs']; $i++)
					{
						$lang_id = $_POST["lang_id_".$i];
						$name	 = _sqlEscValue($_POST["{$this->tableName}{$L['table']}_name_".$i]);
						$descr	 = _sqlEscValue($_POST["{$this->tableName}{$L['table']}_descr_".$i]);
						
						$qTmp .= "('$id', '$lang_id', '$name', '$descr'), ";
					}
					if($qTmp!="")
					{
						$q = "INSERT INTO {$this->tableName}{$L['table']} ({$this->idName}, {$L['id']}, {$this->tableName}{$L['table']}_name, {$this->tableName}{$L['table']}_descr) VALUES ";
						$q .= substr($qTmp, 0, strlen($qTmp)-2);
						$dbi->execute($q);
					}
					//<===
					
					//exit;
					if(isset($_POST['backToEditForm']))
						//redirect to update from
						redirect("admin.php?obj={$_GET["obj"]}&action=page&{$this->idName}={$id}&act=upd");
					else 
						//redirect to update from
						redirect("admin.php?obj={$_GET["obj"]}&action=page");
				}
				else
					echo "Error!";
	    	}
        }
        else 
        	redirect("admin.php?obj=index&action=page_invalid");
    }
	
    /**
	 * Get Items List
	 *
	 * @parameters: $withPaging (1 for paging)
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function getList()
	{
		global $L;
		
		$defaultLangId = $_SESSION[SESS_IDX]['defaultLang'];
		
		//===> for search, paging and sort
		if(isset($_POST["act"]) && $_POST["act"] == "search") search($this->moduleName);
		
		$sqlSort = newSort($this->moduleName, "{$this->tableName}.{$this->priorityName}", 'ASC');
        $sqlLimit = paging($this->moduleName, $this->pagingAction);
		
		$myC = $_SESSION[SESS_IDX][$this->moduleName];
		$vectSearch = (isset($myC["search"]) ? $myC["search"] : array());
		$sqlWhere="";
		if(count($vectSearch) > 0)
		{
			foreach($vectSearch as $key=>$value)
			{				
				switch($key)
				{
					case "sample3lang_name":
						$sqlWhere .= "AND {$this->tableName}{$L['table']}.sample3lang_name LIKE '%$value%' ";
						break;
					case "lang_iso":
						$sqlWhere .= "AND {$this->tableName}{$L['table']}.lang_iso = '$value' ";
						break;
					case "sample3_active":
						$sqlWhere .= "AND {$this->tableName}.sample3_active = '$value' ";
						break;
				}
			}
		}
		//<===
		
		$q="				
			SELECT 
				{$this->tableName}.{$this->idName}
			FROM 
				{$this->tableName}
				LEFT JOIN {$this->tableName}{$L['table']} ON 
							{$this->tableName}.{$this->idName} = {$this->tableName}{$L['table']}.{$this->idName} AND 
							{$this->tableName}{$L['table']}.{$L['id']}='{$defaultLangId}'
			WHERE 
				1
				{$sqlWhere}
			GROUP BY
				{$this->tableName}.{$this->idName}
		";
		$_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"]=$dbi->noRows($q);
		
		$q="
			SELECT 				
				{$this->tableName}.*, {$this->tableName}{$L['table']}_name
			FROM 
				{$this->tableName}
				LEFT JOIN {$this->tableName}{$L['table']} ON 
							{$this->tableName}.{$this->idName} = {$this->tableName}{$L['table']}.{$this->idName} AND 
							{$this->tableName}{$L['table']}.{$L['id']}='{$defaultLangId}'
			WHERE 			
				1
				{$sqlWhere}
			GROUP BY
				{$this->tableName}.{$this->idName}
			ORDER BY 
				{$sqlSort}
			{$sqlLimit}
		";
		$res_idx=$dbi->query($q); $list = array(); $i=-1;
		while($rec=$dbi->getRow($res_idx))
		{
			$i++;
			$list[$i]=$rec;
			$list[$i]["del_op"] = $this->verifyDel($rec[$this->idName]);
		}
		
		return $list;
	}
	
	/**
	 * Verify item for remove operation
	 *
	 * @parameters: $id = item id
	 * @access: public
	 * @return: bool
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function verifyDel($id)
	{
		if(_sqlCheckFieldExist("sample4", $this->idName, $id))
			return false;
		
		return true;
	}
	
    /**
	 * Delete multiple items
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function deleteMItems()
	{
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
        {
            if(isset($_POST["ids"]) && is_array($_POST["ids"]))
            {
				foreach($_POST["ids"] as $k=>$v)
                {
					$this->deleteItem($v);
                }
			}
        }	
	}
	
	/**
	 * Delete item
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function deleteItem($id)
	{		
		global $L;
		
		if($this->verifyDel($id))
		{
			//delete from lang table
			_sqlDel($this->tableName.$L['table'], $this->idName, $id);
			
			//delete item			
			_sqlDel($this->tableName, $this->idName, $id);
		}
	}
}
?>