<?php
//#########################################################################//
//# Sample 4 - multilanguage / add/edit and listing in diferent pages
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 14.01.08
//#########################################################################//

class sample4
{
	var $tplName 		  = "sample4";
    var $moduleName 	  = "sample4";
    var $pagingAction 	  = "page_list";

    var $tableName 		  = "sample4";
    var $idName 		  = "sample4_id";
	var $flagName 		  = "sample4_active";
	var $priorityName	  = "sample4_priority";
	
	var $tableFields	  = array("sample3_id", "sample4_priority", "sample4_active");
	
	var $arrFileFields 	  = array(
								"sample4_file"=>array("name"=>"Image Upl", "type"=>"image")
							);
	
	var $uploadDir        = SAMPLE4_UPLOAD_DIR;
	
	/**
	 * Constructor
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function sample4($action="")
	{
		switch($action)
	  	{
	  		case "page_act":
				$this->page_act();
      		 	break;
      		
      		case "add_upd":
				$this->add_upd();
      		 	break;
      		
      		case "page_list":
				$this->page_list();
      		 	break;
			
      		case "switch":
      			if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='' && isset($_GET['fieldName']) && $_GET['fieldName']!='')
      				_sqlFieldSwitch($this->tableName, $_GET['fieldName'], $this->idName, $_GET[$this->idName]);
      		 	redirect("admin.php?obj={$_GET['obj']}&action=page_list");
				break;
	  	}
	}

	/**
	 * Page act (add/edit form)
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function page_act()
	{
		global $smarty, $dbi, $L;
		
		objInitVar($this, "admin/{$this->tableName}_act.tpl", "page_act", "", "", "", "");
		
		$defaultLangId = $_SESSION[SESS_IDX]['defaultLang'];
			
		$form_act = array();
        if(isset($_GET['act']) && 'upd'==$_GET['act'] && isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
        {
			$id = $_GET[$this->idName];
			$form_act = _sqlGetRowContent($this->tableName, $this->idName, $id);
			
			//===>get lang content
			$q="
            	SELECT
            		{$L['id']}, 
            		{$this->tableName}{$L['table']}_name,
            		{$this->tableName}{$L['table']}_descr
                FROM
                    {$this->tableName}{$L['table']}
                WHERE
                    {$this->tableName}{$L['table']}.{$this->idName} = '{$id}'
            ";
            $dbi->query($q);
            while($rec=$dbi->getRow())
            {
                $form_act["{$this->tableName}{$L['table']}_name"][$rec[0]] = $rec[1];
                $form_act["{$this->tableName}{$L['table']}_descr"][$rec[0]] = $rec[2];
            }
            //<===
			
        	$form_act['act'] = 'upd';
        }
		else
		{
			if(isset($_POST))
				$form_act=$_POST;			
			$form_act['act'] = 'add';
		}
		
		//assign variables					
		$smarty->assign("form_act", htmlArrayFilter($form_act));
		$smarty->assign("sample3List", _sqlGetTableLangContent("sample3", "sample3_id", "sample3{$L['table']}_name", $defaultLangId, "sample3_priority", 0));
		$smarty->assign("langList", getLangList());
		
		//dispaly smarty template
		$smarty->display($this->tplName);		
	}		
	
	/**
	 * Add/Update operation
	 *
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function add_upd()
    {    	
    	global $L, $dbi;
    	
    	if(isset($_POST['act']) && ($_POST['act']=="add" || $_POST['act']=="upd"))
        {
	        if(true)
	    	{
	        	$q_tmp = objPrepareTableFields($this);
	        	
	        	if($_POST['act']=="add") //add
		        {
		        	$q="INSERT INTO
		                    $this->tableName
		                SET
		                	$q_tmp
		            ";
		            $dbi->execute($q);
		            $id=$dbi->lastInsertId();
		        }
		        elseif(isset($_POST[$this->idName]) && $_POST[$this->idName]!="") //update
		        {
		            $id = _sqlEscValue($_POST[$this->idName]);
		            
		            $q="UPDATE
		                    $this->tableName
		                SET
		                  	$q_tmp
		                WHERE
		                    $this->idName = '$id'
		            ";
		            $dbi->execute($q);
		        }
		        
				if(isset($id))
				{
					//===> delete lang fields
					_sqlDel($this->tableName.$L['table'], $this->idName, $id);            
					//<===
					
					//===> add fields per lang
					$qTmp="";
					for($i=0; $i<$_POST['no_langs']; $i++)
					{
						$lang_id = $_POST["lang_id_".$i];
						$name	 = _sqlEscValue($_POST["{$this->tableName}{$L['table']}_name_".$i]);
						$descr	 = _sqlEscValue($_POST["{$this->tableName}{$L['table']}_descr_".$i]);
						
						$qTmp .= "('$id', '$lang_id', '$name', '$descr'), ";
					}
					if($qTmp!="")
					{
						$q = "INSERT INTO {$this->tableName}{$L['table']} ({$this->idName}, {$L['id']}, {$this->tableName}{$L['table']}_name, {$this->tableName}{$L['table']}_descr) VALUES ";
						$q .= substr($qTmp, 0, strlen($qTmp)-2);
						$dbi->execute($q);
					}
					//<===
					
					//===> file upload
					if(isset($this->arrFileFields) && is_array($this->arrFileFields) && count($this->arrFileFields)>0)
					{
						fileUplProcessing($this->tableName, $this->idName, $id, $this->uploadDir, $this->arrFileFields);
					}
					//<===
					
					//exit;
					if(isset($_POST['backToEditForm']))
						//redirect to update from
						redirect("admin.php?obj={$_GET["obj"]}&action=page_act&{$this->idName}={$id}&act=upd");
					else 
						//redirect to update from
						redirect("admin.php?obj={$_GET["obj"]}&action=page_list");
				}
				else
					echo "Error!";
	    	}
        }
        else 
        	redirect("admin.php?obj=index&action=page_invalid");
    }
	
    /**
	 * Page list/edit
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function page_list()
	{
		global $smarty, $L;
		
		objInitVar($this, "admin/{$this->tableName}_list.tpl", "sample4_list", "page_list", "", "", "");
		
		$defaultLangId = $_SESSION[SESS_IDX]['defaultLang'];
		
		//delete multiple items
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
			$this->deleteMItems();
			
		$smarty->assign("recList", $this->getList());
		$smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);
		$smarty->assign("sample3List", _sqlGetTableLangContent("sample3", "sample3_id", "sample3{$L['table']}_name", $defaultLangId, "sample3_priority", 0));
		$smarty->assign("langList", getLangList());
		
		$smarty->display($this->tplName);
	}
    
    /**
	 * Get Items List
	 *
	 * @parameters: $withPaging (1 for paging)
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function getList()
	{
		global $dbi, $L;
		
		$defaultLangId = $_SESSION[SESS_IDX]['defaultLang'];
		
		//===> for search, paging and sort
		if(isset($_POST["act"]) && $_POST["act"] == "search") search($this->moduleName);
		
		$sqlSort = newSort($this->moduleName, "{$this->tableName}.{$this->priorityName}", 'ASC');
        $sqlLimit = paging($this->moduleName, $this->pagingAction);
		
		$myC = $_SESSION[SESS_IDX][$this->moduleName];
		$vectSearch = (isset($myC["search"]) ? $myC["search"] : array());
		$sqlWhere="";
		if(count($vectSearch) > 0)
		{
			foreach($vectSearch as $key=>$value)
			{				
				switch($key)
				{
					case "sample3_id":
						$sqlWhere .= "AND {$this->tableName}.sample3_id = '$value' ";
						break;
					case "sample4lang_name":
						$sqlWhere .= "AND {$this->tableName}{$L['table']}.sample4lang_name LIKE '%$value%' ";
						break;
					case "lang_iso":
						$sqlWhere .= "AND {$this->tableName}{$L['table']}.lang_iso = '$value' ";
						break;
					case "sample4_active":
						$sqlWhere .= "AND {$this->tableName}.sample4_active = '$value' ";
						break;
				}
			}
		}
		//<===
		
		$q="				
			SELECT 
				{$this->tableName}.{$this->idName}
			FROM 
				{$this->tableName}
				LEFT JOIN {$this->tableName}{$L['table']} ON 
							{$this->tableName}.{$this->idName} = {$this->tableName}{$L['table']}.{$this->idName} AND 
							{$this->tableName}{$L['table']}.{$L['id']}='{$defaultLangId}'
				,
				sample3
				LEFT JOIN sample3{$L['table']} ON 
							sample3.sample3_id = sample3{$L['table']}.sample3_id AND 
							sample3{$L['table']}.{$L['id']}='{$defaultLangId}'
			WHERE 
				{$this->tableName}.sample3_id=sample3.sample3_id
				{$sqlWhere}
			GROUP BY
				{$this->tableName}.{$this->idName}
		";
		$_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"]=$dbi->noRows($q);
		
		$q="
			SELECT 				
				{$this->tableName}.*, {$this->tableName}{$L['table']}_name,
				sample3{$L['table']}_name
			FROM 
				{$this->tableName}
				LEFT JOIN {$this->tableName}{$L['table']} ON 
							{$this->tableName}.{$this->idName} = {$this->tableName}{$L['table']}.{$this->idName} AND 
							{$this->tableName}{$L['table']}.{$L['id']}='{$defaultLangId}'
				,
				sample3
				LEFT JOIN sample3{$L['table']} ON 
							sample3.sample3_id = sample3{$L['table']}.sample3_id AND 
							sample3{$L['table']}.{$L['id']}='{$defaultLangId}'
			WHERE 			
				{$this->tableName}.sample3_id=sample3.sample3_id
				{$sqlWhere}
			GROUP BY
				{$this->tableName}.{$this->idName}
			ORDER BY 
				sample3.sample3_priority, sample3.sample3_id, 
				{$sqlSort}
			{$sqlLimit}
		";
		$res_idx=$dbi->query($q); $list = array(); $i=-1;
		while($rec=$dbi->getRow($res_idx))
		{
			$i++;
			$list[$i]=$rec;
			$list[$i]["del_op"] = $this->verifyDel($rec[$this->idName]);
		}
		
		return $list;
	}
	
	/**
	 * Verify item for remove operation
	 *
	 * @parameters: $id = item id
	 * @access: public
	 * @return: bool
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function verifyDel($id)
	{
		return true;
	}
	
    /**
	 * Delete multiple items
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function deleteMItems()
	{
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
        {
            if(isset($_POST["ids"]) && is_array($_POST["ids"]))
            {
				foreach($_POST["ids"] as $k=>$v)
                {
					$this->deleteItem($v);
                }
			}
        }	
	}
	
	/**
	 * Delete item
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function deleteItem($id)
	{		
		global $L;
		
		if($this->verifyDel($id))
		{
			//delete from lang table
			_sqlDel($this->tableName.$L['table'], $this->idName, $id);
			
			//remove files
			fileRemProcessing($this->tableName, $this->idName, $id, $this->uploadDir, $this->arrFileFields);
			
			//delete item			
			_sqlDel($this->tableName, $this->idName, $id);
		}
	}
}
?>