<?php
//#########################################################################//
//# Personne class
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 30.01.2008
//#########################################################################//

class personne
{
	var $tplName 		= "";
    var $moduleName 	= "";
    var $pagingAction 	= "";

    var $tableName 		= "personne";
    var $idName 		= "per_code";
	var $flagName 		= "";
	
	var $tableFields	= "";//array("civ_code", "per_nom", "per_prenom");
	
	/**
	 * Constructor
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function personne($action="")
	{
		$tableData = getTableFields($this->tableName,ROOT_DIR."DAO/ini/ran.ini");
		$this->tableFields = $tableData["fields"];
		
		switch($action)
	  	{	  		
	  		case "page_act":
				$this->page_act();
      		 	break;
      		
      		case "add_upd":
				$this->add_upd();
      		 	break;
      		
      		case "page_list":		
				$this->page_list();
      		 	break;      		       		
	  	}
	}
	
	/**
	 * Page act (add/upd form)
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function page_act()
	{
		global $smarty;
		
		objInitVar($this, "frontend/personne_act.tpl", "page_act", "", "", "", "");
		
		$form_act = array();
		
		$id="";
        if(isset($_GET['act']) && 'upd'==$_GET['act'] && isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
        {
			$daoInfo=DB_DataObject::factory($this->tableName);
			$daoInfo->whereAdd("{$this->idName}={$_GET[$this->idName]}");
			$daoInfo->find();
			$daoInfo->fetch();
			$form_act=$daoInfo->toArray();        	
			
			$form_act['act'] = 'upd';
        	$daoInfo->free();
        }
		else
		{
			if(isset($_POST))
				$form_act=$_POST;
							
			$form_act['act'] = 'add';					
		}
		
		//assign variables					
		$smarty->assign("form_act", htmlArrayFilter($form_act));
				
		// get civilite list
		$smarty->assign("civList", daoGetTableContent('civilite', 'civ_code', 'civ_libelle_long', 'civ_libelle_long', 0));		
		
		$smarty->display($this->tplName);		
	}
	
	/**
	 * Add/Update operation
	 * 
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function add_upd()
    {
    	global $dbi;
    	
    	if(isset($_POST['act']) && ($_POST['act']=="add" || $_POST['act']=="upd"))
        {
	    	$err=0;
        	
	    	$daoAct=DB_DataObject::factory($this->tableName);
	    	foreach($this->tableFields as $k=>$field)
	    	{
	    		$daoAct->$field=$_POST[$field];
	    	}
	    	
        	if($_POST['act']=="add")
	        {
	        	//check personne already exits
	        	$daoUnique=DB_DataObject::factory($this->tableName);
				$daoUnique->per_nom=$_POST['per_nom'];
				$daoUnique->per_prenom=$_POST['per_prenom'];
				if($daoUnique->count()==0)
				{
					//insert operation
					$id=$daoAct->insert();
				}
				else 
					$err=1;
	        }
	        else
	        {
	        	$id=$_POST[$this->idName];
	        	
	        	//check personne already exits
	        	$daoUnique=DB_DataObject::factory($this->tableName);
				$daoUnique->whereAdd("per_nom = '{$_POST['per_nom']}' AND per_prenom = {$_POST['per_prenom']}' AND per_code != '{$id}'");
				if($daoUnique->count()==0)
				{
					//edit operation
					$daoAct->get($id);
		            $daoAct->whereAdd("{$this->idName} = {$id}");
		            $daoAct->update();
				}
				else 
					$err=1;
	        }
	        $daoUnique->free();
	        
	        if(0==$err)
	        {
	        	redirect("index.php?obj={$_GET['obj']}&action=page_act&{$this->idName}={$id}&act=upd");
	        }
	        else
	        {
	        	global $smarty;
	        	
	        	$smarty->assign("err", $err);
	        	
	        	$this->page_act();
	        }
	    }
        else 
        	redirect("index.php?obj=front&action=page_invalid");
    }
    
    /**
	 * Page list/edit
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function page_list()
	{
		global $smarty;
		
		objInitVar($this, "frontend/personne_list.tpl", "personne_list", "page_list", "", "", "");
		
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
			$this->deleteMItems();
		
		$smarty->assign("recList", $this->getList());
		$smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);		
		
		// get civilite list
		$smarty->assign("civList", daoGetTableContent('civilite', 'civ_code', 'civ_libelle_long', 'civ_libelle_long', 0));
		
		$smarty->display($this->tplName);
	}
	
	/**
	 * Get Users List
	 *
	 * @access: public
	 * @return: array
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function getList()
	{
		$daoList = DB_DataObject::factory($this->tableName);
		
		if(isset($_POST["act"]) && $_POST["act"] == "search") search($this->moduleName);
		
		$sqlSort = newSort($this->moduleName, "{$this->tableName}.{$this->idName}", 'DESC');
       	$sqlLimit = paging($this->moduleName, $this->pagingAction);
		$sqlLimit = trim(str_replace(" LIMIT " ,"", $sqlLimit));
		$sqlLimitArr = explode(",", $sqlLimit);
		
		$myC = $_SESSION[SESS_IDX][$this->moduleName];		
		$vectSearch = (isset($myC["search"]) ? $myC["search"] : array());
		$sqlWhere="";
		if(count($vectSearch) > 0)
		{
			foreach($vectSearch as $key=>$value)
			{
				switch($key)
				{
					case "civ_code":
						$daoList->whereAdd("{$this->tableName}.civ_code = '$value'");
						break;					
					case "per_nom":
						$daoList->whereAdd("{$this->tableName}.per_nom LIKE '%{$value}%'");
						break;
					case "per_prenom":
						$daoList->whereAdd("{$this->tableName}.per_nom LIKE '%{$value}%'");
						break;					
				}
			}
		}
		
		$dao_civ = DB_DataObject::factory('civilite');
		$daoList->joinAdd($dao_civ, 'INNER');
		$_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"] = $daoList->count();
		$daoList->orderBy($sqlSort);
		$daoList->limit(trim($sqlLimitArr[0]), trim($sqlLimitArr[1]));
		
		$daoList->find();
		$recList=array(); $i=-1;
		while($daoList->fetch())
		{
			$i++;
			$recList[$i]=$daoList->toArray();
			
			$recList[$i]["del_op"] = $this->verifyDel($recList[$i][$this->idName]);
		}
		
		$daoList->free();
		
		return $recList;
	}
	
	/**
	 * Verify user for remove operation
	 *
	 * @access: public
	 * @return: bool
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function verifyDel($id)
	{
		if(daoCheckFieldExist("utilisateur", $this->idName, $id))
			return false;
		else 
			return true;
	}
	
	/**
	 * Delte items (multiple)
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
    function deleteMItems()
	{
		if(isset($_POST["act"]) && $_POST["act"]=="delete")
        {
            if(isset($_POST["ids"]))
            {    				
				foreach($_POST["ids"] as $k=>$v)
                {
					$this->deleteItem($v);
                }
			}
        }	
	}
	
	/**
	 * Delte item
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function deleteItem($id)
	{		
		if($this->verifyDel($id))
		{
			//delete item
			$daoDel=DB_DataObject::factory($this->tableName);
			$daoDel->get($id);
			$daoDel->delete();
		}
	}
}

?>