<?php
//#########################################################################//
//# Ajax Class
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 21.06.2006
//#########################################################################//

include(COMPONENT_DIR.'useful/extajax.class.php');

class ajax extends extajax
{
	/**
	 * Constructor
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function ajax($action="")
	{		
		switch($action)
	  	{
	  		case "set_pay_communes":
				$this->setPayCommunes();
      		 	break;      		
      		 	
      		case "set_prc_pbi":
				$this->setPrcPbi();
      		 	break;
      		 	
      		case "set_medecin_form_act":
				$this->setMedecinFormAct();
      		 	break;
      		 	
      		case "act_patient_comment":
				$this->actPatientComment();
      		 	break;
      		 	
      		case "medecin_search_result":
				$this->medecinSearchResult();
      		 	break;
      		 	
      		case "medecin_corespondant":
				$this->medecinCorespondant();
      		 	break;
      		 	
      		case "save_courrier_edite":
				$this->saveCourrierEdite();
      		 	break;
      		 	
      		case "pbiTestValue":
      			$this->pbiTestValue();
      		break;
	  	}
	  	
	  	exit;
	}
	
	/**
	 * Set Pay => Adr
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function setPrcPbi()
	{
		global $smarty;
		global $entityManager;
		
		objInitVar($this, "ajax/set_prc_pbi.tpl", "", "", "", "", "");
		
		$csl_code=null;
		
		if(isset($_GET['prc_code']) && is_numeric($_GET['prc_code']))
		{
			$prc_code=$_GET['prc_code'];
			
			if(isset($_GET['csl_code']) && is_numeric($_GET['csl_code']) && $_GET['csl_code']>0)
			{
				$csl_code=$_GET['csl_code'];

				if ($_GET['prc_code']==0){
					$_SESSION["prc_code0"][$csl_code] = 1;
				}
								
				if (isset($_SESSION["prc_code0"][$csl_code])){
					$prc_code=0;
				}
				
				$cslDet = getCslInfo($_GET['csl_code']);
				$patInfo=getPatientInfo($cslDet['per_code_pat']);

				//assign patient info
				$smarty->assign("cslDet", $cslDet);
				$smarty->assign("patInfo", $patInfo);				
			}
			
			$recList=array();
			
			$qb=$entityManager->createQueryBuilder();
			
			$qb->select(array('pbi', 'upa', 'tpb'))
			->from('RAN\Entity\ParametresBiologiques', 'pbi')
			->leftJoin('pbi.upaCode', 'upa')
			->leftJoin('pbi.tpbCode', 'tpb')
			->groupBy('pbi.pbiCode')
			->addOrderBy('tpb.tpbOrdre', 'ASC')
			->addOrderBy('pbi.pbiOrdre', 'ASC');
			
			if ($prc_code!=0)
			{
			    $qb->innerJoin('RAN\Entity\ProfilCsParamBio', 'prcpb','WITH', 'prcpb.pbiCode=pbi.pbiCode')
			       ->andWhere('prcpb.prcCode=:prcCode')->setParameter('prcCode',$prc_code);
			}				
			
			$cspbiValues=array();
			if(!is_null($csl_code)){
			    $qbVal=$entityManager->createQueryBuilder();
			    $qbVal->select(array('IDENTITY(cspbi.pbiCode) as pbiCode, cspbi.cpbValeur'))
			    ->from('RAN\Entity\ConsultParamBio', 'cspbi')
 			    ->andWhere('cspbi.cslCode=:cslCode')
 			    ->setParameter('cslCode', $entityManager->getReference('RAN\Entity\Consultation', $csl_code));
			    
			    $queryVal=$qbVal->getQuery();
			    $queryVal->setHint(Doctrine\ORM\Query::HINT_REFRESH, true);
			    
			    foreach($queryVal->getArrayResult() as $cspbi){
			        $cspbiValues[$cspbi['pbiCode']]=$cspbi['cpbValeur'];
			    }
			}
			
			
			$res_idx=$qb->getQuery()->getArrayResult();
			
			foreach($res_idx as $pbi){
			    $rec=doctrineArrayToLegacy($entityManager, 'RAN\Entity\ParametresBiologiques', $pbi);
			    
			    if(array_key_exists('upaCode', $pbi)){
			        $rec=array_merge($rec, doctrineArrayToLegacy($entityManager, 'RAN\Entity\UniteParam', $pbi['upaCode'], array('upaCode'=>'upa_code')));
			    }
			    else{
			        $rec=array_merge($rec, doctrineArrayToLegacy($entityManager, 'RAN\Entity\UniteParam', array()));
			    }
			    if(array_key_exists('tpbCode', $pbi)){
			        $rec=array_merge($rec, doctrineArrayToLegacy($entityManager, 'RAN\Entity\TypeParametreBiologique', $pbi['tpbCode'], array('tpbCode'=>'tpb_code')));
			    }
			    else{
			        $rec=array_merge($rec, doctrineArrayToLegacy($entityManager, 'RAN\Entity\TypeParametreBiologique', array()));
			    }
			    
			    if(array_key_exists($rec['pbi_code'],$cspbiValues)){
			        $rec['cpb_valeur']=$cspbiValues[$rec['pbi_code']];
			    }
			    else{
			        $rec['cpb_valeur']='';
			    }
			    if(!array_key_exists('pbi_val_defaut', $rec)){
			        $rec['pbi_val_defaut']='';
			    }
			    
			    $recList[$rec['tpb_code']][]=$rec;	
			}
			
			$smarty->assign("recList", $recList);
		}

		$smarty->display($this->tplName);
	}
	
	/**
	 * Set medecin form act
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function setMedecinFormAct()
	{
		global $smarty;
		global $entityManager;

		if(isset($_GET['form_type']) && $_GET['form_type']==2)//not utilisateur
		{
			objInitVar($this, "ajax/medecin_form_notuser.tpl", "", "", "medecin", "per_code", "");
			
			if(isset($_GET['per_code']) && $_GET['per_code']!="")
			{
				$per_code = $_GET['per_code'];
				
				$form_act=array();
				
				$form_act['per_code']=$per_code;
				$form_act['per']=getPerInfo($per_code);
				
				$smarty->assign("form_act", $form_act);
			}
			
			// get pay list
			$smarty->assign("payList", doctrineGetTableContent($entityManager, 'RAN\Entity\Pays', 'payCode', 'payNom', 'payNom', 0));		
			// get r�le list
			$smarty->assign("roleList", doctrineGetTableContent($entityManager, 'RAN\Entity\Role', 'rolCode', 'rolLibelle', 'rolLibelle', 0));
			// get centre de rattachement list
			$smarty->assign("cerList", doctrineGetTableContent($entityManager,'RAN\Entity\CentreDeRattachement', 'cerCode', 'cerNom', 'cerNom', 0));
			// get civilite list
			$smarty->assign("civList", doctrineGetTableContent($entityManager,'RAN\Entity\Civilite', 'civCode', 'civLibelleLong', 'civLibelleLong', 0));
			
			$smarty->display($this->tplName);
		}
		elseif(isset($_GET['form_type']) && $_GET['form_type']==1)//is utilisateur
		{
			objInitVar($this, "ajax/medecin_form_user.tpl", "", "", "", "", "");
			
			if(isset($_GET['per_code']))
			{
				$smarty->assign("per_code", $_GET['per_code']);
			}
			
			$qb=$entityManager->createQueryBuilder();
			$qb->addSelect('civ','per','uti')
			->from('RAN\Entity\Utilisateur', 'uti')
			->innerJoin('uti.perCodeUti', 'per')
			->innerJoin('per.civCode', 'civ');
			
			$sub = $entityManager->createQueryBuilder();
			$sub->select("med");
			$sub->from("RAN\Entity\Medecin","med");
			$sub->andWhere('med.perCode = per.perCode');
			
			$qb->andWhere($qb->expr()->not($qb->expr()->exists($sub->getDQL())));
			$qb->addOrderBy('per.perNom');
			$qb->addOrderBy('per.perPrenom');
			
			$usersNotMed=$qb->getQuery()->getArrayResult();
			
			$recList=array();
			foreach($usersNotMed as $userNotMed){
			    $datas=doctrineArrayToLegacy($entityManager, 'RAN\Entity\Utilisateur', $userNotMed);
			    if(array_key_exists('perCodeUti', $userNotMed)){
			        $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $userNotMed['perCodeUti']));
			        
			        if(array_key_exists('civCode', $userNotMed['perCodeUti'])){
			            $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Civilite', $userNotMed['perCodeUti']['civCode']));
			        }
			    }
			    
			    $recList[]=$datas;
			}
			
			$smarty->assign("recList", $recList);
			
			
			$smarty->display($this->tplName);
		}	
	}
	
	/**
	 * Set Patient Comment
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function actPatientComment()
	{
	    global $entityManager;
	    
	    //Valeur qui sera retournée
	    $returnValue='';
	    
	    //Si le code patient et le type de commentaire est fourni
		if(isset($_POST['per_code_pat']) && isset($_POST['pat_com_type']))		
		{
		    //On recupère les informations
			$per_code_pat=(int) $_POST['per_code_pat'];
			$pat_com_type=(int) $_POST['pat_com_type'];
			$pat_com_txt=utf8_decode($_POST['pat_com_txt']);
			
			//Si on est dans une action de mise à jour avec des informations à priori correctes
			if(isset($_POST['act']) && 'act'==$_POST['act'] && $per_code_pat>0 && $pat_com_type>0)
			{      
			    //On essaie de recuperer le commentaire du patient pour le type fourni
			    $commentaire=$entityManager->getRepository('RAN\Entity\PatientComment')->findOneBy(array('perCodePat'=>$per_code_pat, 'patComType'=>$pat_com_type));
			    //S'il n'existe pas encore
			    if(is_null($commentaire)){
			       
			        //On initialise le nouveau commentaire
			        $commentaire=new RAN\Entity\PatientComment();
			    }
			    
			    //On met à jour les informations du commentaires
			    $commentaire->setPerCodePat($per_code_pat);
			    $commentaire->setPatComType($pat_com_type);
			    $commentaire->setPatComTxt($pat_com_txt);
			    
			    //On enregistre les modifications dans la transaction
			    $entityManager->persist($commentaire);
			    
			    //On valide la transaction
			    $entityManager->flush();
			}
			
			//On recupère le commentaire pour le patient et le type fourni
			$commentaire=$entityManager->getRepository('RAN\Entity\PatientComment')->findOneBy(array('perCodePat'=>$per_code_pat, 'patComType'=>$pat_com_type));
			
			//Si un commentaire existe
			if(!is_null($commentaire)){
			    //On assigne la valeur qui sera retournée à la valeur du commentaire
			    $returnValue=$commentaire->getPatComTxt();
			    
			}
			else{
			    //la valeur de retour sera une chaine vide
			    $returnValue='';
			}
			
		}
		//Si une donnée est manquante, on renvoie une erreur
		else{
		    $returnValue= "Informations incorrectes pour la récupération de commentaire patient";
		}
		
		//On ecrit le nouveau commentaire (utilisé pour le rendu de l'appel en ajax)
		echo $returnValue;
		
		return $returnValue;
	}
	
	/**
	 * Get Consultation distinct days
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	/*
	function getCslDays()
	{
		if(isset($_GET['per_code']) && $_GET['per_code']!='')
		{
			$per_code=(int) $_GET['per_code'];
			$m=(int) $_GET['m'];
			$y=(int) $_GET['y'];
			
			$strDate="";
			
			//get last consultation date
	    	$daoCsl = DB_DataObject::factory('consultation');
	    	$daoCsl->whereAdd("per_code_uti={$per_code} AND MONTH(csl_date)={$m} AND YEAR(csl_date)={$y}");
	    	$daoCsl->groupBy('consultation.csl_date');
	    	$daoCsl->orderBy('consultation.csl_date DESC');	
	    	$daoCsl->find();
			while($daoCsl->fetch())
			{
				$strDate.=$daoCsl->csl_date.",";
			}
	    	$daoCsl->free();
	    	
	    	if($strDate!="")
	    		$strDate=substr($strDate, 0, strlen($strDate)-1);
	    	
	    	echo $strDate;
		}
		
		exit;
	}
	*/
	
	/**
	 * Medecin Search Result
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function medecinSearchResult()
	{
		global $smarty;
		global $entityManager;
		
		objInitVar($this, "ajax/medecin_search_result.tpl", "medecin_search_result", "medecin_search_result", "", "", "");
		
		
	    if (isset($_POST["act"]) && $_POST["act"]=="search"){
			search($this->moduleName);
	    }
	    
	    if(isset($_SESSION[SESS_IDX][$this->moduleName])){
            $myC = $_SESSION[SESS_IDX][$this->moduleName];		
	    }
		
		$vectSearch = (isset($myC["search"]) ? $myC["search"] : array());
		
		$qb=$entityManager->createQueryBuilder();
		$qb->select('per', 'med', 'spm', 'civ', 'adr', 'cer')
		->from('RAN\Entity\Medecin', 'med')
		->join('med.spmCode', 'spm')
		->join('med.perCode', 'per')
		->join('per.cerCode', 'cer')
		->join('per.civCode', 'civ')
		->join('per.adrCode', 'adr')
		->addOrderBy('per.perNom')
		->addOrderBy('per.perPrenom');
		
		if(count($vectSearch) > 0)
		{
		    foreach($vectSearch as $key=>$value)
		    {
		        switch($key)
		        {
		            case "cer_code":
		                $qb->andWhere('med.cerCode=:cerCode')->setParameter('cerCode', $value);
		                break;
		            case "civ_code":
		                $qb->andWhere('per.civCode=:civCode')->setParameter('civCode', $value);
		                break;
		            case "per_nom":
		                $qb->andWhere('per.perNom like :perNom')->setParameter('perNom', $value.'%');
		                break;
		            case "per_prenom":
		                $qb->andWhere('per.perPrenom like :perPrenom')->setParameter('perPrenom', $value.'%');
		                break;
		            case "com_nom":
		                $qb->andWhere('adr.adrVille like :adrVille')->setParameter('adrVille', $value.'%');
						break;
					case "dep_nom":
					    $qb->andWhere('adr.depNom like :depNom')->setParameter('depNom', $value.'%');
						break;
		            case "spm_code":
		                $qb->andWhere('med.spmCode=:spmCode')->setParameter('spmCode', $value);
		                break;
		        }
		    }
		}
		
        $recList=array();
        if(count($vectSearch)>1){
            $medecins=$qb->getQuery()->getArrayResult();
            foreach($medecins as $medecin){
                $datas=doctrineArrayToLegacy($entityManager, 'RAN\Entity\Medecin', $medecin);
                
                if(array_key_exists('perCode', $medecin)){
                    $datas=array_merge($datas,doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $medecin['perCode']));
                    
                    if(array_key_exists('civCode', $medecin['perCode'])){
                        $datas=array_merge($datas,doctrineArrayToLegacy($entityManager, 'RAN\Entity\Civilite', $medecin['perCode']['civCode']));
                    }
                    
                    if(array_key_exists('adrCode', $medecin['perCode'])){
                        if(count($medecin['perCode']['adrCode'])>0){
                            $datas=array_merge($datas,doctrineArrayToLegacy($entityManager, 'RAN\Entity\AdressePostale', $medecin['perCode']['adrCode'][0]));
                        }
                    }
                    
                    if(array_key_exists('cerCode', $medecin['perCode'])){
                        $datas=array_merge($datas,doctrineArrayToLegacy($entityManager, 'RAN\Entity\CentreDeRattachement', $medecin['perCode']['cerCode']));
                    }
                }
                
                if(array_key_exists('spmCode', $medecin)){
                    $datas=array_merge($datas,doctrineArrayToLegacy($entityManager, 'RAN\Entity\SpecialiteMedicale', $medecin['spmCode']));
                }
                
               
                
                $recList[]=$datas;
            }
        }
		$smarty->assign("recList", $recList);
		$smarty->display($this->tplName);
		
		exit;
	}
	
	/**
	 * Add/Del/List Medecin Corespondant
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function medecinCorespondant()
	{
	    try{
    		global $smarty;
    		global $entityManager;
    		
    		objInitVar($this, "ajax/medecin_corespondant_list.tpl", "medecin_corespondant_list", "medecin_corespondant_list", "", "", "");
    		
    		if(isset($_GET['per_code_pat']))
    		{			
    			$per_code_pat=(int) $_GET['per_code_pat'];
    			
    			$csl_code=(int) (isset($_GET['csl_code'])?$_GET['csl_code']:0);
    			
    					
    			if(isset($_GET['per_code_med']))
    			{
    				$per_code_med=(int) $_GET['per_code_med'];
    				if(isset($_GET['act']) && $_GET['act']=='add')
    				{
    				    
    				    if(0==$entityManager->getRepository('RAN\Entity\PatientMedecinTrait')->count(array('perCodePat'=>$per_code_pat, 'perCodeMed'=>$per_code_med ))){
    				        error_log("Medecin traitant non existant pour le patient \r\n", 3, '/var/www/ran/tmp/error.logs');
    				        $medPatTrait=new RAN\Entity\PatientMedecinTrait();
    				        $medPatTrait->setPerCodePat($entityManager->getPartialReference('RAN\Entity\Patient', $per_code_pat));
    				        $medPatTrait->setPerCodeMed($entityManager->getPartialReference('RAN\Entity\Medecin', $per_code_med));
    				        $entityManager->persist($medPatTrait);
    				        $entityManager->flush();
    				    }
    				    else{
    				    }
    				}
    				elseif(isset($_GET['act']) && $_GET['act']=='del')
    				{
    				    $entries=$entityManager->getRepository('RAN\Entity\PatientMedecinTrait')->find(array('perCodePat'=>$per_code_pat, 'perCodeMed'=>$per_code_med ));
    				    foreach($entries as $entry){
    				        $entityManager->remove($entry);
    				    }
    				    $entityManager->flush();
    				    
    				}
    			}
    						
    			$recList=array();
    			
    			$medQb=$entityManager->createQueryBuilder();
    			$medQb->select('medTrait', 'med', 'spm', 'per','civ', 'cer', 'adr')
    			     ->from('RAN\Entity\PatientMedecinTrait', 'medTrait')
    			     ->innerJoin('medTrait.perCodeMed', 'med')
    			     ->leftJoin('med.spmCode', 'spm')
    			     ->leftJoin('med.perCode', 'per')
    			     ->leftJoin('per.civCode', 'civ')
    			     ->leftJoin('per.adrCode', 'adr')
    			     ->leftJoin('per.cerCode', 'cer')
    			     ->andWhere('medTrait.perCodePat=:perCodePat')->setParameter('perCodePat',$per_code_pat);
    			
                $medecinsTraitant=$medQb->getQuery()->getArrayResult();
    			
    			$i=-1;
    			foreach($medecinsTraitant as $medecinTraitant)
    			{
    				$i++;
    				
    				$datas=doctrineArrayToLegacy($entityManager, 'RAN\Entity\PatientMedecinTrait', $medecinTraitant);
    				if(array_key_exists('perCodeMed', $medecinTraitant)){
        				$datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Medecin', $medecinTraitant['perCodeMed']));
        				
        				if(array_key_exists('spmCode', $medecinTraitant['perCodeMed'])){
        				    $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\SpecialiteMedicale', $medecinTraitant['perCodeMed']['spmCode']));
        				}
        				if(array_key_exists('perCode', $medecinTraitant['perCodeMed'])){
        				    $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $medecinTraitant['perCodeMed']['perCode']));
        				
        				    if(array_key_exists('cerCode', $medecinTraitant['perCodeMed']['perCode'])){
        				        $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\CentreDeRattachement', $medecinTraitant['perCodeMed']['perCode']['cerCode']));
        				    }
        				    if(array_key_exists('civCode', $medecinTraitant['perCodeMed']['perCode'])){
        				        $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Civilite', $medecinTraitant['perCodeMed']['perCode']['civCode']));
        				    }
        				    if(array_key_exists('adrCode', $medecinTraitant['perCodeMed']['perCode'])){
        				        if(count($medecinTraitant['perCodeMed']['perCode']['adrCode'])>0){
        				            $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\AdressePostale', $medecinTraitant['perCodeMed']['perCode']['adrCode'][0]));
        				        }
        				    }
        				}
    				}
    				
    				$recList[$i]=$datas;
    				
    				if($csl_code>0)
    				{
    				    $recList[$i]['courrier_edite']=doctrineGetRowContent($entityManager, 'RAN\Entity\CourrierEdite', 'cslCode', $csl_code, 'perCode', $datas['per_code'], true);
    				}
    				else {
    					$recList[$i]['courrier_edite']=false;
    				}
    				
    			}
    			
    			$smarty->assign("recList", $recList);
    		}
    		$smarty->display($this->tplName);
    		exit;
	    }
	    catch(Exception $exception){
	        error_log($exception->getMessage()."\r\n", 3, '/var/www/ran/tmp/error.logs');
	    }
	}
	
	/**
	 * Save in CourrierEdite
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function saveCourrierEdite()
	{
		global $entityManager;
		
		
		if(isset($_GET['csl_code']))
		{
			$csl_code=(int) $_GET['csl_code'];
			
			if(isset($_POST['act']) && $_POST['act']=='save' && isset($_POST['str_med']))
			{
				$str_med=$_POST['str_med'];
				
				$tmp1=explode(',',$str_med);
				
				$c=-1;

				$medArr=array();
				foreach($tmp1 as $k=>$v)
				{
					if($v!='')
					{
						$tmp2=explode('-',$v);
						if($tmp2[0]!='' || $tmp2[1]!='')
						{
							$c++;
							
							$medArr[$c]['per_code']=$tmp2[0];
							$medArr[$c]['cou_lettre']=$tmp2[1];
						}
					}
				}
				
				$courriersEdites=$entityManager->getRepository('RAN\Entity\CourrierEdite')->findBy(array('cslCode'=>$csl_code));
				foreach($courriersEdites as $courriersEdite){
				    $entityManager->remove($courriersEdite);
				}
				$entityManager->flush();
				
				//insert new
				if(count($medArr)>0)
				{
					foreach($medArr as $k=>$v)
					{
					    $courrierEdite=new RAN\Entity\CourrierEdite();
					    $courrierEdite->setCslCode($entityManager->getReference('RAN\Entity\Consultation', $csl_code));
					    $courrierEdite->setPerCode($entityManager->getReference('RAN\Entity\Medecin', $v['per_code']));
					    $courrierEdite->setCouLettre($v['cou_lettre']);
					    $entityManager->persist($courrierEdite);
					}
					$entityManager->flush();
				}
			}//end post
		}
	}
	
	function pbiTestValue()
	{
	    global $entityManager;
		isset($_GET["pbi_code"]) ? $pbi_code = intval($_GET["pbi_code"]) : $pbi_code = 0;
		isset($_GET["pbi_val"]) ? $pbi_val = str_replace(",",".",$_GET["pbi_val"]) : $pbi_val = "";
		
		
		$pbi=$entityManager->find('RAN\Entity\ParametresBiologiques', $pbi_code);
		
		if ($pbi->getPbiFormat() != "")
		{
		    if ($pbi->getPbiFormat()=="INT" && $pbi_val != intval($pbi_val)){
		        echo "Vous devez entrer un nombre entier\n";
		    }
		    elseif ($pbi->getPbiFormat()=="FLOAT" && $pbi_val != (string)floatval($pbi_val)){
		        echo "Vous devez entrer un nombre a virgule\n";
		    }
		        
	        if (($pbi->getPbiMin()!="" && $pbi->getPbiMin()>$pbi_val) || ($pbi->getPbiMax()!="" && $pbi->getPbiMax()<$pbi_val))
	        {
	            if ($pbi->getPbiMin()!="" && $pbi->getPbiMax()!=""){
	                echo utf8_decode("Vous devez entrer une valeur entre ".$pbi->getPbiMin()." et ".$pbi->getPbiMax());
	            }
	            elseif ($pbi->getPbiMin()!=""){
	                echo utf8_decode("Vous devez entrer une valeur supérieure ou égale à ".$pbi->getPbiMin());
	            }
	            elseif ($pbi->getPbiMax()!=""){
	                echo utf8_decode("Vous devez entrer une valeur inférieure ou égale à; ".$pbi->getPbiMax());
	            }
	        }
		}
	
	}
}
?>
