<?php
//#########################################################################//
//# Front class
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 10.00.2008
//#########################################################################//

class front
{
	var $tplName 		= "";
    var $moduleName 	= "";
    var $pagingAction 	= "";

    var $tableName 		= "";
    var $idName 		= "";
	var $flagName 		= "";
	
	/**
	 * Constructor
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function front($action="")
	{
		switch($action)
	  	{	  		
      		case "patpbi_graph":
				$this->patpbi_graph();
      		 	break;
      		
      		case "page_invalid":
				$this->page_invalid();
      		 	break;
      		 	
      		case "access_denied":
				$this->access_denied();
      		 	break;
      		 	
      		default:
				$this->index();
      		 	break;
	  	}
	}
	
	/**
	 * Page Invalid
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function page_invalid()
	{
		global $smarty;
		objInitVar($this, "frontend/page_invalid.tpl", "", "", "", "", "");
		
		$smarty->display($this->tplName);
	}
	
	/**
	 * Access Denied
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function access_denied()
	{
		global $smarty;
		objInitVar($this, "frontend/access_denied.tpl", "", "", "", "", "");
		
		
		$smarty->display($this->tplName);
	}
	
	/**
	 * PBI Evolutions Graph
	 *
	 * @access: public
	 * @return: null
	 * @author: CFlorin (colotin_f@yahoo.com)
	*/
	function patpbi_graph()
	{		
	    global $entityManager;
		if(isset($_GET['per_code_uti']) && isset($_GET['pbi_code']))
		{
			$per_code_uti=(int) $_GET['per_code_uti'];
			$pbi_code=(int) $_GET['pbi_code'];
			
			
			$qb=$entityManager->createQueryBuilder();
			$qb->select('csl', 'cslpbi', 'pbi')
			 ->from('RAN\Entity\ConsultationParamBio', 'cslpbi')
			 ->innerJoin('cslpbi.cslCode', 'csl')
			 ->innerJoin('cslpbi.pbiCode', 'pbi')
			 ->andWhere('csl.perCodeUti=:perCodeUti')->setParameter('perCodeUti', $per_code_uti)
			 ->andWhere('pbi.pbiCode=:pbiCode')->setParameter('pbiCode', $pbi_code)
			 ->addOrderBy('csl.cslDate')
			 ->addOrderBy('csl.cslCode');

            $datax=array();
            $datay=array();
            $cslPbis=$qb->getQuery()->getResult();
            foreach($cslPbis as $cslPbi)
			{
			    $datax[]=$cslPbi->getCslCode()->getCslDate();
			    $datay[]=$cslPbi->getCslPbiValeur();
			}
        	
			
			print_r($datax);
			echo "<hr>";
			print_r($datay);
			
			
			
			include (LIB_DIR."jpgraph/jpgraph.php");
			include (LIB_DIR."jpgraph/jpgraph_line.php");
			
			
			// Setup graph
			$graph = new Graph(700,500,"auto");
			$graph->img->SetMargin(40,150,40,80);    
			$graph->SetScale("textlin");
			$graph->SetShadow();
			
			//Setup title
			$graph->title->Set("Prametre biologie evolution");
			
			// Use built in font
			$graph->title->SetFont(FF_COMIC,FS_NORMAL,14);
			
			// Slightly adjust the legend from it's default position
			$graph->legend->Pos(0.03,0.9,"right",400);
			$graph->legend->SetFont(FF_FONT1,FS_BOLD);
			
			// Setup X-scale
			$graph->xaxis->SetTickLabels($datax);
			$graph->xaxis->SetFont(FF_ARIAL,FS_NORMAL,8);
			$graph->xaxis->SetLabelAngle(45);
			
			// Create the first line
			$p1 = new LinePlot($datay);
			$p1->mark->SetType(MARK_FILLEDCIRCLE);
			$p1->mark->SetFillColor("red");
			$p1->mark->SetWidth(4);
			$p1->SetColor("blue");
			$p1->SetCenter();
			$p1->SetLegend("Poids value");
			$graph->Add($p1);
			
			
			// Output line
			$graph->Stroke();
		}
		
		exit;
	}
}

?>