<?php
//#########################################################################//
//# Patient class
//#
//# Author: SLY
//# Date: 17.03.2015
//#########################################################################//

use Doctrine\ORM\Query;

class greffe
{
	var $tplName 		= "";
    var $moduleName 	= "";
    var $pagingAction 	= "";

    var $tableName 		= "greffe";
    var $idName 		= "per_code";
	var $flagName 		= "";
	
	var $tableFields	  = ""; // array("per_code", "cdi_code", "cer_code", "pat_num_venue", "pat_nom_jf", "pat_sexe", "pat_dt_naiss", "pat_no_efg", "pat_no_ss", "pat_ipum", "pat_dossier_res", "pat_actif");
	
	var $select_yes_no = array(array(1,2),array('Oui','Non'));
	
	var $select_typeDonneur = array();
	
	var $select_sexe = array(array(1,2),array('M','F'));
	
	var $select_en = array(array('EP','IP'),array('Extra P&eacute;riton&eacute;al','Intra P&eacute;riton&eacute;al'));
	
	var $select_uretere = array(array(1,2),array('1','2'));
	

	function aw_decodeUtf8Value(&$item, $key){
	    $item = utf8_decode($item);
	}

		
	/**
	 * Constructor
	 *
	 * @access: public
	 * @return: null
	 */
	function greffe($action="")
	{
		//initialisation de la variable		
		$this->select_typeDonneur = $this->type_donneur();
				
		$tableData = getTableFields($this->tableName,ROOT_DIR."DAO/ini/ran.ini");
		$this->tableFields = $tableData["fields"];
		//var_dump($this->tableFields);
		
		//Si on detect de l'utf-8 dans l'encodage, on decode tous les param�tres POST
		//Permet de regler le probl�me des requ�tes AJAX
		if(isset($_SERVER['CONTENT_TYPE']) && strpos(strtoupper($_SERVER['CONTENT_TYPE']), 'UTF-8') >=0){
			array_walk_recursive($_POST, array($this, 'aw_decodeUtf8Value'));	
		}

		switch($action)
	  	{	  		
	  		case "page_greffe":
  			checkUtilisateurAccess('GREFFE', 'RW');
			$this->page_greffe();
      		 	break;
      		
      		case "onglet_donneur":
      			checkUtilisateurAccess('GREFFE', 'RW');
			$this->onglet_donneur();
      		 	break;
      		
      		case "onglet_greffe": 
      		 	checkUtilisateurAccess('GREFFE', 'RW');
      		 	$this->onglet_greffe();
      		 	break;

      		case "page_list":
      			checkUtilisateurAccess('GREFFE','R');
			$this->page_list();
      		 	break;

      		case "greffe_donneur_vivant":
      			checkUtilisateurAccess('GREFFE', 'RW');
      			$this->select_type_donneur("greffe_donneur_vivant");
      			break;
      			
      		case "greffe_donneur_decede":
      			checkUtilisateurAccess('GREFFE', 'RW');
      			$this->select_type_donneur("greffe_donneur_decede");
      			break;
      			
      		case "creer_greffe":
      			checkUtilisateurAccess('GREFFE', 'RW');
      			$this->create_greffe();
      			break;
      			
      		case "ajoutConditionImminoSupp":
      			checkUtilisateurAccess('GREFFE', 'RW');
      			$this->ajoutConditionImminoSupp();
      			break;
      			
      		case "delete_greffe":
      			//echo '<br> cas delete<br>';
      			checkUtilisateurAccess('GREFFE', 'RW');
      			$this->delete_greffe();
      			break;
      			
      		case "sauvegarde_onglet":
      			//echo '<br> cas sauvegarde<br>';
      			checkUtilisateurAccess('GREFFE', 'RW');
      			$this->sauvegarde_onglet();
      			break;
      		
      		case "consulte_greffe":
      			//echo '<br> cas consulte<br>';
      			checkUtilisateurAccess('GREFFE', 'RW');
      			$this->consulte_greffe();
      			break;
      			
      		case "sauve_greffe" :
      			checkUtilisateurAccess('GREFFE', 'RW');
      			$this->sauve_greffe();
      			break;
      			
	  	}
	}
	
	/**
	 * Page principale de la greffe
	 *
	 * @access: public
	 * @return: null
	*/
	function page_greffe()
	{
		global $smarty;
		global $entityManager;

		//initialise le template qui sera affich�
		objInitVar($this, "frontend/greffe.tpl", "page_greffe", "", "", "", "");
		
		if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
		{
			$per_code=$id=$_GET[$this->idName];
			//echo '<br>page_greffe per_code = '.$per_code;
			//recup�re les informatin du patient
			$patInfo=getPatientInfo($per_code);
			// on assigne les variables pour le template
			$smarty->assign("patInfo", $patInfo);
			
			$smarty->assign("causeList", doctrineGetTableContent($entityManager, 'RAN\Entity\FinFonctionGreffon', 'ffgCode', 'ffgLibelle','ffgOrdre', 0));
			$smarty->assign("yesNoList", $this->select_yes_no);
			
			// on affiche la page principale en mode add
			if (isset($_GET['gre_code']) && $_GET['gre_code']!='' && $_GET['act']=='add')
			{
				
			}
			
			// on affiche la page principale en mode update
			if (isset($_GET['gre_code']) && $_GET['gre_code']!='' && $_GET['act']=='upd')
			{
				
				//on charge toutes les liste d�roulantes du formulaire donneur_vivante et donneur_decede
			    $smarty->assign("stsList", doctrineGetTableContent($entityManager, 'RAN\Entity\StatutSerologie', 'stsCode', 'stsLibelle','', 0));
			    $smarty->assign("lipList", doctrineGetTableContent($entityManager, 'RAN\Entity\LiquidePerfusion', 'lipCode', 'lipLibelle','lipOrdre', 0));
			    $smarty->assign("cotList", doctrineGetTableContent($entityManager, 'RAN\Entity\Cote', 'cotCode', 'cotLibelle','', 0));
			    $smarty->assign("voaList", doctrineGetTableContent($entityManager, 'RAN\Entity\VoieAbord', 'voaCode', 'voaLibelle','', 0));
			    $smarty->assign("parList", doctrineGetTableContent($entityManager, 'RAN\Entity\Parente', 'parCode', 'parLibelle','parOrdre', 0));
			    $smarty->assign("gsaList", doctrineGetTableContent($entityManager, 'RAN\Entity\GroupeSanguin', 'gsaCode', 'gsaLibelle','', 0));
			    $smarty->assign("cadList", doctrineGetTableContent($entityManager, 'RAN\Entity\CauseDeces', 'cadCode', 'cadLibelle','cadOrdre', 0));
			    $smarty->assign("uretereList", $this->select_uretere);
			    $smarty->assign("sexeList", $this->select_sexe);
			    
				$gre_code=$_GET['gre_code'];
							 
				//on recup�re les informations de la greffe
				$greffe=$this->findGreffe($gre_code);
								
				//cas d'un update, on r�cup�re les informations pour affichage
				//on recherche les informations du donneur en fonction de la greffe qui est la page par defaut � afficher
    			$donneur=$this->searchDonneur($gre_code);
    			
//     			//recherche les information groupe HLA
     			$groupeHla=$this->findGroupeHla('form_greffe_donneur',$gre_code);
    			
//     			//recherche la s�rologie
     			$serologie=$this->findSerologie($gre_code);
     			
				//affecte les variables pour le template
				$smarty->assign("donneur", $donneur['info']);
    			$smarty->assign("typeDonneurSelect", $donneur['typeDonneur']);
				$smarty->assign("greffe", $greffe);
 				$smarty->assign("groupeHla", $groupeHla);
 				$smarty->assign("serologie", $serologie);
			}
		}
		
		//affecte les variables pour le template
		$smarty->assign("act", "upd");
		$smarty->assign("typeDonneur", $this->select_typeDonneur);
		//affiche le template
		$smarty->display($this->tplName);		
	}
	
	/**
	 * Charge l'onglet donneur et met � jour l'onglet greffe
	 * 
	 * @access: public
	 * @return: array
	*/
	function onglet_donneur()
	 {   	
	 	global $smarty;
	 	global $entityManager;
	 	$infoPost=array();
	 	//variable utiliser pour connaitre le mode d'affichage de la template et le type d'action, par defaut a add (add=ajout, upd=update)
	 	$actTemplate='add';
	 	$act='';
	 	//initialisation des variables de la classe pour affichage du template
	 	objInitVar($this, "ajax/greffe_donneur.tpl", "greffe_donneur", "", "", "", "");

	 	if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
    	{
    		//assigner les variables correspondant � une liste d�roulante � faire
    		$smarty->assign("stsList", doctrineGetTableContent($entityManager, 'RAN\Entity\StatutSerologie', 'stsCode', 'stsLibelle','', 0));
    		$smarty->assign("lipList", doctrineGetTableContent($entityManager, 'RAN\Entity\LiquidePerfusion', 'lipCode', 'lipLibelle','lipOrdre', 0));
    		$smarty->assign("cotList", doctrineGetTableContent($entityManager, 'RAN\Entity\Cote', 'cotCode', 'cotLibelle','', 0));
    		$smarty->assign("voaList", doctrineGetTableContent($entityManager, 'RAN\Entity\VoieAbord', 'voaCode', 'voaLibelle','', 0));
    		$smarty->assign("parList", doctrineGetTableContent($entityManager, 'RAN\Entity\Parente', 'parCode', 'parLibelle','parOrdre', 0));
    		$smarty->assign("sexeList", $this->select_sexe);
    		$smarty->assign("yesNoList", $this->select_yes_no);
    		$smarty->assign("gsaList", doctrineGetTableContent($entityManager, 'RAN\Entity\GroupeSanguin', 'gsaCode', 'gsaLibelle','', 0));
    		$smarty->assign("cadList", doctrineGetTableContent($entityManager, 'RAN\Entity\CauseDeces', 'cadCode', 'cadLibelle','cadOrdre', 0));
    		$smarty->assign("uretereList", $this->select_uretere);
    		
    		//on recupere le code de la greffe en cours
    		$gre_code = $_POST['gre_code'];
    		//on recupere le tableau $_POST dans une variable pour la passer en parametre
    		$infoPost=$_POST;
    	      			    		    		
    		//si la varaiable saveForm est renseign�
    		if (isset($_GET['saveForm']) && $_GET['saveForm']!=''){
    			//c'est un update, maj necessaire
    			$actTemplate='upd';
    			
    			if ($_GET['saveForm']=='form_greffe_greffe'){
    				// on met � jour la greffe
    				$this->upd_greffe($infoPost,$gre_code);
    			}
    			
    			if (($_GET['saveForm']=='form_greffe_donneur') && $infoPost['don_type']!='') {
    				// on met � jour le donneur
    				$this->add_upd_donneur($gre_code,$infoPost);
    			}
    			
    			//on recherche les informations du donneur en fonction de la greffe
    			$donneur=$this->searchDonneur($gre_code);
    			
    			//recherche les informations serologies
    			$serologie=$this->findSerologie($gre_code);
    			
    			//recherche le groupe HLA
    			$groupeHla=$this->findGroupeHla('form_greffe_donneur',$gre_code);
    			
    			//affecte les variables pour le template
    			$smarty->assign("groupeHla", $groupeHla);
    			$smarty->assign("serologie", $serologie);
    			$smarty->assign("donneur", $donneur['info']);
    			$smarty->assign("typeDonneurSelect", $donneur['typeDonneur']);
    			
    		} else {
    			//c'est un ajout, affiche le template 
    			$actTemplate='add';
    			   			
     		}
    		
    		
    	}
	 	
    	//recupere les information du patient
    	$per_code=$_GET[$this->idName];
    	$patInfo=getPatientInfo($per_code);
    	
    	//affecte les varibales au template
    	$smarty->assign("act", $actTemplate);
    	$smarty->assign("patInfo", $patInfo);
    	$smarty->assign("typeDonneur", $this->select_typeDonneur);
    	$smarty->assign("UL", $_SESSION[SESS_IDX][UL]);
    	
    	//affiche le template
    	$smarty->display($this->tplName);
        
		exit;
   
    }
    
    /**
     * Ajoute ou met a jour un donneur
     * 
     * @param: code greffe,
     * 		   action a effectuer,
     * 		   array() tableau contenant les valeurs des champs
     * @access: public
     * @return: array
     */
    function add_upd_donneur($gre_code,$infoPost){
        global $entityManager;

        $type_Donneur="";
    	
    	$typedDonneur=null;
    	
    	
    	$donneur=$entityManager->getRepository('RAN\Entity\Donneur')->findOneBy(array('greCode'=> $gre_code));
    	
    	if(is_null($donneur)){
    	    $donneur=new RAN\Entity\Donneur();
    	}
    	
		//creation d'une connection a la table donneur_vivant ou donneur_decede en fonction du type de donneur
    	if ($infoPost['don_type']=="0"){
    	    $typedDonneur=$entityManager->getRepository('RAN\Entity\DonneurVivant')->findOneBy(array('greCode'=> $gre_code));
    	    if(is_null($typedDonneur)){
    	       $typedDonneur = new RAN\Entity\DonneurVivant();
    	    }
    	    $type_Donneur="donneur_vivant";
    	}else{
    	    $typedDonneur=$entityManager->getRepository('RAN\Entity\DonneurDecede')->findOneBy(array('greCode'=> $gre_code));
    	    if(is_null($typedDonneur)){
    	       $typedDonneur = new RAN\Entity\DonneurDecede();
    	    }
    	    $type_Donneur="donneur_decede";
    	}
    	
    	
    	//on affecte la valeur des champs de la table donneur
    	$this->affectFieldDonneur($donneur,$type_Donneur,$gre_code,$infoPost);
    	
    	//on affecte la valeur des champs de la table donneur_vivant ou donneur_decede
    	$this->affectFieldTypeDonneur($typedDonneur,$type_Donneur,$gre_code,$infoPost);
    	
    	if(is_a($typedDonneur, 'RAN\Entity\DonneurDecede')){
    	    $dovs=$entityManager->getRepository('RAN\Entity\DonneurVivant')->findBy(array('greCode'=> $gre_code));
    	    foreach($dovs as $dov){
    	        $entityManager->remove($dov);
    	    }
    	}
    	if(is_a($typedDonneur, 'RAN\Entity\DonneurVivant')){
    	    $dods=$entityManager->getRepository('RAN\Entity\DonneurDecede')->findBy(array('greCode'=> $gre_code));
    	    foreach($dods as $dod){
    	        $entityManager->remove($dod);
    	    }
    	}
    	
    	$entityManager->persist($donneur);
    	
    	$entityManager->persist($typedDonneur);

    	$entityManager->flush();
    }
    
     /**
     * Charge l'onglet greffe et met � jour l'onglet donneur
     *
     * @access: public
     * @return: array
     */
    function onglet_greffe()
    {
    	global $smarty;
    	global $entityManager;
    	
    	$infoPost=array();
    	$conditionImmunoSupp=array();
    	//initialisation des variables de la classe pour affichage du template
    	objInitVar($this, "ajax/greffe_greffe.tpl", "greffe_greffe", "", "", "", "");
    	
    	if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
    	{
    		//affecte les variables des listes deroulantes pour le template
    	    $smarty->assign("tgrList", doctrineGetTableContent($entityManager, 'RAN\Entity\TypeGreffe', 'tgrCode', 'tgrLibelle','', 0));
    	    $smarty->assign("cotList", doctrineGetTableContent($entityManager, 'RAN\Entity\Cote', 'cotCode', 'cotLibelle','', 0));
    	    $smarty->assign("sviList", doctrineGetTableContent($entityManager, 'RAN\Entity\StatutVirologique', 'sviCode', 'sviLibelle','', 0));
    	    $smarty->assign("rimHlaList", doctrineGetTableContent($entityManager, 'RAN\Entity\RisqueImmunoHla', 'rimHlaCode', 'rimHlaLibelle','', 0));
    	    $smarty->assign("rimAboList", doctrineGetTableContent($entityManager, 'RAN\Entity\RisqueImmunoAbo', 'rimAboCode', 'rimAboLibelle','', 0));
    	    $smarty->assign("vihList", doctrineGetTableContent($entityManager, 'RAN\Entity\ValIncompatibiliteHla', 'vihCode', 'vihLibelle','', 0));
    	    $smarty->assign("cisList", doctrineGetTableContent($entityManager, 'RAN\Entity\CondImmunoSup', 'cisCode', 'cisLibelle','cisOrdre', 0));
    		$smarty->assign("yesNoList", $this->select_yes_no);
    		$smarty->assign("enList", $this->select_en);
    		
    		//on recupere le code de la greffe en cours
    		$gre_code = $_POST['gre_code'];
    		
    		//on recupere le tableau $_POST dans une variable pour la passer en parametre
    		$infoPost=$_POST;
    		
    		//si la varaiable saveForm est renseign�
    		if (isset($_GET['saveForm']) && $_GET['saveForm']!=''){
    			//ajoute ou met a jour la greffe
    			if ($_GET['saveForm']=='form_greffe_greffe'){
    				$this->upd_greffe($infoPost,$gre_code);
    			 }
    		 
    			 if ($_GET['saveForm']=='form_greffe_donneur'){
    		   		 //effectuer l'ajout ou la mise � jour pour le donneur
    		   		$this->add_upd_donneur($gre_code,$infoPost);
    		 	}
    		} else {
    			echo "Error lors du chargement de l'onglet greffe";
				exit;
    		}
    		
    		//recup�re les informations de la greffe 
    		$info_greffe=$this->findGreffe($gre_code);
    		
    		//recup�re le style/couleur d'affichage du rique immunologique
    		$styleRimHla=$this->styleRimHla($info_greffe["rim_hla_code"]);
    		$styleRimAbo=$this->styleRimAbo($info_greffe["rim_abo_code"]);
    		
    		//recup�re les informations groupe HLA
    		$groupehla=$this->findGroupeHla('form_greffe_greffe',$gre_code);
    		
    		//recup�re les informations statut virologique
    		$statutViro=$this->findStatutVirologique($gre_code);
    		//print_r($statutViro);
    		
    		//recup�re les informations conditionnements rique immuno supp
    		$conditionImmunoSupp=$this->findConditionImmunoSupp($gre_code);
    		
    		//recupere les information du patient
    		$per_code=$_GET[$this->idName];
    		$patInfo=getPatientInfo($per_code);
    		
    		//affecte les variables au template
    		$smarty->assign("greffe", $info_greffe); 
    		$smarty->assign("groupehla", $groupehla);
    		$smarty->assign("statutViro", $statutViro);
    		$smarty->assign("conditionImmunoSupp", $conditionImmunoSupp);
    		$smarty->assign("styleRimHla", $styleRimHla);
    		$smarty->assign("styleRimAbo", $styleRimAbo);
    		$smarty->assign("patInfo", $patInfo);
    	}
    	
    	//affiche le template
    	$smarty->display($this->tplName);
    	exit;
    }
    
    
    /**
     * Met � jour l'onglet greffe
     *
     * @access: public
     * 
     */
    function upd_greffe($infoPost,$gre_code){
    	
        global $entityManager;
        
    	$date='0000-00-00 00:00:00';
    	//ajout ou met a jour la table greffe_groupe_hla
    	$this->add_upd_greffeGroupeHla($gre_code,$infoPost);
    	
    	//ajout ou met a jour la table valeur_statut_viro
    	$this->add_upd_valeur_statut_viro($gre_code,$infoPost);
    	
    	//ajout ou met a met jour la table greffe_cond_immuno_supp
    	$this->add_upd_GreffeCondImmunoSupp($gre_code,$infoPost);
    	
    	$daoGreffe=$entityManager->find('RAN\Entity\Greffe', $gre_code);
    	$entityManager->refresh($daoGreffe);
    	
  	    //affecte les nouvelles valeurs
    	if(isset($infoPost['tgr_code']) && $infoPost['tgr_code']!=''){
    	   $daoGreffe->setTgrCode( $entityManager->getReference('\RAN\Entity\TypeGreffe', $infoPost['tgr_code']));
    	}
    	else{
    	    $daoGreffe->setTgrCode(null);
    	}
    	
    	if(isset($infoPost['rim_hla_code']) && $infoPost['rim_hla_code']!=''){
    	    $daoGreffe->setRimHlaCode( $entityManager->getReference('\RAN\Entity\RisqueImmunoHla', $infoPost['rim_hla_code']));
    	}
    	else{
    	   $daoGreffe->setRimHlaCode(null);
    	}
    	
    	if(isset($infoPost['rim_abo_code']) && $infoPost['rim_abo_code']!=''){
    	    $daoGreffe->setRimAboCode( $entityManager->getReference('\RAN\Entity\RisqueImmunoAbo', $infoPost['rim_abo_code']));
    	}
    	else{
    	    $daoGreffe->setRimAboCode(null);
    	}
    	
    	if(isset($infoPost['cot_code']) && $infoPost['cot_code']!=''){
    	    $daoGreffe->setCotCode( $entityManager->getReference('\RAN\Entity\Cote', $infoPost['cot_code']));
    	}
    	else{
    	    $daoGreffe->setCotCode(null);
    	}
    	
    	$daoGreffe->setGreChir($infoPost['gre_chir']);
    	
    	//concatenation des champs de declampage pour insertion en base de donn� au format yyyy/mm/dd 00:00:00
    	if ($infoPost['gre_declampage']!=''){
    	    $gre_date_clamp=$this->convertDateToInsert($infoPost['gre_declampage']);
    	    
    	    if(isset($infoPost['gre_heure_clamp']) && $infoPost['gre_heure_clamp']!=''){
    	       $heureClamp=$infoPost['gre_heure_clamp'].':00';
    	    }
    	    else{
    	        $heureClamp='00:00:00';
    	    }
    	    $date=$gre_date_clamp.' '.$heureClamp;
    	    
    	    $daoGreffe->setGreDeclampage(new DateTime($date));
    	}
    	else{
    	    $daoGreffe->setGreDeclampage(null);
    	}
    	
    	
    	$daoGreffe->setGreEn($infoPost['gre_en']);
    	
    	if($infoPost['gre_isch_totale']!=''){
    	    $daoGreffe->setGreIschTotale(new DateTime($infoPost['gre_isch_totale']));
    	}
    	else{
    	    $daoGreffe->setGreIschTotale(null);
    	}
    	
    	if($infoPost['gre_duree_anasto']!=''){
    	   $anatoTime='00:'.$infoPost['gre_duree_anasto'].':00';
    	   $daoGreffe->setGreDureeAnasto(new DateTime($anatoTime));
    	}
    	else{
    	    $daoGreffe->setGreDureeAnasto(null);
    	}
    	
    	$daoGreffe->setGreSondeJj($infoPost['gre_sonde_jj']);
    	
    	$daoGreffe->setGreCommentGreffe($infoPost['gre_comment_greffe']);
    	
    	$daoGreffe->setGreLieuGreffe($infoPost['gre_lieu_greffe']);
    	
    	$daoGreffe->setGreProtocole($infoPost['gre_protocole']);
    	
    	if  ($infoPost['gre_protocole'] == '1'){
    	    $daoGreffe->setGreCommentProtocole($infoPost['gre_comment_protocole']);
    	} else {
    	    $daoGreffe->setGreCommentProtocole('');
    	}
    	$daoGreffe->setGreDialyse($infoPost['gre_dialyse']);
    	
    	if($infoPost['gre_dt_der_dialyse']!=''){
    	   $dateDialyse=$this->convertDateToInsert($infoPost['gre_dt_der_dialyse']);
    	   $daoGreffe->setGreDtDerDialyse(new DateTime($dateDialyse));
    	}
    	else{
    	    $daoGreffe->setGreDtDerDialyse(null);
    	}
    	
    	$daoGreffe->setGreCommentRisqImmunoAbo($infoPost['gre_comment_risq_immuno_abo']);
    	$daoGreffe->setGreCommentRisqImmunoHla($infoPost['gre_comment_risq_immuno_hla']);
    	$daoGreffe->setGreCommentCis($infoPost['gre_comment_cis']); 
    	
    	$entityManager->persist($daoGreffe);
    	
    	$entityManager->flush();
    	
    }
    
    /**
     * Affiche le formulaire donneur decede ou donneur vivant en fonction du type de donneur s�lectionn�
     *
     * @access: public
     *
     */
    function select_type_donneur($type_donneur)
    {
    	global $smarty;
    	global $entityManager;
    	
    	objInitVar($this, "ajax/".$type_donneur.".tpl", $type_donneur, "", "", "", "");
    	
    	if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
    	{
    		//affectation des listes deroulantes
    		
    	    $smarty->assign("stsList", doctrineGetTableContent($entityManager, 'RAN\Entity\StatutSerologie', 'stsCode', 'stsLibelle','', 0));
    	    $smarty->assign("lipList", doctrineGetTableContent($entityManager, 'RAN\Entity\LiquidePerfusion', 'lipCode', 'lipLibelle','lipOrdre', 0));
    	    $smarty->assign("cotList", doctrineGetTableContent($entityManager, 'RAN\Entity\Cote', 'cotCode', 'cotLibelle','', 0));
    	    $smarty->assign("voaList", doctrineGetTableContent($entityManager, 'RAN\Entity\VoieAbord', 'voaCode', 'voaLibelle','', 0));
    	    $smarty->assign("parList", doctrineGetTableContent($entityManager, 'RAN\Entity\Parente', 'parCode', 'parLibelle','parOrdre', 0));
    	    $smarty->assign("sexeList", $this->select_sexe);
    	    $smarty->assign("yesNoList", $this->select_yes_no);
    	    $smarty->assign("gsaList", doctrineGetTableContent($entityManager, 'RAN\Entity\GroupeSanguin', 'gsaCode', 'gsaLibelle','', 0));
    	    $smarty->assign("cadList", doctrineGetTableContent($entityManager, 'RAN\Entity\CauseDeces', 'cadCode', 'cadLibelle','cadOrdre', 0));
    	    $smarty->assign("uretereList", $this->select_uretere);
    		    		
    		$per_code=$_GET[$this->idName];
    		$gre_code=trim($_POST['gre_code']);
    		
    		
    		//recupere les information du patient
    		$patInfo=getPatientInfo($per_code);
    		 		    		
    		//on recherche les informations du donneur en fonction de la greffe
    		$donneur=$this->searchDonneur($gre_code);
    		
    		//recherche les informations serologies
    		$serologie=$this->findSerologie($gre_code);
    		 
    		//recherche le groupe HLA
    		$groupeHla=$this->findGroupeHla('form_greffe_donneur',$gre_code);
    		
    		//affecte les variables � la template
    		$smarty->assign("patInfo", $patInfo);
    		$smarty->assign("donneur", $donneur['info']);
    		$smarty->assign("groupeHla", $groupeHla);
    		$smarty->assign("serologie", $serologie);
    		$smarty->assign("typeDonneurSelect", $donneur['typeDonneur']);
    	}
  		
    	$smarty->display($this->tplName);
    	
    	exit;
    }
    
    
    /**
	 * Page list/edit
	 *
	 * @access: public
	 * 
	*/
    function page_list()
	{
		global $smarty;
		
		objInitVar($this, "frontend/greffe_list.tpl", "greffe_list", "page_list", "", "", "");
		
		if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
		{	
			
			$per_code=$id=$_GET[$this->idName];
			
			//recupere les informations du patient
			$patInfo=getPatientInfo($per_code);
			
			//affecte les variables au template
			//liste des greffes pour le patient
			$smarty->assign("grefList", $this->getList());
			//variable moduleSession utilis� pour la pagination
			$smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);
			$smarty->assign("UL", $_SESSION[SESS_IDX][UL]);
			$smarty->assign("patInfo", $patInfo);
			//variable paging_options utilis� pour la pagination
			$smarty->assign("paging_options","&per_code=".$per_code);
		} 
		else
		{
			echo "Error!";
			exit;
		}
			$smarty->display($this->tplName);

	}
	
	/**
	 * Recup�re la liste des greffes d'un patient
	 *
	 * @access: public
	 * @return: array
	*/
    function getList()
	{
        global $entityManager;
        
        
	    
		//initialisation pour la pagination
       	$sqlLimit = paging($this->moduleName, $this->pagingAction);
		$sqlLimit = trim(str_replace(" LIMIT " ,"", $sqlLimit));
		$sqlLimitArr = explode(",", $sqlLimit);
		
		//affectation de la variable $per_code
		$per_code=$_GET[$this->idName];
		
		$qb=$entityManager->createQueryBuilder();
		$qb->select('gre')
            ->from('RAN\Entity\Greffe', 'gre')
            ->leftJoin('gre.tgrCode', 'tgr')
            ->andWhere('gre.perCode=:perCode')->setParameter('perCode', $per_code);
            
        $_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"] = count($qb->getQuery()->getResult());
    
        $qb->addOrderBy('gre.greDate');
        $qb->setFirstResult(trim($sqlLimitArr[0]))->setMaxResults(trim($sqlLimitArr[1]));
    
        $greffes = $qb->getQuery()->getArrayResult();
        
        $recList = array();
        $i = - 1;
        foreach ($greffes as $greffe) {
            $i ++;
            
            $datas=doctrineArrayToLegacy($entityManager, 'RAN\Entity\Greffe', $greffe);
            if(array_key_exists('tgrCode', $greffe)){
                $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Greffe', $greffe['tgrCode']));
            }
            else{
                $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\TypeGreffe', null));
            }
            $recList[$i] = $datas;
        }

        return $recList;
		
	
	}
	
	/**
	 * Creer la greffe (ajout)
	 * 
	 *
	 * * @access: public
	 */
	function create_greffe()
	{
	    global $entityManager;
	    
		if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
		{
			$per_code=$_GET[$this->idName];
			
			$greffe=new RAN\Entity\Greffe();
			$greffe->setGreChir("");
			$greffe->setGreDate(new DateTime($this->convertDateToInsert($_POST['gre_date'])));
			$greffe->setGreRang($_POST['gre_rang']);
			$greffe->setPerCode($entityManager->getReference('RAN\Entity\Personne', $per_code));
			
			if(isset($_POST['gre_greffon_fonct']) && is_numeric($_POST['gre_greffon_fonct'])){
			    $greffe->setGreGreffonFonct($_POST['gre_greffon_fonct']);
			    
			    if($_POST['gre_greffon_fonct']==2){
			        if(isset($_POST['ffg_code'])){
			            $greffe->setFfgCode($entityManager->getReference('RAN\Entity\FinFonctionGreffon', $_POST['ffg_code']));
			        }
			        else{
			            $greffe->setFfgCode(null);
			        }
			        
			        if (isset($_POST['gre_date_fin_fnc']) && $_POST['gre_date_fin_fnc']!=''){
			            $greffe->setGreDateFinFnc(new DateTime($this->convertDateToInsert($_POST['gre_date_fin_fnc'])));
			        }
			        else{
			            $greffe->setGreDateFinFnc(null);
			        }
			    }
			    else{
			        $greffe->setFfgCode(null);
			        $greffe->setGreDateFinFnc(null);
			    }
			}
			else{
			    $greffe->setGreGreffonFonct(null);
			    $greffe->setFfgCode(null);
			    $greffe->setGreDateFinFnc(null);
			}
			
			
			$entityManager->persist($greffe);
			$entityManager->flush();
			
			echo $greffe->getGreCode();
			return $greffe->getGreCode();
		}else{
			
			echo "Error!";
			exit;
		}
	}
	
	
	/**
	 * Recherche si le donneur existe
	 * (si le donneur existe pour la greffe)
	 *
	 * @param: code de la greffe
	 * @access: public
	 * @return: array
	 */
	function findDonneur($gre_code)
	{
		$donneur=array();
		
		//affectation de la condition dans une variable
		$sqlWhere="gre_code = '$gre_code'";
		//initialise une connexion � la table
		$daoDonneur = DB_DataObject::factory("donneur");
		//ajoute la condition
		$daoDonneur->whereAdd($sqlWhere);
		//effectue la recherche
		$num=$daoDonneur->find();
		
		if ($num>0){
			//se positionne sur la ligne suivante
			$daoDonneur->fetch();
			//recuprer la ligne courante sous forme de tableau
			$donneur = $daoDonneur->toArray();
		}
		
		//libere la ressource
		$daoDonneur->free();
			
		return $donneur;
	}
	
	/**
	 * Recherche le donneur
	 * (si le donneur existe pour la greffe)
	 *
	 * @param: code de la greffe
	 * @access: public
	 * @return: array
	 */
	function searchDonneur($gre_code){
        global $entityManager;
	    
		$typeDonneur='';
		
		$qb=$entityManager->createQueryBuilder();
		$qb->select('don', 'cot', 'lip', 'gsa')
		      ->from('RAN\Entity\Donneur', 'don')
		      ->leftJoin('don.cotCode', 'cot')
		      ->leftJoin('don.lipCode', 'lip')
		      ->leftJoin('don.gsaCode', 'gsa')
		      ->andWhere('don.greCode=:greCode')->setParameter('greCode', $gre_code);
		
		$donneurs=$qb->getQuery()->getArrayResult();
		
		$donDatas=array();
		
		if(count($donneurs)>0){
		    
		    $donDatas=doctrineArrayToLegacy($entityManager, 'RAN\Entity\Donneur', $donneurs[0],array('lip_code' => 'lip_perfusion'), 1, true);
		    
		    $qb->resetDQLParts();
		    $qb->select('dov')
		      ->from('RAN\Entity\DonneurVivant', 'dov')
		      
		      ->andWhere('dov.greCode=:greCode')->setParameter('greCode', $gre_code);
		    
		    $dovs=$qb->getQuery()->getArrayResult();
		    
		    if(count($dovs)==1){
		        $donDatas=array_merge($donDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\DonneurVivant', $dovs[0],array('lip_code' => 'lip_conservation'), 1, true));
		        $donDatas['tdd_code']=0;
		    }
		    else{
		        $qb=$qb->resetDQLParts();
		        $qb->select('dod')
		           ->from('RAN\Entity\DonneurDecede', 'dod')
		           ->andWhere('dod.greCode=:greCode')->setParameter('greCode', $gre_code);

		        $dods=$qb->getQuery()->getArrayResult();
		        
		        if(count($dods)==1){ 
		            $donDatas=array_merge($donDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\DonneurDecede', $dods[0],array('lipCode' => 'lip_conservation'), 1, true));
		        }
		    }
		    
		    if(isset($donDatas['don_taille']) && isset($donDatas['don_poids'])){
		        $donDatas['don_imc'] = number_format($donDatas['don_poids'] / (($donDatas['don_taille']/100) *($donDatas['don_taille']/100)) , 2);
		    }
		    
		    $typeDonneur=$donDatas['tdd_code'];
		}

		//affectation du tableau donneur
		$donneur=array("info"=>$donDatas, "typeDonneur"=>$typeDonneur);
		
		return $donneur;
	}
		
		/**
		 * Recherche le type de donneur (vivant ou decede)
		 *
		 * @param: code de la greffe,
		 * 		   la table (donneur_vivant ou donneur_decede) sur lequel faire la jointure pour r�cup�rer les informations du donneur
		 * @access: public
		 * @return: array
		 */
		function findTypeDonneur($gre_code)
		{
			$typeDonneur="";
			$sqlWhere="gre_code= '$gre_code'";
			//initialise une connexion a la table donneur_decede
			$daoTypeDonneur_decede = DB_DataObject::factory('donneur_decede');
			$daoTypeDonneur_decede->whereAdd($sqlWhere);
			$num_row_decede=$daoTypeDonneur_decede->find();
			$daoTypeDonneur_decede->free();
		
			//initialise une connexion a la table donneur_decede
			$daoTypeDonneur_vivant = DB_DataObject::factory('donneur_vivant');
			$daoTypeDonneur_vivant->whereAdd($sqlWhere);
			$num_row_vivant=$daoTypeDonneur_vivant->find();
			$daoTypeDonneur_decede->free();

			//test si c'est un donneur decede
			if ($num_row_decede>0){
				$typeDonneur='donneur_decede';
			}
			
			//test si c'est un donneur vivant
			if ($num_row_vivant>0){
				$typeDonneur='donneur_vivant';
			}
			
			return $typeDonneur;
		}
		
		/**
		 * Retourne l'action � effectuer pour le donneur
		 *
		 * @param: code de la greffe
		 * @access: public
		 * @return: String
		 */
		function actionDonneur($gre_code){
			//on effectue une recherche sur le code greffe
			$donneur=$this->findDonneur($gre_code);
		
			// si donneur existe, update
			if (count($donneur)>0){
				$act='upd';
			} else {
				// si existe pas, ajout
				$act='add';
			}
		
			return $act;
		}
		
		/**
		 * Retourne l'action � effectuer pour le type de donneur
		 *
		 * @param: code de la greffe
		 * @access: public
		 * @return: String
		 */
		function actionTypeDonneur($gre_code,$type_donneur_select){
			//on recherche le type de donneur en fonction du code greffe
			$typedonneur=$this->findTypeDonneur($gre_code);
			
			// si donneur existe et qu'il correspond au type de donneur selectionner
			if ($typedonneur==$type_donneur_select){
				//c'est un update
				$act='upd';
			} else {
				// le type de donneur exite pas ou est different de celui qui est selectione
				
				// si celui qui existe est different de celui qui est selectionner
				if ($typedonneur!='' && ($typedonneur!=$type_donneur_select)){
					// alors on supprime existant
					$condition="gre_code='$gre_code'";
					$req=$this->deleteData($condition,$typedonneur);
					if (!$req){
						echo 'Erreur lors de la supression du type de donneur dans la methode actionTypeDonneur';
						exit;
					}
				} 
				//action est un ajout
				$act='add';
			}
		
			return $act;
		}
		
		/**
		 * Recherche l'existance de la greffe
		 *
		 * @param: code de la greffe
		 * @access: public
		 * @return: array
		 */
		function findGreffe($gre_code){
			global $entityManager;
			
			$greDatas=array();
		
			$qb=$entityManager->createQueryBuilder();
			$qb->select('gre','tgr', 'ffg', 'cot', 'rimAbo', 'rimHla', 'per')
			     ->from('RAN\Entity\Greffe', 'gre')
			     ->leftJoin('gre.tgrCode', 'tgr')
			     ->leftJoin('gre.ffgCode', 'ffg')
			     ->leftJoin('gre.cotCode', 'cot')
			     ->leftJoin('gre.rimAboCode', 'rimAbo')
			     ->leftJoin('gre.rimHlaCode', 'rimHla')
			     ->leftJoin('gre.perCode', 'per')
			     ->andWhere('gre.greCode=:greCode')->setParameter('greCode', $gre_code);
			
			$greffes=$qb->getQuery()->setHint(Query::HINT_REFRESH,1)->getArrayResult();
			
			if(count($greffes)>0){
			    $greffe=$greffes[0];
			    $greDatas=doctrineArrayToLegacy($entityManager, 'RAN\Entity\Greffe', $greffe, null, 1, true);
			    
    			$donneur=$entityManager->getRepository('RAN\Entity\Donneur')->findOneBy(array('greCode'=>$gre_code));
    			if(!is_null($donneur)){
    			    $greDatas['rein']=$donneur->getCotCode()->getCotCode();
    			}
			}
		
			return $greDatas;
		}
		
		/**
		 * Affecte les valeurs au champs de la table donneur
		 *
		 * @param: connection a la table donneur passer par r�f�rence,
		 *         tableau $_POST qui contient les valeurs des champs
		 * @access: public
		 *
		 */
		function affectFieldDonneur(&$daoDonneur,$type_Donneur,$gre_code,$infoPost){
// 			$date='0000-00-00 00:00:00';
			global $entityManager;
			$daoDonneur->setGreCode($entityManager->getReference('RAN\Entity\Greffe', $gre_code));
			
			if(is_numeric($infoPost['lip_perfusion'])){
			    $daoDonneur->setLipCode($entityManager->getReference('RAN\Entity\LiquidePerfusion',$infoPost['lip_perfusion']));
			}
			else{
			    $daoDonneur->setLipCode(null);
			}
			$daoDonneur->setDonSexe($infoPost['don_sexe']);
			
			if(is_numeric($infoPost['don_age'])){
			    $daoDonneur->setDonAge($infoPost['don_age']);
			}
			else{
			    $daoDonneur->setDonAge(null);
			}
			$daoDonneur->setDonNumeroCristal($infoPost['don_numero_cristal']);
			
			if(is_numeric($infoPost['don_taille'])){
			     $daoDonneur->setDonTaille($infoPost['don_taille']);
			}
			else{
			    $daoDonneur->setDonTaille(null);
			}
			
			if(is_numeric($infoPost['don_poids'])){
			     $daoDonneur->setDonPoids($infoPost['don_poids']);
			}
			else{
			    $daoDonneur->setDonPoids($infoPost['don_poids']);
			}
			
			if(is_numeric($infoPost['gsa_code'])){
			    $daoDonneur->setGsaCode($entityManager->getReference('RAN\Entity\GroupeSanguin',$infoPost['gsa_code']));
			}
			else{
			    $daoDonneur->setGsaCode(null);
			}
			
			$daoDonneur->setDonChir($infoPost['don_chir']);
			
			if ($infoPost['don_date_clamp']!=''){
			    if($infoPost['don_heure_clamp']=='' || false==strpos($infoPost['don_heure_clamp'], ':')){
			        $heure_clamp='00:00:00';
			    }
			    else{
			        $heure_clamp=$infoPost['don_heure_clamp'].':00';
			    }
			    $tmpDate=new DateTime($this->convertDateToInsert($infoPost['don_date_clamp']).' '.$heure_clamp);
			    $daoDonneur->setDonDateClamp($tmpDate);
			}
			else{
			    $daoDonneur->setDonDateClamp(null);
			}
			
			//test le type de donneur pour affecter le champ commentaire pr�l�vement ou commentaire veine
			if ($type_Donneur!=='donneur_decede'){
			    $daoDonneur->setDonCommentVeine($infoPost['don_comment_veine']);
			}
			else{
			    $daoDonneur->setDonCommentVeine(null);
			}
			if(is_numeric($infoPost['cot_code'])){
			     $daoDonneur->setCotCode($entityManager->getReference('RAN\Entity\Cote', $infoPost['cot_code']));
			}
			else{
			    $daoDonneur->setCotCode(null);
			}
			$daoDonneur->setDonCommentRein($infoPost['don_comment_rein']);
			
			if(is_numeric($infoPost['don_princ'])){
			     $daoDonneur->setDonPrinc($infoPost['don_princ']);
			}
			else{
			    $daoDonneur->setDonPrinc(null);
			}
			
			if(is_numeric($infoPost['don_pol_sup'])){
        		$daoDonneur->setDonPolSup($infoPost['don_pol_sup']);
			}
			else{
			    $daoDonneur->setDonPolSup(null);
			}
			
			if(is_numeric($infoPost['don_pol_inf'])){
			     $daoDonneur->setDonPolInf($infoPost['don_pol_inf']);
			}
			else{
			    $daoDonneur->setDonPolInf(null);
			}
			
			if(is_numeric($infoPost['don_veine'])){
			     $daoDonneur->setDonVeine($infoPost['don_veine']);
			}
			else{
			    $daoDonneur->setDonVeine(null);
			}
			$daoDonneur->setDonMachPerf($infoPost['don_mach_perf']);
		}
		
		function getUploadedFileContent($fileInputName){
			if(isset($_FILES[$fileInputName])){
				if($_FILES[$fileInputName]['error']== UPLOAD_ERR_OK && isset($_FILES[$fileInputName]['temp_name'])){
					return file_get_contents($_FILES['nom_du_fichier']['temp_name']);
				}
			}
			return null;
		}


		/**
		 * Affecte les valeurs au champs de la table correspondant au type de donneur (donneur_vivant ou donneur_decede)
		 *
		 * @param: connection a la table correspondant au type de donneur passer par r�f�rence,
		 *         type de donneur (vivant ou decede),
		 *         code de la greffe,
		 *         tableau $_POST qui contient les valeurs des champs
		 * @access: public
		 *
		 */
		function affectFieldTypeDonneur(&$daoTypeDonneur,$type_donneur,$gre_code,$infoPost){
		    
		    global $entityManager;
		    
			//ajoute ou met a jour la table donneur_groupe_hla
 			$this->add_upd_donneurGroupeHla($gre_code,$infoPost);

// 			//ajoute ou met a jour la table serologie
       		$this->add_upd_donneurSerologie($gre_code,$infoPost);
			
			if(is_a($daoTypeDonneur, 'RAN\Entity\DonneurVivant')){
			    $daoTypeDonneur->setGreCode($entityManager->getReference('RAN\Entity\Greffe', $gre_code));
			    $daoTypeDonneur->setVoaCode($infoPost['voa_code']);
			    $daoTypeDonneur->setParCode($infoPost['par_code']);
			    $daoTypeDonneur->setDovNom($infoPost['dov_nom']);
			    $daoTypeDonneur->setDovPrenom($infoPost['dov_prenom']);
			    $daoTypeDonneur->setDovCreat($infoPost['dov_creat']);
			    $daoTypeDonneur->setDovClairCalc($infoPost['dov_clair_calc']);
			    $daoTypeDonneur->setDovClairIso($infoPost['dov_clair_iso']);
			    $daoTypeDonneur->setDovCommentClair($infoPost['dov_comment_clair']);
			    $daoTypeDonneur->setDovProteonurie($infoPost['dov_proteonurie']);
			    $daoTypeDonneur->setDovRobot($infoPost['dov_robot']);
			}
			else{
			    //affecte les valeurs aux champs de la table donneur_decede
			    $daoTypeDonneur->setGreCode($entityManager->getReference('RAN\Entity\Greffe', $gre_code));
			    $daoTypeDonneur->setTddCode($infoPost['don_type']);
			    $daoTypeDonneur->setCadCode($infoPost['cad_code']);
			    $daoTypeDonneur->setDodVille($infoPost['dod_ville']);
			    if(is_numeric($infoPost['lip_conservation'])){
			        $daoTypeDonneur->setLipCode($entityManager->getReference('RAN\Entity\LiquidePerfusion',$infoPost['lip_perfusion']));
			    }
			    else{
			        $daoTypeDonneur->setLipCode(null);
			    }
			    $daoTypeDonneur->setDodCommentDeces($infoPost['dod_comment_deces']);
			    $daoTypeDonneur->setDodCommentAnt($infoPost['dod_comment_ant']);
			    $daoTypeDonneur->setDodCritEtendus($infoPost['dod_crit_etendus']);
			    $daoTypeDonneur->setDodArretCoeur($infoPost['dod_arret_coeur']);
			    $daoTypeDonneur->setDodDureeArretCoeur($infoPost['dod_duree_arret_coeur']);
			    $daoTypeDonneur->setDodCommentAnt($infoPost['dod_comment_ant']);
			    $daoTypeDonneur->setDodCritEtendus($infoPost['dod_crit_etendus']);
			    $daoTypeDonneur->setDodArretCoeur($infoPost['dod_arret_coeur']);
			    $daoTypeDonneur->setDodDureeArretCoeur($infoPost['dod_duree_arret_coeur']);
			    $daoTypeDonneur->setDodPaMoyen($infoPost['dod_pa_moyen']);
			    $daoTypeDonneur->setDodAmines($infoPost['dod_amines']);
			    $daoTypeDonneur->setDodTransfusion($infoPost['dod_transfusion']);
			    $daoTypeDonneur->setDonCgr($infoPost['don_cgr']);
			    $daoTypeDonneur->setDonCpa($infoPost['don_cpa']);
			    $daoTypeDonneur->setDonPfc($infoPost['don_pfc']);
			    $daoTypeDonneur->setDonCreatArrivee($infoPost['don_creat_arrivee']);
			    $daoTypeDonneur->setDonCreatPrelev($infoPost['don_creat_prelev']);
			    $daoTypeDonneur->setDonDfg($infoPost['don_dfg']);
			    $daoTypeDonneur->setDonAtheAorte($infoPost['don_athe_aorte']);
			    $daoTypeDonneur->setDonPlaqAorte($infoPost['don_plaq_aorte']);
			    $daoTypeDonneur->setDonAtheOstium($infoPost['don_athe_ostium']);
			    $daoTypeDonneur->setDonPlaqOstium($infoPost['don_plaq_ostium']);
			    $daoTypeDonneur->setDonAtheArtereRein($infoPost['don_athe_artere_rein']);
			    $daoTypeDonneur->setDonPlaqArtereRein($infoPost['don_plaq_artere_rein']);
			    $daoTypeDonneur->setDonUretere($infoPost['don_uretere']);
			    $daoTypeDonneur->setDonPlaiesDigest($infoPost['don_plaies_digest']);
			    $daoTypeDonneur->setDonInfectLiquide($infoPost['don_infect_liquide']);
			    $daoTypeDonneur->setDonCommentInfectLiquide($infoPost['don_comment_infect_liquide']);
			    $daoTypeDonneur->setDonBiopsie($infoPost['don_biopsie']);
			    $daoTypeDonneur->setDonTxtBiopsie($this->getUploadedFileContent('don_txt_biopsie'));
			}
		}
		
		/**
		 * Ajoute ou met a jour la table donneur_groupe_hla
		 *
		 * @param: code greffe,
		 *         tableau $_POST qui contient les valeurs des champs
		 * @access: public
		 *
		 */
		function add_upd_donneurGroupeHla($gre_code,$infoPost){
		    global $entityManager;
		    		    
		    $oldValues=$entityManager->getRepository('RAN\Entity\DonneurGroupeHla')->findBy(array('greCode'=>$gre_code));
		    foreach($oldValues as $oldValue){
		        $entityManager->remove($oldValue);
		    }
		    
		    $entityManager->flush();
		    
		    
		    //parcours la liste de $_post
		    foreach ($infoPost as $cle=>$valeur){
		        //on traite que les champs dont les noms contiennent hla_code
		        if(stristr($cle, 'hla_code') !== false) {
		            
		            if(strlen($valeur) > 0){
		                //on split le nom  qui est de la forme hla_code_1_1 : hla_code nom du champs, 1 code hla, 1 rang du code hla
		                $cle_don_groupe_hla=explode("_", $cle);
		                
		                //code hla (exemple : 1=A, 2=B)
		                $hla_code=$cle_don_groupe_hla[2];
		                
		                //rang (exemple : 1 ou 2)
		                $rvh_code=$cle_don_groupe_hla[3];
		                
		                $donneurGroupeHla=new RAN\Entity\DonneurGroupeHla();
		                $donneurGroupeHla->setGreCode($gre_code);
		                $donneurGroupeHla->setHlaCode($entityManager->getReference('RAN\Entity\GroupeHla',$hla_code));
		                $donneurGroupeHla->setRvhCode($entityManager->getReference('RAN\Entity\RangValeurHla',$rvh_code));
		                $donneurGroupeHla->setDghValeur($valeur);
		                
		                $entityManager->persist($donneurGroupeHla);
		            }
		        }
		    }
		    
            $entityManager->flush();
		}
		
		/**
		 * Ajoute ou met a jour la table donneur_serologie
		 *
		 * @param: code greffe,
		 *         tableau $_POST qui contient les valeurs des champs
		 * @access: public
		 *
		 */
		function add_upd_donneurSerologie($gre_code,$infoPost){
		    global $entityManager;
		    
		    $oldValues=$entityManager->getRepository('RAN\Entity\DonneurSerologie')->findBy(array('greCode'=>$gre_code));
		    foreach($oldValues as $oldValue){
		      $entityManager->remove($oldValue);
		    }
		    
		    $entityManager->flush();
		    
		    //parcours la liste de post
		    foreach ($infoPost as $cle=>$valeur){
		        //on traite que les champs dont les noms contiennent hla_code
		        if(stristr($cle, 'ser_code') !== FALSE) {
		            //on split le nom  qui est de la forme ser_code_1 : ser_code nom du champs, 1 code serologie
		            $cle_don_ser=explode("_", $cle);
		            //code serologie (exemple : 1=CMV, 2=EBV)
		            $ser_code=$cle_don_ser[2];
		            
		            if(is_numeric($valeur)){
		            
		            	$donneurSerologie=new RAN\Entity\DonneurSerologie();
			            $donneurSerologie->setGreCode($entityManager->getReference('RAN\Entity\Greffe', $gre_code));
			            $donneurSerologie->setSerCode($entityManager->getReference('RAN\Entity\Serologie',$ser_code));
			            $donneurSerologie->setStsCode($entityManager->getReference('RAN\Entity\StatutSerologie',$valeur));
		            
		    	        $entityManager->persist($donneurSerologie);
		            }
		        }
		    }
		    
		    $entityManager->flush();
		}
		
		/**
		 * Ajoute ou met a jour la table valeur_statut_viro
		 *
		 * @param: code greffe,
		 *         tableau $_POST qui contient les valeurs des champs
		 * @access: public
		 *
		 */
		function add_upd_valeur_statut_viro($gre_code,$infoPost){
		    global $entityManager;
		    
		    $oldValues=$entityManager->getRepository('RAN\Entity\ValeurStatutViro')->findBy(array('greCode'=>$gre_code));
		    foreach($oldValues as $oldValue){
		        $entityManager->remove($oldValue);
		    }
		    $entityManager->flush();
		    
		    //parcours la liste de post
		    foreach ($infoPost as $cle=>$valeur){
		        //on traite que les champs dont les noms contiennent hla_code
		        if(stristr($cle, 'vir_code') !== false && $valeur!='') {
		            //on split le nom  qui est de la forme vir_code_1 : ser_code nom du champs, 1 code virus
		            $cle_vir_code=explode("_", $cle);
		            //code vir_code (exemple : 1=CMV, 2=EBV)
		            $vir_code=$cle_vir_code[2];
		            
		            
		            $vsv=new RAN\Entity\ValeurStatutViro();
		            
		            //affecte les valeurs aux champs
		            $vsv->setGreCode($entityManager->getReference('RAN\Entity\Greffe', $gre_code));
		            $vsv->setSviCode($entityManager->getReference('RAN\Entity\StatutVirologique', $valeur));
		            $vsv->setVirCode($entityManager->getReference('RAN\Entity\Virus', $vir_code));
		            
		            $entityManager->persist($vsv);
		        }
		    }
		    $entityManager->flush();
		}
		
		/**
		 * Ajoute ou met a jour la table greffe_groupe_hla
		 *
		 * @param: code greffe,
		 *         tableau $_POST qui contient les valeurs des champs
		 * @access: public
		 *
		 */
		function add_upd_greffeGroupeHla($gre_code,$infoPost){
		    global $entityManager;
		    
		    $oldValues=$entityManager->getRepository('RAN\Entity\GreffeIncompatibiliteHla')->findBy(array('greCode'=>$gre_code));
		    foreach($oldValues as $oldValue){
		        $entityManager->remove($oldValue);
		    }
		    $entityManager->flush();
		    
		    //parcours la liste de post
		    foreach ($infoPost as $cle=>$valeur){
		        //on traite que les champs dont les noms contiennent hla_code
		        if(strpos($cle, 'hla_code') === 0 && $valeur!='') {
		            
		            $gih=new RAN\Entity\GreffeIncompatibiliteHla();
		            
		            //on split le nom  qui est de la forme hla_code_1 : hla_code nom du champs, 1 code hla
		            $cle_don_groupe_hla=explode("_", $cle);
		            
		            //code hla (exemple : 1=A, 2=B)
		            $hla_code=$cle_don_groupe_hla[2];
		            
		            //affecte les valeurs aux champs
		            $gih->setGreCode($entityManager->getReference('RAN\Entity\Greffe', $gre_code));
		            $gih->setHlaCode($entityManager->getReference('RAN\Entity\GroupeHla', $hla_code));
		            $gih->setVihCode($entityManager->getReference('RAN\Entity\ValIncompatibiliteHla', $valeur));
		            
		            $entityManager->persist($gih);
		        }
		    }
		    $entityManager->flush();
		}
		
		/**
		 * Ajoute ou met a jour la table greffe_cond_immuno_supp
		 *
		 * @param: code greffe,
		 *         tableau $_POST qui contient les valeurs des champs
		 * @access: public
		 *
		 */
		function add_upd_GreffeCondImmunoSupp($gre_code,$infoPost){
		    
		    global $entityManager;
		    
		    $oldValues=$entityManager->getRepository('RAN\Entity\GreffeCondImmunoSupp')->findBy(array('greCode'=>$gre_code));
		    foreach($oldValues as $oldValue){
		        $entityManager->remove($oldValue);
		    }
		    $entityManager->flush();
		    
		    foreach ($infoPost as $cle=>$cis){
		        //on traite que le champ correspondant � cis_code qui est un tableau
		        if(stristr($cle, 'cis_code') !== false && count($cis)>0) {
		            //parcours le tableau contenant les valeurs de condition immuno � sauvegarder
		            foreach($cis as $valeur){
		                if($valeur!=''){
    		                $gcis=new RAN\Entity\GreffeCondImmunoSupp();
        		            
        		            //affecte les valeurs aux champs
    		                $gcis->setGreCode($entityManager->getReference('RAN\Entity\Greffe',$gre_code));
    		                $gcis->setCisCode($entityManager->getReference('RAN\Entity\CondImmunoSup', $valeur));
        		            
    		                $entityManager->persist($gcis);
		                }
		            }
		        }
		    }
		    $entityManager->flush();
		}
		
		/**
		 * Recherche le type de deces
		 *
		 * @param: code type decede,
		 *
		 * @access: public
		 * @return: array
		 */
		function findTypeDonneurDecede($tdd_code){
			//initialise une connection a la table
			$daoTypeDonneurDecede = DB_DataObject::factory("greffe_cond_immuno_supp");
			//effectue une recherche dans la table en fonction de la condition
			$daoTypeDonneurDecede->whereAdd("tdd_code= '$tdd_code'");
			//trouve les resultats
			$daoTypeDonneurDecede->find();
			//recup�re la ligne suivante
			$daoTypeDonneurDecede->fetch();
			//recup�re le resultat courant sous forme de tableau
			$type_Donneur_Decede=$daoTypeDonneurDecede->toArray();
			//libere la ressource
			$daoTypeDonneurDecede->free();
		
			return $type_Donneur_Decede;
		}
		
		/**
		 * R�cup�re les valeurs necessaires pour le champs type de donneur (vivant, decede)
		 *
		 *
		 * @access: public
		 * @return: array
		 */
		function type_donneur(){
		    global $entityManager;
			$type_donneur=array();
			
			$type_donneur=doctrineGetTableContent($entityManager, 'RAN\Entity\TypeDonneurDecede', 'tddCode', 'tddLibelle','', 0);
			
			//ajoute le type donneur vivant qui n'existe pas dans la table
			$type_donneur[0][]=0;
			$type_donneur[1][]='DV';
		
			return $type_donneur;
		}
		
		/**
		 * Convertit la date au bon format pour afficher dans le formulaire
		 *
		 * @param: un tableau contenant la definition d'une table
		 * @param: un tableau de resultat d'une requ�te passer par r�f�rence pour inserer la date au bon format pour affichage
		 * @access: public
		 * @return: un type de date
		 */
		function convertDateTodisplay($infoChamps,&$restable){
					
			//parcours la definition de la table pass�e en parametre - exemple pour la table greffe : (array(gre_code=>129,gre_date=>134...)
			foreach ($infoChamps as $champ=>$type){
				//traite l'affichage de la date en fonction de nom du champs
				//echo '<br>convertDateTodisplay type '.$type;
				switch($type)
				{
					//type date au format yyyy-mm-dd
					case ('134'):
					case ('6'):
						/*echo '<br>convertDateTodisplay tata';
						echo '<br>';
						var_dump($restable[$champ]);*/
						//si la chaine n'est pas cide et est diff�rent de '0000-00-00'
						if ((($restable[$champ]!='' && $restable[$champ]!='0000-00-00'))){
							//converti au format dd/mm/yyyy
							$restable[$champ]=date('d/m/Y', strtotime($restable[$champ]));
						} else {
							//sinon on affiche un champ vide
							$restable[$champ]='';
						}
						break;
					/*--------------------------------------------------------------------------------------*/
					//type datetime yyyy-mm-dd 00:00:00
					case '142':
					case '14':
						//echo '<br>convertDateTodisplay toto';
						//variable qui contient la valeur du champs date en cours
						$date='';
						//si c'est le champs don_date_clamp ou gre_declampage
						if ($champ=='don_date_clamp'||$champ=='gre_declampage'){
							
							//si la chaine n'est pas cide et est diff�rent de '0000-00-00 00:00:00'
							if ((($restable[$champ]!='' && $restable[$champ]!='0000-00-00 00:00:00'))){
								//converti au dd/mm/yyyy hh:mm
								$date=date('d/m/Y H:i', strtotime($restable[$champ]));
							}
							
							//echo '<br>recup date declampage '.$date;
							//split sur espace entre la date et heure
							if ($date!=''){
								$date=explode(" ",$date);
								//recup�re la date pour le champs du formulaire don_date_clamp
								$restable[$champ]=$date[0];
								if ($champ=='don_date_clamp'){
									//recup�re la date pour le champs du formulaire don_heure_clamp
									$restable['don_heure_clamp']=$date[1];
								} else {
									//recup�re la date pour le champs du formulaire don_heure_clamp
									$restable['gre_heure_clamp']=$date[1];
								}
							} else {
								//recup�re la date pour le champs du formulaire don_date_clamp
								$restable[$champ]='';
								//recup�re la date pour le champs du formulaire don_heure_clamp
								if ($champ=='don_date_clamp'){
									//recup�re la date pour le champs du formulaire don_heure_clamp
									$restable['don_heure_clamp']='';
								} else {
									//recup�re la date pour le champs du formulaire don_heure_clamp
									$restable['gre_heure_clamp']='';
								}
							}
						}
						break;
						/*--------------------------------------------------------------------------------------*/
						case '138':
							//echo '<br>convertDateTodisplay titi';
							//si c'est le champs gre_duree_anasto, on affiche que les minutes
							if ($champ=='gre_duree_anasto'){
								//si la chaine n'est pas vide et est diff�rent de '00:00:00'
								if ((($restable[$champ]!='' && $restable[$champ]!='00:00:00'))){
									//converti au format mm (afiche seulement les minutes)
									$restable[$champ]=date('i', strtotime($restable[$champ]));
								} else {
									//sinon on affiche un champ vide
									$restable[$champ]='';
								}
								
							}
							if ($champ=='gre_isch_totale'){
								//si la chaine n'est pas vide et est diff�rent de '00:00:00'
								if ((($restable[$champ]!='' && $restable[$champ]!='00:00:00'))){
									//converti au format hh:mm
									$restable[$champ]=date('H:i', strtotime($restable[$champ]));
								} else {
									//sinon on affiche un champ vide
									$restable[$champ]='';
								}
							}
						
						break;
						//sinon passe au suivant, si ne correspond a un type a traiter
						/*--------------------------------------------------------------------------------------*/
						default:
						//echo '<br>convertDateTodisplay tutu';
						break;
				}
			}
		}
		
		/**
		 * Convertit la date au bon format  pour insertion dans la base de donn�
		 *
		 * @param: date au format dd/mm/yyyy
		 * @access: public
		 * @return: date au format yyyy-mm-dd
		 */
		function convertDateToInsert($date){
			if ($date!=""){
				$tmp_date = explode("/",$date);
				$date= $tmp_date[2]."-".$tmp_date[1]."-".$tmp_date[0];
			}
			return $date;
		}
		
		/**
		 * Recherche le groupe hla correspondant au parametre
		 *
		 * @param: formulaire pour lequel on recherche le HLA (greffe ou donneur),
		 *         code greffe
		 * @access: public
		 * @return: tableau de r�sultat de la recherche formater pour affichage
		 */
		function findGroupeHla($formulaire,$gre_code){
		    global $entityManager;

			//tableau qui contient un tableau formater pour l'affichage
			$groupHlaDatas=array();
		
			if ($formulaire=="form_greffe_donneur"){
			    
			    $groupesHla=$entityManager->getRepository('RAN\Entity\DonneurGroupeHla')->findBy(array('greCode'=>$gre_code));
			    
			    foreach($groupesHla as $groupeHla){
			        //concateine les diff�rentes valeurs pour obtenir la cle pour affichage
			        $key="hla_code_".$groupeHla->getHlaCode()->getHlaCode()."_".$groupeHla->getRvhCode()->getRvhCode();
			        //affecte la valeur a la cle
			        $groupHlaDatas[$key]=$groupeHla->getDghValeur();
			    }
			} 
			else {
			    $groupesHla=$entityManager->getRepository('RAN\Entity\GreffeIncompatibiliteHla')->findBy(array('greCode'=>$gre_code));
			    
			    foreach($groupesHla as $groupeHla){
			        //concateine les diff�rentes valeurs pour obtenir la cle pour affichage
			        $key="hla_code_".$groupeHla->getHlaCode()->getHlaCode();
			        //affecte la valeur a la cle
			        $groupHlaDatas[$key]=$groupeHla->getVihCode()->getVihCode();
			    }
			}
			
			return $groupHlaDatas;
		}
		
		/**
		 * Recherche la serologie correspondant au parametre
		 *
		 * @param: code greffe
		 * @access: public
		 * @return: tableau de r�sultat de la recherche formater pour affichage
		 */
		function findSerologie($gre_code){
		    global $entityManager;
		    
		    //tableau qui contient un tableau formater pour l'affichage
		    $serologie=array();
		    
		    $donsSero=$entityManager->getRepository('RAN\Entity\DonneurSerologie')->findBy(array('greCode'=>$gre_code));
		    foreach($donsSero as $donSero){
		        //concateine les information pour obtenir la cle pour affichage
		        $key="ser_code_".$donSero->getSerCode()->getSerCode();
		        //affecte la valeur a la cle
		        $serologie[$key]=$donSero->getStsCode()->getStsCode();
		    }
		
			return $serologie;
		
		}
		
		/**
		 * Recherche le statut virologie correspondant au parametre
		 *
		 * @param: code greffe
		 * @access: public
		 * @return: tableau de r�sultat de la recherche formater pour affichage
		 */
		function findStatutVirologique($gre_code){
		    global $entityManager;
			$statutViro=array();
			
			$valsStatutViro=$entityManager->getRepository('RAN\Entity\ValeurStatutViro')->findBy(array('greCode'=>$gre_code));
			
			foreach($valsStatutViro as $valStatViro){
			    //concateine les informations pour obtenir la cle pour affichage
			    $key="vir_code_".$valStatViro->getVirCode()->getVirCode();
			    //affecte la valeur a la cle
			    $statutViro[$key]=$valStatViro->getSviCode()->getSviCode();
			}
		
			return $statutViro;
		
		}
		
		/**
		 * Cherche tous les condition immunosuppresseur en fonction du parametre
		 *
		 * @param: code greffe
		 * @access: public
		 * @return: tableau de r�sultat de la recherche formater pour affichage
		 */
		function findConditionImmunoSupp($gre_code){
		    global $entityManager;
		    
			//tableau qui contient le resultat de la requ�te
			$conditionImmunoSupp=array();
			
			$condsImSup=$entityManager->getRepository('RAN\Entity\GreffeCondImmunoSupp')->findBy(array('greCode'=>$gre_code));
		
			foreach($condsImSup as $idx=>$condImSup){
			    //affecte le tableau
			    $conditionImmunoSupp[$idx]=array('cis_code'=>$condImSup->getCisCode()->getCisCode());
			}
			
			return $conditionImmunoSupp;
		}
		/**
		 *  Ajoute les cellules d'une ligne du tableau condition immunosuppresseur de l'onglet greffe lorsqu'on ajoute une nouvelle ligne
		 *
		 * @param: code greffe
		 * @access: public
		 * @return: tableau de r�sultat de la recherche formater pour affichage
		 */
		function ajoutConditionImminoSupp(){
			global $smarty;
			global $entityManager;
			//initialise le template qui sera affich�
			objInitVar($this, "frontend/inc/cellTabListeCis.tpl", "cellTabListeCis", "ajoutConditionImminoSupp", "", "", "");
			
			if(isset($_GET[$this->idName]) && $_GET[$this->idName]!='')
			{
				$cisList=doctrineGetTableContent($entityManager, 'RAN\Entity\CondImmunoSup', 'cisCode', 'cisLibelle','cisOrdre', 0);
				$smarty->assign('nbElement',0);
				$smarty->assign('index',0);
				$smarty->assign("cisList", $cisList);
    			$smarty->display($this->tplName);
			} else {
				echo "Error ajout condition immuno supp";
				exit;
			}
		}
		
		/**
		 * Supprime un element d'une table
		 *
		 * @param: condition de recherche,
		 * 		   la table sur lequel on doit effectuer la supression
		 * @access: public
		 * @return: array
		 */
		function deleteData($condition,$table)
		{
			//initialise une connection a la table
			$daoTable = DB_DataObject::factory($table);
			//on ajoute le critere de condition de la recherche
			$daoTable->whereAdd($condition);
			//supprime le resultat correspondant � la recherche
			$result=$daoTable->delete(DB_DATAOBJECT_WHEREADD_ONLY);
			//libere la ressource
			$daoTable->free();
			
			return $result;
		}
		/**
		 * trouve un element d'une table en fonction de la condition
		 *
		 * @param: condition de recherche,
		 * 		   la table sur lequel on doit effectuer la supression
		 * @access: public
		 * @return: array
		 */
		function findData($condition,$table)
		{
            global $entityManager;
            
            return $entityManager->createNativeQuery('DELETE FROM '.$table.' WHERE '.$condition, null)->execute();
            
// 			//initialise une connection a la table
// 			$daoTable = DB_DataObject::factory($table);
// 			//on ajoute le critere de condition de la recherche
// 			$daoTable->whereAdd($condition);
// 			//on effectue la recherche
// 			$num=$daoTable->find();
// 			//libere la ressource	
// 			$daoTable->free();
			
// 			return $num;
				
		}
		
		
		/**
		 * Supprime une greffe
		 *
		 * @param: code de la greffe,
		 * 		   la table sur lequel on doit effectuer la supression
		 * @access: public
		 * @return: array
		 */
		function delete_greffe()
		{
			//test si url contient onglet qu'on sauvegarde et le code greffe
			if(isset($_GET['gre_code']) && $_GET['gre_code']!='')
			{
				$gre_code=$_GET['gre_code'];
				//supprime la greffe et toutes les donn�es li�es
				$condition="gre_code = '$gre_code'";
				
				//echo '<br>dans delete_greffe '.$gre_code;
				//supprime groupe HAL donneur si existe pour la greffe
				if ($this->findData($condition,'donneur_groupe_hla')){
					$this->deleteData($condition,'donneur_groupe_hla');
				}
				//supprime groupe HAL greffe si existe pour la greffe
				if ($this->findData($condition,'greffe_incompatibilite_hla')){
					$this->deleteData($condition,'greffe_incompatibilite_hla');
				}
				//supprime conditionnement immuno greffe
				if ($this->findData($condition,'valeur_statut_viro')){
					$this->deleteData($condition,'valeur_statut_viro');
				}
				//supprime serologie donneur
				if ($this->findData($condition,'donneur_serologie')){
					$this->deleteData($condition,'donneur_serologie');
				}
				//supprime le type de donneur
				if ($this->findData($condition,'greffe_cond_immuno_supp')){
					$this->deleteData($condition,'greffe_cond_immuno_supp');
				}
				//supprime le type donneur
				$tableTypeDonneur=$this->findTypeDonneur($gre_code);
				if ($tableTypeDonneur!=''){
					$this->deleteData($condition,$tableTypeDonneur);
				}
				//supprime le donneur
				if ($this->findData($condition,'donneur')){
					$this->deleteData($condition,'donneur');
				}
				//supprime la greffe
				if ($this->findData($condition,'greffe')){
					$this->deleteData($condition,'greffe');
				}
				
				$this->page_list();
			}
		}
		
		/**
		 * Sauvegarde l'onglet en cours et retourne sur la liste des greffes
		 *
		 * 
		 * @access: public
		 * @return: array
		 */
		function sauvegarde_onglet()
		{
			//test si url contient onglet qu'on sauvegarde et le code greffe
			if((isset($_GET['onglet']) && $_GET['onglet']!='') && (isset($_GET['gre_code']) && $_GET['gre_code']!='')){
				$infoPost=$_POST;
		
				$gre_code=$_GET['gre_code'];
				//si on sauvegarde l'onglet donneur
				if ($_GET['onglet']=='onglet_donneur'){
					//insert ou met a jour les informations du donneur
					$this->add_upd_donneur($gre_code,$infoPost);
				}	
				//si on sauvegarde l'onglet greffe
				if ($_GET['onglet']=='onglet_greffe'){
					//insert ou met a jour les informations du donneur
					$this->upd_greffe($infoPost,$gre_code);
				}
			}
			//affiche la liste des greffes
			$this->page_list();
		}
		
		/**
		 * Affiche les informations pour la consultation d'une greffe
		 *
		 */
		function consulte_greffe()
		{
			global $smarty;
			global $entityManager;
			
			$type='';
			$donneur=array();
			$greffe=array();
			//initialise le template � afficher
			objInitVar($this, "ajax/greffe_consultation.tpl", "consulte_greffe", "", "", "", "");
			
			//test si url contient le code greffe
			if(isset($_GET['gre_code']) && $_GET['gre_code']!='')
			{
				$gre_code = $_GET['gre_code'];
				//on recup�re les informations du donneur
				$donneur=$this->info_donneur($gre_code);
				//on recup�re les informations du donneur
				$greffe=$this->info_greffe($gre_code);

				
				if($donneur['don_type']!=0){
				    $typeDonneur='donneur_decede';
				    $qb=$entityManager->createQueryBuilder();
				    $qb->select('dd', 'cad')
				        ->from('RAN\Entity\DonneurDecede', 'dd')
				        ->leftJoin('dd.cadCode', 'cad')
				        ->andWhere('dd.greCode=:greCode')->setParameter('greCode', $gre_code);
				    
				    $results=$qb->getQuery()->getArrayResult();
				    
				        
				    $infoDonneurDecede=doctrineArrayToLegacy($entityManager, 'RAN\Entity\DonneurDecede', $results[0], array(), 1, true);
				    $smarty->assign("infoDonneurDecede", $infoDonneurDecede);
				}
				else{
				    $typeDonneur='donneur_vivant';
				}

				//on recup�re les informations d'incompatibilit� HLA
				$groupeHla=$this->info_incompatibilite_HLA($gre_code);
				//on recup�re les informations statut virologique
				$statutViro=$this->info_statut_virologique($gre_code);
				
				//traitement du champ don_sexe pour affichage
				if (count($donneur)>0){
					if ($donneur['don_sexe']==1){
						$donneur['don_sexe']='Homme';
					} else {
						if ($donneur['don_sexe']==2){
							$donneur['don_sexe']='Femme';
						}
					}
				}
			}
			
			//affectation des informations � la template
			$smarty->assign("donneur", $donneur);
			$smarty->assign("greffe", $greffe);
			$smarty->assign("groupeHla", $groupeHla);
			$smarty->assign("statutViro", $statutViro);
			$smarty->assign("typeDonneur", $typeDonneur);
			//affiche le template
			$smarty->display($this->tplName);
		}
		
		/**
		 * R�cup�re les informations de la greffe pour la consultation
		 *
		 * @param: code de la greffe,
		 * @access: public
		 * @return: array
		 * */
		function info_greffe($gre_code){

		    return $this->findGreffe($gre_code);
		}
		
		/**
		 * R�cup�re les informations du donneur pour la consultation d'une greffe
		 *
		 * @param: code de la greffe,
		 * @access: public
		 * @return: array
		 * */
		function info_donneur($gre_code){
		    
		    global $entityManager;
		    
		    $qb=$entityManager->createQueryBuilder();
		    
		    $qb->select('don', 'gsa')
		      ->from('RAN\Entity\Donneur', 'don')
		      ->leftJoin('don.gsaCode', 'gsa')
		      ->andWhere('don.greCode=:greCode')->setParameter('greCode', $gre_code);
		    
		
		    $results=$qb->getQuery()->getArrayResult();
		    
		    if(count($results)==1){
		       $donneur=doctrineArrayToLegacy($entityManager, 'RAN\Entity\Donneur', $results[0], null, 1, true);
		    }
					
			return $donneur;
		}
		
		
		
		/**
		 * R�cup�re les informations d'incompatibilit� HLA pour la consultation de la greffe
		 *
		 * @param: code de la greffe,
		 * @access: public
		 * @return: array
		 * */
		function info_incompatibilite_HLA($gre_code){
		    global $entityManager;
		    
		    //tableau qui contient un tableau formater pour l'affichage
		    $groupHlaDatas=array();
		    

	        $incompatibilitesHla=$entityManager->getRepository('RAN\Entity\GreffeIncompatibiliteHla')->findBy(array('greCode'=>$gre_code));
	        
	        foreach($incompatibilitesHla as $incompatibiliteHla){
	            //concateine les diff�rentes valeurs pour obtenir la cle pour affichage
	            $key=$incompatibiliteHla->getHlaCode()->getHlaLibelle();
	            //affecte la valeur a la cle
	            $groupHlaDatas[$key]=$incompatibiliteHla->getVihCode()->getVihLibelle();
	        }
		    
		    
		    return $groupHlaDatas;
		}
		
		/**
		 * R�cup�re les informations du statut virologique pour la consultation de la greffe
		 *
		 * @param: code de la greffe,
		 * @access: public
		 * @return: array
		 * */
		function info_statut_virologique($gre_code){
		    
		    
		    global $entityManager;
		    $statutViro=array();
		    
		    $valsStatutViro=$entityManager->getRepository('RAN\Entity\ValeurStatutViro')->findBy(array('greCode'=>$gre_code));
		    
		    foreach($valsStatutViro as $valStatViro){
		        //concateine les informations pour obtenir la cle pour affichage
		        $key=$valStatViro->getVirCode()->getVirLibelle();
		        //affecte la valeur a la cle
		        $statutViro[$key]=$valStatViro->getSviCode()->getSviLibelle();
		    }
		    
		    return $statutViro;
		}
		
		/**
		 * Sauvegarde la mise � jour des informations obligatoires pour la cr�ation de la greffe
		 *
		 * */
		function sauve_greffe(){
		    global $entityManager;
			if(isset($_POST['gre_code']) && $_POST['gre_code']!=''){
			    
			    $greffe=$entityManager->find('RAN\Entity\Greffe', $_POST['gre_code']);
			    
			    $greffe->setGreChir("");
			    $greffe->setGreDate(new DateTime($this->convertDateToInsert($_POST['gre_date'])));
			    $greffe->setGreRang($_POST['gre_rang']);
			    
			    if(isset($_POST['gre_greffon_fonct']) && is_numeric($_POST['gre_greffon_fonct'])){
			        $greffe->setGreGreffonFonct($_POST['gre_greffon_fonct']);
			     
        		    if($_POST['gre_greffon_fonct']==2){
        		        if(isset($_POST['ffg_code'])){
        		             $greffe->setFfgCode($entityManager->getReference('RAN\Entity\FinFonctionGreffon', $_POST['ffg_code']));
        		        }
        		        else{
        		            $greffe->setFfgCode(null);
        		        }
        		        
        			    if (isset($_POST['gre_date_fin_fnc']) && $_POST['gre_date_fin_fnc']!=''){
        			        $greffe->setGreDateFinFnc(new DateTime($this->convertDateToInsert($_POST['gre_date_fin_fnc'])));
        			    }
        			    else{
        			        $greffe->setGreDateFinFnc(null);
        			    }
        		    }
        		    else{
        		        $greffe->setFfgCode(null);
        		        $greffe->setGreDateFinFnc(null);
        		    }
			    }
			    else{
			        $greffe->setGreGreffonFonct(null);
			        $greffe->setFfgCode(0);
			        $greffe->setGreDateFinFnc(null);
			    }
			    
			    $entityManager->persist($greffe);
			    $entityManager->flush();
			}
		}
		
		/**
		 * Retourne la couleur d'affichage du texte risque immunologique 
		 *
		 * @param: id du risque immunologique,
		 * @access: public
		 * @return: string
		 * */
		function styleRimHla($value){
			$style='';
			switch ($value) {
				//non immunis� est affich� en vert
				case '1':
					$style ='#677E52' ;
					break;
				//immunis� sans DSA est affich� en orange
				case '2':
					$style ='#FF5B2B' ;
					break;
				//immunis� DSA et ABO incompatible est affich� en rouge.
				case '3':
				case '4':
					$style = '#E70739';
					break;
			    //sinon affiche normalement en noir
				default:
					$style = 'none';
					break;
			}
			return $style;
		}
		
		/**
		 * Retourne la couleur d'affichage du texte risque immunologique
		 *
		 * @param: id du risque immunologique,
		 * @access: public
		 * @return: string
		 * */
		function styleRimAbo($value){
			$style='';
			switch ($value) {
				//Compatible
				case '1':
					$style ='#677E52' ;
					break;
				//Incompatible
				case '2':
				case '3':
				case '4':
					$style = '#E70739';
					break;
					//sinon affiche normalement en noir
				default:
					$style = 'none';
					break;
			}
			return $style;
		}
}
?>
