<?php

// #########################################################################//
// # Medecin class
// #
// # Author: CFlorin (E-mail: colotin_f@yahoo.com)
// # Date: 13.02.2008
// #########################################################################//
class medecin
{

    var $tplName = "medecin";

    var $moduleName = "";

    var $pagingAction = "";

    var $tableName = "medecin";

    var $idName = "per_code";

    var $flagName = "";

    var $tableFields = "";

    // array("civ_code", "per_nom", "per_prenom");

    /**
     * Constructor
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function medecin($action = "")
    {
        $tableData = getTableFields($this->tableName, ROOT_DIR . "DAO/ini/ran.ini");
        $this->tableFields = $tableData["fields"];

        switch ($action) {
            case "page":
                checkUtilisateurAccess('MEDECIN');
                $this->page();
                break;

            case "add_upd":
                checkUtilisateurAccess('MEDECIN', 'RW');
                $this->add_upd();
                break;
        }
    }

    /**
     * Page (add/upd/list form)
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function page()
    {
        global $smarty, $entityManager;

        objInitVar($this, "frontend/medecin.tpl", "medecin", "page", "", "", "");

        if (isset($_POST["act"]) && $_POST["act"] == "delete") {
            $this->deleteMItems();
            redirect("index.php?obj={$_GET['obj']}&action={$_GET['action']}&act=upd");
        }

        $form_act = array();

        if (isset($_GET['act']) && 'upd' == $_GET['act'] && isset($_GET[$this->idName]) && $_GET[$this->idName] != '') {
            checkUtilisateurAccess('MEDECIN', 'RW');

            $form_act = getMedInfo($_GET[$this->idName]);
            $form_act['per_code'] = $_GET[$this->idName];
            $form_act['per'] = getPerInfo($_GET[$this->idName]);

            if (doctrineCheckFieldExist($entityManager, 'RAN\Entity\Utilisateur', 'perCodeUti', $_GET[$this->idName])) {
                $form_act['uti'] = doctrineGetRowContent($entityManager, 'RAN\Entity\Utilisateur', 'perCodeUti', $_GET[$this->idName], null, null, true);
                $form_act['form_type'] = 1;
            } else {
                $form_act['form_type'] = 2;
            }

            $form_act['act'] = 'upd';
        } else {
            if (isset($_POST)) {
                $form_act = $_POST;
            }

            $form_act['act'] = 'add';
        }

        // assign variables
        $smarty->assign("form_act", htmlArrayFilter($form_act));

        $smarty->assign("recList", $this->getList());
        $smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);

        // get specialite_medicale list
        $smarty->assign("spmList", doctrineGetTableContent($entityManager, 'RAN\Entity\SpecialiteMedicale', 'spmCode', 'spmLibelle', 'spmLibelle', 0));

        $smarty->display($this->tplName);
    }

    /**
     * Add/Update operation
     *
     * @access: public
     * @return: array
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function add_upd()
    {
        global $entityManager;

        checkUtilisateurAccess('MEDECIN', 'RW');

        if (isset($_POST['act']) && ($_POST['act'] == "add" || $_POST['act'] == "upd")) {
            $err = 0;

            $medecin = null;
            $personne = null;
            $adresse = null;

            if (isset($_POST[$this->idName])) {
                $medecin = $entityManager->find('RAN\Entity\Medecin', $_POST[$this->idName]);
                $entityManager->refresh($medecin);
            } else {
                $medecin = new RAN\Entity\Medecin();
            }

            $medecin->setSpmCode($entityManager->getReference('RAN\Entity\SpecialiteMedicale', $_POST['spm_code']));
            $medecin->setMedRpps($_POST['med_rpps']);

            // Si le medecin n'est pas un utilisateur
            if ($_POST['form_type'] == 2) {
                // Si la personne associée au medecin n'existe pas encore
                if (is_null($medecin->getPerCode())) {
                    // On créé la personne pour l'enregistrement
                    $personne = new RAN\Entity\Personne();
                    $medecin->setPerCode($personne);
                }

                // On met à jour les données sur la personne
                $personne = $medecin->getPerCode();
                $personne->setCivCode($entityManager->getReference('RAN\Entity\Civilite', $_POST['civ_code']));
                $personne->setPerNom($_POST['per_nom']);
                $personne->setPerPrenom($_POST['per_prenom']);

                // On met à jour le code du centre de rattachement
                if ($_POST['cer_code'] != "") {
                    $personne->setCerCode($entityManager->getReference('RAN\Entity\CentreDeRattachement', $_POST['cer_code']));
                } else {
                    $personne->setCerCode(null);
                }

                // On met à jour l'adresse de la personne
                $adresses = $personne->getAdrCode();
                if (count($adresses) == 0) {
                    $adresse = new RAN\Entity\AdressePostale();
                    $adresse->addPerCode($personne);
                } else {
                    $adresse = $adresses[0];
                }
                $adresse->setAdrVoie($_POST['adr_voie']);
                $adresse->setAdrCp($_POST['adr_cp']);
                $adresse->setAdrVille($_POST['adr_ville']);
            } // Si le medecin est un utilisateur
            else {
                if (! empty($_POST['per_code_uti'])) {
                    $medecin->setPerCode($entityManager->getReference('RAN\Entity\Personne', $_POST['per_code_uti']));
                } else {
                    echo "Error! Invalid per_code!";
                    exit();
                }
            }

            $entityManager->persist($medecin);
            $entityManager->persist($personne);
            $entityManager->persist($adresse);

            $entityManager->flush();

            if ($err == 0) {
                if (isset($_POST["back_url"]) && $_POST["back_url"] != "")
                    $url = string2var($_POST["back_url"]);
                else
                    $url = "index.php?obj={$_GET['obj']}&action=page&{$this->idName}={$id}&act=upd#med_form";

                redirect($url);
            } else {
                global $smarty;

                $smarty->assign("err", $err);

                $this->page();
            }
        }
        // else
        // redirect("index.php?obj=front&action=page_invalid");
    }

    /**
     * Get Users List
     *
     * @access: public
     * @return: array
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function getList()
    {
        global $entityManager;

        if (isset($_GET["init"])) {
            unset($_SESSION[SESS_IDX][$this->moduleName]);
        }

        if (isset($_POST["act"]) && $_POST["act"] == "search") {
            search($this->moduleName);
        }

        $sqlSort = newSort($this->moduleName, "{$this->tableName}.{$this->idName}", 'DESC');
        $sqlLimit = paging($this->moduleName, $this->pagingAction);
        $sqlLimit = trim(str_replace(" LIMIT ", "", $sqlLimit));
        $sqlLimitArr = explode(",", $sqlLimit);

        $myC = $_SESSION[SESS_IDX][$this->moduleName];

        $vectSearch = (isset($myC["search"]) ? $myC["search"] : array());

        $medQb = $entityManager->createQueryBuilder();
        $medQb->select('med','per', 'spm', 'adr','cer')
            ->from('RAN\Entity\Medecin', 'med')
            ->join('med.perCode', 'per')
            ->leftJoin('per.cerCode', 'cer')
            ->leftJoin('per.civCode', 'civ')
            ->leftJoin('med.spmCode', 'spm')
            ->leftJoin('per.adrCode', 'adr')
            ->addOrderBy('per.perNom')
            ->addOrderBy('per.perPrenom');

        $medecins = $medQb->getQuery()->getArrayResult();

        foreach ($vectSearch as $key => $value) {

            switch ($key) {
                case "per_nom":
                    $val = str_replace(" ", "%", $value);
                    $val = str_replace("-", "%", $val);
                    $medQb->andWhere("(per.perNom LIKE '$val%' or per.perNom LIKE '% $val%' or per.perNom LIKE '%-$val%')");
                    break;
                case "per_prenom":
                    $medQb->andWhere('(per.perPrenom LIKE :perPrenom)')->setParameter(':perPrenom', $value . '%');
                    break;
                case "spm_code":
                    $medQb->andWhere('(med.spmCode =:spmCode)')->setParameter(':spmCode', $value);
                    break;
                case "adr_ville":
                    $medQb->andWhere('adr.adrVille like :adrVille')->setParameter('adrVille', $value . '%');
                    break;
                case "adr_cp":
                    $medQb->andWhere('adr.adrCp like :adrCp')->setParameter('adrCp', $value . '%');
                    break;
            }
        }
        $_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"] = count($medQb->getQuery()->getResult());

        $medQb->orderBy('per.perNom');
        // $medQb->addOrderBy('spm.spmLibelle');
        $medQb->setFirstResult(trim($sqlLimitArr[0]))->setMaxResults(trim($sqlLimitArr[1]));

        $medecins = $medQb->getQuery()->getArrayResult();

        $recList = array();
        $i = - 1;
        foreach ($medecins as $medecin) {
            $i ++;
            $medecinAsArray = doctrineArrayToLegacy($entityManager, 'RAN\Entity\Medecin', $medecin);

            if (array_key_exists('perCode', $medecin)) {
                $medecinAsArray = array_merge($medecinAsArray, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $medecin['perCode']));

                if (array_key_exists('civCode', $medecin['perCode'])) {
                    $medecinAsArray = array_merge($medecinAsArray, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Civilite', $medecin['perCode']['civCode']));
                }

                if (array_key_exists('cerCode', $medecin['perCode'])) {
                    $medecinAsArray = array_merge($medecinAsArray, doctrineArrayToLegacy($entityManager, 'RAN\Entity\CentreDeRattachement', $medecin['perCode']['cerCode']));
                }

                if (array_key_exists('adrCode', $medecin['perCode'])) {
                    if (count($medecin['perCode']['adrCode']) > 0) {
                        $medecinAsArray = array_merge($medecinAsArray, doctrineArrayToLegacy($entityManager, 'RAN\Entity\AdressePostale', $medecin['perCode']['adrCode'][0]));
                    }
                }
            }

            if (array_key_exists('spmCode', $medecin)) {
                $medecinAsArray = array_merge($medecinAsArray, doctrineArrayToLegacy($entityManager, 'RAN\Entity\SpecialiteMedicale', $medecin['spmCode']));
            }

            $recList[$i] = $medecinAsArray;
            $recList[$i]["del_op"] = $this->verifyDel($recList[$i][$this->idName]);
        }

        return $recList;
    }

    /**
     * Verify user for remove operation
     *
     * @access: public
     * @return: bool
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function verifyDel($id)
    {
        global $entityManager;

        // on vérifie qu'il n'existe pas de consultation pour le medecin
        $result= ! doctrineCheckFieldExist($entityManager, '\RAN\Entity\Consultation', 'perCodeUti', $id);
        $result&= ! doctrineCheckFieldExist($entityManager, '\RAN\Entity\PatientMedecinTrait', 'perCodeMed', $id);
        return $result;
    }

    /**
     * Delte items (multiple)
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function deleteMItems()
    {
        if (isset($_POST["act"]) && $_POST["act"] == "delete") {
            if (isset($_POST["ids"])) {
                foreach ($_POST["ids"] as $k => $v) {
                    $this->deleteItem($v);
                }
            }
        }
    }

    /**
     * Delte item
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function deleteItem($id)
    {
        global $entityManager;
        checkUtilisateurAccess('MEDECIN', 'RW');

        if ($this->verifyDel($id)) {
            doctrineDelete($entityManager, 'RAN\Entity\Medecin', 'perCode', $id);
            delPer($id);
        }
    }
}

?>