<?php

// #########################################################################//
// # Medicament class
// #
// # Author: CFlorin (E-mail: colotin_f@yahoo.com)
// # Date: 25.02.2008
// #########################################################################//
class medicament
{

    var $tplName = "medicament";

    var $moduleName = "";

    var $pagingAction = "";

    var $tableName = "RAN\Entity\Medicament";

    var $idName = "medi_code";

    var $flagName = "";

    var $tableFields = "";

    /**
     * Constructor
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function medicament($action = "")
    {
        switch ($action) {
            case "page":
                checkUtilisateurAccess('MEDICAMENT');
                $this->page();
                break;

            case "add_upd":
                checkUtilisateurAccess('MEDICAMENT', 'RW');
                $this->add_upd();
                break;
        }
    }

    /**
     * Page (add/upd/list form)
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function page()
    {
        global $smarty;
        global $entityManager;

        objInitVar($this, "frontend/medicament.tpl", "medicament", "page", "", "", "");

        if (isset($_POST["act"]) && $_POST["act"] == "delete") {
            $this->deleteMItems();
            redirect("index.php?obj={$_GET['obj']}&action={$_GET['action']}&act=upd");
        }

        $form_act = array();

        if (isset($_GET['act']) && 'upd' == $_GET['act'] && isset($_GET[$this->idName]) && $_GET[$this->idName] != '') {
            checkUtilisateurAccess('MEDICAMENT', 'RW');

            $form_act = doctrineGetRowContent($entityManager, 'RAN\Entity\Medicament', 'mediCode', $_GET[$this->idName], null,null, true);

            $form_act['act'] = 'upd';
        } else {
            if (isset($_POST)) {
                $form_act = $_POST;
            }

            $form_act['act'] = 'add';
        }

        // assign variables
        $smarty->assign("form_act", htmlArrayFilter($form_act));

        $smarty->assign("recList", $this->getList());
        $smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);

        $smarty->display($this->tplName);
    }

    /**
     * Add/Update operation
     *
     * @access: public
     * @return: array
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function add_upd()
    {
        global $entityManager;

        if (isset($_POST['act']) && ($_POST['act'] == "add" || $_POST['act'] == "upd")) {
            try {
                $med = doctrineEntityFromForm($entityManager, 'RAN\Entity\Medicament', $_POST, false);
                $med->setMediDtCreat(new DateTime());
                $entityManager->persist($med);
                $entityManager->flush();
                $id = $med->getMediCode();

                redirect("index.php?obj={$_GET['obj']}&action=page&{$this->idName}={$id}&act=upd");
            } catch (Exception $err) {
                global $smarty;

                $smarty->assign("err", $err->getMessage());

                $this->page();
            }
        } else {
            redirect("index.php?obj=front&action=page_invalid");
        }
    }

    /**
     * Get Users List
     *
     * @access: public
     * @return: array
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function getList()
    {
        global $entityManager;

        if (isset($_POST["act"]) && $_POST["act"] == "search") {
            search($this->moduleName);
        }

        $sqlSort = newSort($this->moduleName, "medi_nom_com", 'ASC');
        $sqlLimit = paging($this->moduleName, $this->pagingAction);
        $sqlLimit = trim(str_replace(" LIMIT ", "", $sqlLimit));
        $sqlLimitArr = explode(",", $sqlLimit);
        
        $myC = $_SESSION[SESS_IDX][$this->moduleName];
        $vectSearch = (isset($myC["search"]) ? $myC["search"] : array());

        $qb = $entityManager->createQueryBuilder();
        $qb->select('med')->from('RAN\Entity\Medicament', 'med');

        if (count($vectSearch) > 0) {
            foreach ($vectSearch as $key => $value) {
                switch ($key) {
                    case "medi_nom_com":
                        $qb->andWhere('med.mediNomCom like :mediNomCom')->setParameter('mediNomCom', $value . '%');
                        // $daoList->whereAdd("medi_nom_com LIKE '%$value%'");
                        break;
                    case "medi_dci":
                        $qb->andWhere('med.mediDci like :mediDci')->setParameter('mediDci', '%' . $value . '%');
                        // $daoList->whereAdd("medi_dci LIKE '%$value%'");
                        break;
                    case "medi_dosage":
                        $qb->andWhere('med.mediDosage like :mediDosage')->setParameter('mediDosage', '%' . $value . '%');
                        // $daoList->whereAdd("medi_dosage LIKE '%{$value}%'");
                        break;
                    case "medi_unite":
                        $qb->andWhere('med.mediUnite like :mediUnite')->setParameter('mediUnite', '%' . $value . '%');
                        break;
                }
            }
        }

        $_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"] = count($qb->getQuery()->getResult());
        
        if(!empty($_SESSION[SESS_IDX][$this->moduleName]["sort"])){
            $order= $_SESSION[SESS_IDX][$this->moduleName]["sort"]['sense_sort'];
            switch ($_SESSION[SESS_IDX][$this->moduleName]["sort"]['field_sort']) {
                case "medi_nom_com":
                    $qb->addOrderBy('med.mediNomCom', $order);
                    break;
                case "medi_dt_creat":
                    $qb->addOrderBy('med.mediDtCreat', $order);
                    break;
                case "medi_dci":
                    $qb->addOrderBy('med.mediDci', $order);
                    break;
                case "medi_dosage":
                    $qb->addOrderBy('med.mediDosage', $order);
                    break;
                case "medi_unite":
                    $qb->addOrderBy('med.mediUnite', $order);
                    break;
            }
        }
        else{
            $qb->addOrderBy('med.mediNomCom');
        }
        

        $qb->setFirstResult(trim($sqlLimitArr[0]))->setMaxResults(trim($sqlLimitArr[1]));
        $medicaments = $qb->getQuery()->getArrayResult();

        $recList = array();
        $i = - 1;
        foreach ($medicaments as $medicament) {
            $i ++;
            $recList[$i] = doctrineArrayToLegacy($entityManager, 'RAN\Entity\Medicament', $medicament);

            $recList[$i]["del_op"] = $this->verifyDel($medicament['mediCode']);
        }

        return $recList;
    }

    /**
     * Verify user for remove operation
     *
     * @access: public
     * @return: bool
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function verifyDel($id)
    {
        global $entityManager;
        
        return ! doctrineCheckFieldExist($entityManager, 'RAN\Entity\Prescription', 'mediCode', $id);
    }

    /**
     * Delte items (multiple)
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function deleteMItems(){
        global $entityManager;
        if (isset($_POST["act"]) && $_POST["act"] == "delete") {
            if (isset($_POST["ids"])) {
                foreach ($_POST["ids"] as $v) {
                    $this->deleteItem($v, true);
                }
            }
        }
        $entityManager->flush();
    }

    /**
     * Delte item
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function deleteItem($id, $inTransaction = false)
    {
        global $entityManager;

        checkUtilisateurAccess('MEDICAMENT', 'RW');

        if ($this->verifyDel($id)) {
            $med = $entityManager->find('RAN\Entity\Medicament', $id);
            
            if (! is_null($med)) {
                $entityManager->remove($med);
                if (! $inTransaction) {
                    $entityManager->flush();
                }
            }
        }
    }
}

?>