<?php
// #########################################################################//
// # Patient class
// #
// # Author: CFlorin (E-mail: colotin_f@yahoo.com)
// # Date: 31.01.2008
// #########################################################################//
use Doctrine\ORM\Query\Expr\Join;

class patient
{

    var $tplName = "";

    var $moduleName = "";

    var $pagingAction = "";

    var $tableName = "patient";

    var $idName = "per_code";

    var $flagName = "";

    var $tableFields = "";

    // array("per_code", "cdi_code", "cer_code", "pat_num_venue", "pat_nom_jf", "pat_sexe", "pat_dt_naiss", "pat_no_efg", "pat_no_ss", "pat_ipum", "pat_dossier_res", "pat_actif");

    /**
     * Constructor
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function patient($action = "")
    {
        $tableData = getTableFields($this->tableName, ROOT_DIR . "DAO/ini/ran.ini");
        $this->tableFields = $tableData["fields"];

        // var_dump($this->tableFields);
        switch ($action) {
            case "page_act":
                checkUtilisateurAccess('PATIENT', 'RW');
                $this->page_act();
                break;

            case "add_upd":
                checkUtilisateurAccess('PATIENT', 'RW');
                $this->add_upd();
                break;

            case "page_list":
                checkUtilisateurAccess('PATIENT', 'R');
                $this->page_list();
                break;

            case "page_consultation":
                checkUtilisateurAccess('CONSULTATION');
                $this->page_consultation();
                break;

            case "patient_synthese":
                checkUtilisateurAccess('CONSULTATION');
                $this->patient_synthese();
                break;

            case "patient_synthese_bio":
                checkUtilisateurAccess('CONSULTATION');
                $this->patient_synthese_bio();
                break;

            case "patient_synthese_bio_export":
                checkUtilisateurAccess('CONSULTATION');
                $this->patient_synthese_bio_export();
                break;

            case "show_graph_pbi_pat":
                $this->showGraphPbiPat();
                break;

            case "medecin_correspondant":
                checkUtilisateurAccess('COMPTE_RENDU');
                $this->medecin_correspondant();
                break;

            case "compte_rendu":
                $this->compteRendu();
                break;

            case "csl_print":
                checkUtilisateurAccess('COMPTE_RENDU');
                $this->csl_print();
                break;

            case "patient_traitement":
                checkUtilisateurAccess('ORDONNANCE');
                $this->patient_traitement();
                break;

            case "prescription_search_result":
                $this->prescriptionSearchResult();
                break;

            case "traitement_form_add":
                $this->traitementFormAdd();
                break;

            case "ordonnance_print":
                checkUtilisateurAccess('ORDONNANCE');
                $this->ordonnance_print();
                break;

            case "medic_suggest":
                $this->medic_suggest();
                break;

            case "medic_info":
                $this->medic_info();
                break;

            case "medic_substituable":
                $this->medic_substituable();
                break;

            case "csl_del":
                checkUtilisateurAccess('CONSULTATION', 'RW');
                $this->csl_del();
                break;
        }
    }

    /**
     * Page act (add/upd form)
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function page_act()
    {
        global $entityManager;
        global $smarty;

        objInitVar($this, "frontend/patient_act.tpl", "page_act", "", "", "", "");

        $form_act = array();

        $id = "";
        if (isset($_GET['act']) && 'upd' == $_GET['act'] && isset($_GET[$this->idName]) && $_GET[$this->idName] != '') {
            $id = $_GET[$this->idName];

            $form_act = getPatientInfo($id);

            $form_act['act'] = 'upd';
        } else {
            if (isset($_POST))
                $form_act = $_POST;

            $form_act['act'] = 'add';
        }

        
        
        // assign variables
        $smarty->assign("form_act", htmlArrayFilter($form_act));

        // get typ telephone list
        $smarty->assign("typeTelList", doctrineGetTableContent($entityManager, 'RAN\Entity\TypeTelephone', 'tytCode', 'tytLibelle', 'tytLibelle', 0));
        // get centre dialyse list
        $smarty->assign("cdiList", doctrineGetTableContent($entityManager, 'RAN\Entity\CentreDialyse', 'cdiCode', 'cdiNom', 'cdiNom', 0));
        // get pay list
        $smarty->assign("payList", doctrineGetTableContent($entityManager, 'RAN\Entity\Pays', 'payCode', 'payNom', 'payNom', 0));
        // get type greffe list
        $smarty->assign("typeGreffeList", doctrineGetTableContent($entityManager, 'RAN\Entity\TypeGreffe', 'tgrCode', 'tgrLibelle', 'tgrLibelle', 0));
        // get type greffe list
        $smarty->assign("typeDialyseList", doctrineGetTableContent($entityManager, 'RAN\Entity\TypeDialyse', 'tydCode', 'tydLibelle', 'tydLibelle', 0));
        // get role list
        $smarty->assign("roleList", doctrineGetTableContent($entityManager, 'RAN\Entity\Role', 'rolCode', 'rolLibelle', 'rolLibelle', 0));
        // get centre de rattachement list
        $smarty->assign("cerList", doctrineGetTableContent($entityManager, 'RAN\Entity\CentreDeRattachement', 'cerCode', 'cerNom', 'cerNom', 0));
        // get civilite list
        $smarty->assign("civList", doctrineGetTableContent($entityManager, 'RAN\Entity\Civilite', 'civCode', 'civLibelleLong', 'civLibelleLong', 0));

        
        
        $smarty->display($this->tplName);
    }

    /**
     * Add/Update operation
     *
     * @access: public
     * @return: array
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function add_upd()
    {
        global $entityManager;
        if (isset($_POST['act']) && ($_POST['act'] == "add" || $_POST['act'] == "upd")) {
            $err = 0;

            // On récupère
            $patient = new RAN\Entity\Patient();
            if ($_POST['act'] == 'upd') {
                if ($_POST['per_code']) {
                    $patient = $entityManager->find('RAN\Entity\Patient', $_POST['per_code']);
                    $entityManager->refresh($patient);
                } else {
                    die('no percode');
                }
            }

            // Si le patient n'a pas de personne associée (création)
            if (is_null($patient->getPerCode())) {
                // On creer une nouvelle personne qu'on rattache au patient
                $patient->setPerCode(new RAN\Entity\Personne());
            }

            // On met à jour les données de la personne liée au patient
            $personne = $patient->getPerCode();
            $personne->setCerCode($entityManager->find('RAN\Entity\CentreDeRattachement', $_POST['cer_code']));
            $personne->setCivCode($entityManager->find('RAN\Entity\Civilite', $_POST['civ_code']));
            $personne->setPerNom($_POST['per_nom']);
            $personne->setPerPrenom($_POST['per_prenom']);

            // On recupere et met à toutes les données liées au patient
            $patMetadata = $entityManager->getClassMetadata('RAN\Entity\Patient');
            foreach ($patMetadata->getColumnNames() as $column) {
                if ($column != $this->idName && isset($_POST[$column])) {
                    if ($column == "pat_dt_naiss" || $column == "pat_dt_deces") {
                        $_POST[$column] = strlen(trim($_POST[$column])) > 0 ? new DateTime(date_fr_to_mysql($_POST[$column])) : new DateTime(null);
                    }

                    $patMetadata->setFieldValue($patient, $patMetadata->getFieldName($column), $_POST[$column]);
                }
            }

            // Si l'utilisateur a des adresses postales attachées
            if (! is_null($personne->getAdrCode())) {
                // On supprime les adresses postales
                $personne->getAdrCode()->clear();
            }

            // On supprime tous les numéros de téléphones attachés
            if (! is_null($personne->getPerTel())) {
                // Pour chaque lien rattachant la personne au téléphone
                foreach ($personne->getPerTel() as $perTel) {
                    // On supprime le téléphone (pas de cascade)
                    $entityManager->remove($perTel->getTelCode());
                    // On supprime le lien
                    $entityManager->remove($perTel);
                }
            }

            // On enregistre l'adresse postale de l'utilisateur
            $adrPostale = new RAN\Entity\AdressePostale();
            $adrPostale->setAdrVoie($_POST['adr_voie']);
            $adrPostale->setAdrCp($_POST['adr_cp']);
            $adrPostale->setAdrVille($_POST['adr_ville']);
            $adrPostale->addPerCode($personne);
            $entityManager->persist($adrPostale);

            $personne->addAdrCode($adrPostale);

            // On enregistre les téléphones de l'utilisateur
            for ($i = 0; $i < 5; $i ++) {
                if (isset($_POST['per_tel' . $i]) && $_POST['per_tel' . $i] != "") {

                    $tel = new RAN\Entity\Telephone();
                    $tel->setTelNumero($_POST['per_tel' . $i]);
                    $tel->setTytCode($entityManager->find('RAN\Entity\TypeTelephone', $_POST['per_tel' . $i . '_type']));

                    $perTel = new RAN\Entity\PersonneTelephone();
                    $perTel->setPerTelCommentaire($_POST['per_tel' . $i . '_commentaire']);
                    $perTel->setPerCode($personne);
                    $perTel->setTelCode($tel);

                    $entityManager->persist($tel);
                    $entityManager->persist($perTel);
                }
            }

            $entityManager->persist($personne);
            $entityManager->persist($patient);

            // efface date greffes selectionn�es
            for ($i = 0; $i <= 20; $i ++) {
                if (isset($_POST['gre_code_del' . $i])) {
                    $entityManager->remove($entityManager->find('RAN\Entity\Greffe', $_POST['gre_code_del' . $i]));
                }
            }

            if (isset($_POST['gre_date']) && ! empty($_POST['gre_date']) && isset($_POST['tgr_code']) && ! empty($_POST['tgr_code']) && isset($_POST['gre_rang']) && ! empty($_POST['gre_rang'])) {

                $greffe = new RAN\Entity\Greffe();
                $greffe->setPerCode($personne);
                $greffe->setGreDate(new DateTime(date_fr_to_mysql($_POST['gre_date'])));
                $greffe->setTgrCode($entityManager->find('RAN\Entity\TypeGreffe', $_POST['tgr_code']));
                $greffe->setGreRang($_POST['gre_rang']);

                if (isset($_POST['gre_comment_greffe'])) {
                    $greffe->setGreCommentGreffe($_POST['gre_comment_greffe']);
                }
                $greffe->setGreChir('');
                $greffe->setGreDialyse(0);
                $entityManager->persist($greffe);
            }

            // efface date greffes selectionnées
            for ($i = 0; $i <= 20; $i ++) {
                if (isset($_POST['dia_code_del' . $i])) {
                    $entityManager->remove($entityManager->find('RAN\Entity\Dialyse', $_POST['dia_code_del' . $i]));
                }
            }

            if (isset($_POST['dia_date']) && ! empty($_POST['dia_date']) && isset($_POST['tyd_code']) && ! empty($_POST['tyd_code']) && isset($_POST['dia_rang']) && ! empty($_POST['dia_rang'])) {

                $dialyse = new RAN\Entity\Dialyse();
                $dialyse->setPerCodePat($patient);
                $dialyse->setDiaDate(new DateTime(date_fr_to_mysql($_POST['dia_date'])));
                $dialyse->setTydCode($entityManager->find('RAN\Entity\TypeDialyse', $_POST['tyd_code']));
                $dialyse->setDiaRang($_POST['dia_rang']);

                if (isset($_POST['dia_comment_dialyse'])) {
                    $dialyse->setDiaCommentDialyse($_POST['dia_comment_dialyse']);
                }

                $entityManager->persist($dialyse);
            }

            $entityManager->flush();

            if (0 == $err) {
                // redirect("index.php?obj={$_GET['obj']}&action=page_act&{$this->idName}={$id}&act=upd");
                redirect("index.php?obj={$_GET['obj']}&action=page_list");
            } else {
                global $smarty;

                $smarty->assign("err", $err);

                $this->page_act();
            }
        } else
            redirect("index.php?obj=front&action=page_invalid");
    }

    /**
     * Page list/edit
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function page_list()
    {
        global $entityManager;
        global $smarty;

        objInitVar($this, "frontend/patient_list.tpl", "patient_list", "page_list", "", "", "");

        if (isset($_POST["act"]) && $_POST["act"] == "delete")
            $this->deleteMItems();

        $smarty->assign("recList", $this->getList());
        $smarty->assign("moduleSession", $_SESSION[SESS_IDX][$this->moduleName]);

        $cdList = doctrineGetTableContent($entityManager, 'RAN\Entity\CentreDialyse', 'cdiCode', 'cdiNom');

        // get centre dialyse list
        $smarty->assign("cdiList", $cdList);

        // Si le centre de rattachement est 1 (chu de bordeaux)
        if ($_SESSION[SESS_IDX][UL]['cer_code'] == 1) {
            // on autorise une recherche sur chaque centre de rattachement existant
            $cerList = doctrineGetTableContent($entityManager, 'RAN\Entity\CentreDeRattachement', 'cerCode', 'cerNom');
            $smarty->assign("cerList", $cerList);
        } // Si le centre de rattachement n'est pas le chu de bordeaux
        else {
            // On n'autorise une recherche que sur le centre de rattachement de l'utilisateur
            $cerList = doctrineGetTableContentFiltered($entityManager, 'RAN\Entity\CentreDeRattachement', 'cerCode', 'cerNom', 'dao.cerCode=' . $_SESSION[SESS_IDX][UL]['cer_code']);
            $smarty->assign("cerList", $cerList);
        }
        // Si une recherche a d�j� �t� execut�e
        if (isset($_SESSION[SESS_IDX][$this->moduleName]['search']['cer_code'])) {
            // On recupere l'identifiant du centre de rattachement recherch� et on l'assigne en valeur selected pour la liste
            $smarty->assign("defaultCer", $_SESSION[SESS_IDX][$this->moduleName]['search']['cer_code']);
        } // Si aucune recherche n'a �t� execut�e
        else {
            if ($_SESSION[SESS_IDX][UL]['cer_code'] != 1) {
                // On assigne le centre de rattachement de l'utilisateur comme valeur par d�faut
                $smarty->assign("defaultCer", $_SESSION[SESS_IDX][UL]['cer_code']);
            } else {
                $smarty->assign("defaultCer", '');
            }
        }

        // get pay list
        $paysList = doctrineGetTableContent($entityManager, 'RAN\Entity\Pays', 'payCode', 'payNom');
        $smarty->assign("payList", $paysList);

        // get civilite list
        $civList = doctrineGetTableContent($entityManager, 'RAN\Entity\Civilite', 'civCode', 'civLibelleLong');
        $smarty->assign("civList", $civList);

        $smarty->display($this->tplName);
    }

    /**
     * Get Users List
     *
     * @access: public
     * @return: array
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function getList()
    {
        global $entityManager;

        if (isset($_GET["last"])) {
            $_POST = array();
            $_POST["act"] = "search";
            $_POST["last"] = 1;
        }

        if (isset($_POST["act"]) && $_POST["act"] == "search")
            doctrinesearch($this->moduleName);

        $sqlSort = "per_nom";
        $sqlLimit = paging($this->moduleName, $this->pagingAction);
        $sqlLimit = trim(str_replace(" LIMIT ", "", $sqlLimit));
        $sqlLimitArr = explode(",", $sqlLimit);

        $myC = $_SESSION[SESS_IDX][$this->moduleName];

        $vectSearch = (isset($myC["search"]) ? $myC["search"] : array());

        $patQb = $entityManager->createQueryBuilder();
        $patQb->select('pat','per')
            ->from('RAN\Entity\Patient', 'pat')
            ->join('pat.perCode', 'per')
            ->leftJoin('per.cerCode', 'cer')
            ->leftJoin('per.civCode', 'civ');

        if(array_key_exists('last', $_POST) && $_POST['last']==1){
            $patQb->innerJoin('RAN\Entity\PatientsConsultes', 'pc', Join::WITH, 'pc.perCodePat=pat.perCode');
            $patQb->andWhere('pc.perCodeUti=:perCodeUti')->setParameter('perCodeUti', $_SESSION[SESS_IDX][UL]["per_code_uti"]);
            $patQb->addOrderBy('pc.patUtiTs', 'DESC');
        }
            

        if ((isset($vectSearch["act"]) && $vectSearch["act"] == "search" && sizeof($vectSearch) <= 1) || sizeof($vectSearch) == 0){
            return array();
        }

        if (count($vectSearch) > 0) {
            if (isset($_GET["jf_extend"]) && $_GET["jf_extend"] == 1) {
                if (isset($vectSearch["perNom"])) {
                    $vectSearch["patNomJf"] = $vectSearch["perNom"];
                    unset($vectSearch["perNom"]);

                    $_SESSION[SESS_IDX][$this->moduleName]["search"] = $vectSearch;
                }
            }

            foreach ($vectSearch as $key => $value) {
                // $value = mysql_escape_string($value);

                switch ($key) {
                    case "cerCode":
                        $patQb->andWhere('cer.cerCode=:cerCode')->setParameter('cerCode', $value);
                        break;
                    case "civCode":
                        $patQb->andWhere('civ.civCode=:civCode')->setParameter('civCode', $value);
                        break;
                    case "perNom":
                        $val = str_replace(" ", "%", $value);
                        $val = str_replace("-", "%", $val);
                        $patQb->andWhere("(per.perNom LIKE '$val%' or per.perNom LIKE '% $val%' or per.perNom LIKE '%-$val%')");
                        break;
                    case "perPrenom":
                        $patQb->andWhere('(per.perPrenom LIKE :perPrenom)')->setParameter(':perPrenom', $value . '%');
                        break;
                    case "patNumVenue":
                        $patQb->andWhere('(pat.patNumVenue LIKE :patNumVenue)')->setParameter(':patNumVenue', '%' . $value . '%');
                        break;
                    case "patNomJf":
                        $patQb->andWhere('(pat.patNomJf LIKE :patNomJf)')->setParameter(':patNomJf', '%' . $value . '%');
                        break;
                    case "patSexe":
                        $patQb->andWhere('pat.patSexe=:patSexe')->setParameter('patSexe', $value);
                        break;
                    case "patDtNaiss":
                        $tmp = explode("/", $value);
                        if (sizeof($tmp) == 3) {
                            $date = $tmp[2] . "-" . $tmp[1] . "-" . $tmp[0];
                            $patQb->andWhere('pat.patDtNaiss=:patDtNaiss')->setParameter('patDtNaiss', $date);
                        }
                        break;
                    case "patActif":
                        $patQb->andWhere('pat.patActif=:patActif')->setParameter('patActif', $value);
                        break;
                }
            }
        }

        // $daoVPerJoin = DB_DataObject::factory('v_personne');
        // $daoCdiJoin = DB_DataObject::factory('centre_dialyse');
        // $daoConsultJoin = DB_DataObject::factory('patients_consultes');

        // $daoList->joinAdd($daoVPerJoin, 'inner', false, 'per_code', 'per_code');
        // $daoList->joinAdd($daoCdiJoin, 'left');

        // if (isset($vectSearch["last"]))
        // {
        // $daoConsultJoin->per_code_uti = $_SESSION[SESS_IDX][UL]["per_code_uti"];

        // $daoList->joinAdd($daoConsultJoin, 'inner');

        // $daoList->orderBy('pat_uti_ts desc');
        // $daoList->groupBy('v_personne.per_code');
        // }

        $_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"] = count($patQb->getQuery()->getResult());

        $patQb->addOrderBy('per.perNom');
        $patQb->setFirstResult(trim($sqlLimitArr[0]))->setMaxResults(trim($sqlLimitArr[1]));

        $patients = $patQb->getQuery()->getArrayResult();

        $recList = array();
        $i = - 1;
        foreach ($patients as $patient) {
            $i ++;
            $recList[$i] = $patient;

            $recList[$i]["del_op"] = $this->verifyDel($recList[$i][$this->idName]);
        }

        return $recList;
    }

    /**
     * Verify user for remove operation
     *
     * @access: public
     * @return: bool
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function verifyDel($id)
    {
        global $entityManager;
        return doctrineCheckFieldExist($entityManager, 'RAN\Entity\Consultation', 'perCodePat', $id);
    }

    /**
     * Delte items (multiple)
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function deleteMItems()
    {
        if (isset($_POST["act"]) && $_POST["act"] == "delete") {
            if (isset($_POST["ids"])) {
                foreach ($_POST["ids"] as $v) {
                    $this->deleteItem($v);
                }
            }
        }
    }

    /**
     * Delte item
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function deleteItem($id)
    {
        global $entityManager;

        if ($this->verifyDel($id)) {
            // delete persone
            delPer($id);

            doctrineDelete($entityManager, '\RAN\Entity\Patient', 'perCode', $id);
        }
    }

    /**
     * Get Last Csl
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function getLastCsl($per_code)
    {
        global $entityManager;

        $qb = $entityManager->createQueryBuilder();
        $qb->select('c');
        $qb->from('RAN\Entity\Consultation', 'c');
        $qb->andWhere('c.perCodePat=:perCodePat')->setParameter('perCodePat', $per_code);
        $qb->addOrderBy('c.cslDate', 'DESC');
        $qb->addOrderBy('c.cslCode', 'DESC');
        $qb->setMaxResults(1);

        $csl = $qb->getQuery()->getOneOrNullResult();

        if (! is_null($csl)) {
            $cslInfo = getCslInfo($csl->getCslCode(), true);
        } else {
            $cslInfo = array();
        }

        return $cslInfo;
    }

    function patient_synthese()
    {
        global $smarty;

        objInitVar($this, "frontend/patient_synthese.tpl", "patient_synthese", "", "", "", "");

        $patInfo = array();

        if (isset($_GET[$this->idName]) && $_GET[$this->idName] != '') {
            $per_code = $_GET[$this->idName];
            $cslList = $this->getCslList($per_code, null);
            $patInfo = getPatientInfo($per_code);

            // assign vars for listing
            $smarty->assign("cslList", $cslList);
            $smarty->assign("patInfo", $patInfo);
        } else {
            echo "Error!";
            exit();
        }

        $smarty->display($this->tplName);
    }

    /**
     * Methode qui genere le CSV correspondant aux parametres biologiques
     */
    function patient_synthese_bio_export($consultation_id = array())
    {
        if (isset($_GET[$this->idName]) && $_GET[$this->idName] != '') {
            // On recupere l'identifiant du patient
            $per_code = $_GET[$this->idName];
            // On recupere les informations du patient
            $patInfo = getPatientInfo($per_code);
            // On recupere la liste des consultation du patient
            $cslList = $this->getCslList($per_code, isset($_GET['csl_date']) ? $_GET['csl_date'] : null);

            // Tableau qui contient la liste des donn�es biologiques par date
            // Sous la forme
            // csl_date_1 => { pbi_code_1=>cpb_valeur_1, pbi_code_2=>cpb_valeur_2}
            // csl_date_2 => { pbi_code_1'=>cpb_valeur_1', pbi_code_2'=>cpb_valeur_2'}
            $paramList = array();

            // Tableau qui contient pour chaque type de param�tre utilis�
            // dans les consultations, les dates auxquel il est rattach�
            // Sous la forme
            // pbi_code => {csl_date_1, csl_date_2 ...}
            $paramOk = array();

            // Tableau qui contient la liste des dates
            // pour lesquels des param�tres biologiques sont renseign�s
            $paramDateOk = array();

            $param_chunk = array();
            $params = array();
            $nr_csl = 0;

            // On parcoure les consultations rattach�es au patient
            foreach ($cslList as $csl) {
                // On recupere la liste des param�tres biologiques enregistr�s dans la consultation
                $csl_param = getConsultationParam($csl["csl_code"]);

                // On n'affiche pas les consultations sans param�tre biologique
                // on passe donc a la consultation suivante
                if (count($csl_param) == 0)
                    continue;

                // On incremente le compteur de consultation affich�e
                $nr_csl ++;

                $csl_date = $csl['csl_date']->format('d/m/Y');

                // Si la liste des param�tres pour la consultation n'est pas encore cr��e
                // et qu'elle contient des param�tres � afficher
                if (! isset($paramList[$csl_date])){
                    // on creer le tableau qui contiendra les informations sur les param�tres
                    $params[$csl_date] = array();
                }

                // Si la date n'existe n'existe pas dans la liste des dates (pour l'entete')
                if (! in_array($csl_date, $paramDateOk))
                    // On l'ajoute � la liste des dates � afficher
                    $paramDateOk[] = $csl_date;

                // Pour chaque param�tre biologique de la consultation
                foreach ($csl_param as $param) {
                    $param_pbi_code = $param['pbi_code'];
                    $param_cpb_valeur = $param['cpb_valeur'];

                    // Si le type de parametre n'existe pas dans la liste des types
                    // utilis�s par les consultations
                    if (! array_key_exists($param_pbi_code, $paramOk))
                        // On l'ajoute
                        $paramOk[$param_pbi_code] = array();

                    // Pour chaque parametre, on va renseigner les dates
                    // pour lesquels ils est utilis�
                    $paramOk[$param_pbi_code][] = $csl_date;

                    // On enregistre les informations du param�tre dans la liste
                    $paramList[$csl_date][$param_pbi_code] = $param_cpb_valeur;
                }
            }

            $liste_types_param_bio_existants = getAllParamBio();
            $csv_content = '';

            // L'en-t�te du tableau est constitu� de la liste des dates
            // pr�c�d�e d'une colonne vide
            $en_tete = ';' . join(';', $paramDateOk) . "\n";

            // tableau qui contiendra toutes les lignes CSV relatives aux param�tres bio
            $params_datas = array();

            // Pour chaque type de param�tre existant
            while (list (, $type_param_bio) = each($liste_types_param_bio_existants)) {

                // on parcoure la liste des param�tres qui y sont rattach�s
                while (list (, $param_bio) = each($type_param_bio['params'])) {
                    $param_bio_pbi_code = $param_bio['pbi_code'];

                    // On va genere la ligne correspondante
                    // on commence par le titre de la ligne
                    $param_datas = $param_bio['pbi_libelle'] . ';';

                    // Si le parametre biologique est utilis� par une consultation
                    if (array_key_exists($param_bio_pbi_code, $paramOk)) {

                        // On remet le pointeur interne du tableau a la position 0
                        reset($paramDateOk);
                        // Pour chaque date pour laquelle afficher des informations
                        while (list (, $date_consultation) = each($paramDateOk)) {

                            // Si le parametre est utilis� pour la date
                            if (in_array($date_consultation, $paramOk[$param_bio_pbi_code])) {
                                // on recupere la valeur du param�tre
                                $param_bio_value = $paramList[$date_consultation][$param_bio_pbi_code];
                                // On remplace les . par des virgules pour que Excel consid�re les valeurs comme des nombres
                                $param_bio_value = str_replace('.', ',', $paramList[$date_consultation][$param_bio_pbi_code]);
                                // Si la chaine contient le caract�re " qui est utilis� pour proteger le contenu des champs
                                if (substr_count($param_bio_value, '"') > 0) {
                                    // Si la chaine contient le caract�re ; qui est utilis� pour separer les champs
                                    if (substr_count($param_bio_value, ';') > 0) {
                                        // On prot�ge les caract�res "
                                        $param_bio_value = str_replace('"', '""', $param_bio_value);
                                        // On prot�ge la chaine en entourant de "
                                        $param_bio_value = '"' . $param_bio_value . '"';
                                    } // Si le caract�re separateur n'est pas pr�sent
                                    else {
                                        // On protege les caract�res " en les doublant
                                        // et on prot�ge la chaine
                                        $param_bio_value = '"' . str_replace('"', '""', $param_bio_value) . '"';
                                    }
                                } // Si le caract�re " n'est pas pr�sent"
                                else {
                                    // On prot�ge la chaine
                                    if (substr_count($param_bio_value, ';') > 0) {
                                        $param_bio_value = '"' . $param_bio_value . '"';
                                    }
                                }
                            } // Si aucune valeur pour le param�tre
                            else {
                                // On indique une chaine vide en valeur par d�faut
                                $param_bio_value = '';
                            }

                            // On ajoute la valeur � la liste
                            $param_datas .= $param_bio_value . ';';
                        }
                    } // Si le param�tre biologique n'est jamais utilis�
                    else {
                        // La valeur du parametre pour chaque date sera vide
                        $param_datas .= str_repeat(';', count($paramDateOk));
                    }

                    // On ajoute la ligne concernant le param�tre courant
                    // au tableau de ligne CSV des parametres
                    array_push($params_datas, $param_datas);
                }
            }

            // on genere le contenu du csv qui est
            // compos� de l'entete et des informations sur les parametres
            $csv_content = $en_tete . join($params_datas, "\n");

            // On genere le nom du fichier CSV
            $csv_filename = date('Ymd') . '_' . $patInfo['per']['per_prenom'] . '_' . $patInfo['per']['per_nom'] . '.csv';

            // On met les entetes pour definir le type du document (CSV)
            header("Content-length: " . strlen($csv_content));
            // Gestion particuliere pour IE qui ne comprend pas le type MIME text/csv,
            // et auquel il faut indiquer qu'il ne faut pas recuperer depuis le cache
            if ((strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false) && (strpos($_SERVER['HTTP_USER_AGENT'], 'Opera') == false)) {
                header("Pragma: must-revalidate");
                header("Cache-Control: must-revalidate");
                header("Content-type: application/vnd.ms-excel");
            } // Cas normal
            else {
                header("Content-type: text/csv");
            }
            // header("Content-Type: application/csv-tab-delimited-table");
            // On met les informations sur le nom du fichier g�n�r�
            header("Content-disposition: attachment; filename=" . $csv_filename);

            // On affiche le contenu du CSV
            echo $csv_content;

            // On arrete le flux qui pourrait arriver par la suite
            exit();
        } else {
            echo "Error!";
            exit();
        }
    }

    function patient_synthese_bio()
    {
        global $smarty;

        objInitVar($this, "frontend/patient_synthese_bio.tpl", "patient_synthese_bio", "", "", "", "");

        if (isset($_GET[$this->idName]) && $_GET[$this->idName] != '') {
            $per_code = $id = $_GET[$this->idName];
            $patInfo = getPatientInfo($per_code);

            $cslList = $this->getCslList($per_code, null);
            $paramList = array();
            $paramOk = array();
            $paramDateOk = array();

            $param_chunk = array();
            $params = array();
            $nr_csl = 0;

            isset($_GET["print"]) ? $nr_col = 8 : $nr_col = 1000;

            foreach ($cslList as $csl) {
                $nr_csl ++;
                $csl_param = getConsultationParam($csl["csl_code"]);
                $csl["csl_date"] = strtotime($csl["csl_date"]->format('m/d/Y'));

                // die(debug($csl_param));
                foreach ($csl_param as $param) {
                    if (! isset($paramList[$csl["csl_date"]])) {
                        $param[$csl["csl_date"]] = array();
                    }

                    $paramList[$csl["csl_date"]][$param["pbi_code"]] = $param["cpb_valeur"];

                    if (! in_array($csl["csl_date"], $paramDateOk)) {
                        $paramDateOk[] = $csl["csl_date"];
                    }
                }

                if ($nr_csl % $nr_col == 0) {
                    $param_chunk = array();
                    $param_chunk['dateOk'] = $paramDateOk;
                    $param_chunk['list'] = $paramList;
                    $params[] = $param_chunk;

                    $paramDateOk = array();
                    $paramList = array();
                }
            }

            if ($nr_csl % $nr_col != 0) {
                $param_chunk = array();
                $param_chunk['dateOk'] = $paramDateOk;
                $param_chunk['list'] = $paramList;
                $params[] = $param_chunk;
            }

            $paramBioAll = getAllParamBio();

            // assign vars for listing
            $smarty->assign("paramBioAll", $paramBioAll);
            $smarty->assign("paramList", $paramList);
            $smarty->assign("paramDateOk", $paramDateOk);
            $smarty->assign("params", $params);

            $smarty->assign("patInfo", $patInfo);
        } else {
            echo "Error!";
            exit();
        }

        $smarty->assign('paramBioAll', getAllParamBio());

        $smarty->display($this->tplName);
    }

    /**
     * Page act (add/upd form)
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function page_consultation()
    {
        global $smarty;

        global $entityManager;

        objInitVar($this, "frontend/patient_consultation.tpl", "patient_consultation", "", "", "", "");

        $patInfo = array();

        if (isset($_GET[$this->idName]) && $_GET[$this->idName] != '') {
            $per_code = $id = $_GET[$this->idName];

            // get patient info
            $patInfo = getPatientInfo($per_code);

            $this->patient_consult_upd($per_code);
            // ############################################ START ADD / EDIT CONSULTATION ############################################//

            // ======> add new consultation
            $step = "validate";
            if (isset($_POST['act']) && $_POST['act'] == 'csl_validate' && ! empty($_POST['prc_code'])) {
                checkUtilisateurAccess('CONSULTATION', 'RW');

                $tmp = explode("/", $_POST["csl_date"]);

                $jplus1 = mktime(0, 0, 0, date("m"), date("d") + 1, date("Y"));
                $csl_ts = mktime(0, 0, 0, $tmp[1], $tmp[0], $tmp[2]);

                // if ($csl_ts < $jplus1)
                $step = "save";
                // else
                // $_SESSION['notify'] = "Vous ne pouvez pas cr�er un consultation � une date future";
            } elseif (isset($_POST['act']) && ($_POST['act'] == 'csl_add' || $_POST['act'] == 'csl_upd') && ! empty($_POST['prc_code'])) {
                checkUtilisateurAccess('CONSULTATION', 'RW');

                $prc_code = $_POST['prc_code'];

                $per_code_uti = $_SESSION[SESS_IDX][UL]['per_code_uti'];
                $per_code_pat = $per_code;

                $csl_comment = $_POST["csl_comment"]; // str_replace("<br />","",str_replace("<br/>","",$_POST['csl_comment']));
                $csl_comment = strip_tags($csl_comment, '<b><u><a><span><ul><li>');
                $csl_poids = str_replace(",", ".", $_POST['csl_poids']);
                $csl_taille = $_POST['csl_taille'];
                $csl_ta = $_POST['csl_ta'];
                $csl_ta2 = $_POST['csl_ta2'];

                $daoCsl = new RAN\Entity\Consultation();

                if (! empty($_POST['csl_code'])) {
                    $daoCsl = $entityManager->find('RAN\ENtity\Consultation', $_POST['csl_code']);
                    $entityManager->refresh($daoCsl);
                }

                $daoCsl->setPrcCode($entityManager->getReference('RAN\Entity\ProfilConsultation', $prc_code));
                $daoCsl->setPerCodePat($entityManager->getReference('RAN\Entity\Patient', $per_code_pat));
                $daoCsl->setCslComment($csl_comment);
                $daoCsl->setCslPoids(floatval($csl_poids));
                $daoCsl->setCslTaille(intval($csl_taille));
                $daoCsl->setCslTa($csl_ta);
                $daoCsl->setCslTa2($csl_ta2);

                if (isset($_POST['csl_date'])) {
                    $csl_date = $_POST['csl_date'];
                    $tmp = explode("/", $csl_date);
                    $csl_date = $tmp[2] . "-" . $tmp[1] . "-" . $tmp[0];
                    $daoCsl->setCslDate(new DateTime($csl_date));
                }

                if ($_POST['act'] == 'csl_add') // insert into consultation
                {
                    if ($_SESSION[SESS_IDX][UL]["is_medecin"]) {
                        $daoCsl->setPerCodeUti($entityManager->getReference('RAN\Entity\Medecin', $per_code_uti));
                    } else {
                        $daoCsl->setPerCodeUti($entityManager->getReference('RAN\Entity\Medecin', PER_CODE_UTI_DEFAULT));
                    }
                } elseif (! empty($_POST['csl_code'])) // update consultation
                {

                    if ($daoCsl->getPerCodeUti()
                        ->getPerCode()
                        ->getPerCode() == PER_CODE_UTI_DEFAULT && $_SESSION[SESS_IDX][UL]["is_medecin"]) {
                        $daoCsl->setPerCodeUti($entityManager->getReference('RAN\Entity\Medecin', $per_code_uti)
                            ->getPerCode());
                    }
                }

                $entityManager->persist($daoCsl);
                $entityManager->flush();

                $csl_code = $daoCsl->getCslCode();

                if (isset($csl_code) && $csl_code > 0) {
                    // ===> insert param bio in consult_param_bio

                    $pbiList = $entityManager->getRepository('RAN\Entity\ParametresBiologiques')->findAll();

                    $queryClearPbi = $entityManager->createQuery('DELETE RAN\Entity\ConsultParamBio c WHERE c.cslCode=:cslCode')->setParameter('cslCode', $csl_code);
                    $queryClearPbi->execute();

                    foreach ($pbiList as $pbi) {
                        if (array_key_exists("cpb_valeur{$pbi->getPbiCode()}", $_POST)) {
                            if (trim($_POST["cpb_valeur{$pbi->getPbiCode()}"]) != '') {
                                $cspbi = new RAN\Entity\ConsultParamBio();
                                $cspbi->setCslCode($daoCsl);
                                $cspbi->setPbiCode($pbi);
                                $cspbi->setCpbValeur($_POST["cpb_valeur{$pbi->getPbiCode()}"]);
                                $entityManager->persist($cspbi);
                            }
                        }
                    }
                    $entityManager->flush();

                    setClairance($csl_code);

                    // redirect to edit form
                    if ($_POST["redirect"] == "compte_rendu")
                        $url = "index.php?obj=patient&action=medecin_correspondant&csl_code=$csl_code";
                    elseif ($_POST["redirect"] == "ordonnance")
                        $url = "index.php?obj=patient&action&action=patient_traitement&csl_code=$csl_code";
                    else
                        $url = "index.php?obj={$_GET['obj']}&action={$_GET['action']}&per_code={$per_code}&csl_code={$csl_code}";

                    if ($_POST["extra"] == "prc_code0")
                        $url .= "&prc_code=0#csl_form";

                    if ($_POST["extra"] == "export_csv")
                        $url .= "&export=1#csl_form";

                    redirect($url);
                } else {
                    echo "Error at consultation insert!";
                    exit();
                }
            }

            // ===> edit consultation form
            if (isset($_GET['csl_code']) && $_GET['csl_code'] > 0) {
                $cslDet = getCslInfo($_GET['csl_code']);

                $smarty->assign("cslDet", $cslDet);

                $step = "save";
            }
            // <===

            if ($step == "save") {
                // ===> rich text editor
                $text = (isset($cslDet['csl_comment']) ? $cslDet['csl_comment'] : '');
                require_once (ROOT_DIR . 'www/js/fckeditor/fckeditor.php');

                $rtf_obj = editorRTF('csl_comment', str_replace("\n", "<br />", $text)); // str_replace("\n","<br />",str_replace("<br/>","",$text)));
                $smarty->assign('rtf_obj', $rtf_obj);
                // <===
            }

            if (isset($_GET['step']) && $_GET['step'] == 'done') {
                $step = "done";
            }
            $smarty->assign("step", $step);

            // <====== end add new consultation

            // ############################################ END ADD / EDIT CONSULTATION ############################################//

            // ############################################ START LISTING CONSULTATION ############################################//

            // ===>get last consultation
            if ($lastCslInfo = $this->getLastCsl($per_code)) {
                if (isset($lastCslInfo['csl_date'])) {
                    $csl_date = $lastCslInfo['csl_date'];

                    $smarty->assign("lastCslInfo", $lastCslInfo);
                }
            } else
                $csl_date = _dtGetDate();
            // <====

            // Get last greffe
            if (isset($cslDet)){
                $smarty->assign("lastGreffe", getGreffe($per_code, $cslDet['csl_date']));
            }
            else{
                $smarty->assign("lastGreffe", getGreffe($per_code, false));
            }

            // ===>get consultation date for display
            if (isset($_GET['csl_date']) && $_GET['csl_date'] != '')
                $csl_date = $_GET['csl_date'];
            else
                $csl_date = null;
            // <===

            $cslList = $this->getCslList($per_code, $csl_date);

            // assign vars for listing
            $smarty->assign("csl_date", $csl_date);
            $smarty->assign("cslList", $cslList);

            // if(isset($cslList[0])) $smarty->assign("cslInfo", $cslList[0]);

            // assign consultations dates selected for calendar
            $smarty->assign("cslStrDates", $this->getCslStrDates($per_code));

            // ############################################ END LISTING CONSULTATION ############################################//

            // assign patient info
            $smarty->assign("patInfo", $patInfo);

            // Transcription de "Profil non archivé"
            $filtreProfilConsultation = 'dao.prcArchive!=1 ';

            // Afin d'exclure de la liste de saisie les profils de consultation archivés
            // on construit le filtre "profil non archivé OU profil actuellement indiqué pour la consultation"
            if (isset($cslDet)) {
                $prc_code = $cslDet['prc_code'];

                // Transcription de "profil actuellement indiqué pour la consultation"
                if (! is_null($prc_code) && is_numeric($prc_code))
                    $filtreProfilConsultation .= ' OR dao.prcCode=' . $prc_code;
            }
            
            
            
            // On recupere la liste des profils de consultation, en excluant les profils archivés sauf le profil courant s'il devait être archivé
            $smarty->assign("prcList", doctrineGetTableContentFiltered($entityManager, 'RAN\Entity\ProfilConsultation', 'prcCode', 'prcDesc', $filtreProfilConsultation, 'prcDesc', 0));
        } else {
            echo "Error!";
            exit();
        }
        
        $smarty->display($this->tplName);
    }

    function getCslList($per_code, $csl_date)
    {
        // ===>prepare consultation listing
        $cslList = array();

        global $entityManager;

        $qb = $entityManager->createQueryBuilder();

        $qb->select(array(
            'csl',
            'prc',
            'med',
            'medPer',
            'medSpe'
        ))
            ->from('RAN\Entity\Consultation', 'csl')
            ->innerJoin('csl.prcCode', 'prc')
            ->innerJoin('csl.perCodeUti', 'med')
            ->innerJoin('med.perCode', 'medPer')
            ->innerJoin('med.spmCode', 'medSpe')
            ->andWhere('csl.perCodePat=:perCodePat')
            ->setParameter('perCodePat', $per_code);

        if ($csl_date != null) {
            $qb->andWhere('csl.cslDate=:cslDate')->setParameter('cslDate', $csl_date);
        }
        $qb->addOrderBy('csl.cslDate', 'DESC');
        $qb->addOrderBy('csl.cslCode', 'DESC');

        $results = $qb->getQuery()->getArrayResult();

        foreach ($results as $result) {
            $cslInfo = array();

            $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Consultation', $result));

            if (isset($result['prcCode'])) {
                $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\ProfilConsultation', $result['prcCode']));
            }
            if (isset($result['perCodeUti'])) {
                $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Medecin', $result['perCodeUti']));

                if (isset($result['perCodeUti']['perCode'])) {
                    $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $result['perCodeUti']['perCode']));
                }

                if (isset($result['perCodeUti']['spmCode'])) {
                    $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\SpecialiteMedicale', $result['perCodeUti']['spmCode']));
                }
            }

            if ($cslInfo["csl_ta"]) {
                $cslInfo["csl_ta"] = sprintf('%03d', $cslInfo["csl_ta"]);
            } else {
                $cslInfo["csl_ta"] = "";
            }

            if ($cslInfo["csl_ta2"]) {
                $cslInfo["csl_ta2"] = sprintf('%03d', $cslInfo["csl_ta2"]);
            } else {
                $cslInfo["csl_ta2"] = "";
            }

            $cslInfo['pbi'] = getConsultationParam($result['cslCode']);

            $cslList[] = $cslInfo;
        }

        return $cslList;
        // <===
    }

    /**
     * Get Consultation Distinct Days
     *
     * @access: public
     * @return: string
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function getCslStrDates($per_code)
    {
        $strDates = "";

        global $entityManager;

        $qb = $entityManager->createQueryBuilder();

        $qb->select(array(
            'distinct csl.cslDate'
        ))
            ->from('RAN\Entity\Consultation', 'csl')
            ->andWhere('csl.perCodePat=:perCodePat')
            ->setParameter('perCodePat', $per_code);

            
        $cslDates = $qb->getQuery()->getArrayResult();

        if(!empty($cslDates)){
            foreach ($cslDates[0] as $cslDate) {
                $strDates .= "'" . $cslDate->format('{d}_{m}_{Y}') . "',";
            }
        }
        if ($strDates != "") {
            $strDates = substr($strDates, 0, strlen($strDates) - 1);
        }
        return $strDates;
    }

    /**
     * Show Graph Pbi Consultation //per_code_pat=24&pbi_code=35
     *
     * @access: public
     * @return: string
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function showGraphPbiPat()
    {
        global $smarty;
        if (isset($_GET['csl_code']) && is_numeric($_GET['csl_code'])) {
            $cslInfo = getCslInfo($_GET['csl_code']);
            $smarty->assign('lastGreffe', getGreffe($_GET['pat_per_code'], $cslInfo['csl_date']));
        }
        
        $smarty->assign("greffes", getGreffe($_GET['pat_per_code'], false));
        $smarty->display("frontend/show_graph_pbi_pat.tpl");
        exit();
    }

    /**
     * Medecin correspondant
     *
     * @access: public
     * @return: string
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function medecin_correspondant()
    {
        global $smarty;
        global $entityManager;

        if (isset($_GET['csl_code'])) {
            objInitVar($this, "frontend/medecin_correspondant.tpl", "medecin_correspondant", "medecin_correspondant", "", "", "");

            $csl_code = $_GET['csl_code'];

            $cslInfo = getCslInfo($csl_code);

            $per_code = $cslInfo['per_code_pat'];

            // ===>get last consultation
            if ($lastCslInfo = $this->getLastCsl($per_code)) {
                if (isset($lastCslInfo['csl_date'])) {
                    $csl_date = $lastCslInfo['csl_date'];

                    $smarty->assign("lastCslInfo", $lastCslInfo);
                }
            } else
                $csl_date = _dtGetDate();
            // <====

            // Get last greffe
            $smarty->assign("lastGreffe", getGreffe($per_code, $cslInfo['csl_date']));

            // get patient info
            $patInfo = getPatientInfo($cslInfo['per_code_pat']);

            $smarty->assign("cslInfo", $cslInfo);
            $smarty->assign("patInfo", $patInfo);

            // get specialite medicale list
            $smarty->assign("spmList", doctrineGetTableContent($entityManager, 'RAN\Entity\SpecialiteMedicale', 'spmCode', 'spmLibelle', 'spmLibelle', 0));

            $smarty->display($this->tplName);
        }
        else{
            redirect("index.php?obj={$_GET['obj']}&action=page_list");
        }
    }

    /**
     * Csl Print
     *
     * @access: public
     * @return: string
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function csl_print()
    {
        global $smarty;
        global $entityManager;
        
        if (isset($_GET['csl_code']) && $cslInfo = getCslInfo($_GET['csl_code'], true)) {
            objInitVar($this, "frontend/csl_print.tpl", "csl_print", "csl_print", "", "", "");

            $csl_code = (int) $_GET['csl_code'];

            // ===> get medecin from courrier_edite
            $medArr = array();

            $courriersEdites=$entityManager->getRepository('RAN\Entity\CourrierEdite')->findBy(array('cslCode'=>$csl_code));
            $c = - 1;
            
            foreach($courriersEdites as $courrierEdite){
                $c ++;
                $medArr[$c]['medecin'] = getPerInfo($courrierEdite->getPerCode()->getPerCode());
                $medArr[$c]['modele_lettre'] = $courrierEdite->getCouLettre();
            }

            // get patient info
            $patInfo=doctrineGetRowContent($entityManager, 'RAN\Entity\Patient', 'perCode', $cslInfo['per_code_pat'], null, null, true);
            
            $patInfo['per'] = getPerInfo($cslInfo['per_code_pat']);
            $patInfo['comm'][1]=doctrineGetFieldContent($entityManager, 'RAN\Entity\PatientComment', 'patComTxt', 'perCodePat', $cslInfo['per_code_pat'], 'patComType', 1);
            $patInfo['comm'][2]=doctrineGetFieldContent($entityManager, 'RAN\Entity\PatientComment', 'patComTxt', 'perCodePat', $cslInfo['per_code_pat'], 'patComType', 2);
            $patInfo['comm'][3]=doctrineGetFieldContent($entityManager, 'RAN\Entity\PatientComment', 'patComTxt', 'perCodePat', $cslInfo['per_code_pat'], 'patComType', 3);
            
            $medInfo=getMedInfo($cslInfo['per_code_uti']);

            // On prepare la liste des destinataires en copie
            // a indiquer dans chaque courrier
            $htmlMedecinCopie = '<table border="0" width="700px">';
            $htmlMedecinCopie .= '<tr><th>Destinataires</th></tr>';
            foreach ($medArr as $medecinCopieDatas) {
                $prenom_nom = $medecinCopieDatas['medecin']['per_prenom'] . " " . $medecinCopieDatas['medecin']['per_nom'];
                $adresse = $medecinCopieDatas['medecin']['adresse'][0]['adr_cp'] . ' ' . $medecinCopieDatas['medecin']['adresse'][0]['adr_ville'];
                $htmlMedecinCopie .= '<tr><td>Docteur ' . $prenom_nom . ', ' . $adresse . '</td></tr>';
            }
            $htmlMedecinCopie .= '</table>';

            // get traitement ordonnances
            $ordList = $this->prescriptionSearchResult($csl_code);

            // ==================================== PDF SET HEADER ====================================//

            header("Pragma: public"); // required // leave blank to avoid IE errors or header("Pragma: public");
            header("Expires: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0"); // leave blank to avoid IE errors
            header("Cache-Control: private", false); // required for certain browsers
                                                     // header('Content-type: application/pdf');

            error_reporting(1);

            require_once ('tcpdf/config/lang/eng.php');
            require_once ('tcpdf/tcpdf.php');

            // ==================================== TCPDF INIT START ====================================//

            $doc_title = "test title";
            $doc_subject = "test description";
            $doc_keywords = "test keywords";

            // create new PDF document (document units are set by default to millimeters)
            $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);

            // set document information
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor(PDF_AUTHOR);
            $pdf->SetTitle($doc_title);
            $pdf->SetSubject($doc_subject);
            $pdf->SetKeywords($doc_keywords);

            // $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

            // set margins
            $pdf->SetMargins(55, 50, 10);
            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); // set image scale factor

            $pdf->setHeaderFont(Array(
                PDF_FONT_NAME_MAIN,
                '',
                PDF_FONT_SIZE_MAIN
            ));
            $pdf->setFooterFont(Array(
                PDF_FONT_NAME_DATA,
                '',
                PDF_FONT_SIZE_DATA
            ));

            $pdf->setLanguageArray($l); // set language items

            // initialize document
            $pdf->AliasNbPages();

            // ==================================== TCPDF INIT END ====================================//

            // print for each medecin and model lettre
            foreach ($medArr as $keyM => $itemM) {
                // ==================================== PAGINA 1 =====================================//
                $pdf->setPrintHeader(false);

                $pdf->AddPage();

                $pdf->SetFont("FreeSans", "", 10);

                $htmlc = "<table border=\"0\"><tr><td width=\"537\">Docteur " . $itemM["medecin"]["per_prenom"] . " " . $itemM["medecin"]["per_nom"] . "<br />" . nl2br(htmlentities2($itemM["medecin"]["adresse"][0]["adr_voie"])) . "<br />" . $itemM["medecin"]["adresse"][0]["adr_cp"] . " " . $itemM["medecin"]["adresse"][0]["adr_ville"] . "</td></tr></table>";
                $pdf->writeHTMLCell(120, 0, 115, 45, utf8_encode($htmlc), 0, 2, 0, true);

                $villeEdition = (is_null($medInfo['adr_ville']) || 0 == strlen(trim($medInfo['adr_ville'])) ? 'Bordeaux' : ucfirst(strtolower(trim($medInfo['adr_ville']))));
                $htmlc = "<table border=\"0\"><tr><td width=\"537\" align=\"right\">" . $villeEdition . " le " . date('d/m/Y', strtotime($cslInfo['csl_date'])) . "</td></tr></table>";
                $pdf->writeHTMLCell(120, 0, 20, 85, utf8_encode($htmlc), 0, 2, 0, true);

                $htmlcNewLine = "<br>";
                $pdf->writeHTML($htmlcNewLine);
                $pdf->writeHTMLCell(120, 0, 0, 0, utf8_encode($htmlMedecinCopie), 0, 2, 0, true);

                $pdf->setPrintFooter(false, false);

                // ==================================== PAGINA 2 =====================================//

                // $pdf->setPrintHeader(false);
                // $pdf->AddPage();
                $pdf->SetFont("FreeSans", "BU", 10);
                $htmlc="<br>";
                $pdf->writeHTML($htmlc);
                //$pdf->write(14, "Compte-rendu de " . utf8_encode($cslInfo['prc_desc']).' de '.strtoupper(remove_accent($patInfo['per']['per_nom']))." ".strtoupper(remove_accent($patInfo['per']['per_prenom'])).' '.date('d/m/Y',$patInfo['pat_dt_naiss']), '', 0, C);
                
                $consultHeadLine="Compte-rendu de " . utf8_encode($cslInfo['prc_desc']).' de '.strtoupper(remove_accent($patInfo['per']['per_nom']))." ".strtoupper(remove_accent($patInfo['per']['per_prenom']));
                if(!is_null($patInfo['pat_dt_naiss']) && $patInfo['pat_dt_naiss']!=''){
                    $consultHeadLine=$consultHeadLine.' ('.$patInfo['pat_dt_naiss']->format('d/m/Y').')';
                }
                $pdf->writeHTML($consultHeadLine);
                
                //$pdf->write(14,"Compte-rendu de ".utf8_encode($cslInfo['prc_desc']),'',0,C);
                
                //$pdf->writeHTML($htmlc);
                //$pdf->writeHTMLCell(100, 0, 55, 0, $htmlc, 0, 1, 0, true);
                $pdf->SetFont("FreeSans", "", 10);
                $htmlc="<br>";
                $pdf->writeHTML($htmlc);
                
                $htmlc = utf8_encode($smarty->fetch("frontend/modele_lettre/modele_lettre_{$itemM['modele_lettre']}.tpl"));
                $pdf->writeHTMLCell(150, 0, 0, 0, $htmlc, 0, 1, 0, true);

                // some data from csl
                $htmlc = "<br><br><b>Sa T.A.</b> est de {$cslInfo['csl_ta']}/{$cslInfo['csl_ta2']} mmHg<br><br><b>Son poids</b> est {$cslInfo['csl_poids']} kg\n";

                if ($cslInfo['csl_taille'] != '')
                    $htmlc .= "<br><br><b>Sa taille</b> est {$cslInfo['csl_taille']} cm";

                $htmlc .= "<br><br>" . nl2br($cslInfo['csl_comment']) . "<br>";
                $pdf->writeHTMLCell(0, 0, 0, 0, $htmlc, 0, 1, 0, true);

                // PARAM PBI
                $pdf->SetFont("FreeSans", "", 10);
                $htmlc = "<u>" . htmlentities2("Son bilan biologique pr&eacute;sente les caract&eacute;ristiques suivantes :") . "</u><br>";
                $pdf->writeHTMLCell(150, 0, 0, 0, $htmlc, 0, 1, 0, true);

                $pdf->SetFont("FreeSans", "", 10);
                $htmlc = "";
                $tpb_code = - 1;

                foreach ($cslInfo['pbi'] as $key => $item) {
                    if ($tpb_code != $item['tpb_code']){
                        $htmlc .= "<br><b>" . htmlentities2(utf8_decode($item['tpb_libelle'])) . "</b><br>";
                    }
                    $tpb_code = $item['tpb_code'];
                    $htmlc .= " - " . htmlentities2(utf8_decode($item['pbi_libelle'])) . " : " . htmlentities2($item['cpb_valeur']) . " " . htmlentities2(utf8_decode($item['upa_libelle'])) . "<br>";
                }
                $pdf->writeHTMLCell(150, 0, 0, 0, $htmlc, 0, 1, 0, true);

                // TRAITEMENT
                $pdf->SetFont("FreeSans", "", 10);
                $htmlc = "<br> <u>" . htmlentities2('Son traitement actuel associe :') . "</u><br>";
                $pdf->writeHTMLCell(150, 0, 0, 0, $htmlc, 0, 1, 0, true);

                $pdf->SetFont("FreeSans", "", 10);
                // Variable qui va servir de buffer pour la chaine representant l'ordonnance
                $htmlc = "";

                // Pour chaque �l�ment dans l'ordonnance (qui est en fait un couple [type d'ordonnance][Liste des prescriptions])

                foreach ($ordList as $keyO => $itemO) {
                    $htmlOrd = '';

                    // On ajoute au buffer le nom du type d'ordonnance (hospitaliere, classique, ...)
                    $htmlOrd .= "<br> <b>" . htmlentities2(strtoupper("Ordonnance " . utf8_decode($itemO['tpo_libelle']))) . " - " . date('d/m/Y', strtotime($itemO['csl_date'])) . "</b><br>";

                    // Pour chaque �l�ment de la liste des prescriptions

                    foreach ($itemO['pre'] as $keyP => $itemP) {

                        // Variable qui va servir de buffer pour la chaine representant une prescription

                        $htmlcPre = '';

                        // On recupere dans le buffer le nom du medicament

                        $htmlcPre .= "    - <b>" . htmlentities2(ucfirst($itemP['medi_nom_com'])) . ":</b> ";

                        // On recupere dans le buffer la quantit� de medicament

                        $quantitePrescription = ($itemP["pre_quantite_access"] != "") ? $itemP['pre_quantite_access'] : $itemP['pre_quantite'];

                        // Si le traitement est prescrit le matin
                        if ($itemP['pro_code'][0] == 1) {
                            $htmlcPre .= htmlentities2($quantitePrescription . ' le matin');

                            // Si le traitement est aussi prescrit le midi
                            if ($itemP['pro_code'][1] == 1) {
                                $htmlcPre .= htmlentities2(', ' . $quantitePrescription . ' le midi');
                            }

                            // Si le traitement est aussi prescrit le soir
                            if ($itemP['pro_code'][2] == 1) {
                                $htmlcPre .= htmlentities2(', ' . $quantitePrescription . ' le soir');
                            }
                        } // Si le traitement n'est pas prescrit le matin
                        else {
                            // Si le traitement est prescrit le midi
                            if ($itemP['pro_code'][1] == 1) {
                                $htmlcPre .= htmlentities2($quantitePrescription . ' le midi');

                                // Si le traitement est aussir prescrit le soir
                                if ($itemP['pro_code'][2] == 1) {
                                    $htmlcPre .= htmlentities2(', ' . $quantitePrescription . ' le soir');
                                }
                            } // Si le traitement n'est pas prescrit le midi (ni le matin)
                            else {
                                // Si le traitement est prescrit le soir
                                if ($itemP['pro_code'][2] == 1) {
                                    $htmlcPre .= htmlentities2($quantitePrescription . ' le soir');
                                } // Si le traitement n'est pas prescrit le soir (ni le matin, ni le midi)
                                else {
                                    $htmlcPre .= htmlentities2($quantitePrescription);
                                }
                            }
                        }

                        // On recupere dans le buffer la dur�e du traitement

                        if ($itemP["pre_duree_access"] != "")

                            $htmlcPre .= " " . htmlentities2(" - dur&eacute;e: " . $itemP['pre_duree_access']);

                        else {

                            $htmlcPre .= " " . htmlentities2(" - dur&eacute;e: " . $itemP['pre_duree']);

                            switch ($itemP["pre_duree_type"]) {

                                case "j":

                                    $htmlcPre .= htmlentities2(" jour(s)");

                                    break;

                                case "s":

                                    $htmlcPre .= htmlentities2(" semaine(s)");

                                    break;

                                case "m":

                                    $htmlcPre .= htmlentities2(" mois");

                                    break;
                            }
                        }

                        // On recupere dans le buffer si la prescription est renouvelable

                        if ($itemP['pre_renouvel'] > 0)

                            $htmlcPre .= ", " . htmlentities2("&agrave; renouveler " . $itemP['pre_renouvel'] . " fois");

                        // On recupere dans le buffer la date d'arr�t pour la prescription

                        if ($itemP['pre_dt_arret'] != "") {

                            $htmlcPre .= htmlentities2(" - Date arret " . $itemP['pre_dt_arret']);
                        }

                        // On recupere dans le buffer si la prescription est substiuable ou pas

                        if ($itemP['pre_non_substituable'] != 0) {
                            $htmlcPre .= ', ' . htmlentities2('non substituable');
                        }

                        $htmlcPre .= "<br>";
                        $htmlOrd .= $htmlcPre;
                    }
                    $htmlc .= $htmlOrd . '<br>';
                }

                $pdf->writeHTMLCell(150, 0, 0, 0, $htmlc, 0, 1, 0, true);

                $pdf->SetFont("FreeSans", "", 10);

                $htmlc = "<br>" . utf8_encode($smarty->fetch("frontend/modele_lettre/modele_lettre_bas_{$itemM['modele_lettre']}.tpl"));

                $htmlc = utf8_encode("<br><br>Docteur " . htmlentities2(strtoupper($medInfo['per_nom']) . " " . ucfirst(htmlentities2($medInfo['per_prenom']))));

                $pdf->writeHTMLCell(120, 0, 115, 0, $htmlc, 0, 1, 0, true);

                $pdf->setPrintFooter(false, false);
            }

            // Close and output PDF document
            // $pdf->Output(ROOT_DIR."www/test.pdf","F");
            
            $pdf->Output();

            exit();
        } else
            echo "Error!";
    }

    /**
     * Page traitement
     *
     * @access: public
     * @return: string
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function patient_traitement()
    {
   
        global $smarty;
        global $entityManager;

        objInitVar($this, "frontend/patient_traitement.tpl", "patient_traitement", "patient_traitement", "", "", "");
        $patInfo = array();

        if (isset($_GET['csl_code']) && $cslInfo = getCslInfo($_GET['csl_code'])) {
            $csl_code = $_GET['csl_code'];
            $per_code = $cslInfo['per_code_pat'];

            // get patient info
            $patInfo = getPatientInfo($per_code);

            // get last csl and check access to add/upd a traitement
            $accessAct = 1;
            if ($lastCslInfo = $this->getLastCsl($per_code)) {
                if ($lastCslInfo['csl_code'] != $csl_code) {
                    $accessAct = 0;
                }
            }

            $smarty->assign("lastGreffe", getGreffe($per_code, $cslInfo['csl_date']));

            // ######################################## Add/Upd Start #######################################//

            if (isset($_POST['act']) && ($_POST['act'] == 'add' || $_POST['act'] == 'upd') && $accessAct == 1) {
                if ($_POST['act'] == 'add') // add multiple ordonannces
                {
                    $arrInsert = array();

                    // delete old ordonnance
                    $this->deleteCslOrdonnance($csl_code);

                    if (isset($_POST['no_pre']) && $_POST['no_pre'] > 0) {
                        for ($i = 0; $i <= $_POST['no_pre']; $i ++) {
                            ! isset($_POST['pro_code1' . $i]) ? $_POST['pro_code1' . $i] = 0 : false;
                            ! isset($_POST['pro_code2' . $i]) ? $_POST['pro_code2' . $i] = 0 : false;
                            ! isset($_POST['pro_code3' . $i]) ? $_POST['pro_code3' . $i] = 0 : false;

                            $pro_code = $_POST['pro_code1' . $i] . $_POST['pro_code2' . $i] . $_POST['pro_code3' . $i];

                            // die(debug($_POST));
                            $tpo_code = $_POST['tpo_code' . $i];
                            $medi_code = $_POST['medi_code' . $i];
                            $pre_quantite = $_POST['pre_quantite' . $i];
                            $pre_duree = intval($_POST['pre_duree' . $i]);
                            $pre_duree_type = $_POST['pre_duree_type' . $i];
                            $pre_renouvel = $_POST['pre_renouvel' . $i];
                            $pre_dt_arret = $_POST['pre_dt_arret' . $i];
                            $pre_bizone = $_POST['pre_bizone' . $i];
                            $pre_non_substituable = isset($_POST['pre_non_substituable' . $i]) ? $_POST['pre_non_substituable' . $i] : 0;

                            if ($medi_code > 0) {
                                $arrInsert[$tpo_code][] = array(
                                    'medi_code' => $medi_code,
                                    'pro_code' => $pro_code,
                                    'pre_quantite' => $pre_quantite,
                                    'pre_duree' => $pre_duree,
                                    'pre_duree_type' => $pre_duree_type,
                                    'pre_renouvel' => $pre_renouvel,
                                    'pre_dt_arret' => $pre_dt_arret,
                                    'pre_bizone' => $pre_bizone,
                                    'pre_non_substituable' => $pre_non_substituable
                                );
                            }
                        }
                    }

                    foreach ($arrInsert as $tpo_code => $v) {
                        $ordonnance = new RAN\Entity\Ordonnance();
                        $ordonnance->setTpoCode($entityManager->getReference('RAN\Entity\TypeOrdonnance', $tpo_code));
                        $ordonnance->setCslCode($entityManager->getReference('RAN\Entity\Consultation', $csl_code));
                        $entityManager->persist($ordonnance);

                        for ($i = 0; $i < count($v); $i ++) {
                            $medi_code = $v[$i]['medi_code'];
                            $pro_code = $v[$i]['pro_code'];
                            $pre_quantite = $v[$i]['pre_quantite'];
                            $pre_duree = ($v[$i]['pre_duree']);

                            $pre_duree_type = $v[$i]['pre_duree_type'];
                            $pre_renouvel = $v[$i]['pre_renouvel'];

                            $pre_dt_arret = ($v[$i]['pre_dt_arret'] != '' ? new DateTime(date_fr_to_mysql($v[$i]['pre_dt_arret'])) : null);

                            $pre_bizone = $v[$i]['pre_bizone'];
                            $pre_non_substituable = $v[$i]['pre_non_substituable'];

                            $prescription = new RAN\Entity\Prescription();
                            $prescription->setOrdCode($ordonnance);
                            $prescription->setProCode($pro_code);
                            $prescription->setMediCode($entityManager->getReference('RAN\Entity\Medicament', $medi_code));

                            $prescription->setPreQuantite($pre_quantite);
                            $prescription->setPreDuree($pre_duree);
                            $prescription->setPreRenouvel($pre_renouvel);
                            $prescription->setPreDureeType($pre_duree_type);
                            $prescription->setPreDtArret($pre_dt_arret);
                            $prescription->setPreBizone($pre_bizone);
                            $prescription->setPreNonSubstituable($pre_non_substituable);

                            $entityManager->persist($prescription);
                        }

                        $entityManager->flush();
                    }

                    if (isset($_GET["redirect"]) && $_GET["redirect"] == "consult") {
                        $url = "index.php?obj=patient&action=page_consultation&per_code={$_GET["per_code_pat"]}&csl_code={$csl_code}";
                    } else {
                        $url = "index.php?obj={$_GET['obj']}&action={$_GET['action']}&csl_code={$csl_code}&added=1";
                    }

                    redirect($url);
                }
            } // end post['act]

            // ######################################## Add/Upd End #######################################//

            // ===>form add/edit new
            $form_act = array();
            $form_act['pre'] = array();
            if (array_key_exists('ord_code', $_GET) && array_key_exists('act', $_GET) && $_GET['act'] == 'upd') {
                if ($form_act = doctrineGetRowContent($entityManager, 'RAN\Entity\Ordonnance', 'ordCode', $_GET['ord_code'])) {
                    $form_act['pre'] = $this->getOrdonnancePrescription($form_act['ord_code']);
                    $form_act['act'] = 'upd';
                }
            } else {
                if (array_key_exists('clone', $_GET)) {
                    $qb = $entityManager->createQueryBuilder();

                    $qb->select('ordonnance', 'consultation')
                        ->from('RAN\Entity\Ordonnance', 'ordonnance')
                        ->join('ordonnance.cslCode', 'consultation')
                        ->andWHere('ordonnance.cslCode <> :cslCode')
                        ->setParameter('cslCode', $csl_code)
                        ->andWhere('consultation.perCodePat=:perCode')
                        ->setParameter('perCode', $per_code)
                        ->addOrderBy('consultation.cslDate', 'DESC')
                        ->setMaxResults(1);

                    $ordonnance = $qb->getQuery()->getOneOrNullResult();
                    if (! is_null($ordonnance)) {

                        $clone_csl = $ordonnance->getCslCode();
                        $form_act['pre'] = $this->getTraitement($clone_csl);
                    } else {
                        $form_act['pre'] = array();
                    }
                } else {
                    $form_act['pre'] = $this->getTraitement($csl_code);
                }

                if (array_key_exists('act', $_GET)) {
                    $form_act = $_POST;
                    $form_act['pre'] = array();
                }
                $form_act['act'] = 'add';
            }

            $ordonnance = $entityManager->getRepository('RAN\Entity\Ordonnance')->findOneBy(array(
                'cslCode' => $csl_code
            ));

            $currOrdList = array();

            if ($ordonnance != null) {
                $currOrdList[0] = array();
                $currOrdList[0]['pre'] = $this->getOrdonnancePrescription($ordonnance->getOrdCode());
            }

            $smarty->assign("currOrdList", $currOrdList);

            // assign csl info
            $smarty->assign("cslInfo", $cslInfo);

            // assign patient info
            $smarty->assign("patInfo", $patInfo);

            // assign the last consultation
            $smarty->assign("lastCslInfo", $lastCslInfo);

            // assign status access add/upd traitement
            $smarty->assign("accessAct", $accessAct);

            // get profil list
            // $smarty->assign("proList", daoGetTableContent('periodicite', 'pro_code', 'pro_libelle', 'pro_libelle', 0));
            $smarty->assign("proList", doctrineGetTableContent($entityManager, 'RAN\Entity\Periodicite', 'proCode', 'proLibelle', 'proLibelle', 0));

            // get ordonnance list
            // $smarty->assign("tpoList", daoGetTableContent('type_ordonnance', 'tpo_code', 'tpo_libelle', 'tpo_libelle', 0));
            $smarty->assign("proList", doctrineGetTableContent($entityManager, 'RAN\Entity\TypeOrdonnance', 'tpoCode', 'tpoLibelle', 'tpoLibelle', 0));

            // get medicament list
            // $smarty->assign("mediList", daoGetTableContent('medicament', 'medi_code', 'medi_nom_com', 'medi_nom_com', 0));
        } // end valid csl
        else {
            redirect("index.php?obj=front&action=page_invalid");
        }

        $smarty->assign("form_act", $form_act);

        $smarty->display($this->tplName);
    }

    function getTraitement($csl_code)
    {
        global $entityManager;
        $liste_traitement = array();

        $qb = $entityManager->createQueryBuilder();
        $qb->select('ord')
            ->from('RAN\Entity\Ordonnance', 'ord')
            ->where('ord.cslCode=:cslCode')
            ->setParameter('cslCode', $csl_code);

        $ordonnances = $qb->getQuery()->getResult();

        foreach ($ordonnances as $ordonnance) {
            $tmp = $this->getOrdonnancePrescription($ordonnance->getOrdCode());

            foreach ($tmp as $prescription) {
                $prescription['tpo_code'] = $ordonnance->getTpoCode()->getTpoCode();
                $liste_traitement[] = $prescription;
            }
        }

        return $liste_traitement;
    }

    /**
     * Page traitement
     *
     * @access: public
     * @return: string
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function getOrdonnancePrescription($ord_code, $sqlWhere = '', $bindings = array())
    {
        global $entityManager;

        $preList = array();

        $qb = $entityManager->createQueryBuilder();
        $qb->select('prescription', 'medicament', 'ordonnance');
        $qb->from('RAN\Entity\Prescription', 'prescription');
        $qb->join('prescription.mediCode', 'medicament');
        $qb->join('prescription.ordCode', 'ordonnance');
        $qb->andWhere('prescription.ordCode=:ordCode')->setParameter('ordCode', $ord_code);

        if (! is_null($sqlWhere) && trim($sqlWhere) != '') {
            $qb->andWhere($sqlWhere);

            if (is_array($bindings)) {
                foreach ($bindings as $paramName => $paramValue) {
                    $qb->setParameter($paramName, $paramValue);
                }
            }
        }

        $results = $qb->getQuery()->getArrayResult();
        foreach ($results as $result) {
            $prescription = doctrineArrayToLegacy($entityManager, 'RAN\Entity\Prescription', $result);
            $prescription["pro_code"] = $this->proCode2Array($prescription['pro_code']);

            if (array_key_exists('mediCode', $result)) {
                $prescription = array_merge($prescription, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Medicament', $result['mediCode']));
            }
            if (array_key_exists('ordCode', $result)) {
                $prescription = array_merge($prescription, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Ordonnance', $result['ordCode']));
            }

            $preList[] = $prescription;
        }

        return $preList;
    }

    /**
     * Prescription Search Result
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function prescriptionSearchResult($cslcode = '')
    {
        global $smarty;
        global $entityManager;

        $per_code_pat = array_key_exists('per_code_pat', $_GET) ? $_GET['per_code_pat'] : null;

        if ($cslcode == '') {
            objInitVar($this, "ajax/prescription_search_result.tpl", "prescription_search_result", "prescription_search_result", "", "", "");
        } else {
            // $_GET['per_code_pat']=daoGetFieldContent('consultation', 'per_code_pat', 'csl_code', $cslcode);
            $consultation = $entityManager->find('RAN\Entity\Consultation', $cslcode);
            $per_code_pat = $entityManager->getUnitOfWork()->getEntityIdentifier($consultation->getPerCodePat())['perCode'];
        }

        if (! is_null($per_code_pat)) {

            $qb = $entityManager->createQueryBuilder();
            $qb->select('csl', 'ord', 'tpo')
                ->from('RAN\Entity\Ordonnance', 'ord')
                ->innerJoin('ord.cslCode', 'csl')
                ->innerJoin('ord.tpoCode', 'tpo')
                ->addOrderBy('csl.cslDate', 'DESC')
                ->addOrderBy('ord.ordCode', 'DESC');

            if (! is_null($cslcode) && $cslcode != '') {
                $qb->andWhere('csl.cslCode=:cslCode')->setParameter('cslCode', $cslcode);
            } else {
                $qb->andWhere('csl.perCodePat=:perCodePat')->setParameter('perCodePat', $per_code_pat);
            }

            $ordList = $qb->getQuery()->getArrayResult();

            $mediSqlWhere = '';
            $bindings = array();
            if (isset($_POST['medi_nom_com']) && trim($_POST['medi_nom_com']) != '') {
                $mediSqlWhere = 'medicament.mediNomCom LIKE :medi_nom_com';
                $bindings['medi_nom_com'] = '%' . trim($_POST['medi_nom_com']) . '%';
            }

            $i = 0;
            foreach ($ordList as $ordonnance) {

                $ordPrescription = $this->getOrdonnancePrescription($ordonnance['ordCode'], $mediSqlWhere, $bindings);

                $ordonnanceDatas = doctrineArrayToLegacy($entityManager, 'RAN\Entity\Ordonnance', $ordonnance);

                if (array_key_exists('cslCode', $ordonnance)) {
                    $ordonnanceDatas = array_merge($ordonnanceDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Consultation', $ordonnance['cslCode']));
                }

                if (array_key_exists('tpoCode', $ordonnance)) {
                    $ordonnanceDatas = array_merge($ordonnanceDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\TypeOrdonnance', $ordonnance['tpoCode']));
                }

                $ordList[$i] = $ordonnanceDatas;
                $ordList[$i]['pre'] = $ordPrescription;
                $i ++;
            }

            if ($cslcode != '') {
                return $ordList;
            }

            $smarty->assign("per_code_pat", $per_code_pat);

            $smarty->assign("ordList", $ordList);
        }

        $smarty->display($this->tplName);
        exit();
    }

    /**
     * Traitement Form Add
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function traitementFormAdd()
    {
        global $smarty;
        global $entityManager;

        objInitVar($this, "ajax/traitement_form_add.tpl", "traitement_form_add", "traitement_form_add", "", "", "");

        (isset($_POST['no_pre']) && $_POST['no_pre'] != - 1) ? $no_blankrows = $_POST['no_pre'] + 2 : $no_blankrows = 4;

        if (isset($_POST['act2']) && $_POST['act2'] == 'add') {
            $no_blankrows = $_POST['no_pre'] + 1 + 1;
        } elseif (isset($_POST['act2']) && $_POST['act2'] == 'del') {
            if ($_POST['no_pre'] >= 1)
                $no_blankrows = $_POST['no_pre'];
            else
                $no_blankrows = 1;
        }

        $form_act=array();
        $form_act['pre'] = array();
        if (isset($_POST['no_pre'])) {
            for ($i = 0; $i <= $_POST['no_pre']; $i ++) {
                $tpo_code = $_POST['tpo_code' . $i];
                $medi_code = $_POST['medi_code' . $i];
                $pro_code = $_POST['pro_code1' . $i] . $_POST['pro_code2' . $i] . $_POST['pro_code3' . $i];
                $pre_quantite = utf8_decode($_POST['pre_quantite' . $i]);
                $pre_duree = $_POST['pre_duree' . $i];
                $pre_duree_type = $_POST['pre_duree_type' . $i];
                $pre_renouvel = $_POST['pre_renouvel' . $i];
                $pre_dt_arret = $_POST['pre_dt_arret' . $i];
                $pre_bizone = $_POST['pre_bizone' . $i];
                $pre_non_substituable = $_POST['pre_non_substituable' . $i];

                $form_act['pre'][$i] = array(
                    'tpo_code' => $tpo_code,
                    'medi_code' => $medi_code,
                    'pro_code' => $pro_code,
                    'pre_quantite' => $pre_quantite,
                    'pre_duree' => $pre_duree,
                    'pre_duree_type' => $pre_duree_type,
                    'pre_renouvel' => $pre_renouvel,
                    'pre_dt_arret' => $pre_dt_arret,
                    'pre_bizone' => $pre_bizone,
                    'pre_non_substituable' => $pre_non_substituable
                );
            }
        }
        $smarty->assign("form_act", $form_act);
        $smarty->assign("no_blankrows", $no_blankrows);

        // get profil list
        $smarty->assign("proList", doctrineGetTableContent($entityManager, 'RAN\Entity\Periodicite', 'proCode', 'proLibelle', 'proLibelle', 0));

        // get ordonnance list
        $smarty->assign("tpoList", doctrineGetTableContent($entityManager, 'RAN\Entity\TypeOrdonnance', 'tpoCode', 'tpoLibelle', 'tpoLibelle', 0));

        // get medicament list
        // $smarty->assign("mediList", daoGetTableContent('medicament', 'medi_code', 'medi_nom_com', 'medi_nom_com', 0));

        $smarty->display($this->tplName);
        exit();
    }

    /**
     * Compte Rendu for Ajax
     *
     * @access: public
     * @return: null
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function compteRendu()
    {
        global $smarty;
        global $entityManager;
        
        objInitVar($this, "ajax/compte_rendu.tpl", "compte_rendu", "compte_rendu", "", "", "");

        if (isset($_GET['csl_code']) && $cslInfo = getCslInfo($_GET['csl_code'], true)) {

            $csl_code = (int) $_GET['csl_code'];

            
            // get patient info
            $patInfo = doctrineGetRowContent($entityManager, 'RAN\Entity\Patient', 'perCode', $cslInfo['per_code_pat'], null, null, true);
            $patInfo['per_code']=$cslInfo['per_code_pat'];
            
            $patInfo['per'] = getPerInfo($cslInfo['per_code_pat']);
            
            $patInfo['comm'][1] = doctrineGetFieldContent($entityManager, 'RAN\Entity\PatientComment', 'patComTxt', 'perCodePat', $cslInfo['per_code_pat'], 'patComType', 1);
            
            $patInfo['comm'][2] = doctrineGetFieldContent($entityManager, 'RAN\Entity\PatientComment', 'patComTxt', 'perCodePat', $cslInfo['per_code_pat'], 'patComType', 2);
            
            $patInfo['comm'][3] = doctrineGetFieldContent($entityManager, 'RAN\Entity\PatientComment', 'patComTxt', 'perCodePat', $cslInfo['per_code_pat'], 'patComType', 3);
            
            $medInfo = getMedInfo($cslInfo['per_code_uti']);
            
            // get traitement ordonnances
            $ordList = $this->prescriptionSearchResult($csl_code);

            // assign vars
            $smarty->assign("cslInfo", $cslInfo);
            $smarty->assign("patInfo", $patInfo);
            $smarty->assign("medInfo", $medInfo);
            $smarty->assign("ordList", $ordList);
        }

        $smarty->display($this->tplName);
        exit();
    }

    /**
     * Ordonnance Print
     *
     * @access: public
     * @return: string
     * @author: CFlorin (colotin_f@yahoo.com)
     */
    function ordonnance_print()
    {
        global $smarty;
        global $entityManager;

        if (isset($_GET['csl_code']) && $cslInfo = getCslInfo($_GET['csl_code'], true)) {
            $csl_code = $_GET['csl_code'];

            // get patient info
            $patInfo = doctrineGetRowContent($entityManager, 'RAN\Entity\Patient', 'perCode', $cslInfo['per_code_pat'], null, null, true);

            $patInfo['per'] = getPerInfo($cslInfo['per_code_pat']);

            $patInfo['comm'][1] = doctrineGetFieldContent($entityManager, 'RAN\Entity\PatientComment', 'patComTxt', 'perCodePat', $cslInfo['per_code_pat'], 'patComType', 1);

            $patInfo['comm'][2] = doctrineGetFieldContent($entityManager, 'RAN\Entity\PatientComment', 'patComTxt', 'perCodePat', $cslInfo['per_code_pat'], 'patComType', 2);

            $patInfo['comm'][3] = doctrineGetFieldContent($entityManager, 'RAN\Entity\PatientComment', 'patComTxt', 'perCodePat', $cslInfo['per_code_pat'], 'patComType', 3);

            $medInfo = getMedInfo($cslInfo['per_code_uti']);

            $pdfOrd = array();

            if (isset($_GET['print_form'])) {
                if (isset($_POST['no_pre']) && $_POST['no_pre'] > 0) {
                    for ($i = 0; $i <= $_POST['no_pre']; $i ++) {
                        ! isset($_POST['pro_code1' . $i]) ? $_POST['pro_code1' . $i] = 0 : false;
                        ! isset($_POST['pro_code2' . $i]) ? $_POST['pro_code2' . $i] = 0 : false;
                        ! isset($_POST['pro_code3' . $i]) ? $_POST['pro_code3' . $i] = 0 : false;

                        $pro_code = $_POST['pro_code1' . $i] . $_POST['pro_code2' . $i] . $_POST['pro_code3' . $i];

                        $tpo_code = $_POST['tpo_code' . $i];
                        $medi_code = $_POST['medi_code' . $i];

                        $pre_quantite = $_POST['pre_quantite' . $i];
                        $pre_duree = $_POST['pre_duree' . $i];
                        $pre_duree_type = $_POST['pre_duree_type' . $i];
                        $pre_renouvel = $_POST['pre_renouvel' . $i];
                        $pre_dt_arret = $_POST['pre_dt_arret' . $i];
                        $pre_bizone = $_POST['pre_bizone' . $i];
                        $pre_non_substituable = (isset($_POST['pre_non_substituable' . $i]) ? $_POST['pre_non_substituable' . $i] : 0);
                        $p = isset($_POST['print' . $i]) ? 1 : 0;

                        if ($p && $medi_code > 0) {

                            $pdfOrd[$tpo_code]['tpo_libelle'] = '';
                            $pdfOrd[$tpo_code]['pre'][$pre_bizone][] = array(
                                'medi_code' => $medi_code,
                                'pro_code' => $pro_code,
                                'pre_quantite' => $pre_quantite,
                                'pre_duree' => $pre_duree,
                                'pre_duree_type' => $pre_duree_type,
                                'pre_renouvel' => $pre_renouvel,
                                'pre_dt_arret' => $pre_dt_arret,
                                'pre_bizone' => $pre_bizone,
                                'pre_non_substituable' => $pre_non_substituable
                            );
                        }
                    }
                }
                foreach ($pdfOrd as $key => $val) {
                    $tmp = $val["pre"];

                    if (! isset($tmp[1]))
                        $tmp[1] = array();
                    if (! isset($tmp[2]))
                        $tmp[2] = array();

                    $pdfOrd[$key]["pre"] = $tmp;
                }

                if (count($pdfOrd) > 0) {
                    foreach ($pdfOrd as $tpo_code => $itemT) {
                        if (count($itemT['pre']) > 0) {
                            $pdfOrd[$tpo_code]['tpo_libelle'] = doctrineGetFieldContent($entityManager, 'RAN\Entity\TypeOrdonnance', 'tpoLibelle', 'tpoCode', $tpo_code);

                            foreach ($itemT['pre'] as $pre_bizone => $itemB) {
                                foreach ($itemB as $k => $itemP) {
                                    $pdfOrd[$tpo_code]['pre'][$pre_bizone][$k]['medi_nom_com'] = doctrineGetFieldContent($entityManager, 'RAN\Entity\Medicament', 'mediNomCom', 'mediCode', $itemP['medi_code']);
                                    $pdfOrd[$tpo_code]['pre'][$pre_bizone][$k]['pro_libelle'] = doctrineGetFieldContent($entityManager, 'RAN\Entity\Periodicite', 'proLibelle', 'proCode', $itemP['pro_code']);
                                }
                            }
                        }
                    }
                }
            } else {
                // get traitement ordonnances
                $ordList = $this->prescriptionSearchResult($csl_code);

                foreach ($ordList as $keyO => $itemO) {
                    $pdfOrd[$itemO['tpo_code']]['tpo_libelle'] = $itemO['tpo_libelle'];

                    foreach ($itemO['pre'] as $keyP => $itemP) {
                        $pdfOrd[$itemO['tpo_code']]['pre'][$itemP['pre_bizone']][] = $itemP;
                    }
                }
            }

            // ==================================== PDF SET HEADER ====================================//

            // header("Pragma: public"); // required // leave blank to avoid IE errors or header("Pragma: public");
            header("Expires: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0"); // leave blank to avoid IE errors
            header("Cache-Control: private", false); // required for certain browsers
            header('Content-type: application/pdf');

            //error_reporting(E_ALL);

            require_once ('tcpdf/tcpdf.php');

            // ==================================== TCPDF INIT START ====================================//

            $doc_title = "test title";
            $doc_subject = "test description";
            $doc_keywords = "test keywords";

            // create new PDF document (document units are set by default to millimeters)
            $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);

            // set document information
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor(PDF_AUTHOR);
            $pdf->SetTitle($doc_title);
            $pdf->SetSubject($doc_subject);
            $pdf->SetKeywords($doc_keywords);

            // $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

            // set margins
            $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); // set image scale factor

            $pdf->setHeaderFont(Array(
                PDF_FONT_NAME_MAIN,
                '',
                PDF_FONT_SIZE_MAIN
            ));
            $pdf->setFooterFont(Array(
                PDF_FONT_NAME_DATA,
                '',
                PDF_FONT_SIZE_DATA
            ));

            // initialize document
            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->SetFont("FreeSans", "", 10);
            // ==================================== TCPDF INIT END ====================================//

            foreach ($pdfOrd as $tpo_code => $item) {
                for ($p = 1; $p <= 2; $p ++) {
                    // print for each medecin and model lettre
                    $pdf->AddPage();

                    // Image example
                    $pdf->Image(ROOT_DIR . PUBLIC_FOLDER . "tcpdf/images/cerfa.jpg", PDF_MARGIN_LEFT, PDF_MARGIN_TOP, 20, 10, '', '', '');

                    if ($p == 2) {
                        $pdf->Text(100, 13, "DUPLICATA");
                    }

                    $htmlc = "Docteur " . htmlentities2(strtoupper($medInfo['per_nom'] . " " . $medInfo['per_prenom'])) . "
					<br>" . nl2br((ucfirst(htmlentities2($medInfo['adr_voie']))));
                    $htmlc .= "<br>" . htmlentities2($medInfo['adr_cp']) . " " . htmlentities2($medInfo['adr_ville']);

                    $pdf->writeHTMLCell(87, 50, $pdf->GetX(), $pdf->GetY() + 12, utf8_encode($htmlc), 1, 0, 0, true);
                    
                    $pdf->Text(PDF_MARGIN_LEFT + 5, $pdf->GetY() + 29, 'N° RPPS ');
		            $pdf->writeBarcode(PDF_MARGIN_LEFT+5, $pdf->GetY()+30, 30, 15, 'C128A', false, false, 2, $medInfo['med_rpps']);
                    //$pdf->Write1DBarcode($medInfo['med_rpps'],'C128A',  PDF_MARGIN_LEFT + 5, $pdf->GetY() + 30, 30, 15, 2 );
                    $pdf->Text(PDF_MARGIN_LEFT + 5, $pdf->GetY() + 30 + 18, $medInfo['med_rpps']);

                    $pdf->Text(PDF_MARGIN_LEFT + 5 + 30 + 10, $pdf->GetY() + 29, 'N° FINESS');
                    $pdf->writeBarcode(PDF_MARGIN_LEFT + 5 + 30 + 10, $pdf->GetY() + 30, 30, 15, 'C128A', false, false, 2, $medInfo['cer_no_finess']);
                    //$pdf->Write1DBarcode($medInfo['cer_no_finess'],'C128A',  PDF_MARGIN_LEFT + 5 + 30 + 10, $pdf->GetY() + 30, 30, 15, 2 );
                    $pdf->Text(PDF_MARGIN_LEFT + 5 + 30 + 10, $pdf->GetY() + 30 + 18, $medInfo['cer_no_finess']);

                    $htmlc = "Patient:
					<br>" . strtoupper($patInfo['per']['per_nom']) . " " . ucfirst($patInfo['per']['per_prenom']);
                    //$htmlc .= '.<br>Date de naissance : ' . date('d/m/y', strtotime($patInfo['pat_dt_naiss']));
                    $htmlc .= '.<br>Date de naissance : ' . $patInfo['pat_dt_naiss']->format('d/m/y');
                    $pdf->writeHTMLCell(87, 50, 108, $pdf->GetY(), utf8_encode($htmlc), 1, 0, 0, true);

                    $html = "\nDate: " . $cslInfo["csl_date"]->format('d/m/Y'). "\n";

                    $pdf->writeHTML($html, false, 0, false, true);
                    // $pdf->writeHTML("<br>", false, 0, false, false);

                    $styleLine = array(
                        "width" => 1,
                        "cap" => "butt",
                        "join" => "miter",
                        "phase" => 10,
                        "color" => array(
                            0,
                            0,
                            0
                        )
                    );

                    // foreach($item['pre'] as $pre_bizone=>$itemBizone)

                    for ($pre_bizone = 1; $pre_bizone <= 2; $pre_bizone ++) {
                        if(false===array_key_exists($pre_bizone, $item['pre'])){
                            continue;
                        }
                        $itemBizone = $item['pre'][$pre_bizone];
                        $htmlcPre = '';
                        foreach ($itemBizone as $k => $itemP) {
                            // $htmlcPre.=" - <b>".htmlentities2(ucfirst($itemP['medi_nom_com'])).":</b> ".htmlentities2($itemP['pro_libelle'])." ".htmlentities2($itemP['pre_quantite']).", ".htmlentities2($itemP['pre_duree'])."<br>";

                            $htmlcPre .= "    - <b>" . htmlentities2(ucfirst($itemP['medi_nom_com'])) . ":</b> ";

                            // On recupere dans le buffer la quantit� de medicament

                            $quantitePrescription = ($itemP["pre_quantite_access"] != "") ? $itemP['pre_quantite_access'] : $itemP['pre_quantite'];

                            // Si le traitement est prescrit le matin
                            if ($itemP['pro_code'][0] == 1) {
                                $htmlcPre .= htmlentities2($quantitePrescription . ' le matin');

                                // Si le traitement est aussi prescrit le midi
                                if ($itemP['pro_code'][1] == 1) {
                                    $htmlcPre .= htmlentities2(', ' . $quantitePrescription . ' le midi');
                                }

                                // Si le traitement est aussi prescrit le soir
                                if ($itemP['pro_code'][2] == 1) {
                                    $htmlcPre .= htmlentities2(', ' . $quantitePrescription . ' le soir');
                                }
                            } // Si le traitement n'est pas prescrit le matin
                            else {
                                // Si le traitement est prescrit le midi
                                if ($itemP['pro_code'][1] == 1) {
                                    $htmlcPre .= htmlentities2($quantitePrescription . ' le midi');

                                    // Si le traitement est aussir prescrit le soir
                                    if ($itemP['pro_code'][2] == 1) {
                                        $htmlcPre .= htmlentities2($quantitePrescription . ', le soir');
                                    }
                                } // Si le traitement n'est pas prescrit le midi (ni le matin)
                                else {
                                    // Si le traitement est prescrit le soir
                                    if ($itemP['pro_code'][2] == 1) {
                                        $htmlcPre .= htmlentities2($quantitePrescription . ' le soir');
                                    } // Si le traitement n'est pas prescrit le soir (ni le matin, ni le midi)
                                    else {
                                        $htmlcPre .= htmlentities2($quantitePrescription);
                                    }
                                }
                            }

                            if ($itemP["pre_duree_access"] != "")
                                $htmlcPre .= " " . htmlentities2("Dur&eacute;e: " . $itemP['pre_duree_access']);
                            else {
                                $htmlcPre .= " " . htmlentities2("Dur&eacute;e: " . $itemP['pre_duree']);

                                switch ($itemP["pre_duree_type"]) {
                                    case "j":
                                        $htmlcPre .= htmlentities2(" jour(s)");
                                        break;

                                    case "s":
                                        $htmlcPre .= htmlentities2(" semaine(s)");
                                        break;

                                    case "m":
                                        $htmlcPre .= htmlentities2(" mois");
                                        break;
                                }
                            }
                            if ($itemP['pre_renouvel'] > 0)
                                $htmlcPre .= ", " . htmlentities2("&agrave; renouveler " . $itemP['pre_renouvel'] . " fois");

                            if ($itemP['pre_dt_arret'] != "") {
                                $htmlcPre .= htmlentities2(" - Date arret " . $itemP['pre_dt_arret']);
                            }
                            if ($itemP['pre_non_substituable'] != 0)
                                $htmlcPre .= ', ' . htmlentities2('non substituable MTE');

                            $htmlcPre .= "<br>";
                        }

                        if ($pre_bizone == 1)
                            $htmlc = "<hr><table border=\"0\"><tr><td cellspacing=\"0\" cellpadding=\"0\" width=\"719\" align=\"center\">Prescriptions relatives au traitement de l'affection de longue dur&eacute;e reconnue (liste ou hors liste)<br>(AFFECTION EXONERANTE)</td></tr></table><hr>";
                        else
                            $htmlc = "<hr><table border=\"0\"><tr><td width=\"719\" align=\"center\">Prescriptions SANS RAPPORT avec l'affection de longue dur&eacute;e<br>(MALADIES INTERCURRENTES)</td></tr></table><hr>";

                        $pdf->writeHTMLCell(180, 0, 0, $pdf->GetY() + 5, "<br>" . $htmlc, 0, 1, 0, true);

                        $pdf->writeHTMLCell(180, 0, 0, 0, $htmlcPre, 0, 1, 0, true);
                    }
                }
            }

            // Close and output PDF document
            $pdf->Output();

            exit();
        } else
            echo "Error!";
    }

    function deleteCslOrdonnance($csl_code)
    {
        global $entityManager;

        $qb = $entityManager->createQueryBuilder();

        $qb->select('ord')
            ->from('RAN\Entity\Ordonnance', 'ord')
            ->andWhere('ord.cslCode=:cslCode')
            ->setParameter('cslCode', $csl_code);

        $ordonnances = $qb->getQuery()->getResult();

        foreach ($ordonnances as $ordonnance) {
            $entityManager->beginTransaction();
            doctrineDelete($entityManager, '\RAN\Entity\Prescription', 'ordCode', $ordonnance->getOrdCode());
            $entityManager->remove($ordonnance);
            $entityManager->flush();
            $entityManager->commit();
        }
    }

    function patient_consult_upd($per_code_pat)
    {
        global $entityManager;
        if (isset($_SESSION[SESS_IDX][UL])) {
            $per_code_uti = $_SESSION[SESS_IDX][UL]["per_code_uti"];

            $queryPC = $entityManager->createQuery('DELETE RAN\Entity\PatientsConsultes p WHERE p.perCodeUti=:perCodeUti and p.perCodePat=:perCodePat')
                ->setParameter('perCodeUti', $entityManager->getReference('RAN\Entity\Utilisateur', $per_code_uti))
                ->setParameter('perCodePat', $entityManager->getReference('RAN\Entity\Patient', $per_code_pat));
            $queryPC->execute();

            $queryPC = $entityManager->createQuery('SELECT p FROM RAN\Entity\PatientsConsultes p ORDER BY p.patUtiTs DESC')->setFirstResult(40);
            $patsConsultsToDelete = $queryPC->getResult();
            foreach ($patsConsultsToDelete as $patConsultToDelete) {
                $entityManager->remove($patConsultToDelete);
            }

            $patConsult = new \RAN\Entity\PatientsConsultes();
            $patConsult->setPerCodePat($entityManager->find('RAN\Entity\Patient', $per_code_pat));
            $patConsult->setPerCodeUti($entityManager->find('RAN\Entity\Utilisateur', $per_code_uti));
            $patConsult->setPatUtiTs(new DateTime());
            $entityManager->persist($patConsult);

            $entityManager->flush();
        }
    }

    function proCode2Array($pro_code)
    {
        $pro_code = sprintf('%03d', $pro_code);
        return array(
            $pro_code[0],
            $pro_code[1],
            $pro_code[2]
        );
    }

    function medic_substituable()
    {
        
        global $entityManager;
        
        $medi_code = $_REQUEST['medi_code'];

        $med=$entityManager->find('RAN\Entity\Medicament', $medi_code);
        
        echo $med->getMediNonSubstituable() ? 0 : 1;
        
//         $daoMedic = DB_DataObject::factory('medicament');

//         $daoMedic->get($medi_code);
//         echo $daoMedic->medi_non_substituable == 1 ? 0 : 1;
    }

    function medic_info()
    {
        $medi_code = $_REQUEST['medi_code'];
        $daoMedic = DB_DataObject::factory('medicament');
        $daoMedic->get($medi_code);
        $medic_info = $daoMedic->toArray();

        $htmlResponse = '<?xml version="1.0" encoding="UTF-8"?>';
        $htmlResponse .= '<medicament id="' . $medi_code . '">';
        while (list ($field, $value) = each($medic_info)) {
            $htmlResponse .= '<attribute name="' . $field . '">' . $value . '</attribute>';
        }
        $htmlResponse .= '</medicament>';
        die(utf8_encode($htmlResponse));
    }

    function medic_suggest()
    {
        global $entityManager;

        $post = array_values($_POST);
        $nom = (isset($post[0]) ? $post[0] . '%' : $nom = '');

        $ret = "<ul>";
        if ($nom != "") {
            $query = $entityManager->createQuery("SELECT med FROM RAN\Entity\Medicament med WHERE med.mediNomCom like :mediNomCom");
            $query->setParameter('mediNomCom', $nom);
            $query->setMaxResults(100);
            $medicaments = $query->getResult();

            foreach ($medicaments as $medicament) {
                $ret .= "<li id='" . $medicament->getMediCode() . "'>" . htmlspecialchars($medicament->getMediNomCom(), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1') . "</li>";
            }
        }

        $ret .= "</ul>";

        echo $ret;
    }

    function csl_del()
    {
        global $entityManager;
        
        isset($_GET["csl_code"]) ? $csl_code = $_GET["csl_code"] : $csl_code = "";

        if ($csl_code != "") {
//            $csl = DB_DataObject::factory('consultation');
//            $csl->csl_code = $csl_code;

            $csl=$entityManager->find('RAN\Entity\Consultation', $csl_code);
            
            
            if(!is_null($csl)){
               $pat_code = $csl->getPerCodePat()->getPerCode()->getPerCode();
                
               $entityManager->remove($csl);
               
               $courrierEdite=$entityManager->getRepository('RAN\Entity\CourrierEdite')->findOneBy(array('cslCode'=> $csl_code));
               if(!is_null($courrierEdite)){
                   $entityManager->remove($courrierEdite);
               }
               
               $compteRendu=$entityManager->getRepository('RAN\Entity\CompteRendu')->findOneBy(array('cslCode'=> $csl_code));
               if(!is_null($compteRendu)){
                   $entityManager->remove($compteRendu);
               }
               
               $ordonnances=$entityManager->getRepository('RAN\Entity\Ordonnance')->findBy(array('cslCode'=> $csl_code));
               if(!is_null($compteRendu)){
                   foreach($ordonnances as $ordonnance){
                       $entityManager->remove($ordonnance);
                       
                       $prescription=$entityManager->getRepository('RAN\Entity\Prescription')->findOneBy(array('cslCode'=> $csl_code));
                       if(!is_null($prescription)){
                            $entityManager->remove($prescription);
                       }
                   }
               }
               
               $cslParamsBio=$entityManager->getRepository('RAN\Entity\ConsultParamBio')->findBy(array('cslCode'=> $csl_code));
               if(!is_null($cslParamsBio)){
                   foreach($cslParamsBio as $cslParamBio){
                       $entityManager->remove($cslParamBio);
                   }
               }
               $entityManager->flush();
            }
            
//             if ($csl->find(true) == 1) {
//                 $pat_code = $csl->per_code_pat;

//                 // efface courrier
//                 $courrier = DB_DataObject::factory('courrier_edite');
//                 $courrier->csl_code = $csl_code;
//                 $courrier->delete();
//                 $courrier->free();

//                 // efface compte rendu
//                 $cpt_rendu = DB_DataObject::factory('compte_rendu');
//                 $cpt_rendu->csl_code = $csl_code;
//                 $cpt_rendu->delete();
//                 $cpt_rendu->free();

//                 // efface ordonnance
//                 // Recup ordonnances
//                 $ord = DB_DataObject::factory('ordonnance');
//                 $ord->csl_code = $csl_code;

//                 $ord->find();

//                 // Pour chaque ordonnance
//                 while ($ord->fetch()) {
//                     // delete prescription
//                     $pre = DB_DataObject::factory('prescription');
//                     $pre->ord_code = $ord->ord_code;
//                     $pre->delete();

//                     $ord->delete();
//                 }

//                 // efface parametre bio
//                 $csl_param_bio = DB_DataObject::factory('consult_param_bio');

//                 $csl_param_bio->csl_code = $csl_code;
//                 $csl_param_bio->delete();

//                 // efface consult
//                 $csl->delete();
//             }

            $_SESSION["notify"] = "La consultation a &eacute;t&eacute; supprim&eacute;e";

            redirect("index.php?obj=patient&action=page_consultation&per_code=" . $pat_code);
        }
    }

    function clairance_upd()
    {
        $csl_param_bio = DB_DataObject::factory('consult_param_bio');
        $csl_param_bio->pbi_code = CREATININE_CODE;
        $csl_param_bio->find();

        while ($csl_param_bio->fetch()) {
            $csl = DB_DataObject::factory('consultation');
            $csl->csl_code = $csl_param_bio->csl_code;
            $csl->find(true);

            $patInfo = getPatientInfo($csl->per_code_pat);

            $cpb_clairance = DB_DataObject::factory('consult_param_bio');
            $cpb_clairance->pbi_code = CLAIRANCE_CODE;
            $cpb_clairance->csl_code = $csl->csl_code;

            if ($cpb_clairance->find(true))
                $cpb_clairance->delete();

            $cpb_clairance->cpb_valeur = getClairance($patInfo['age'], $patInfo['pat_sexe'], $csl_param_bio->cpb_valeur);
        }
    }
}

?>
