<?php
// #########################################################################//
// # Utilisateur class
// #
// # Author: CFlorin (E-mail: colotin_f@yahoo.com)
// # Date: 28.01.2008
// #########################################################################//
class utilisateur {
	var $tplName = "";
	var $moduleName = "";
	var $pagingAction = "";
	var $tableName = "utilisateur";
	var $idName = "per_code_uti";
	var $flagName = "uti_cpt_bloque";
	var $tableFields = ""; // array("per_code", "rol_code", "cer_code", "civ_code", "per_nom", "per_prenom", "uti_identifiant", "uti_password", "uti_cpt_bloque", "uti_email");
	
	/**
	 * Constructor
	 *
	 * @access : public
	 * @return : null
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function utilisateur($action = "") {
		$tableData = getTableFields ( $this->tableName, ROOT_DIR . "DAO/ini/ran.ini" );
		$this->tableFields = $tableData ["fields"];
		
		switch ($action) {
			case "page_act" :
				checkUtilisateurAccess ( 'UTILISATEUR', 'RW' );
				$this->page_act ();
				break;
			
			case "add_upd" :
				checkUtilisateurAccess ( 'UTILISATEUR', 'RW' );
				$this->add_upd ();
				break;
			
			case "page_list" :
				checkUtilisateurAccess ( 'UTILISATEUR' );
				$this->page_list ();
				break;
			
			case "logout" :
				$this->logout ();
				break;
			
			case "page_start" :
				$this->page_start ();
				break;
			
			case "auth_print" :
				$this->auth_print ();
				break;
			
			case "clear_auth_attempts" :
				checkUtilisateurAccess ( 'UTILISATEUR', 'RW' );
				$this->clear_auth_attempts ();
				break;
			
			case "page_pwd_reset" :
				$this->page_pwd_reset ();
				break;
			
			case 'page_profile' :
				checkUtilisateurAccess ( 'UTILISATEUR' );
				$this->page_profile ();
				break;
			
			default :
				$this->page_login ();
				break;
		}
	}
	
	
	function page_profile() {
	    
	    global $smarty;
	    global $entityManager;
	    $per_code_uti = (isset ( $_SESSION [SESS_IDX] [UL] [$this->idName] ) ? $_SESSION [SESS_IDX] [UL] [$this->idName] : null);
	    $form_act = (isset ( $_REQUEST ['form_act'] ) ?  $_REQUEST ['form_act'] : null);
	    if (!is_null ( $per_code_uti )) {
	        if ('upd' == $form_act) {
	            $user=$entityManager->find('RAN\Entity\Utilisateur', $per_code_uti);
	            if (isset ( $_REQUEST ['uti_password'] )) {
	                if (strlen ( $_REQUEST ['uti_password'] ) > 0) {
	                    if ($this->checkPassword ( $_REQUEST ['uti_password'] )) {
	                        $user->setUtiPassword(sha1 ( $_REQUEST ['uti_password']));
	                        $user->setUtiPwdDate = new DateTime();
	                    } else {
	                        $err = 'Le mot de passe ne respecte pas la convention de s�curit� ' . $_POST [$field];
	                    }
	                }
	            }
	            if (isset ( $_REQUEST ['uti_email'] )) {
	                $user->setUtiEmail = $_REQUEST ['uti_email'];
	            }
	            
	            $entityManager->flush($user);
	        }
	        
	        $form_act = $this->getUtilisateurInfo ( $per_code_uti, array (
	            'uti_password'
	        ) );
	        
	        $smarty->assign ( 'form_act', $form_act );
	        $smarty->assign ( "civList", doctrineGetTableContent($entityManager,'RAN\Entity\Civilite', 'civCode', 'civLibelleLong', 'civLibelleLong',0));
	        $smarty->display ( 'frontend/page_profile.tpl' );
	    }
	}
	
	/**
	 * Get Utilisateur Info
	 *
	 * @access : public
	 * @return : null
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function getUtilisateurInfo($id, $excluded = array()) {
	    global $entityManager;
	    
	    
	    
	    $user=$entityManager->find('RAN\Entity\Utilisateur', $id);
	    
	    $med=$entityManager->find('RAN\Entity\Medecin', $user->getPerCodeUti());
	    
		$userInfo =array();
		$userInfo['uti_identifiant']=$user->getUtiIdentifiant();
		$userInfo['uti_email']=$user->getUtiEmail();
		$userInfo['uti_cpt_bloque']=$user->getUtiCptBloque();
		$userInfo['uti_no_faild_login']=$user->getUtiNoFaildLogin();
		$userInfo['uti_chlg_date']=$user->getUtiChlgDate();
		$userInfo['uti_pwd_date']=$user->getUtiPwdDate();
		$userInfo['rol_code']=$user->getRolCode()->getRolCode();
		$userInfo['cer_code']=$user->getCerCode()->getCerCode();
		$userInfo['per_code_uti']=$user->getPerCodeUti()->getPerCode();
		
		$userInfo ['per'] = getPerInfo ( $id );
		$userInfo ['is_medecin'] = !is_null($med);
		
		$query=$entityManager->createQuery('SELECT h FROM RAN\Entity\Habilite h WHERE h.rolCode=:rolCode');
		$query->setParameter('rolCode', $user->getRolCode());
		$habilites=$query->getResult();

		$userInfo['habilite'] = array ();
		foreach($habilites as $habilite){
		    $userInfo['habilite'][$habilite->getFcaCode()->getFcaCode()] [$habilite->getHabCode()->getHabCode()] = 1;
		}
				
		if (is_array ( $excluded )) {
			foreach ( $excluded as $key => $value ) {
				unset ( $userInfo [$value] );
			}
		}
		
		return $userInfo;
	}
	
	/**
	 * Fonction pour gerer la page d'accueil
	 */
	function page_start() {
		global $smarty;
		
		$smarty->display ( "frontend/page_start.tpl" );
	}
	
	/**
	 * Fonction qui gère la réinitialisation des essai d'authentification
	 */
	function clear_auth_attempts() {
	    global $entityManager;
		isset ( $_GET ["per_code_uti"] ) ? $per_code_uti = intval ( $_GET ["per_code_uti"] ) : $per_code_uti = "";
		
		if (! is_null ( $per_code_uti )) {
		    $users=$entityManager->find('RAN\Entity\Utilisateur', $per_code_uti);
		    if(count($users)==1){
		        $users[0]->setUtiNoFaildLogin=0;
		        $entityManager->flush($users[0]);
		    }
		}
		redirect ( 'index.php?obj=utilisateur&action=page_act&per_code_uti=' . $per_code_uti . '&act=upd' );
	}
	
	/**
	 * Page login
	 *
	 * @access : public
	 * @return : null
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function page_login() {
		global $smarty;
		global $entityManager;
		objInitVar ( $this, "frontend/page_login.tpl", "", "", "", "", "" );
		
		if (isset ( $_SESSION [SESS_IDX] [UL] ))
			redirect ( "index.php?obj=patient&action=page_list" );
			
		if (isset ( $_POST ['user'] ) && isset ( $_POST ['pass'] )) {
			$user = $_POST ['user'];
			$pass = $_POST ['pass'];
			
			$errLogin = 0;
			
			$userCheckQuery='SELECT u FROM RAN\Entity\Utilisateur u WHERE u.utiIdentifiant=:utiId';
			$chlgCheckQuery='SELECT ua FROM RAN\Entity\UtilisateurAuth ua WHERE ua.perCodeUti=:utiId and ua.authCoord=:coord and ua.authValeur=:val';
			
			$query=$entityManager->createQuery($userCheckQuery);
			$query->setParameter('utiId', $user);
			$query->useResultCache(false);
			$users=$query->getResult();
			
			$errLogin=0;
			
			//L'utilisateur existe
			if(count($users)==1){
			    $user=$users[0];

			    //Si le compte est bloqué
			    if($user->getUtiCptBloque()!=0){
			        $errLogin = 3; // account blocked by admin
			    }
			    //Si le nombre de connexion en erreur est dépassé
			    elseif ($user->getUtiNoFaildLogin() >= AUTH_MAX_ATTEMPTS) {
			        $errLogin = 2; // account blocked for to much no tries
			        $smarty->assign ( 'uti_no_faild_login', $user->getUtiNoFaildLogin());
			    }
			    //Si le compte n'est pas bloqué 
			    else{
			        //Si le mot de passe est invalide 
                    if($user->getUtiPassword()!=sha1($pass)){
                        $errLogin=2;
                    }
                    //Si le mot de passe est valide
                    else{
                        //On vérifie le challenge
        			    $query=$entityManager->createQuery($chlgCheckQuery);
			
                        for($i = 1; $i <= AUTH_NO_CHALLENGE; $i++) {
                            $query->setParameter('utiId', $user->getPerCodeUti());
            			    $query->setParameter('coord', $_POST ['challenge_coord_'.$i]);
        			        $query->setParameter('val', $_POST ['challenge_valeur_'.$i]);
        			        
        			        if (false and (count($query->getResult()) == 0)){
                                $errLogin = 2;
        			        }
        			    }
                    }
			    }
			    
			    //Si la connexion est valide
			    if($errLogin == 0) {
			        $user->setUtiNoFaildLogin(0);
			        $entityManager->persist($user);
			        $entityManager->flush($user);
			        
			        
			        // ===> session user register
			        unset ( $_SESSION [SESS_IDX] );
			        $_SESSION [SESS_IDX] [UL] = array ();
			        $_SESSION [SESS_IDX] [UL] = $this->getUtilisateurInfo ($user->getPerCodeUti()->getPerCode());
			        $_SESSION [SESS_IDX] [UL] ['auth'] = 1;
			        // <===
			        
			        
			        redirect ( "index.php?obj=patient&action=page_list" );
			    }
			    else{
			        $user->setUtiNoFaildLogin( $user->getUtiNoFaildLogin()+1);
			        $entityManager->flush($user);
			        $smarty->assign('uti_no_faild_login', $user->getUtiNoFaildLogin());
			    }
			}
			//L'utilisateur n'existe pas
			else{
			    $errLogin = 1;
			}
			$smarty->assign ( "errLogin", $errLogin );
		}
		
		$smarty->assign ( "challenge_list", getAuthChallenge () );
		
		$smarty->display ( $this->tplName );
		
		
	}
	
	function page_pwd_reset() {
		global $smarty;
		global $entityManager;
		
		objInitVar ( $this, "frontend/page_pwd_reset.tpl", "page_pwd_reset", "", "", "", "" );
		
		$step = (isset ( $_REQUEST ['step'] ) ? $_REQUEST ['step'] : null);
		
		if (is_null ( $step )) {
			$smarty->display ( 'frontend/page_pwd_reset.tpl' );
		}
		else {
			if ($step === 'sendMail') {
				$login = (isset ( $_POST ['login'] ) ? $_POST ['login'] : null);
				$email = (isset ( $_POST ['email'] ) ? $_POST ['email'] : null);
				
				if (! is_null ( $login ) && ! is_null ( $email )) {
				    $utilisateur=$entityManager->getRepository('RAN\Entity\Utilisateur')->findOneBy(array('utiIdentifiant'=>$login));
				    
				    
				    if(!is_null($utilisateur)){
    				    $userPwdResets=$entityManager->getRepository('RAN\Entity\UtilisateurPwdReset')->findBy(array('perCodeUti'=>$utilisateur));
    				    foreach($userPwdResets as $userPwdReset){
    				        $entityManager->remove($userPwdReset);
    				    }
    				    $entityManager->flush();
    				    
    				    $token = sha1 ( microtime () . '_' . $login );
    				    $userPwdReset=new RAN\Entity\UtilisateurPwdReset();
    				    $userPwdReset->setUprToken($token);
    				    $userPwdReset->setUprDate(new DateTime());
    				    $userPwdReset->setPerCodeUti($utilisateur);
    				    $entityManager->persist($userPwdReset);
    				    
    				    $entityManager->flush();
				    
						$connection = new Swift_SmtpTransport ( SMTP_SERVER, SMTP_PORT, SMTP_OPTION );
						$connection->setUserName ( EMAIL_FROM_ADDR );
						$connection->setPassword ( EMAIL_FROM_PWD );
						$mailer = new Swift_Mailer ( $connection );
						$message = new Swift_Message ( 'R@n - Changement de mot de passe' );
						$message->setFrom ( EMAIL_FROM_NAME );
						$message->setTo ( array (
								$email 
						) );
						$reset_url = ROOT_HOST . 'index.php?=obj=utilisateur&action=page_pwd_reset&step=resetPwd&token=' . $token;
						$smarty_mail = getSmartyInstance ();
						$smarty_mail->assign ( 'reset_url', $reset_url );
						$message->setBody ( $smarty_mail->fetch ( 'mail/mail_reset_password.tpl' ), 'text/html' );
						$mailer->send ( $message );
						$connection->stop ();
						
						$smarty->assign ( 'msg', 'Un email de r&eacute;initialisation a &eacute;t&eacute; envoy&eacute; � l\'adresse du compte.' );
						$smarty->display ( 'frontend/page_pwd_reset.tpl' );
					} else {
						$smarty->assign ( 'msg', 'Les informations saisies sont invalides.' );
						$smarty->display ( 'frontend/page_pwd_reset.tpl' );
					}
				}
			}
			if ($step === 'resetPwd') {
				$token = (isset ( $_REQUEST ['token'] ) ? $_REQUEST ['token'] : null);
				$login = (isset ( $_REQUEST ['login'] ) ? $_REQUEST ['login'] : null);
				$password = (isset ( $_REQUEST ['password'] ) ? $_REQUEST ['password'] : null);
				
				if (! is_null ( $token )) {
				    $userPwdReset=$entityManager->getRepository('RAN\Entity\UtilisateurPwdReset')->findOneBy(array('uprToken'=>$token));
				    
				    if(!is_null($userPwdReset)){
				        if(!is_null($userPwdReset->getPerCodeUti())){
				            if (!is_null ( $password )) {
				                if ($this->checkPassword ( $password )) {

        				            $utilisateur=$userPwdReset->getPerCodeUti();
        				            $utilisateur->setUtiPassword(sha1 ( $password ));
        				            
        				            $entityManager->persist($utilisateur);
        				            $entityManager->remove($userPwdReset);
        				            
        				            $entityManager->flush();
									$smarty->assign ( 'msg', 'Votre mot de passe a &eacute;t&eacute; mise &agrave; jour.' );
								} 
								else {
									$smarty->assign ( 'err', 1 );
									$smarty->assign ( 'msg', 'Le mot de passe ne respecte pas les r&egrave;gles de s&eacute;curit&eacute;.' );
								}
						  }
    					} else {
    						$smarty->assign ( 'err', 1 );
    						$smarty->assign ( 'msg', 'Le lien de r&eacute;initialisation n\'est pas valide ou expir&eacute;.' );
    					}
				    }
				    else {
				        $smarty->assign ( 'err', 1 );
				        $smarty->assign ( 'msg', 'Le lien de r&eacute;initialisation n\'est pas valide ou expir&eacute;.' );
				    }
					
					$smarty->assign ( 'token', $token );
				} else {
					$smarty->assign ( 'err', 1 );
					$smarty->assign ( 'msg', 'Le lien de r&eacute;initialisation n\'est pas valide.' );
				}
				$smarty->display ( 'frontend/page_pwd_reset_step2.tpl' );
			}
		}
	}
	
	/**
	 * Page act (add/upd form)
	 *
	 * @access : public
	 * @return : null
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function page_act() {
	    global $entityManager, $smarty;
		
		objInitVar ( $this, "frontend/utilisateur_act.tpl", "page_act", "", "", "", "" );
		
		$form_act = array ();
		
		$id = "";
		if (isset ( $_GET ['act'] ) && 'upd' == $_GET ['act']) {
			if (isset ( $_GET [$this->idName] ) && $_GET [$this->idName] != '')
				$id = $_GET [$this->idName];
			elseif (isset ( $_SESSION [SESS_IDX] [UL] [$this->idName] ) && $_SESSION [SESS_IDX] [UL] [$this->idName] != '')
				$id = $_SESSION [SESS_IDX] [UL] [$this->idName];
			else {
				echo "Invalid ID";
				exit ();
			}
			
			$form_act = $this->getUtilisateurInfo ( $id, array (
					'uti_password' 
			) );
			
			$form_act ['act'] = 'upd';
		} else {
			if (isset ( $_POST ))
				$form_act = $_POST;
			
			$form_act ['act'] = 'add';
		}
		
		if (array_key_exists ( 'uti_password', $form_act )) {
			// On supprime le password de la liste
			unset ( $form_act ['uti_password'] );
		}
		
		// assign variables
		$smarty->assign ( "form_act", htmlArrayFilter ( $form_act ) );
		
		// get pay list
		$smarty->assign ( "payList", doctrineGetTableContent ($entityManager, 'RAN\Entity\Pays', 'payCode', 'payNom', 'payNom', 0 ) );
		// get role list
		$smarty->assign ( "rolList", doctrineGetTableContent ( $entityManager,'RAN\Entity\Role', 'rolCode', 'rolLibelle', 'rolLibelle', 0 ) );
		// get centre de rattachement list
		$smarty->assign ( "cerList", doctrineGetTableContent ( $entityManager,'RAN\Entity\CentreDeRattachement', 'cerCode', 'cerNom', 'cerNom', 0 ) );
		// get civilite list
		$smarty->assign ( "civList", doctrineGetTableContent ($entityManager, 'RAN\Entity\Civilite', 'civCode', 'civLibelleLong', 'civLibelleLong', 0 ) );
		
		$smarty->display ( $this->tplName );
	}
	
	/**
	 * Methode qui vérifie si un mot de passe respecte la règle de sécurité
	 * 
	 * @param $password Chaine representant le mot de passe à vérifier
	 
	 * @return boolean TRUE si le mot de passe est une chaine de caractère valide, FALSE sinon
	 */
	protected function checkPassword($password) {
		return is_string($password) && (1 == preg_match ( '/^(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9]).{8,}$/', $password ));
	}
	
	/**
	 * Add/Update operation
	 *
	 * @access : public
	 * @return : array
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function add_upd() {
	    error_reporting(E_ALL);
	    global $entityManager;
		if (isset ( $_POST ['act'] ) && ($_POST ['act'] == "add" || $_POST ['act'] == "upd")) {
			$err = 0;
			
			//Si on ajoute un utilisateur
			if ($_POST ['act'] == "add") {
			    //Si un identifiant est fourni
			    if(isset($_POST ['uti_identifiant']) && strlen(trim($_POST ['uti_identifiant']))>0){
			        //On vérifie qu'il n'est pas utilisé
                    if(count($entityManager->getRepository('RAN\Entity\Utilisateur')->findBy(array('utiIdentifiant'=>$_POST ['uti_identifiant'])))>0) {
	   		             $err=1;
	   		        }
			    }
			    //Si aucun identifiant fourni, on ne peut pas creer l'utilisateur
			    else{
			        $err=1;
			    }
			}
			
			//S'il n'y a pas d'erreur
			if($err==0){
    			$utilisateur=null;
    			
    			//Si l'identifiant d'un utilisateur est fourni
    			if(isset($_POST[$this->idName]) && !empty($_POST[$this->idName])){
    			    //On recupere les informations de l'utilisateur en base
    			    $utilisateur=$entityManager->find('RAN\Entity\Utilisateur', $_POST[$this->idName]);
    			    $entityManager->refresh($utilisateur);
    			}
    			else{
    			    //On initialise le nouvel utilisateur
    			    $utilisateur=new RAN\Entity\Utilisateur();
    			}
    			
    			$personne=$utilisateur->getPerCodeUti();
    			//Si la personne associée à l'utilisateur n'existe pas encore
    			if(is_null($personne)){
    			    //On créé la personne pour l'enregistrement
    			    $personne=new RAN\Entity\Personne();
    			    $utilisateur->setPerCodeUti($personne);
    			}
    			$personne->setCivCode($entityManager->getReference('RAN\Entity\Civilite', $_POST['civ_code']));
    			$personne->setPerNom($_POST['per_nom']);
    			$personne->setPerPrenom( $_POST['per_prenom']);
    			
    			//On met à jour le code du centre de rattachement
    			if ($_POST['cer_code']!=""){
    			    $personne->setCerCode($entityManager->getReference('RAN\Entity\CentreDeRattachement', $_POST['cer_code']));
    			}
    			else{
    			    $personne->setCerCode(null);
    			}
    			
    			//On met à jour l'adresse de la personne
    			$adresses=$personne->getAdrCode();
    			if(count($adresses)==0){
    			    $adresse=new RAN\Entity\AdressePostale();
    			    $adresse->addPerCode($personne);
    			}
    			else{
    			    $adresse=$adresses[0];
    			}
    			$adresse->setAdrVoie($_POST['adr_voie']);
    			$adresse->setAdrCp($_POST['adr_cp']);
    			$adresse->setAdrVille($_POST['adr_ville']);
    			
    			//Si le mot de passe est à mettre à jour
    			if(isset($_POST['uti_password']) && strlen ( $_POST ['uti_password'] ) > 0){
    			    //S'il respecte les normes de sécurités
    			    if ($this->checkPassword($_POST['uti_password'])) {
    			        //On met à jour le mot de passe de l'utilisateur
    			        $utilisateur->setUtiPassword(sha1(trim($_POST['uti_password'])));
    			        $utilisateur->setUtiPwdDate(new DateTime());
    			    } else {
    			        $err = 'Le mot de passe ne respecte pas la convention de s�curit� ' . $_POST [uti_password];
    			    }
    			}
    			
    			//Si l'identifiant est fourni et qu'il n'est pas vide
    			if(isset($_POST['uti_identifiant']) && strlen (trim($_POST ['uti_identifiant'])) > 0){
    			    $utilisateur->setUtiIdentifiant($_POST ['uti_identifiant']);
    			}
    			
    			//Si un role est fourni
    			if(isset($_POST['rol_code'])){
    			    //Si le role correspond à un identifiant de role
    			    if(strlen ($_POST ['rol_code']) > 0){
        			    $utilisateur->setRolCode($entityManager->getReference('RAN\Entity\Role',$_POST ['rol_code']));
    			    }
    			    //Si le role est vide
    			    else{
    			        $utilisateur->setRolCode(null);
    			    }
    			}
    			
    			$utilisateur->setUtiCptBloque($_POST ['uti_cpt_bloque']);
    			$utilisateur->setUtiEmail($_POST['uti_email']);
    			
    			//On sauvegarde les mises à jour
    			$entityManager->persist($personne);
    			$entityManager->persist($adresse);
    			$entityManager->persist($utilisateur);
    			
    			$entityManager->flush();
			}
			
			if (0 === $err) {
				if (isset ( $_SESSION [SESS_IDX] [UL] [$this->idName] ) && $id == $_SESSION [SESS_IDX] [UL] [$this->idName]) {
					// ===> session user register
					$_SESSION [SESS_IDX] [UL] = $this->getUtilisateurInfo ( $id );
					$_SESSION [SESS_IDX] [UL] ['auth'] = 1;
					// <===
				}
				
				redirect ( "index.php?obj={$_GET['obj']}&action=page_act&{$this->idName}={$id}&act=upd" );
			} else {
				global $smarty;
				
				$smarty->assign ( "err", $err );
				$this->page_act ();
			}
		} else
			redirect ( "index.php?obj=front&action=page_invalid" );
	}
	
	/**
	 * Page list/edit
	 *
	 * @access : public
	 * @return : null
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function page_list() {
		global $smarty;
		global $entityManager;
		
		
		objInitVar ( $this, "frontend/utilisateur_list.tpl", "utilisateur_list", "page_list", "", "", "" );
		
		if (isset ( $_POST ["act"] ) && $_POST ["act"] == "delete")
			$this->deleteMItems ();
		
		$smarty->assign ( "recList", $this->getList () );
		$smarty->assign ( "moduleSession", $_SESSION [SESS_IDX] [$this->moduleName] );
		
		// get r�le list
		$smarty->assign ( "rolList", doctrineGetTableContent ($entityManager, 'RAN\Entity\Role', 'rolCode', 'rolLibelle', 'rolLibelle', 0 ) );
		
		$smarty->display ( $this->tplName );
	}
	
	/**
	 * Get Users List
	 *
	 * @access : public
	 * @return : array
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function getList() {
	    global $entityManager;
	    
	    if (isset ( $_POST ["act"] ) && $_POST ["act"] == "search"){
	        search ( $this->moduleName );
	    }
	    
	    $qb=$entityManager->createQueryBuilder();
	    $qb->select('civ','per', 'uti', 'role');
	    $qb->from('RAN\Entity\Utilisateur', 'uti');
	    $qb->innerJoin('uti.perCodeUti', 'per');
	    $qb->innerJoin('uti.perCodeUti', 'role');
	    $qb->innerJoin('per.civCode', 'civ');
	    
	    $sqlSort = newSort ( $this->moduleName, "{$this->tableName}.{$this->idName}", 'DESC' );
	    $sqlLimit = paging ( $this->moduleName, $this->pagingAction );
	    $sqlLimit = trim ( str_replace ( " LIMIT ", "", $sqlLimit ) );
	    $sqlLimitArr = explode ( ",", $sqlLimit );
	    
	    $myC = $_SESSION [SESS_IDX] [$this->moduleName];
	    $vectSearch = (isset ( $myC ["search"] ) ? $myC ["search"] : array ());
	    
	    if (count ( $vectSearch ) > 0) {
	        foreach ( $vectSearch as $key => $value ) {
	            if(is_null($value) || strlen(trim($value))==0){
	                continue;
	            }
	            
	            switch ($key) {
	                case "cer_code" :
	                    $qb->andWhere('per.cerCode=:cerCode')->setParameter('cerCode', $value);
	                    break;
	                case "civ_code" :
	                    $qb->andWhere('per.civCode=:civCode')->setParameter('civCode', $value);
	                    break;
	                case "per_nom" :
	                    $qb->andWhere('per.perNom like :perNom')->setParameter('perNom', '%'.$value.'%');
	                    break;
	                case "per_prenom" :
	                    $qb->andWhere('per.perPrenom like :perPrenom')->setParameter('perPrenom', '%'.$value.'%');
	                    break;
	                case "uti_identifiant" :
	                    $qb->andWhere('uti.utiIdentifiant like :utiIdentifiant')->setParameter('utiIdentifiant', '%'.$value.'%');
	                    break;
	                case "rol_code" :
	                    $qb->andWhere('uti.rolCode=:rolCode')->setParameter('rolCode', $value);
	                    break;
	                case "uti_cpt_bloque" :
	                    $qb->andWhere('uti.utiCptBloque=:utiCptBloque')->setParameter('utiCptBloque', $value);
	                    break;
	            }
	        }
	    }
	    
		
        $_SESSION[SESS_IDX][$this->moduleName]['paging']["noRowsResult"] = count($qb->getQuery()->getArrayResult());
		
		$qb->orderBy('uti.perCodeUti');
		$qb->setFirstResult(trim($sqlLimitArr[0]))->setMaxResults(trim($sqlLimitArr[1]));
		
		$utilisateurs = $qb->getQuery()->getArrayResult();
		
		$recList = array();
		$i = - 1;
		foreach ($utilisateurs as $utilisateur) {
		    $i ++;
		    
		    $datas=doctrineArrayToLegacy($entityManager, 'RAN\Entity\Utilisateur', $utilisateur, null, 0);
		    
		    if(array_key_exists('rolCode', $utilisateur)){
                $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Role', $utilisateur['rolCode'], null, 0));
		    }
		    else{
		        $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Role', array(), null, 0));
		    }
		    
		    if(array_key_exists('perCodeUti', $utilisateur)){
		        $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $utilisateur['perCodeUti'], null, 0));

		        $datas['per_code_uti']=$datas['per_code'];
    		    if(array_key_exists('civCode', $utilisateur['perCodeUti'])){
    		        $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Civilite', $utilisateur['perCodeUti']['civCode'], null, 0));
    		    }
    		    else{
    		        $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Civilite', array(), null, 0));
    		    }
    		    
    		    if(array_key_exists('cerCode', $utilisateur['perCodeUti'])){
    		        $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\CentreDeRattachement', $utilisateur['perCodeUti']['cerCode'], null, 0));
    		    }
    		    else{
    		        $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\CentreDeRattachement', array(), null, 0));
    		    }
		    }
		    
		    $recList[$i] = $datas;
		    $recList[$i]["del_op"] = $this->verifyDel($recList[$i][$this->idName]);
		}
		
		return $recList;
	}
	
	/**
	 * Verify user for remove operation
	 *
	 * @access : public
	 * @return : bool
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function verifyDel($id) {
		if (isset ( $_SESSION [SESS_IDX] [UL] [$this->idName] ) && $_SESSION [SESS_IDX] [UL] [$this->idName] == $id)
			return false;
		else
			return true;
	}
	
	/**
	 * Delte items (multiple)
	 *
	 * @access : public
	 * @return : null
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function deleteMItems() {
		if (isset ( $_POST ["act"] ) && $_POST ["act"] == "delete") {
			if (isset ( $_POST ["ids"] )) {
				foreach ( $_POST ["ids"] as $k => $v ) {
					$this->deleteItem ( $v );
				}
			}
		}
	}
	
	/**
	 * Delte item
	 *
	 * @access : public
	 * @return : null
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function deleteItem($id) {
	    global $entityManager;
	    
		checkUtilisateurAccess ( 'UTILISATEUR', 'RW' );
		
		if ($this->verifyDel ( $id )) {
		    
		    $entityManager->createQueryBuilder()
		      ->delete('RAN\Entity\UtilisateurAuth', 'utiAuth')
		      ->where('utiAuth.perCodeUti=:perCodeUti')->setParameter('perCodeUti', $id)->execute();
		    
		    $entityManager->createQueryBuilder()
		      ->delete('RAN\Entity\Utilisateur', 'uti')
		      ->where('uti.perCodeUti=:perCodeUti')->setParameter('perCodeUti', $id)->execute();
			
			// delete persone
			delPer ( $id );
		}
	}
	
	/**
	 * Logout
	 *
	 * @access : public
	 * @return : null
	 * @author : CFlorin (colotin_f@yahoo.com)
	 */
	function logout() {
		session_regenerate_id ();
		unset ( $_SESSION [SESS_IDX] );
		
		redirect ( "index.php?act=logout" );
	}
	
	function auth_fill($per_code_uti) {
	    
	    global $entityManager;
	    
	    $auths=$entityManager->getRepository('RAN\Entity\UtilisateurAuth')->findBy(array('perCodeUti'=>$per_code_uti));
	    
	    foreach($auths as $auth){
	        $entityManager->remove($auth);
	    }
	    $entityManager->flush();
		
		// gerere les coord
		$coord_list = array ();
		
		for($x = 1; $x <= AUTH_NO_X; $x ++) {
			for($y = 65; $y < AUTH_NO_Y + 65; $y ++) {
			    $auth=new RAN\Entity\UtilisateurAuth();
			    $auth->setAuthCoord(chr ( $y ) . $x);
			    $auth->setAuthValeur(rand ( 1000, 9999 ));
			    $auth->setPerCodeUti($entityManager->getReference('RAN\Entity\Utilisateur', $per_code_uti));
				$entityManager->persist($auth);
			}
		}
		$entityManager->flush();
		
		$utilisateur=$entityManager->find('RAN\Entity\Utilisateur', $per_code_uti);
		$utilisateur->setUtiChlgDate(new DateTime());
		$entityManager->persist($utilisateur);
		
		$entityManager->flush();
	}
	
	function auth_print() {
	    global $entityManager;
	    
		isset ( $_GET ["per_code_uti"] ) ? $per_code_uti = intval ( $_GET ["per_code_uti"] ) : $per_code_uti = "";
		
		if ($per_code_uti != "") {
			$this->auth_fill ( $per_code_uti );
			
			$daoPer=doctrineEntityToLegacy($entityManager, $entityManager->find('RAN\Entity\Personne', $per_code_uti), array(), 1, true);
			$daoUti=doctrineEntityToLegacy($entityManager, $entityManager->find('RAN\Entity\Utilisateur', $per_code_uti), array(), 1, true);
			
			$auth_datas=array();
			$qb=$entityManager->createQueryBuilder();
			$qb->select('auth.authCoord as auth_coord', 'auth.authValeur as auth_valeur')
			     ->from('RAN\Entity\UtilisateurAuth', 'auth')
			     ->andWhere('auth.perCodeUti=:perCodeUti')->setParameter('perCodeUti', $per_code_uti);
			
			    
			     
			     
			foreach($qb->getQuery()->getArrayResult() as $authInfo){
			    $auth_datas[$authInfo['auth_coord']] = $authInfo['auth_valeur'];
			    
			}

			// ==================================== PDF SET HEADER ====================================//
			
			header ( "Pragma: public" ); // required // leave blank to avoid IE errors or header("Pragma: public");
			header ( "Expires: 0" );
			header ( "Cache-Control: must-revalidate, post-check=0, pre-check=0" ); // leave blank to avoid IE errors
			header ( "Cache-Control: private", false ); // required for certain browsers
			                                         // header('Content-type: application/pdf');
			
			require_once ('tcpdf/config/lang/eng.php');
			require_once ('tcpdf/tcpdf.php');
			
			// ==================================== TCPDF INIT START ====================================//
			
			$user_name = $daoPer['per_prenom'] . ' ' . $daoPer['per_nom'];
			$doc_title = 'Matrice d\'authentification pour ' . $user_name;
			$doc_subject = "test description";
			$doc_keywords = "test keywords";
			
			// create new PDF document (document units are set by default to millimeters)
			$pdf = new TCPDF ( "L", PDF_UNIT, "A4", true );
			
			// set document information
			$pdf->SetCreator ( PDF_CREATOR );
			$pdf->SetAuthor ( PDF_AUTHOR );
			$pdf->SetTitle ( $doc_title );
			$pdf->SetSubject ( $doc_subject );
			$pdf->SetKeywords ( $doc_keywords );
			
			// $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
			
			// set margins
			$pdf->SetMargins ( 1, 1, 1 );
			// set auto page breaks
			// $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
			// $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
			// $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
			// $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); //set image scale factor
			
			// $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
			// $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
			
			$pdf->setLanguageArray ( $l ); // set language items
			                            
			// initialize document
			$pdf->AliasNbPages ();
			
			// ==================================== TCPDF INIT END ====================================//
			// print for each medecin and model lettre
			$pdf->setPrintHeader ( false );
			$pdf->AddPage ();
			
			$pdf->SetFont ( "FreeSans", "", 7 );
			
			for($y = 64; $y < AUTH_NO_Y + 65; $y ++) {
				for($x = 0; $x <= AUTH_NO_X; $x ++) {
					$auth = chr ( $y ) . $x;
					
					if ($y == 64) {
					    if ($x == 0){
							$pdf->MultiCell ( 7, 3, "", 1, 'C', 0, 0, 0, 0, true );
					    }
					    elseif ($x == AUTH_NO_X){
							$pdf->MultiCell ( 8, 3, $x, 1, 'C', 0, 1, 0, 0, true );
					    }
					    else{
							$pdf->MultiCell ( 8, 3, $x, 1, 'C', 0, 0, 0, 0, true );
					    }
					} else {
					    
					    if ($x == 0){
					        $pdf->MultiCell ( 7, 3, chr ( $y ), 1, 'C',0, 0, 0, 0, true );
					    }
					    elseif ($x == AUTH_NO_X){
							$pdf->MultiCell ( 8, 3, $auth_datas [$auth], 1, 'C', ($x % 2 == 1 or $y % 2 == 0) ? 1 : 0, 1, 0, 0, true );
					    }
					    else{
							$pdf->MultiCell ( 8, 3, $auth_datas [$auth], 1, 'C', ($x % 2 == 1 or $y % 2 == 0) ? 1 : 0, 0, 0, 0, true );
					    }
					}
				}
			}
			$pdf->Write ( 4, utf8_encode ( $user_name . ' - Impression ' . $daoUti['uti_chlg_date']->format('d/m/Y H:m:s')) );
			
			/*
			 * $pdf->MultiCell(15, 5, "2222", 1, 'C', 0, 0, 0 ,0, true);
			 * $pdf->MultiCell(15, 5, "3333", 1, 'C', 0, 0, 0 ,0, true);
			 * $pdf->MultiCell(15, 5, "4444", 1, 'C', 0, 1, 0 ,0, true);
			 * $pdf->MultiCell(15, 5, "1111", 1, 'C', 1, 0, 0 ,0, true);
			 * $pdf->MultiCell(15, 5, "2222", 1, 'C', 1, 0, 0 ,0, true);
			 * $pdf->MultiCell(15, 5, "3333", 1, 'C', 1, 0, 0 ,0, true);
			 * $pdf->MultiCell(15, 5, "4444", 1, 'C', 1, 1, 0 ,0, true);
			 */
			// $pdf->MultiCell(40, 5, "B test multicell line 1 test multicell line 2 test multicell line 3", 1, 'C', 0, 1, 0 ,0, true);
			// $pdf->MultiCell(40, 5, "C test multicell line 1 test multicell line 2 test multicell line 3", 1, 'C', 0, 0, 0 ,0, true);
			// $pdf->MultiCell(40, 5, "D test multicell line 1 test multicell line 2 test multicell line 3\n", 1, 'J', 1, 2, 0 ,0, true);
			// die("dd");
			// Close and output PDF document
			
			$pdf->Output ();
			
			exit ();
		}
	}
}

?>
