<?php
use Doctrine\ORM\NoResultException;

// #########################################################################//
// # Project particularized functions
// #
// # Author: CFlorin (E-mail: colotin_f@yahoo.com)
// # Date: 17.01.2006
// #########################################################################//

/**
 * Return a Smarty instance
 *
 * @param string $useDefaults
 *            If true, initialize data with default parameters
 *            
 * @return Smarty Smarty instance
 */
function getSmartyInstance($useDefaults = true)
{
    $smartyInstance = new Smarty();
    if ($useDefaults == true) {
        $smartyInstance->compile_check;
        $smartyInstance->template_dir = TEMPLATES_DIR;
        $smartyInstance->compile_dir = COMPILE_DIR;
        $smartyInstance->config_dir = TEMPLATES_DIR . "configs/";
        $smartyInstance->debugging = false;
        $smartyInstance->cache_dir = CACHE_DIR;
        $smartyInstance->caching = CACHING;
    }
    return $smartyInstance;
}

/**
 * Init Site
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 17.01.2006 (dd.mm.YYYY)
 */
function initFrontEnd()
{
    global $smarty, $L;

    define("SESS_IDX", SESS_IDX_FE);
    define("UL", "UL");

    // set session
    if (! isset($_SESSION[SESS_IDX]))
        $_SESSION[SESS_IDX] = array();

    // assign user loged data
    if (isset($_SESSION[SESS_IDX][UL]['auth']) && $_SESSION[SESS_IDX][UL]['auth'] == 1) {
        $smarty->assign("UL", $_SESSION[SESS_IDX][UL]);
    }

    // assign date format
    $smarty->assign("DF", "%d/%m/%Y");
    $smarty->assign("DTF", "%d %b %Y %H:%M:%S");
}

/**
 * RTF in page
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function editorRTF($elemFieldName, $elemFieldNameValue, $lang = '', $toolBar = '', $skin = '')
{
    ob_start();
    $sBasePath = FCKEDITOR_URL;

    $oFCKeditor = new FCKeditor($elemFieldName);
    $oFCKeditor->BasePath = $sBasePath;

    $oFCKeditor->Height = '295';

    if ($lang != '') {
        $oFCKeditor->Config['AutoDetectLanguage'] = false;
        $oFCKeditor->Config['DefaultLanguage'] = $lang;
    }

    if ($toolBar != '')
        $oFCKeditor->ToolbarSet = $toolBar; // Default Basic

    if ($skin != '')
        $oFCKeditor->Config['SkinPath'] = $sBasePath . 'editor/skins/' . $skin . '/';

    $oFCKeditor->Value = $elemFieldNameValue;
    $oFCKeditor->Create();

    $rtf_obj = ob_get_contents();
    ob_end_clean();

    return $rtf_obj;
}

function getMedInfo($per_code)
{
    global $entityManager;

    $qb = $entityManager->createQueryBuilder();
    $qb->select('medecin', 'speMed', 'personne', 'cer', 'adr');
    $qb->from('RAN\Entity\Medecin', 'medecin');
    $qb->leftJoin('medecin.perCode', 'personne');
    $qb->leftJoin('medecin.spmCode', 'speMed');
    $qb->leftJoin('personne.cerCode', 'cer');
    $qb->leftJoin('personne.adrCode', 'adr');
    $qb->andWhere('medecin.perCode=:perCode')->setParameter('perCode', 1);

    $result = $qb->getQuery()
            ->setHint(Doctrine\ORM\Query::HINT_REFRESH, true)
            ->getOneOrNullResult();
    $medInfo=doctrineEntityToLegacy($entityManager, $result, array(), 3, true);
    

//     $results = $qb->getQuery()
//         ->setHint(Doctrine\ORM\Query::HINT_REFRESH, true)
//         ->getArrayResult();

//     $medInfo = array();
//     if (count($results) == 1) {
//         $medecin = $results[0];

//         $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Medecin', $medecin));

//         if (array_key_exists('perCode', $medecin)) {

//             $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $medecin['perCode']));

//             if (array_key_exists('cerCode', $medecin['perCode'])) {
//                 $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\CentreDeRattachement', $medecin['perCode']['cerCode']));
//             }

//             if (array_key_exists('cerCode', $medecin['perCode'])) {
//                 if (count($medecin['perCode']['adrCode']) > 0) {
//                     $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\AdressePostale', $medecin['perCode']['adrCode'][0]));
//                 } else {
//                     $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\AdressePostale', null));
//                 }
//             }
//         }
//     }
    return $medInfo;
}

/**
 * Get personne info
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function getPerInfo($per_code)
{
    global $entityManager;

    $qb = $entityManager->createQueryBuilder();
    
    $qb->select('per', 'cer')
        ->from('RAN\Entity\Personne', 'per')
        ->leftJoin('per.cerCode', 'cer')
        ->leftJoin('per.adrCode', 'adr')
        ->leftJoin('per.perTel', 'tel')
        ->andWhere('per.perCode=:perCode')
        ->setParameter('perCode', $per_code);

    $per = $qb->getQuery()
        ->setHint(Doctrine\ORM\Query::HINT_REFRESH, true)
        ->getSingleResult();
        
    $perInfo = array();
    $perInfo['per_nom'] = $per->getPerNom();
    $perInfo['per_prenom'] = $per->getPerPrenom();
    if (! is_null($per->getCivCode())) {
        $perInfo['civ_code'] = $per->getCivCode()->getCivCode();
    } else {
        $perInfo['civ_code'] = null;
    }

    if (! is_null($per->getCerCode())) {
        $perInfo['cer_code'] = $per->getCerCode()->getCerCode();
        $perInfo['cer_nom'] = $per->getCerCode()->getCerNom();
    } else {
        $perInfo['cer_code'] = null;
        $perInfo['cer_nom'] = null;
    }

    $perInfo['adresse'] = array();

    foreach ($per->getAdrCode() as $addr) {
        $addrArray = array();
        $addrArray['adr_code'] = $addr->getAdrCode();
        $addrArray['com_code'] = $addr->getComCode();
        $addrArray['adr_voie'] = $addr->getAdrVoie();
        $addrArray['adr_complement'] = $addr->getAdrComplement();
        $addrArray['adr_cp'] = $addr->getAdrCp();
        $addrArray['adr_ville'] = $addr->getAdrVille();

        $perInfo['adresse'][] = $addrArray;
    }

    $perInfo['tel'] = array();
    foreach ($per->getPerTel() as $tel) {
        $telArray = array();
        $telArray['tel_code'] = $tel->getTelCode()->getTelCode();
        $telArray['tel_numero'] = $tel->getTelCode()->getTelNumero();
        $telArray['per_tel_commentaire'] = $tel->getPerTelCommentaire();
        if (! is_null($tel->getTelCode()->getTytCode())) {
            $telArray['tyt_code'] = $tel->getTelCode()
                ->getTytCode()
                ->getTytCode();
            $telArray['tyt_libelle'] = $tel->getTelCode()
                ->getTytCode()
                ->getTytLibelle();
        } else {
            $telArray['tyt_code'] = null;
            $telArray['tyt_libelle'] = null;
        }

        $perInfo['tel'][] = $telArray;
    }

    return $perInfo;
}

/**
 * Get personne info
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function delPer($per_code, $inTransaction = false)
{
    global $entityManager;

    $qb = $entityManager->createQueryBuilder();

    $qb->select('per')
        ->from('RAN\Entity\Personne', 'per')
        ->leftJoin('per.adrCode', 'adr')
        ->leftJoin('per.perTel', 'tel')
        ->andWhere('per.perCode=:perCode')->setParameter('perCode', $per_code);

    try {
        // ON recupere la personne
        $per = $qb->getQuery()
            ->setHint(Doctrine\ORM\Query::HINT_REFRESH, true)
            ->getSingleResult();

        // On supprime toutes les addresses attachées
        foreach ($per->getAdrCode() as $addr) {
            $entityManager->remove($addr);
        }

        // ON supprime tous les téléphones attachés
        foreach ($per->getPerTel() as $tel) {
            $entityManager->remove($tel);
        }

        // ON supprime la personne
        $entityManager->remove($per);

        if(!$inTransaction){
            $entityManager->flush();
        }
    } catch (NoResultException $exception) {}
}

/**
 * Get Csl Info
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function getCslInfo($csl_code = '', $get_param = false)
{
    global $entityManager;

    $qb = $entityManager->createQueryBuilder();

    $qb->select( 'csl', 'prc', 'med', 'medPer', 'medSpe', 'pat', 'patPer', 'medCer')
        ->from('RAN\Entity\Consultation', 'csl')
        ->innerJoin('csl.prcCode', 'prc')
        ->innerJoin('csl.perCodeUti', 'med')
        ->innerJoin('csl.perCodePat', 'pat')
        ->innerJoin('pat.perCode', 'patPer')
        ->innerJoin('med.perCode', 'medPer')
        ->innerJoin('med.spmCode', 'medSpe')
        ->innerJoin('medPer.cerCode', 'medCer')
        ->andWhere('csl.cslCode=:cslCode')
        ->setParameter('cslCode', $csl_code);

    $result = $qb->getQuery()->getArrayResult();

    $cslInfo = false;
    if (count($result) == 1) {
        $result = $result[0];
        $cslInfo = array();

        $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Consultation', $result));

        if (isset($result['prcCode'])) {
            $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\ProfilConsultation', $result['prcCode']));
        }
        if (isset($result['perCodeUti'])) {
            $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Medecin', $result['perCodeUti']));

            if (isset($result['perCodeUti']['perCode'])) {
                $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $result['perCodeUti']['perCode'], array(
                    'per_code' => 'per_code_uti'
                )));

                if (isset($result['perCodeUti']['perCode']['cerCode'])) {
                    $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\CentreDeRattachement', $result['perCodeUti']['perCode']['cerCode']));
                }
            }

            if (isset($result['perCodeUti']['spmCode'])) {
                $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\SpecialiteMedicale', $result['perCodeUti']['spmCode']));
            }
        }
        if (isset($result['perCodePat'])) {
            $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Patient', $result['perCodePat'], [
                'per_code' => 'per_code_pat'
            ]));

            if (isset($result['perCodePat']['perCode'])) {
                $cslInfo = array_merge($cslInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $result['perCodePat']['perCode'], array(
                    'per_code' => 'per_code_pat'
                )));
            }
        }
    }

    if ($get_param) {
        $cslInfo['pbi'] = getConsultationParam($csl_code);
    }

    if ($cslInfo["csl_ta"] != "0") {
        $cslInfo["csl_ta"] = sprintf('%03d', $cslInfo["csl_ta"]);
    } else {
        $cslInfo["csl_ta"] = "";
    }
    if ($cslInfo["csl_ta2"] != "0") {
        $cslInfo["csl_ta2"] = sprintf('%03d', $cslInfo["csl_ta2"]);
    } else {
        $cslInfo["csl_ta2"] = "";
    }

    // //===> for medecin info
    // //factory for join specialite_medicale with medecin table
    // $daoSpmJoinMed = DB_DataObject::factory('specialite_medicale');
    // $daoPrc = DB_DataObject::factory('profil_consultation');
    // //factory for join v_personne with medecin table
    // $daoVPersJoinMed = DB_DataObject::factory('v_personne');
    // //factory for join with medecin table
    // $daoMedJoin = DB_DataObject::factory('medecin');
    // $daoMedJoin->joinAdd($daoSpmJoinMed, 'inner');
    // $daoMedJoin->joinAdd($daoVPersJoinMed, 'inner', false, 'per_code', 'per_code');
    // //<===

    // $daoCsl = DB_DataObject::factory('consultation');
    // $daoCsl->joinAdd($daoMedJoin, 'inner');
    // $daoCsl->joinAdd($daoPrc, 'inner');
    // $daoCsl->whereAdd("csl_code = {$csl_code}");
    // if($daoCsl->count())
    // {
    // $daoCsl->find();
    // $daoCsl->fetch();

    // $cslInfo=$daoCsl->toArray();

    // if ($cslInfo["csl_ta"]!="0")
    // $cslInfo["csl_ta"] = sprintf('%03d',$cslInfo["csl_ta"]);
    // else
    // $cslInfo["csl_ta"] = "";

    // if ($cslInfo["csl_ta2"]!="0")
    // $cslInfo["csl_ta2"] = sprintf('%03d',$cslInfo["csl_ta2"]);
    // else
    // $cslInfo["csl_ta2"] = "";
    // if($get_param)
    // {
    // $cslInfo['pbi']=getConsultationParam($csl_code);
    // }
    // }
    // else
    // $cslInfo=false;

    // $daoCsl->free();

    return $cslInfo;
}

/**
 * Get Consultation Param
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function getConsultationParam($csl_code)
{
    $cslpbiList = array();

    global $entityManager;

    $qb = $entityManager->createQueryBuilder();

    $qb->select(array(
        'cspbi',
        'pbi',
        'tpb',
        'upa'
    ))
        ->from('RAN\Entity\ConsultParamBio', 'cspbi')
        ->innerJoin('cspbi.pbiCode', 'pbi')
        ->innerJoin('pbi.tpbCode', 'tpb')
        ->leftJoin('pbi.upaCode', 'upa')
        ->andWhere('cspbi.cslCode=:cslCode')
        ->setParameter('cslCode', $csl_code)
        ->addOrderBy('tpb.tpbOrdre', 'ASC')
        ->addOrderBy('pbi.pbiOrdre', 'ASC');

    $results = $qb->getQuery()->getArrayResult();

    foreach ($results as $result) {
        $pbiDatas = array();
        $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\ConsultParamBio', $result));

        if (isset($result['pbiCode'])) {
            $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\ParametresBiologiques', $result['pbiCode']));
        } else {
            $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\ParametresBiologiques', array()));
        }

        if (isset($result['pbiCode']['upaCode'])) {
            $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\UniteParam', $result['pbiCode']['upaCode']));
        } else {
            $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\UniteParam', array()));
        }

        $cslpbiList[] = $pbiDatas;
    }

//     print_r($cslpbiList);
//     die();

    // //select pbi from consult_param_bio
    // $daoTpb=DB_DataObject::factory('type_parametre_biologique');
    // $daoPbi=DB_DataObject::factory('parametres_biologiques');
    // $daoUnP =DB_DataObject::factory('unite_param');
    // $daoPbi->joinAdd($daoTpb, 'inner');
    // $daoPbi->joinAdd($daoUnP, 'left');

    // $daoCslPbi=DB_DataObject::factory('consult_param_bio');
    // //$daoCslPbi->csl_code=$csl_code;
    // $daoCslPbi->joinAdd($daoPbi, 'inner');
    // $daoCslPbi->whereAdd("consult_param_bio.csl_code={$csl_code}");

    // $daoCslPbi->orderBy("type_parametre_biologique.tpb_ordre, parametres_biologiques.pbi_ordre");

    // $daoCslPbi->find();
    // while($daoCslPbi->fetch())
    // {
    // $cslpbiList[]=$daoCslPbi->toArray();
    // }

    // $daoTpb->free();
    // $daoPbi->free();
    // $daoCslPbi->free();

    return $cslpbiList;
}

function getParamBio($tpbCode)
{
    global $entityManager;

    $qb = $entityManager->createQueryBuilder();

    $qb->select(array(
        'pbi',
        'tpb',
        'upa'
    ))
        ->from('RAN\Entity\ParametresBiologiques', 'pbi')
        ->innerJoin('pbi.tpbCode', 'tpb')
        ->leftJoin('pbi.upaCode', 'upa')
        ->andWhere('pbi.tpbCode=:tpbCode')
        ->setParameter('tpbCode', $entityManager->getReference('RAN\Entity\TypeParametreBiologique', $tpbCode))
        ->addOrderBy('pbi.pbiOrdre', 'ASC');

    $results = $qb->getQuery()->getArrayResult();

    $pbis = array();
    foreach ($results as $result) {
        $pbiDatas = array();

        $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\ParametresBiologiques', $result));

        if (isset($result['upaCode'])) {
            $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\UniteParam', $result['upaCode']));
        } else {
            $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\UniteParam', array()));
        }

        if (isset($result['tpbCode'])) {
            $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\TypeParametreBiologique', $result['tpbCode']));
        } else {
            $pbiDatas = array_merge($pbiDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\TypeParametreBiologique', array()));
        }

        $pbis[] = $pbiDatas;
    }

    return $pbis;
}

function getAllParamBio()
{
    global $entityManager;

    $qbTpb = $entityManager->createQueryBuilder();

    $qbTpb->select('tpb')->from('RAN\Entity\TypeParametreBiologique', 'tpb');
    $results = $qbTpb->getQuery()->getArrayResult();

    $paramsByTpb = array();

    foreach ($results as $result) {
        $tpbDatas = array();

        $tpbDatas = array_merge($tpbDatas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\TypeParametreBiologique', $result));
        $tpbDatas['params'] = getParamBio($result['tpbCode']);

        $paramsByTpb[] = $tpbDatas;
    }

    return $paramsByTpb;
    // //select pbi from consult_param_bio
    // $daoTpb=DB_DataObject::factory('type_parametre_biologique');

    // $daoTpb->find();

    // $type_param_list = array();

    // while ($daoTpb->fetch())
    // {
    // $type_param = $daoTpb->toArray();
    // $type_param["params"] = array();

    // $daoPbi=DB_DataObject::factory('parametres_biologiques');
    // $daoUnP =DB_DataObject::factory('unite_param');
    // $daoPbi->joinAdd($daoTpb, 'inner');
    // $daoPbi->joinAdd($daoUnP, 'left');

    // $daoPbi->tpb_code = $daoTpb->tpb_code ;

    // $daoPbi->find();

    // while ($daoPbi->fetch())
    // {
    // $type_param["params"][] = $daoPbi->toArray();
    // }

    // $type_param_list[] = $type_param;

    // }

    // return $type_param_list;
}

function checkUtilisateurAccess($fca, $hab = "", $ret = "")
{
    if ($hab == "") {
        if (isset($_SESSION[SESS_IDX][UL]['habilite'][$fca]['R']) || isset($_SESSION[SESS_IDX][UL]['habilite'][$fca]['RW']))
            return true;
        elseif ($ret == "bool")
            return false;
        else
            redirect("index.php?obj=front&action=access_denied");
    } else {
        if (isset($_SESSION[SESS_IDX][UL]['habilite'][$fca][$hab]))
            return true;
        elseif ($ret == "bool")
            return false;
        else
            redirect("index.php?obj=front&action=access_denied");
    }
}

function getMediNom($medi_code)
{
    global $entityManager;

    $medicament = null;
    if (is_numeric($medi_code)) {
        $medicament = $entityManager->find('RAN\Entity\Medicament', $medi_code);
    }
    return (is_null($medicament) ? '' : utf8_decode($medicament->getMediNomCom()));
}

function getAuthChallenge()
{
    // gerere les coord
    $coord_list = array();

    for ($x = 1; $x < AUTH_NO_X; $x ++) {
        for ($y = 65; $y < AUTH_NO_Y + 65; $y ++) {
            $coord_list[chr($y) . $x] = chr($y) . $x;
        }
    }

    // tire au hasard les challenges
    $challenge_list = array_rand($coord_list, AUTH_NO_CHALLENGE);

    return $challenge_list;
}

function testAuth()
{
    return false;
}

// Recupere la derniere greffe du patient
function getGreffe($per_code_pat, $last = false)
{
    global $entityManager;

    $qb=$entityManager->createQueryBuilder();

    $qb->select('gre','tgr' )
        ->from('RAN\Entity\Greffe', 'gre')
        ->join('gre.tgrCode', 'tgr')
        ->andWhere('gre.perCode=:perCode')->setParameter('perCode', $per_code_pat);

    if ($last != false) {
        if(is_a($last, DateTime::class)){
            $qb->andWhere('gre.greDate=:greDate')->setParameter('greDate', $last);
        }
        else{
            $qb->andWhere('gre.greDate=:greDate')->setParameter('greDate', new DateTime($last));
        }
        $qb->orderBy('gre.greDate', 'DESC');
        $qb->setMaxResults(1);
    }

    $greffes = $qb->getQuery()->getArrayResult();

    if ($last != false) {
        if (!empty($greffes)) {
            $datas=doctrineArrayToLegacy($entityManager, 'RAN\Entity\Greffe', $greffes[0]);
            if(array_key_exists('tgrCode', $greffes[0])){
                $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\TypeGreffe', $greffes[0]['tgrCode']));
            }
            return $datas;
        } else {
            return null;
        }
    }
    else {
        $greffesDatas=array();
        foreach($greffes as $greffe){
            $datas=doctrineArrayToLegacy($entityManager, 'RAN\Entity\Greffe', $greffe);
            if(array_key_exists('tgrCode', $greffe)){
                $datas=array_merge($datas, doctrineArrayToLegacy($entityManager, 'RAN\Entity\TypeGreffe', $greffe['tgrCode']));
            }
            $greffesDatas[]=$datas;
        }
        return $greffesDatas;
    }
}

// Recupere la derniere greffe du patient
function getDialyses($per_code_pat, $last = false)
{
    global $entityManager;

    $qb = $entityManager->createQueryBuilder();

    $qb->select(array(
        'dia',
        'tyd'
    ))
        ->from('RAN\Entity\Dialyse', 'dia')
        ->join('dia.tydCode', 'tyd')
        ->andWhere('dia.perCodePat=:perCodePat')
        ->setParameter('perCodePat', $per_code_pat);

    if ($last = false) {
        $qb->orderBy('dia.diaDate', 'DESC');
        $qb->andWhere('dia.greDate=:diaDate')->setParameter('diaDate', $last);
        $qb->setMaxResults(1);
    }

    $dialyses = $qb->getQuery()->getArrayResult();

    if ($last != false) {
        if (! isEMpty($dialyses)) {
            return $dialyses[0];
        } else {
            return null;
        }
    } else {
        return $dialyses;
    }
}

function cslIsLast($csl_code)
{
    global $entityManager;

    if ($_SESSION[SESS_IDX][UL]["cer_code"] == 1 && $_SESSION[SESS_IDX][UL]["is_medecin"] == 1) {
        return true;
    }

    $consultation = $entityManager->getRepository('RAN\Entity\Consultation')->find($csl_code);

    $qb = $entityManager->createQueryBuilder();
    $qb->select('csl')
        ->from('RAN\Entity\Consultation', 'csl')
        ->andWhere('csl.perCodePat=:perCodePat')
        ->setParameter('perCodePat', $consultation->getPerCodePat())
        ->addOrderBy('csl.cslDate', 'DESC')
        ->setMaxResults(1);

    $results = $qb->getQuery()->getArrayResult();

    $patMostRecentCsl = $results[0];
    if ($patMostRecentCsl->getCslCode() == $consultation->getCslCode()) {
        return true;
    }

    return false;

    // $csl=DB_DataObject::factory('consultation');

    // if ($csl->get($csl_code)==1)
    // {
    // if ($_SESSION[SESS_IDX][UL]["cer_code"]==1 && $_SESSION[SESS_IDX][UL]["is_medecin"]==1)
    // return true;

    // if (strtotime($csl->csl_date)> mktime (0,0,0,date("m") ,date("d")-30,date("Y")))
    // return true;

    // $per_code_pat = $csl->per_code_pat;

    // $csl->free();

    // $csl=DB_DataObject::factory('consultation');
    // $csl->per_code_pat = $per_code_pat;
    // $csl->orderBy('csl_date desc, csl_code desc');
    // $csl->limit(0,1);

    // $csl->find(true);

    // if ($csl_code == $csl->csl_code)
    // return true;
    // }

    // return false;
}

/**
 * Get Patient Info
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function getPatientInfo($id)
{
    global $entityManager;

    $qb = $entityManager->createQueryBuilder();

    $qb->select(array(
        "pat"
    ))
        ->from('RAN\Entity\Patient', 'pat')
        ->andWhere('pat.perCode=:perCode')
        ->setParameter('perCode', $id);

    $pat = $qb->getQuery()->getSingleResult();

    $patInfo = array();
    $patInfo['per_code'] = $id;
    $patInfo['pat_num_venue'] = $pat->getPatNumVenue();
    $patInfo['pat_dt_creat'] = $pat->getPatDtCreat();
    $patInfo['pat_nom_jf'] = $pat->getPatNomJf();
    $patInfo['pat_sexe'] = $pat->getPatSexe();
    $patInfo['pat_dt_naiss'] = $pat->getPatDtNaiss();
    $patInfo['pat_dt_deces'] = $pat->getPatDtDeces();
    $patInfo['pat_dt_dc'] = $pat->getPatDtDc();
    $patInfo['pat_no_efg'] = $pat->getPatNoEfg();
    $patInfo['pat_no_ss'] = $pat->getPatNoSs();
    $patInfo['pat_ipum'] = $pat->getPatIpum();
    $patInfo['pat_dossier_res'] = $pat->getPatDossierRes();
    $patInfo['pat_actif'] = $pat->getPatActif();
    $patInfo['pat_sdf'] = $pat->getPatSdf();
    $patInfo['pat_nb_enf'] = $pat->getPatNbEnf();
    $patInfo['pat_code_access'] = $pat->getPatCodeAccess();

    // $patInfo=daoGetRowContent("patient", "per_code", $id);
    $patInfo['per'] = getPerInfo($id);

    $patInfo['greffes'] = getGreffe($id);
    $patInfo['dialyses'] = getDialyses($id);

    if (! is_null($patInfo['pat_dt_naiss'])) {
        $patInfo['age'] = getAge(date('d/m/Y', $patInfo['pat_dt_naiss']->getTimestamp()));
        $patInfo['pat_dt_naiss'] = date('d/m/Y', $patInfo['pat_dt_naiss']->getTimestamp());
    } else {
        $patInfo['age'] = '';
        $patInfo['pat_dt_naiss'] = '';
    }

    if (! is_null($patInfo['pat_dt_deces'])) {
        $patInfo['pat_dt_deces'] = date('d/m/Y', $patInfo['pat_dt_deces']->getTimestamp());
    } else {
        $patInfo['pat_dt_deces'] = '';
    }

    $qb->select('comm')
        ->from('RAN\Entity\PatientComment', 'comm')
        ->andWhere('comm.perCodePat=:perCode')
        ->setParameter('perCode', $id);

    $patInfo['comm'] = array();
//     $patInfo['comm'][1] = array();
//     $patInfo['comm'][2] = array();
//     $patInfo['comm'][3] = array();
    foreach ($qb->getQuery()->getResult() as $comm) {
//         $patInfo[$comm->getPatComType()]['pat_com'] = $comm->getPatCom();
//         $patInfo[$comm->getPatComType()]['pat_com_type'] = $comm->getPatComType();
//         $patInfo[$comm->getPatComType()]['pat_com_txt'] = $comm->getPatComTxt();
        $patInfo['comm'][$comm->getPatComType()] = $comm->getPatComTxt();
    }

    return $patInfo;
}

function getAge($naiss)
{
    if (preg_match('/\d{1,2}\/\d{1,2}\/\d{4}/', $naiss)) {
        list ($jour, $mois, $annee) = preg_split('[/.]', $naiss);
    } else {
        list ($annee, $mois, $jour) = preg_split('[-.]', $naiss);
    }
    $today = [
        'mois' => date('n'),
        'jour' => date('j'),
        'annee' => date('Y')
    ];

    $annees = $today['annee'] - $annee;
    if ($today['mois'] <= $mois) {
        if ($mois == $today['mois']) {
            if ($jour > $today['jour']) {
                $annees --;
            }
        } else {
            $annees --;
        }
    }
    return $annees;
}

function getClairance($age, $sexe, $creatinine)
{
    $clairance = 175 * pow($creatinine / 88.4, - 1.154) * pow($age, - 0.203);

    if ($sexe == 2)
        $clairance = $clairance * 0.742;

    return intval($clairance);
}

function setClairance($csl_code)
{
    global $entityManager;

    $cslInfo = getCslInfo($csl_code);

    // debug($cslInfo);

    $patInfo = getPatientInfo($cslInfo["per_code_pat"]);

    $cslParams = getConsultationParam($csl_code);

    $creatinine = "";

    foreach ($cslParams as $param) {
        if ($param["pbi_code"] == CREATININE_CODE)
            $creatinine = $param["cpb_valeur"];
    }

    if ($creatinine != "") {
        $clairance = getClairance(getAge($patInfo["pat_dt_naiss"]), $patInfo["pat_sexe"], $creatinine);

        $qb = $entityManager->createQueryBuilder();

        $qb->select(array(
            'cspbi'
        ))
            ->from('RAN\Entity\ConsultParamBio', 'cspbi')
            ->andWhere('cspbi.cslCode=:cslCode')
            ->setParameter('cslCode', $csl_code)
            ->andWhere('cspbi.pbiCode=:pbiCode')
            ->setParameter('pbiCode', CLAIRANCE_CODE);

        $cspbi = $qb->getQuery()
            ->setHint(Doctrine\ORM\Query::HINT_REFRESH, true)
            ->getOneOrNullResult();

        if ($cspbi == null) {
            $cspbi = new \RAN\Entity\ConsultParamBio();
            $cspbi->setCslCode($entityManager->getReference('\RAN\Entity\Consultation', $csl_code));
            $cspbi->setPbiCode($entityManager->getReference('\RAN\Entity\ParametresBiologiques', CLAIRANCE_CODE));
            $cspbi->setCpbValeur($clairance);
            $entityManager->persist($cspbi);
        } else {
            $cspbi->setCpbValeur($clairance);
        }

        $entityManager->flush();
    }
}

function getTaille($pat_code)
{
    global $entityManager;

    $qb = $entityManager->createQueryBuilder();

    $qb->select(array(
        "csl"
    ))
        ->from('RAN\Entity\Consultation', 'csl')
        ->andWhere('csl.perCodePat=:perCode')
        ->setParameter('perCode', $pat_code)
        ->andWhere($qb->expr()
        ->isNotNull('csl.cslTaille'))
        ->addOrderBy('csl.cslDate', 'DESC')
        ->addOrderBy('csl.cslCode', 'DESC')
        ->setMaxResults(1);

    $result = $qb->getQuery()->getResult();
    if (count($result) == 1) {
        return $result[0]->getCslTaille();
    } else {
        return '';
    }
}
?>
