<?php
//#########################################################################//
//# Useful for Admin
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 17.01.2008
//#########################################################################//

/**
 * Init Admin
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 17.01.2006 (dd.mm.YYYY)
*/
function initAdmin()
{
	global $smarty;
	
	define("SESS_IDX", SESS_IDX_BE);
	define("UL", "AL");
	
	// session admin initialization
	if(!isset($_SESSION[SESS_IDX])) $_SESSION[SESS_IDX]=array();
	
	// set default language for admin modules - only for multlanguage apps
	if(MULTILANGUAGE && !isset($_SESSION[SESS_IDX]['defaultLang'])) setAdminDefaultLang();
	
	// user loged case
	if(isset($_SESSION[SESS_IDX][UL]['auth']) && $_SESSION[SESS_IDX][UL]['auth']==1)
	{
		if(!isset($_SESSION[SESS_IDX]['adminMenu']))
			buildAdminMenu();
		
		//check user access
		checkUserAccess();
		
		//update logout time
		updateLogoutTime($_SESSION[SESS_IDX][UL]['user_id'], $_SESSION[SESS_IDX][UL]['user_userid'], $_SESSION[SESS_IDX][UL]['user_name']);
		
		//assign info user
		$smarty->assign("UL", $_SESSION[SESS_IDX][UL]);
		
		$smarty->assign("adminMenu", $_SESSION[SESS_IDX]['adminMenu']);
	}
		
	//===> assign smarty variales	
	$smarty->assign("DF", "%d %b %Y");
	$smarty->assign("DTF", "%d %b %Y %H:%M:%S");
	$smarty->assign("buttonStyle", "class=\"button\" onmouseover=\"this.className='buttonHover'\" onmouseout=\"this.className='button'\"");
	//<===
}

/**
 * Check User/Admin Access
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com) 
*/
function checkUserAccess($urlSearch='', $retBool=false)
{
	$flag=true;
	$arrRights=$_SESSION[SESS_IDX][UL]['rights'];
	if(strtolower($_SESSION[SESS_IDX][UL]['user_userid'])!='root' && count($arrRights)>0)
	{
		if($urlSearch=='')
		{
			$urlSearch=basename($_SERVER['PHP_SELF']);
			if($_SERVER['QUERY_STRING']!='')
				$urlSearch.='?'.$_SERVER['QUERY_STRING'];
		}
		
		if($urlSearch==basename($_SERVER['PHP_SELF']) && $_SERVER['QUERY_STRING']=='')
			$urlSearch.='?obj=index&action=page_index';
		
		$tmpArr = explode("?", $urlSearch);
		$tmpArr = explode("&", $tmpArr[1]);
		foreach($tmpArr as $k=>$v)
		{
			$tmpArr2 = explode("=", $v);
			$urlSearchArr[$tmpArr2[0]]=$tmpArr2[1];
		}
		
		//===>searc if exists match
		foreach($arrRights as $k=>$v)
		{
			$s=0;
			
			//===>Obj
			if($v['uright_obj']==$urlSearchArr['obj'])
			{
				$s++;
			}
			//<===
			
			//===>action
			if($v['uright_action']!='')
			{
				$tmpAction = explode('|', $v['uright_action']);
				
				if(isset($urlSearchArr['action']))
				{
					foreach($tmpAction as $k1=>$v1)
					{
						if($urlSearchArr['action']==$v1)
						{
							$s++;
							break;
						}
					}	
				}
			}
			else
				$s++;
			//<===
			
			//===>act
			if($v['uright_act']!='')
			{
				if(isset($urlSearchArr['act']) && $urlSearchArr['act']==$v['uright_act'])
				{
					$s++;	
				}
			}
			else
				$s++;
			//<===
			
			
			if($s==3)
			{
				if($v['right_alocated']==1)
					$flag=true;
				else 
					$flag=false;
				
				break;
			}
		}
		//<===
	}
	
	if($flag==false && $retBool==false)
		redirect("admin.php?obj=index&action=permission_denied");
	else 
		return $flag;
}

/**
 * Update Logout Time (for admin, mauser, maclient) 
 * 
 * @access: public, use session variables :login_time, lupd_time
 * @return: null 
 * @author: CFlorin (colotin_f@yahoo.com) 
*/
function updateLogoutTime($user_id, $userid, $name)
{
	global $dbi;
	
	$sessid = getSessId();
	
	$ip = getIP();
	
	if(isset($_SESSION[SESS_IDX][UL]['login_time']) && $_SESSION[SESS_IDX][UL]['login_time']>0)
	{		
		$perWait = 20;
		$per = 40;
		$cTime = _dtGetTime();
		
		if(isset($_SESSION[SESS_IDX][UL]['lupd_time']))
			$luTime = $_SESSION[SESS_IDX][UL]['lupd_time'];
		else
			$luTime = $_SESSION[SESS_IDX][UL]['login_time'];
		
		$dTime = $cTime-$luTime;
		
		$r = $dTime%$per;
		if($r>$perWait || $dTime>$per) //add-upd
		{
			$_SESSION[SESS_IDX][UL]['lupd_time'] = $cTime;
			
			$q = "SELECT userlog_userid FROM userlog WHERE user_id=$user_id AND userlog_userid='$userid' AND userlog_sessid = '$sessid' ORDER BY userlog_id LIMIT 0,1";
			$dbi->query($q);
			if($dbi->getRow()) //update log
			{
				$datelogout = date('Y-m-d H:i:s', $cTime);
				$q="UPDATE 
						userlog 
					SET 
						userlog_datelogout='$datelogout'
					WHERE 
						user_id=$user_id AND
						userlog_userid='$userid' AND 
						userlog_sessid='$sessid' 
				";
				$dbi->execute($q);
			}
			else //add new log 
			{
				$datetime = date("Y-m-d H:i:s", $_SESSION[SESS_IDX][UL]['login_time']);
				$q="
			    	INSERT INTO 
			    		userlog
					SET
			    		user_id				= $user_id, 
						userlog_userid		= '$userid',
			    		userlog_name		= '$name',
			    		userlog_datelogin	= '$datetime',
			    		userlog_ip 			= '$ip',
			    		userlog_sessid		= '$sessid'
			    ";
				$dbi->execute($q);
			}
		}
	}
	elseif(isset($_SESSION[SESS_IDX][UL]))
	{
		$_SESSION[SESS_IDX][UL]['login_time']=_dtGetTime();
	    $datetime = date("Y-m-d H:i:s", $_SESSION[SESS_IDX][UL]['login_time']);
	    
	    $q="
	    	INSERT INTO 
	    		userlog
			SET
	    		user_id				= '$user_id',
				userlog_userid		= '$userid',
	    		userlog_name		= '$name',
	    		userlog_datelogin	= '$datetime',
	    		userlog_ip 			= '$ip',
	    		userlog_sessid		= '$sessid'
	    ";
		$dbi->execute($q);
	}
}


/**
 * Reset Admin Menu
 * 
 * @access: public
 * @return: null 
 * @author: CFlorin (colotin_f@yahoo.com) 
*/
function resetAdminMenu()
{
	if(isset($_SESSION[SESS_IDX]['adminMenu']))
		unset($_SESSION[SESS_IDX]['adminMenu']);
}

/**
 * Assign Admin Menu
 * 
 * @access: public
 * @return: null 
 * @author: CFlorin (colotin_f@yahoo.com) 
*/
function buildAdminMenu()
{
	global $dbi;
	
	//reset admin menu
	resetAdminMenu();

	$_SESSION[SESS_IDX]['adminMenu']=array();
	
	//===> db tables used
	$mTableName 	= "adminmenu";
    $mIdName 		= "adminmenu_id";
    $mName 			= "adminmenu_name";
    $mPriorityName 	= "adminmenu_priority";
    $mStatusName 	= "adminmenu_active";
    
    $smTableName 	= "adminsmenu";
    $smIdName 		= "adminsmenu_id";
    $smName 		= "adminsmenu_name";
    $smUrlName 		= "adminsmenu_url";
    $smPriorityName = "adminsmenu_priority";
    $smStatusName 	= "adminsmenu_active";
    //<===
    
    //===> generate menu
    $recList = array();$i=-1;
    
    $q="SELECT 
            {$mTableName}.{$mIdName}, {$mTableName}.{$mName}
        FROM 
            {$mTableName}
        WHERE
     		{$mTableName}.{$mStatusName} = 1
    	ORDER BY
     		{$mTableName}.{$mPriorityName}, {$mTableName}.{$mIdName}
    ";
    $res_m=$dbi->query($q);
    while($recM=$dbi->getRow($res_m))
    {
    	$i++;
    	$recList[$i]['name'] = $recM[$mName];
    	$recList[$i]["SM"] 	 = array();
    	
    	//===>
    	$tmpSM = array(); $j=-1;
    	$q="SELECT 
	            {$smTableName}.{$smIdName}, {$smTableName}.{$smName}, {$smTableName}.{$smUrlName}
	        FROM 
	            {$smTableName}
	        WHERE
	     		{$smTableName}.{$mIdName} = {$recM[$mIdName]} AND
    			{$smTableName}.{$smStatusName} = 1
	    	ORDER BY
	     		{$smTableName}.{$smPriorityName}, {$smTableName}.{$smIdName}
	    ";
    	$res_sm=$dbi->query($q);
	    while($recSM=$dbi->getRow($res_sm))
	    {
	    	$j++;
	    	
	    	$tmpSM[$j]['name']   = $recSM[$smName];
	    	$tmpSM[$j]['url']    = $recSM[$smUrlName];
	    	$tmpSM[$j]['access'] = checkUserAccess($recSM[$smUrlName], true);
	    }
	    
	    if($j>=0)
	    	$recList[$i]["SM"] = $tmpSM;
    }
    //<===
    
	$_SESSION[SESS_IDX]['adminMenu'] = $recList;
}
?>