<?php
//#########################################################################//
//# Useful for MultiLanguages Applications
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 17.01.2008
//#########################################################################//

$L['table'] 	= "lang";
$L['id'] 		= "lang_iso";
$L['name'] 		= "lang_name";
$L['priority'] 	= "lang_priority";

/**
 * Set Admin Default Lang
 * 
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com) 
*/
function setAdminDefaultLang()
{
	global $L;
	
	$q="SELECT {$L['id']} FROM {$L['table']} ORDER BY lang_defadmin DESC, {$L['priority']}, {$L['id']} LIMIT 0,1";
	$dbi->query($q);
	if($rec=$dbi->getRow())
		$_SESSION[SESS_IDX]['defaultLang'] = $record[0];
	else 
		echo "No records in {$L['table']} table!";
}

/**
 * Assign lang variable to session
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function sessAssignLangVar($lang_id='')
{
	global $L;
	
	if(isset($_SESSION[SESS_IDX]['lang']))
		unset($_SESSION[SESS_IDX]['lang']);
	else 
	{
		//used for country autodetection
		if(isset($_SESSION[SESS_IDX]['country']['iso']) && $_SESSION[SESS_IDX]['country']['iso']!='')
			$lang_id = $_SESSION[SESS_IDX]['country']['iso'];
		
		$_SESSION[SESS_IDX]['lang'] = array();
	}
	
	//===>get info lang
	if(''==$lang_id)
		$q="SELECT {$L['id']}, {$L['name']} FROM {$L['table']} WHERE lang_active=1 ORDER BY lang_defsite DESC, {$L['priority']}, {$L['id']} LIMIT 0,1";
	else
		$q="SELECT {$L['id']}, {$L['name']} FROM {$L['table']} WHERE lang_active=1 AND {$L['id']}='{$lang_id}'";				
	$dbi->query($q);
	if(!$rec=$dbi->getRow('num'))
	{
		if(''!=$lang_id)
		{
			sessAssignLangVar();
			return ;
		}
		else 
		{
			echo "Language are not set!";
			exit;
		}
	}
	else 
	{
		$_SESSION[SESS_IDX]['lang']['id']	 = $record[0];
		$_SESSION[SESS_IDX]['lang']['name']  = $record[1];
		$_SESSION[SESS_IDX]['lang']['list']  = getLangList();
		$_SESSION[SESS_IDX]['lang']['trans'] = getTrans($record[0]);
	}
	//<===
}


/**
 * Get translations variable
 *
 * @access: public
 * @return: array()
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function getTrans($lang_id)
{
    global $L;
    
    //===> Init of CacheLite
	require_once('Cache/Lite.php');
	$options = array('cacheDir' => COMPILE_DIR.'cache_lite/', 'lifeTime' => CACHE_LIFETIME); 
	$cache_lite = new Cache_Lite($options);
	//<===
    
	if (($cached=$cache_lite->get(md5("trans"))))  
		$trans = unserialize($cached); 
	else 
	{	
		$trans=array();
		
		$q = "
	        SELECT 
	            trans.trans_var, trans{$L['table']}.trans{$L['table']}_text
	        FROM
	            trans, trans{$L['table']}
	        WHERE
	            trans.trans_id=trans{$L['table']}.trans_id AND 
	    		trans{$L['table']}.{$L['id']}='$lang_id'
	    ";
	    $dbi->query($q);
	    while($rec=$dbi->getRow())
	        $trans[strtolower($record[0])]=$record[1];
	   
	   $cache_lite->save(serialize($trans), md5("trans"));
	}
	
    return $trans;
}

/**
 * Get Lang List
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com) 
*/
function getLangList()
{
	global $L;
	
	$ret = array();
	$q="SELECT {$L['id']}, {$L['name']} FROM {$L['table']} WHERE lang_active=1 ORDER BY {$L['priority']}, {$L['id']}";
	$dbi->query($q); $i=0;
	while($rec=$dbi->getRow('num'))
	{
		$ret[$i][0] = $rec[0];
		$ret[$i][1] = $rec[1];
		$i++;
	}
	
	return $ret;
}
?>