<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Adminmenu
 *
 * @ORM\Table(name="adminmenu", uniqueConstraints={@ORM\UniqueConstraint(name="adminmenu_name", columns={"adminmenu_name"})})
 * @ORM\Entity
 */
class Adminmenu
{
    /**
     * @var bool
     *
     * @ORM\Column(name="adminmenu_id", type="boolean", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $adminmenuId = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="adminmenu_name", type="string", length=50, nullable=false)
     */
    private $adminmenuName = '';

    /**
     * @var bool
     *
     * @ORM\Column(name="adminmenu_priority", type="boolean", nullable=false)
     */
    private $adminmenuPriority = '0';

    /**
     * @var bool
     *
     * @ORM\Column(name="adminmenu_active", type="boolean", nullable=false)
     */
    private $adminmenuActive = '0';



    /**
     * Get adminmenuId.
     *
     * @return bool
     */
    public function getAdminmenuId()
    {
        return $this->adminmenuId;
    }

    /**
     * Set adminmenuName.
     *
     * @param string $adminmenuName
     *
     * @return Adminmenu
     */
    public function setAdminmenuName($adminmenuName)
    {
        $this->adminmenuName = $adminmenuName;

        return $this;
    }

    /**
     * Get adminmenuName.
     *
     * @return string
     */
    public function getAdminmenuName()
    {
        return $this->adminmenuName;
    }

    /**
     * Set adminmenuPriority.
     *
     * @param bool $adminmenuPriority
     *
     * @return Adminmenu
     */
    public function setAdminmenuPriority($adminmenuPriority)
    {
        $this->adminmenuPriority = $adminmenuPriority;

        return $this;
    }

    /**
     * Get adminmenuPriority.
     *
     * @return bool
     */
    public function getAdminmenuPriority()
    {
        return $this->adminmenuPriority;
    }

    /**
     * Set adminmenuActive.
     *
     * @param bool $adminmenuActive
     *
     * @return Adminmenu
     */
    public function setAdminmenuActive($adminmenuActive)
    {
        $this->adminmenuActive = $adminmenuActive;

        return $this;
    }

    /**
     * Get adminmenuActive.
     *
     * @return bool
     */
    public function getAdminmenuActive()
    {
        return $this->adminmenuActive;
    }
}
