<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Adminsmenu
 *
 * @ORM\Table(name="adminsmenu", indexes={@ORM\Index(name="adminmenu_id", columns={"adminmenu_id"})})
 * @ORM\Entity
 */
class Adminsmenu
{
    /**
     * @var bool
     *
     * @ORM\Column(name="adminsmenu_id", type="boolean", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $adminsmenuId = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="adminsmenu_name", type="string", length=50, nullable=false)
     */
    private $adminsmenuName = '';

    /**
     * @var string
     *
     * @ORM\Column(name="adminsmenu_url", type="string", length=255, nullable=false)
     */
    private $adminsmenuUrl = '';

    /**
     * @var bool
     *
     * @ORM\Column(name="adminsmenu_priority", type="boolean", nullable=false)
     */
    private $adminsmenuPriority = '0';

    /**
     * @var bool
     *
     * @ORM\Column(name="adminsmenu_master", type="boolean", nullable=false)
     */
    private $adminsmenuMaster = '0';

    /**
     * @var bool
     *
     * @ORM\Column(name="adminsmenu_active", type="boolean", nullable=false)
     */
    private $adminsmenuActive = '0';

    /**
     * @var \RAN\Entity\Adminmenu
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Adminmenu")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="adminmenu_id", referencedColumnName="adminmenu_id")
     * })
     */
    private $adminmenu;



    /**
     * Get adminsmenuId.
     *
     * @return bool
     */
    public function getAdminsmenuId()
    {
        return $this->adminsmenuId;
    }

    /**
     * Set adminsmenuName.
     *
     * @param string $adminsmenuName
     *
     * @return Adminsmenu
     */
    public function setAdminsmenuName($adminsmenuName)
    {
        $this->adminsmenuName = $adminsmenuName;

        return $this;
    }

    /**
     * Get adminsmenuName.
     *
     * @return string
     */
    public function getAdminsmenuName()
    {
        return $this->adminsmenuName;
    }

    /**
     * Set adminsmenuUrl.
     *
     * @param string $adminsmenuUrl
     *
     * @return Adminsmenu
     */
    public function setAdminsmenuUrl($adminsmenuUrl)
    {
        $this->adminsmenuUrl = $adminsmenuUrl;

        return $this;
    }

    /**
     * Get adminsmenuUrl.
     *
     * @return string
     */
    public function getAdminsmenuUrl()
    {
        return $this->adminsmenuUrl;
    }

    /**
     * Set adminsmenuPriority.
     *
     * @param bool $adminsmenuPriority
     *
     * @return Adminsmenu
     */
    public function setAdminsmenuPriority($adminsmenuPriority)
    {
        $this->adminsmenuPriority = $adminsmenuPriority;

        return $this;
    }

    /**
     * Get adminsmenuPriority.
     *
     * @return bool
     */
    public function getAdminsmenuPriority()
    {
        return $this->adminsmenuPriority;
    }

    /**
     * Set adminsmenuMaster.
     *
     * @param bool $adminsmenuMaster
     *
     * @return Adminsmenu
     */
    public function setAdminsmenuMaster($adminsmenuMaster)
    {
        $this->adminsmenuMaster = $adminsmenuMaster;

        return $this;
    }

    /**
     * Get adminsmenuMaster.
     *
     * @return bool
     */
    public function getAdminsmenuMaster()
    {
        return $this->adminsmenuMaster;
    }

    /**
     * Set adminsmenuActive.
     *
     * @param bool $adminsmenuActive
     *
     * @return Adminsmenu
     */
    public function setAdminsmenuActive($adminsmenuActive)
    {
        $this->adminsmenuActive = $adminsmenuActive;

        return $this;
    }

    /**
     * Get adminsmenuActive.
     *
     * @return bool
     */
    public function getAdminsmenuActive()
    {
        return $this->adminsmenuActive;
    }

    /**
     * Set adminmenu.
     *
     * @param \RAN\Entity\Adminmenu|null $adminmenu
     *
     * @return Adminsmenu
     */
    public function setAdminmenu(\RAN\Entity\Adminmenu $adminmenu = null)
    {
        $this->adminmenu = $adminmenu;

        return $this;
    }

    /**
     * Get adminmenu.
     *
     * @return \RAN\Entity\Adminmenu|null
     */
    public function getAdminmenu()
    {
        return $this->adminmenu;
    }
}
