<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdressePostale
 *
 * @ORM\Table(name="adresse_postale", indexes={@ORM\Index(name="fk_adresse_postale_pays", columns={"pay_id"}), @ORM\Index(name="fk_fk_adr_postale_commune", columns={"com_code"})})
 * @ORM\Entity
 */
class AdressePostale
{
    /**
     * @var int
     *
     * @ORM\Column(name="adr_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $adrCode;

    /**
     * @var int|null
     *
     * @ORM\Column(name="com_code", type="smallint", nullable=true)
     */
    private $comCode;

    /**
     * @var string
     *
     * @ORM\Column(name="adr_voie", type="string", length=200, nullable=false)
     */
    private $adrVoie;

    /**
     * @var string|null
     *
     * @ORM\Column(name="adr_complement", type="string", length=50, nullable=true)
     */
    private $adrComplement;

    /**
     * @var string|null
     *
     * @ORM\Column(name="adr_cp", type="string", length=5, nullable=true)
     */
    private $adrCp;

    /**
     * @var string|null
     *
     * @ORM\Column(name="adr_ville", type="string", length=64, nullable=true)
     */
    private $adrVille;

    /**
     * @var int|null
     *
     * @ORM\Column(name="pay_id", type="smallint", nullable=true)
     */
    private $payId;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\Personne", inversedBy="adrCode")
     * @ORM\JoinTable(name="personne_adr_postale",
     *   joinColumns={
     *     @ORM\JoinColumn(name="adr_code", referencedColumnName="adr_code")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     *   }
     * )
     */
    private $perCode;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->perCode = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get adrCode.
     *
     * @return int
     */
    public function getAdrCode()
    {
        return $this->adrCode;
    }

    /**
     * Set comCode.
     *
     * @param int|null $comCode
     *
     * @return AdressePostale
     */
    public function setComCode($comCode = null)
    {
        $this->comCode = $comCode;

        return $this;
    }

    /**
     * Get comCode.
     *
     * @return int|null
     */
    public function getComCode()
    {
        return $this->comCode;
    }

    /**
     * Set adrVoie.
     *
     * @param string $adrVoie
     *
     * @return AdressePostale
     */
    public function setAdrVoie($adrVoie)
    {
        $this->adrVoie = $adrVoie;

        return $this;
    }

    /**
     * Get adrVoie.
     *
     * @return string
     */
    public function getAdrVoie()
    {
        return $this->adrVoie;
    }

    /**
     * Set adrComplement.
     *
     * @param string|null $adrComplement
     *
     * @return AdressePostale
     */
    public function setAdrComplement($adrComplement = null)
    {
        $this->adrComplement = $adrComplement;

        return $this;
    }

    /**
     * Get adrComplement.
     *
     * @return string|null
     */
    public function getAdrComplement()
    {
        return $this->adrComplement;
    }

    /**
     * Set adrCp.
     *
     * @param string|null $adrCp
     *
     * @return AdressePostale
     */
    public function setAdrCp($adrCp = null)
    {
        $this->adrCp = $adrCp;

        return $this;
    }

    /**
     * Get adrCp.
     *
     * @return string|null
     */
    public function getAdrCp()
    {
        return $this->adrCp;
    }

    /**
     * Set adrVille.
     *
     * @param string|null $adrVille
     *
     * @return AdressePostale
     */
    public function setAdrVille($adrVille = null)
    {
        $this->adrVille = $adrVille;

        return $this;
    }

    /**
     * Get adrVille.
     *
     * @return string|null
     */
    public function getAdrVille()
    {
        return $this->adrVille;
    }

    /**
     * Set payId.
     *
     * @param int|null $payId
     *
     * @return AdressePostale
     */
    public function setPayId($payId = null)
    {
        $this->payId = $payId;

        return $this;
    }

    /**
     * Get payId.
     *
     * @return int|null
     */
    public function getPayId()
    {
        return $this->payId;
    }

    /**
     * Add perCode.
     *
     * @param \RAN\Entity\Personne $perCode
     *
     * @return AdressePostale
     */
    public function addPerCode(\RAN\Entity\Personne $perCode)
    {
        $this->perCode[] = $perCode;

        return $this;
    }

    /**
     * Remove perCode.
     *
     * @param \RAN\Entity\Personne $perCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removePerCode(\RAN\Entity\Personne $perCode)
    {
        return $this->perCode->removeElement($perCode);
    }

    /**
     * Get perCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPerCode()
    {
        return $this->perCode;
    }
}
