<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Alerte
 *
 * @ORM\Table(name="alerte", indexes={@ORM\Index(name="fk_fk_patient_alerte", columns={"per_code_pat"})})
 * @ORM\Entity
 */
class Alerte
{
    /**
     * @var int
     *
     * @ORM\Column(name="ale_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $aleCode;

    /**
     * @var string
     *
     * @ORM\Column(name="ale_objet", type="string", length=500, nullable=false)
     */
    private $aleObjet;

    /**
     * @var string
     *
     * @ORM\Column(name="ale_message", type="string", length=2000, nullable=false)
     */
    private $aleMessage;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="ale_email", type="boolean", nullable=true)
     */
    private $aleEmail;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_pat", referencedColumnName="per_code")
     * })
     */
    private $perCodePat;



    /**
     * Get aleCode.
     *
     * @return int
     */
    public function getAleCode()
    {
        return $this->aleCode;
    }

    /**
     * Set aleObjet.
     *
     * @param string $aleObjet
     *
     * @return Alerte
     */
    public function setAleObjet($aleObjet)
    {
        $this->aleObjet = $aleObjet;

        return $this;
    }

    /**
     * Get aleObjet.
     *
     * @return string
     */
    public function getAleObjet()
    {
        return $this->aleObjet;
    }

    /**
     * Set aleMessage.
     *
     * @param string $aleMessage
     *
     * @return Alerte
     */
    public function setAleMessage($aleMessage)
    {
        $this->aleMessage = $aleMessage;

        return $this;
    }

    /**
     * Get aleMessage.
     *
     * @return string
     */
    public function getAleMessage()
    {
        return $this->aleMessage;
    }

    /**
     * Set aleEmail.
     *
     * @param bool|null $aleEmail
     *
     * @return Alerte
     */
    public function setAleEmail($aleEmail = null)
    {
        $this->aleEmail = $aleEmail;

        return $this;
    }

    /**
     * Get aleEmail.
     *
     * @return bool|null
     */
    public function getAleEmail()
    {
        return $this->aleEmail;
    }

    /**
     * Set perCodePat.
     *
     * @param \RAN\Entity\Patient|null $perCodePat
     *
     * @return Alerte
     */
    public function setPerCodePat(\RAN\Entity\Patient $perCodePat = null)
    {
        $this->perCodePat = $perCodePat;

        return $this;
    }

    /**
     * Get perCodePat.
     *
     * @return \RAN\Entity\Patient|null
     */
    public function getPerCodePat()
    {
        return $this->perCodePat;
    }
}
