<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Allergie
 *
 * @ORM\Table(name="allergie", indexes={@ORM\Index(name="fk_fk_allergiex_medic", columns={"medi_code"}), @ORM\Index(name="IDX_1ED89E4A2C7710A1", columns={"per_code_pat"})})
 * @ORM\Entity
 */
class Allergie
{
    /**
     * @var int
     *
     * @ORM\Column(name="medi_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $mediCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="aller_dt_creat", type="date", nullable=false)
     */
    private $allerDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="aller_alerte", type="string", length=500, nullable=true)
     */
    private $allerAlerte;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_pat", referencedColumnName="per_code")
     * })
     */
    private $perCodePat;



    /**
     * Set mediCode.
     *
     * @param int $mediCode
     *
     * @return Allergie
     */
    public function setMediCode($mediCode)
    {
        $this->mediCode = $mediCode;

        return $this;
    }

    /**
     * Get mediCode.
     *
     * @return int
     */
    public function getMediCode()
    {
        return $this->mediCode;
    }

    /**
     * Set allerDtCreat.
     *
     * @param \DateTime $allerDtCreat
     *
     * @return Allergie
     */
    public function setAllerDtCreat($allerDtCreat)
    {
        $this->allerDtCreat = $allerDtCreat;

        return $this;
    }

    /**
     * Get allerDtCreat.
     *
     * @return \DateTime
     */
    public function getAllerDtCreat()
    {
        return $this->allerDtCreat;
    }

    /**
     * Set allerAlerte.
     *
     * @param string|null $allerAlerte
     *
     * @return Allergie
     */
    public function setAllerAlerte($allerAlerte = null)
    {
        $this->allerAlerte = $allerAlerte;

        return $this;
    }

    /**
     * Get allerAlerte.
     *
     * @return string|null
     */
    public function getAllerAlerte()
    {
        return $this->allerAlerte;
    }

    /**
     * Set perCodePat.
     *
     * @param \RAN\Entity\Patient $perCodePat
     *
     * @return Allergie
     */
    public function setPerCodePat(\RAN\Entity\Patient $perCodePat)
    {
        $this->perCodePat = $perCodePat;

        return $this;
    }

    /**
     * Get perCodePat.
     *
     * @return \RAN\Entity\Patient
     */
    public function getPerCodePat()
    {
        return $this->perCodePat;
    }
}
