<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AntAutres
 *
 * @ORM\Table(name="ant_autres", indexes={@ORM\Index(name="fk_fk_ant_autres_cim10", columns={"cim_code"})})
 * @ORM\Entity
 */
class AntAutres
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ant_dt_creat", type="date", nullable=false)
     */
    private $antDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ant_comment", type="string", length=500, nullable=true)
     */
    private $antComment;

    /**
     * @var string
     *
     * @ORM\Column(name="aua_nom_med", type="string", length=50, nullable=false)
     */
    private $auaNomMed;

    /**
     * @var string|null
     *
     * @ORM\Column(name="aua_prise_charge", type="string", length=200, nullable=true)
     */
    private $auaPriseCharge;

    /**
     * @var string|null
     *
     * @ORM\Column(name="aua_comment", type="string", length=500, nullable=true)
     */
    private $auaComment;

    /**
     * @var bool
     *
     * @ORM\Column(name="aua_transfu", type="boolean", nullable=false)
     */
    private $auaTransfu;

    /**
     * @var int|null
     *
     * @ORM\Column(name="aua_nb_transfu", type="smallint", nullable=true)
     */
    private $auaNbTransfu;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="aua_dt_transfu", type="date", nullable=true)
     */
    private $auaDtTransfu;

    /**
     * @var bool
     *
     * @ORM\Column(name="aua_gross", type="boolean", nullable=false)
     */
    private $auaGross;

    /**
     * @var int|null
     *
     * @ORM\Column(name="aua_nb_gross", type="smallint", nullable=true)
     */
    private $auaNbGross;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="aua_dt_gross", type="date", nullable=true)
     */
    private $auaDtGross;

    /**
     * @var \RAN\Entity\Cim10
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Cim10")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cim_code", referencedColumnName="cim_code")
     * })
     */
    private $cimCode;

    /**
     * @var \RAN\Entity\Antecedent
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Antecedent")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set antDtCreat.
     *
     * @param \DateTime $antDtCreat
     *
     * @return AntAutres
     */
    public function setAntDtCreat($antDtCreat)
    {
        $this->antDtCreat = $antDtCreat;

        return $this;
    }

    /**
     * Get antDtCreat.
     *
     * @return \DateTime
     */
    public function getAntDtCreat()
    {
        return $this->antDtCreat;
    }

    /**
     * Set antComment.
     *
     * @param string|null $antComment
     *
     * @return AntAutres
     */
    public function setAntComment($antComment = null)
    {
        $this->antComment = $antComment;

        return $this;
    }

    /**
     * Get antComment.
     *
     * @return string|null
     */
    public function getAntComment()
    {
        return $this->antComment;
    }

    /**
     * Set auaNomMed.
     *
     * @param string $auaNomMed
     *
     * @return AntAutres
     */
    public function setAuaNomMed($auaNomMed)
    {
        $this->auaNomMed = $auaNomMed;

        return $this;
    }

    /**
     * Get auaNomMed.
     *
     * @return string
     */
    public function getAuaNomMed()
    {
        return $this->auaNomMed;
    }

    /**
     * Set auaPriseCharge.
     *
     * @param string|null $auaPriseCharge
     *
     * @return AntAutres
     */
    public function setAuaPriseCharge($auaPriseCharge = null)
    {
        $this->auaPriseCharge = $auaPriseCharge;

        return $this;
    }

    /**
     * Get auaPriseCharge.
     *
     * @return string|null
     */
    public function getAuaPriseCharge()
    {
        return $this->auaPriseCharge;
    }

    /**
     * Set auaComment.
     *
     * @param string|null $auaComment
     *
     * @return AntAutres
     */
    public function setAuaComment($auaComment = null)
    {
        $this->auaComment = $auaComment;

        return $this;
    }

    /**
     * Get auaComment.
     *
     * @return string|null
     */
    public function getAuaComment()
    {
        return $this->auaComment;
    }

    /**
     * Set auaTransfu.
     *
     * @param bool $auaTransfu
     *
     * @return AntAutres
     */
    public function setAuaTransfu($auaTransfu)
    {
        $this->auaTransfu = $auaTransfu;

        return $this;
    }

    /**
     * Get auaTransfu.
     *
     * @return bool
     */
    public function getAuaTransfu()
    {
        return $this->auaTransfu;
    }

    /**
     * Set auaNbTransfu.
     *
     * @param int|null $auaNbTransfu
     *
     * @return AntAutres
     */
    public function setAuaNbTransfu($auaNbTransfu = null)
    {
        $this->auaNbTransfu = $auaNbTransfu;

        return $this;
    }

    /**
     * Get auaNbTransfu.
     *
     * @return int|null
     */
    public function getAuaNbTransfu()
    {
        return $this->auaNbTransfu;
    }

    /**
     * Set auaDtTransfu.
     *
     * @param \DateTime|null $auaDtTransfu
     *
     * @return AntAutres
     */
    public function setAuaDtTransfu($auaDtTransfu = null)
    {
        $this->auaDtTransfu = $auaDtTransfu;

        return $this;
    }

    /**
     * Get auaDtTransfu.
     *
     * @return \DateTime|null
     */
    public function getAuaDtTransfu()
    {
        return $this->auaDtTransfu;
    }

    /**
     * Set auaGross.
     *
     * @param bool $auaGross
     *
     * @return AntAutres
     */
    public function setAuaGross($auaGross)
    {
        $this->auaGross = $auaGross;

        return $this;
    }

    /**
     * Get auaGross.
     *
     * @return bool
     */
    public function getAuaGross()
    {
        return $this->auaGross;
    }

    /**
     * Set auaNbGross.
     *
     * @param int|null $auaNbGross
     *
     * @return AntAutres
     */
    public function setAuaNbGross($auaNbGross = null)
    {
        $this->auaNbGross = $auaNbGross;

        return $this;
    }

    /**
     * Get auaNbGross.
     *
     * @return int|null
     */
    public function getAuaNbGross()
    {
        return $this->auaNbGross;
    }

    /**
     * Set auaDtGross.
     *
     * @param \DateTime|null $auaDtGross
     *
     * @return AntAutres
     */
    public function setAuaDtGross($auaDtGross = null)
    {
        $this->auaDtGross = $auaDtGross;

        return $this;
    }

    /**
     * Get auaDtGross.
     *
     * @return \DateTime|null
     */
    public function getAuaDtGross()
    {
        return $this->auaDtGross;
    }

    /**
     * Set cimCode.
     *
     * @param \RAN\Entity\Cim10|null $cimCode
     *
     * @return AntAutres
     */
    public function setCimCode(\RAN\Entity\Cim10 $cimCode = null)
    {
        $this->cimCode = $cimCode;

        return $this;
    }

    /**
     * Get cimCode.
     *
     * @return \RAN\Entity\Cim10|null
     */
    public function getCimCode()
    {
        return $this->cimCode;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\Antecedent $antCode
     *
     * @return AntAutres
     */
    public function setAntCode(\RAN\Entity\Antecedent $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\Antecedent
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
