<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AntCardio
 *
 * @ORM\Table(name="ant_cardio")
 * @ORM\Entity
 */
class AntCardio
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ant_dt_creat", type="date", nullable=false)
     */
    private $antDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ant_comment", type="string", length=500, nullable=true)
     */
    private $antComment;

    /**
     * @var string|null
     *
     * @ORM\Column(name="anc_diurese", type="string", length=10, nullable=true, options={"fixed"=true})
     */
    private $ancDiurese;

    /**
     * @var string|null
     *
     * @ORM\Column(name="anc_psa", type="string", length=10, nullable=true, options={"fixed"=true})
     */
    private $ancPsa;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="anc_tabac", type="boolean", nullable=true)
     */
    private $ancTabac;

    /**
     * @var int|null
     *
     * @ORM\Column(name="anc_paq_an", type="smallint", nullable=true)
     */
    private $ancPaqAn;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="anc_sevre", type="boolean", nullable=true)
     */
    private $ancSevre;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="anc_diabete", type="boolean", nullable=true)
     */
    private $ancDiabete;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="anc_dyslipidemie", type="boolean", nullable=true)
     */
    private $ancDyslipidemie;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="anc_hta", type="boolean", nullable=true)
     */
    private $ancHta;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="anc_sedentarite", type="boolean", nullable=true)
     */
    private $ancSedentarite;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="anc_antec_famille", type="boolean", nullable=true)
     */
    private $ancAntecFamille;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="anc_sur_poids", type="boolean", nullable=true)
     */
    private $ancSurPoids;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="anc_hyp_homocysteniemie", type="boolean", nullable=true)
     */
    private $ancHypHomocysteniemie;

    /**
     * @var \RAN\Entity\Antecedent
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Antecedent")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set antDtCreat.
     *
     * @param \DateTime $antDtCreat
     *
     * @return AntCardio
     */
    public function setAntDtCreat($antDtCreat)
    {
        $this->antDtCreat = $antDtCreat;

        return $this;
    }

    /**
     * Get antDtCreat.
     *
     * @return \DateTime
     */
    public function getAntDtCreat()
    {
        return $this->antDtCreat;
    }

    /**
     * Set antComment.
     *
     * @param string|null $antComment
     *
     * @return AntCardio
     */
    public function setAntComment($antComment = null)
    {
        $this->antComment = $antComment;

        return $this;
    }

    /**
     * Get antComment.
     *
     * @return string|null
     */
    public function getAntComment()
    {
        return $this->antComment;
    }

    /**
     * Set ancDiurese.
     *
     * @param string|null $ancDiurese
     *
     * @return AntCardio
     */
    public function setAncDiurese($ancDiurese = null)
    {
        $this->ancDiurese = $ancDiurese;

        return $this;
    }

    /**
     * Get ancDiurese.
     *
     * @return string|null
     */
    public function getAncDiurese()
    {
        return $this->ancDiurese;
    }

    /**
     * Set ancPsa.
     *
     * @param string|null $ancPsa
     *
     * @return AntCardio
     */
    public function setAncPsa($ancPsa = null)
    {
        $this->ancPsa = $ancPsa;

        return $this;
    }

    /**
     * Get ancPsa.
     *
     * @return string|null
     */
    public function getAncPsa()
    {
        return $this->ancPsa;
    }

    /**
     * Set ancTabac.
     *
     * @param bool|null $ancTabac
     *
     * @return AntCardio
     */
    public function setAncTabac($ancTabac = null)
    {
        $this->ancTabac = $ancTabac;

        return $this;
    }

    /**
     * Get ancTabac.
     *
     * @return bool|null
     */
    public function getAncTabac()
    {
        return $this->ancTabac;
    }

    /**
     * Set ancPaqAn.
     *
     * @param int|null $ancPaqAn
     *
     * @return AntCardio
     */
    public function setAncPaqAn($ancPaqAn = null)
    {
        $this->ancPaqAn = $ancPaqAn;

        return $this;
    }

    /**
     * Get ancPaqAn.
     *
     * @return int|null
     */
    public function getAncPaqAn()
    {
        return $this->ancPaqAn;
    }

    /**
     * Set ancSevre.
     *
     * @param bool|null $ancSevre
     *
     * @return AntCardio
     */
    public function setAncSevre($ancSevre = null)
    {
        $this->ancSevre = $ancSevre;

        return $this;
    }

    /**
     * Get ancSevre.
     *
     * @return bool|null
     */
    public function getAncSevre()
    {
        return $this->ancSevre;
    }

    /**
     * Set ancDiabete.
     *
     * @param bool|null $ancDiabete
     *
     * @return AntCardio
     */
    public function setAncDiabete($ancDiabete = null)
    {
        $this->ancDiabete = $ancDiabete;

        return $this;
    }

    /**
     * Get ancDiabete.
     *
     * @return bool|null
     */
    public function getAncDiabete()
    {
        return $this->ancDiabete;
    }

    /**
     * Set ancDyslipidemie.
     *
     * @param bool|null $ancDyslipidemie
     *
     * @return AntCardio
     */
    public function setAncDyslipidemie($ancDyslipidemie = null)
    {
        $this->ancDyslipidemie = $ancDyslipidemie;

        return $this;
    }

    /**
     * Get ancDyslipidemie.
     *
     * @return bool|null
     */
    public function getAncDyslipidemie()
    {
        return $this->ancDyslipidemie;
    }

    /**
     * Set ancHta.
     *
     * @param bool|null $ancHta
     *
     * @return AntCardio
     */
    public function setAncHta($ancHta = null)
    {
        $this->ancHta = $ancHta;

        return $this;
    }

    /**
     * Get ancHta.
     *
     * @return bool|null
     */
    public function getAncHta()
    {
        return $this->ancHta;
    }

    /**
     * Set ancSedentarite.
     *
     * @param bool|null $ancSedentarite
     *
     * @return AntCardio
     */
    public function setAncSedentarite($ancSedentarite = null)
    {
        $this->ancSedentarite = $ancSedentarite;

        return $this;
    }

    /**
     * Get ancSedentarite.
     *
     * @return bool|null
     */
    public function getAncSedentarite()
    {
        return $this->ancSedentarite;
    }

    /**
     * Set ancAntecFamille.
     *
     * @param bool|null $ancAntecFamille
     *
     * @return AntCardio
     */
    public function setAncAntecFamille($ancAntecFamille = null)
    {
        $this->ancAntecFamille = $ancAntecFamille;

        return $this;
    }

    /**
     * Get ancAntecFamille.
     *
     * @return bool|null
     */
    public function getAncAntecFamille()
    {
        return $this->ancAntecFamille;
    }

    /**
     * Set ancSurPoids.
     *
     * @param bool|null $ancSurPoids
     *
     * @return AntCardio
     */
    public function setAncSurPoids($ancSurPoids = null)
    {
        $this->ancSurPoids = $ancSurPoids;

        return $this;
    }

    /**
     * Get ancSurPoids.
     *
     * @return bool|null
     */
    public function getAncSurPoids()
    {
        return $this->ancSurPoids;
    }

    /**
     * Set ancHypHomocysteniemie.
     *
     * @param bool|null $ancHypHomocysteniemie
     *
     * @return AntCardio
     */
    public function setAncHypHomocysteniemie($ancHypHomocysteniemie = null)
    {
        $this->ancHypHomocysteniemie = $ancHypHomocysteniemie;

        return $this;
    }

    /**
     * Get ancHypHomocysteniemie.
     *
     * @return bool|null
     */
    public function getAncHypHomocysteniemie()
    {
        return $this->ancHypHomocysteniemie;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\Antecedent $antCode
     *
     * @return AntCardio
     */
    public function setAntCode(\RAN\Entity\Antecedent $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\Antecedent
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
