<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Antecedent
 *
 * @ORM\Table(name="antecedent")
 * @ORM\Entity
 */
class Antecedent
{
    /**
     * @var int
     *
     * @ORM\Column(name="ant_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $antCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ant_dt_creat", type="date", nullable=false)
     */
    private $antDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ant_comment", type="string", length=500, nullable=true)
     */
    private $antComment;



    /**
     * Get antCode.
     *
     * @return int
     */
    public function getAntCode()
    {
        return $this->antCode;
    }

    /**
     * Set antDtCreat.
     *
     * @param \DateTime $antDtCreat
     *
     * @return Antecedent
     */
    public function setAntDtCreat($antDtCreat)
    {
        $this->antDtCreat = $antDtCreat;

        return $this;
    }

    /**
     * Get antDtCreat.
     *
     * @return \DateTime
     */
    public function getAntDtCreat()
    {
        return $this->antDtCreat;
    }

    /**
     * Set antComment.
     *
     * @param string|null $antComment
     *
     * @return Antecedent
     */
    public function setAntComment($antComment = null)
    {
        $this->antComment = $antComment;

        return $this;
    }

    /**
     * Get antComment.
     *
     * @return string|null
     */
    public function getAntComment()
    {
        return $this->antComment;
    }
}
