<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AntecedentInfectieux
 *
 * @ORM\Table(name="antecedent_infectieux", indexes={@ORM\Index(name="fk_fk_ant_infect_thesau", columns={"code_greffe"})})
 * @ORM\Entity
 */
class AntecedentInfectieux
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ant_dt_creat", type="date", nullable=false)
     */
    private $antDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ant_comment", type="string", length=500, nullable=true)
     */
    private $antComment;

    /**
     * @var string
     *
     * @ORM\Column(name="ani_medecin", type="string", length=50, nullable=false)
     */
    private $aniMedecin;

    /**
     * @var string
     *
     * @ORM\Column(name="ani_prise_charge", type="string", length=500, nullable=false)
     */
    private $aniPriseCharge;

    /**
     * @var \RAN\Entity\Antecedent
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Antecedent")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;

    /**
     * @var \RAN\Entity\ThesaurusGreffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ThesaurusGreffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="code_greffe", referencedColumnName="code_greffe")
     * })
     */
    private $codeGreffe;



    /**
     * Set antDtCreat.
     *
     * @param \DateTime $antDtCreat
     *
     * @return AntecedentInfectieux
     */
    public function setAntDtCreat($antDtCreat)
    {
        $this->antDtCreat = $antDtCreat;

        return $this;
    }

    /**
     * Get antDtCreat.
     *
     * @return \DateTime
     */
    public function getAntDtCreat()
    {
        return $this->antDtCreat;
    }

    /**
     * Set antComment.
     *
     * @param string|null $antComment
     *
     * @return AntecedentInfectieux
     */
    public function setAntComment($antComment = null)
    {
        $this->antComment = $antComment;

        return $this;
    }

    /**
     * Get antComment.
     *
     * @return string|null
     */
    public function getAntComment()
    {
        return $this->antComment;
    }

    /**
     * Set aniMedecin.
     *
     * @param string $aniMedecin
     *
     * @return AntecedentInfectieux
     */
    public function setAniMedecin($aniMedecin)
    {
        $this->aniMedecin = $aniMedecin;

        return $this;
    }

    /**
     * Get aniMedecin.
     *
     * @return string
     */
    public function getAniMedecin()
    {
        return $this->aniMedecin;
    }

    /**
     * Set aniPriseCharge.
     *
     * @param string $aniPriseCharge
     *
     * @return AntecedentInfectieux
     */
    public function setAniPriseCharge($aniPriseCharge)
    {
        $this->aniPriseCharge = $aniPriseCharge;

        return $this;
    }

    /**
     * Get aniPriseCharge.
     *
     * @return string
     */
    public function getAniPriseCharge()
    {
        return $this->aniPriseCharge;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\Antecedent $antCode
     *
     * @return AntecedentInfectieux
     */
    public function setAntCode(\RAN\Entity\Antecedent $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\Antecedent
     */
    public function getAntCode()
    {
        return $this->antCode;
    }

    /**
     * Set codeGreffe.
     *
     * @param \RAN\Entity\ThesaurusGreffe|null $codeGreffe
     *
     * @return AntecedentInfectieux
     */
    public function setCodeGreffe(\RAN\Entity\ThesaurusGreffe $codeGreffe = null)
    {
        $this->codeGreffe = $codeGreffe;

        return $this;
    }

    /**
     * Get codeGreffe.
     *
     * @return \RAN\Entity\ThesaurusGreffe|null
     */
    public function getCodeGreffe()
    {
        return $this->codeGreffe;
    }
}
