<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AntecedentNeoplasique
 *
 * @ORM\Table(name="antecedent_neoplasique")
 * @ORM\Entity
 */
class AntecedentNeoplasique
{
    /**
     * @var int|null
     *
     * @ORM\Column(name="aut_ant_code", type="integer", nullable=true)
     */
    private $autAntCode;

    /**
     * @var int|null
     *
     * @ORM\Column(name="dop_ant_code", type="integer", nullable=true)
     */
    private $dopAntCode;

    /**
     * @var int|null
     *
     * @ORM\Column(name="irm_ant_code", type="integer", nullable=true)
     */
    private $irmAntCode;

    /**
     * @var int|null
     *
     * @ORM\Column(name="tdm_ant_code", type="integer", nullable=true)
     */
    private $tdmAntCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ant_dt_creat", type="date", nullable=false)
     */
    private $antDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ant_comment", type="string", length=500, nullable=true)
     */
    private $antComment;

    /**
     * @var \RAN\Entity\Antecedent
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Antecedent")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set autAntCode.
     *
     * @param int|null $autAntCode
     *
     * @return AntecedentNeoplasique
     */
    public function setAutAntCode($autAntCode = null)
    {
        $this->autAntCode = $autAntCode;

        return $this;
    }

    /**
     * Get autAntCode.
     *
     * @return int|null
     */
    public function getAutAntCode()
    {
        return $this->autAntCode;
    }

    /**
     * Set dopAntCode.
     *
     * @param int|null $dopAntCode
     *
     * @return AntecedentNeoplasique
     */
    public function setDopAntCode($dopAntCode = null)
    {
        $this->dopAntCode = $dopAntCode;

        return $this;
    }

    /**
     * Get dopAntCode.
     *
     * @return int|null
     */
    public function getDopAntCode()
    {
        return $this->dopAntCode;
    }

    /**
     * Set irmAntCode.
     *
     * @param int|null $irmAntCode
     *
     * @return AntecedentNeoplasique
     */
    public function setIrmAntCode($irmAntCode = null)
    {
        $this->irmAntCode = $irmAntCode;

        return $this;
    }

    /**
     * Get irmAntCode.
     *
     * @return int|null
     */
    public function getIrmAntCode()
    {
        return $this->irmAntCode;
    }

    /**
     * Set tdmAntCode.
     *
     * @param int|null $tdmAntCode
     *
     * @return AntecedentNeoplasique
     */
    public function setTdmAntCode($tdmAntCode = null)
    {
        $this->tdmAntCode = $tdmAntCode;

        return $this;
    }

    /**
     * Get tdmAntCode.
     *
     * @return int|null
     */
    public function getTdmAntCode()
    {
        return $this->tdmAntCode;
    }

    /**
     * Set antDtCreat.
     *
     * @param \DateTime $antDtCreat
     *
     * @return AntecedentNeoplasique
     */
    public function setAntDtCreat($antDtCreat)
    {
        $this->antDtCreat = $antDtCreat;

        return $this;
    }

    /**
     * Get antDtCreat.
     *
     * @return \DateTime
     */
    public function getAntDtCreat()
    {
        return $this->antDtCreat;
    }

    /**
     * Set antComment.
     *
     * @param string|null $antComment
     *
     * @return AntecedentNeoplasique
     */
    public function setAntComment($antComment = null)
    {
        $this->antComment = $antComment;

        return $this;
    }

    /**
     * Get antComment.
     *
     * @return string|null
     */
    public function getAntComment()
    {
        return $this->antComment;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\Antecedent $antCode
     *
     * @return AntecedentNeoplasique
     */
    public function setAntCode(\RAN\Entity\Antecedent $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\Antecedent
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
