<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AntecedentNephrologique
 *
 * @ORM\Table(name="antecedent_nephrologique", indexes={@ORM\Index(name="fk_fk_ant_nephro_patho", columns={"code_pathologie"}), @ORM\Index(name="fk_fk_ant_nephro_type_dialyse", columns={"tyd_code"}), @ORM\Index(name="fk_fk_ant_nephro_frequence", columns={"frd_code"})})
 * @ORM\Entity
 */
class AntecedentNephrologique
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ant_dt_creat", type="date", nullable=false)
     */
    private $antDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ant_comment", type="string", length=500, nullable=true)
     */
    private $antComment;

    /**
     * @var bool
     *
     * @ORM\Column(name="ann_dialyse", type="boolean", nullable=false)
     */
    private $annDialyse;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="ann_dt_deb_dialyse", type="date", nullable=true)
     */
    private $annDtDebDialyse;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ann_ct_dialyse", type="string", length=100, nullable=true)
     */
    private $annCtDialyse;

    /**
     * @var \RAN\Entity\Antecedent
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Antecedent")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;

    /**
     * @var \RAN\Entity\FrequenceDialyse
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\FrequenceDialyse")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="frd_code", referencedColumnName="frd_code")
     * })
     */
    private $frdCode;

    /**
     * @var \RAN\Entity\ThesaurusCristal
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ThesaurusCristal")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="code_pathologie", referencedColumnName="code_pathologie")
     * })
     */
    private $codePathologie;

    /**
     * @var \RAN\Entity\TypeDialyse
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\TypeDialyse")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tyd_code", referencedColumnName="tyd_code")
     * })
     */
    private $tydCode;



    /**
     * Set antDtCreat.
     *
     * @param \DateTime $antDtCreat
     *
     * @return AntecedentNephrologique
     */
    public function setAntDtCreat($antDtCreat)
    {
        $this->antDtCreat = $antDtCreat;

        return $this;
    }

    /**
     * Get antDtCreat.
     *
     * @return \DateTime
     */
    public function getAntDtCreat()
    {
        return $this->antDtCreat;
    }

    /**
     * Set antComment.
     *
     * @param string|null $antComment
     *
     * @return AntecedentNephrologique
     */
    public function setAntComment($antComment = null)
    {
        $this->antComment = $antComment;

        return $this;
    }

    /**
     * Get antComment.
     *
     * @return string|null
     */
    public function getAntComment()
    {
        return $this->antComment;
    }

    /**
     * Set annDialyse.
     *
     * @param bool $annDialyse
     *
     * @return AntecedentNephrologique
     */
    public function setAnnDialyse($annDialyse)
    {
        $this->annDialyse = $annDialyse;

        return $this;
    }

    /**
     * Get annDialyse.
     *
     * @return bool
     */
    public function getAnnDialyse()
    {
        return $this->annDialyse;
    }

    /**
     * Set annDtDebDialyse.
     *
     * @param \DateTime|null $annDtDebDialyse
     *
     * @return AntecedentNephrologique
     */
    public function setAnnDtDebDialyse($annDtDebDialyse = null)
    {
        $this->annDtDebDialyse = $annDtDebDialyse;

        return $this;
    }

    /**
     * Get annDtDebDialyse.
     *
     * @return \DateTime|null
     */
    public function getAnnDtDebDialyse()
    {
        return $this->annDtDebDialyse;
    }

    /**
     * Set annCtDialyse.
     *
     * @param string|null $annCtDialyse
     *
     * @return AntecedentNephrologique
     */
    public function setAnnCtDialyse($annCtDialyse = null)
    {
        $this->annCtDialyse = $annCtDialyse;

        return $this;
    }

    /**
     * Get annCtDialyse.
     *
     * @return string|null
     */
    public function getAnnCtDialyse()
    {
        return $this->annCtDialyse;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\Antecedent $antCode
     *
     * @return AntecedentNephrologique
     */
    public function setAntCode(\RAN\Entity\Antecedent $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\Antecedent
     */
    public function getAntCode()
    {
        return $this->antCode;
    }

    /**
     * Set frdCode.
     *
     * @param \RAN\Entity\FrequenceDialyse|null $frdCode
     *
     * @return AntecedentNephrologique
     */
    public function setFrdCode(\RAN\Entity\FrequenceDialyse $frdCode = null)
    {
        $this->frdCode = $frdCode;

        return $this;
    }

    /**
     * Get frdCode.
     *
     * @return \RAN\Entity\FrequenceDialyse|null
     */
    public function getFrdCode()
    {
        return $this->frdCode;
    }

    /**
     * Set codePathologie.
     *
     * @param \RAN\Entity\ThesaurusCristal|null $codePathologie
     *
     * @return AntecedentNephrologique
     */
    public function setCodePathologie(\RAN\Entity\ThesaurusCristal $codePathologie = null)
    {
        $this->codePathologie = $codePathologie;

        return $this;
    }

    /**
     * Get codePathologie.
     *
     * @return \RAN\Entity\ThesaurusCristal|null
     */
    public function getCodePathologie()
    {
        return $this->codePathologie;
    }

    /**
     * Set tydCode.
     *
     * @param \RAN\Entity\TypeDialyse|null $tydCode
     *
     * @return AntecedentNephrologique
     */
    public function setTydCode(\RAN\Entity\TypeDialyse $tydCode = null)
    {
        $this->tydCode = $tydCode;

        return $this;
    }

    /**
     * Get tydCode.
     *
     * @return \RAN\Entity\TypeDialyse|null
     */
    public function getTydCode()
    {
        return $this->tydCode;
    }
}
