<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AtcNiveau2
 *
 * @ORM\Table(name="atc_niveau_2")
 * @ORM\Entity
 */
class AtcNiveau2
{
    /**
     * @var int
     *
     * @ORM\Column(name="an2_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $an2Code;

    /**
     * @var string
     *
     * @ORM\Column(name="an5_libelle", type="string", length=50, nullable=false)
     */
    private $an5Libelle;

    /**
     * @var string
     *
     * @ORM\Column(name="an2_code_court", type="string", length=2, nullable=false, options={"fixed"=true})
     */
    private $an2CodeCourt;



    /**
     * Get an2Code.
     *
     * @return int
     */
    public function getAn2Code()
    {
        return $this->an2Code;
    }

    /**
     * Set an5Libelle.
     *
     * @param string $an5Libelle
     *
     * @return AtcNiveau2
     */
    public function setAn5Libelle($an5Libelle)
    {
        $this->an5Libelle = $an5Libelle;

        return $this;
    }

    /**
     * Get an5Libelle.
     *
     * @return string
     */
    public function getAn5Libelle()
    {
        return $this->an5Libelle;
    }

    /**
     * Set an2CodeCourt.
     *
     * @param string $an2CodeCourt
     *
     * @return AtcNiveau2
     */
    public function setAn2CodeCourt($an2CodeCourt)
    {
        $this->an2CodeCourt = $an2CodeCourt;

        return $this;
    }

    /**
     * Get an2CodeCourt.
     *
     * @return string
     */
    public function getAn2CodeCourt()
    {
        return $this->an2CodeCourt;
    }
}
