<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AtcNiveau3
 *
 * @ORM\Table(name="atc_niveau_3")
 * @ORM\Entity
 */
class AtcNiveau3
{
    /**
     * @var int
     *
     * @ORM\Column(name="an3_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $an3Code;

    /**
     * @var string
     *
     * @ORM\Column(name="an5_libelle", type="string", length=50, nullable=false)
     */
    private $an5Libelle;

    /**
     * @var string
     *
     * @ORM\Column(name="an3_code_court", type="string", length=1, nullable=false, options={"fixed"=true})
     */
    private $an3CodeCourt;



    /**
     * Get an3Code.
     *
     * @return int
     */
    public function getAn3Code()
    {
        return $this->an3Code;
    }

    /**
     * Set an5Libelle.
     *
     * @param string $an5Libelle
     *
     * @return AtcNiveau3
     */
    public function setAn5Libelle($an5Libelle)
    {
        $this->an5Libelle = $an5Libelle;

        return $this;
    }

    /**
     * Get an5Libelle.
     *
     * @return string
     */
    public function getAn5Libelle()
    {
        return $this->an5Libelle;
    }

    /**
     * Set an3CodeCourt.
     *
     * @param string $an3CodeCourt
     *
     * @return AtcNiveau3
     */
    public function setAn3CodeCourt($an3CodeCourt)
    {
        $this->an3CodeCourt = $an3CodeCourt;

        return $this;
    }

    /**
     * Get an3CodeCourt.
     *
     * @return string
     */
    public function getAn3CodeCourt()
    {
        return $this->an3CodeCourt;
    }
}
